create
    definer = root@localhost procedure actualiza_cliente_resumen(IN my_cliente_id varchar(32))
ac:
BEGIN

    DECLARE cliente_es_cobranza, cliente_es_cobranza_ INT;

    DECLARE toleranciaPagoDocumentosPesos, toleranciaPagoDocumentosUsd INT;
    DECLARE tipoCambio DECIMAL(14, 4);
    DECLARE
        chequesTotalesPesos, chequesTotalesUsd,
        pagaresTotalesPesos, pagaresTotalesUsd,
        valesTotalesPesos, valesTotalesUsd,
        comprasTotalesPesos, comprasTotalesUsd
        DECIMAL(14, 2);
    DECLARE
        cuantosCheques, cuantosChequesPagados,
        cuantosPagares, cuantosPagaresPagados,
        cuantosVales, cuantosValesPagados,
        cuantosCompras, cuantosComprasPagados
        INT;

    DECLARE g_ultima_salida_bodega
        DATE;


    SELECT receive_cheques,
           receive_cheques = 1 AND cheques_totales = 0 AND pagares_totales = 0 AND vales_totales = 0 AND compras_totales = 0
    INTO cliente_es_cobranza, cliente_es_cobranza_
    FROM cliente
    WHERE cliente_id = my_cliente_id;

    SET cliente_es_cobranza = IFNULL(cliente_es_cobranza, 0);
    SET cliente_es_cobranza_ = IFNULL(cliente_es_cobranza_, 0);


    /*IF cliente_es_cobranza = 0 OR cliente_es_cobranza_ = 1 THEN
        SELECT MAX(fecha)
        INTO g_ultima_salida_bodega
        FROM nota_bodega
        WHERE nota_bodega.tipo = 'Movimiento'
          AND JSON_CONTAINS(cliente ,JSON_OBJECT("cliente_id", my_cliente_id,"fue_error","No"));


        UPDATE cliente cte
        SET cte.ultima_salida_bodega = g_ultima_salida_bodega
        WHERE cte.cliente_id = my_cliente_id;

        SELECT cliente_es_cobranza;
        SELECT cliente_es_cobranza_;


        LEAVE ac;
    END IF;*/


    SET @TRIGGER_DISABLED = IFNULL(@TRIGGER_DISABLED, 0);

    IF (@TRIGGER_DISABLED <> 1) THEN

        SELECT tolerancia_pago_documentos_pesos,
               tolerancia_pago_documentos_usd,
               ROUND(tc, 4)
        INTO toleranciaPagoDocumentosPesos, toleranciaPagoDocumentosUsd, tipoCambio
        FROM iac_parametros;


        DELETE FROM clientes_saldos_cat WHERE cliente_id = my_cliente_id;

        INSERT INTO `clientes_saldos_cat`
        (`cliente_id`, `nombre`, `categoria_id`, tienda_id,
         `saldo_cheques_pesos`, `saldo_cheques_usd`,
         `saldo_pagares_pesos`, `saldo_pagares_usd`,
         `saldo_vales_pesos`, `saldo_vales_usd`,
         `cheque_mas_antiguo`, `pagare_mas_antiguo`, `vale_mas_antiguo`,
         `ultima_liquidacion`, `ultimo_pago`, `ultima_compra`,
         `cuantos_cheques`, `cuantos_pagares`, `cuantos_vales`, tipo_cambio,
         `saldo_compras_pesos`, `saldo_compras_usd`, `cuantos_compras`, `compra_mas_antigua`)
        SELECT IF(doc.cliente_id IS NULL, doc.cliente, doc.cliente_id)                                cliente_id,
               IF(doc.cliente IS NULL, doc.cliente_id, doc.cliente)                                   cliente,
               doc.categoria_id,
               IFNULL((SELECT tienda_id FROM cliente WHERE cliente_id = my_cliente_id), 1),
               COALESCE(SUM(CASE
                                WHEN doc.origen IN ('CHEQUE', 'NOTA', 'GASTO') AND doc.paid = 0 AND doc.moneda_id = 1
                                    THEN IF(ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosPesos,
                                            0.00, IF(doc.quantity - doc.total_payments < 0, 0.00,
                                                     doc.quantity - doc.total_payments)) END),
                        0.00)                                                                         saldo_cheques_pesos,

               COALESCE(SUM(CASE
                                WHEN doc.origen IN ('CHEQUE', 'NOTA', 'GASTO') AND doc.paid = 0 AND doc.moneda_id = 2
                                    THEN IF(ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosUsd, 0.00,
                                            IF(doc.quantity - doc.total_payments < 0, 0.00,
                                               doc.quantity - doc.total_payments)) END), 0.00)        saldo_cheques_usd,

               COALESCE(SUM(CASE
                                WHEN doc.origen = 'PAGARE' AND doc.paid = 0 AND doc.moneda_id = 1 THEN IF(
                                        ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosPesos, 0.00,
                                        IF(doc.quantity - doc.total_payments < 0, 0.00,
                                           doc.quantity - doc.total_payments)) END),
                        0.00)                                                                         saldo_pagares_pesos,

               COALESCE(SUM(CASE
                                WHEN doc.origen = 'PAGARE' AND doc.paid = 0 AND doc.moneda_id = 2 THEN IF(
                                        ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosUsd, 0.00,
                                        IF(doc.quantity - doc.total_payments < 0, 0.00,
                                           doc.quantity - doc.total_payments)) END), 0.00)            saldo_pagares_usd,


               COALESCE(SUM(CASE
                                WHEN doc.origen = 'VALE' AND doc.paid = 0 AND doc.moneda_id = 1 THEN IF(
                                        ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosPesos, 0.00,
                                        IF(doc.quantity - doc.total_payments < 0, 0.00,
                                           doc.quantity - doc.total_payments)) END), 0.00)            saldo_vales_pesos,

               COALESCE(SUM(CASE
                                WHEN doc.origen = 'VALE' AND doc.paid = 0 AND doc.moneda_id = 2 THEN IF(
                                        ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosUsd, 0.00,
                                        IF(doc.quantity - doc.total_payments < 0, 0.00,
                                           doc.quantity - doc.total_payments)) END), 0.00)            saldo_vales_usd,

               DATE(MIN(IF(doc.origen IN ('CHEQUE', 'NOTA', 'GASTO') AND doc.borrado = 'No' AND doc.paid = 0, doc.fecha,
                           null)))                                                                    cheque_mas_antiguo,
               DATE(MIN(IF(doc.origen = 'PAGARE' AND doc.borrado = 'No' AND doc.paid = 0, doc.fecha,
                           null)))                                                                    pagare_mas_antiguo,
               DATE(MIN(IF(doc.origen = 'VALE' AND doc.borrado = 'No' AND doc.paid = 0, doc.fecha,
                           null)))                                                                    vale_mas_antiguo,

               IF(COUNT(CASE
                            WHEN doc.origen IN ('CHEQUE', 'NOTA', 'GASTO', 'PAGARE', 'VALE', 'COMPRA') AND doc.paid = 0
                                THEN 1 END) = 0, DATE(MAX(doc.ultimo_pago)),
                  NULL)                                                                               ultima_liquidacion,

               DATE(MAX(IF(doc.origen IN ('CHEQUE', 'NOTA', 'GASTO', 'PAGARE', 'VALE', 'COMPRA') AND doc.borrado = 'No',
                           doc.ultimo_pago, null)))                                                   ultimo_pago,

               DATE(MAX(IF(doc.origen IN ('CHEQUE', 'NOTA', 'GASTO', 'PAGARE', 'VALE', 'COMPRA') AND doc.borrado = 'No',
                           doc.alta_db, null)))                                                       ultima_compra,
               COUNT(CASE WHEN doc.origen IN ('CHEQUE', 'NOTA', 'GASTO') AND doc.paid = 0 THEN 1 END) cuantos_cheques,
               COUNT(CASE WHEN doc.origen = 'PAGARE' AND doc.paid = 0 THEN 1 END)                     cuantos_pagares,
               COUNT(CASE WHEN doc.origen = 'VALE' AND doc.paid = 0 THEN 1 END)                       cuantos_vales,
               MIN(tipoCambio),

               COALESCE(SUM(CASE
                                WHEN doc.origen = 'COMPRA' AND doc.paid = 0 AND doc.moneda_id = 1 THEN IF(
                                        ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosPesos, 0.00,
                                        IF(doc.quantity - doc.total_payments < 0, 0.00,
                                           doc.quantity - doc.total_payments)) END),
                        0.00)                                                                         saldo_compras_pesos,

               COALESCE(SUM(CASE
                                WHEN doc.origen = 'COMPRA' AND doc.paid = 0 AND doc.moneda_id = 2 THEN IF(
                                        ABS(doc.quantity - doc.total_payments) < toleranciaPagoDocumentosUsd, 0.00,
                                        IF(doc.quantity - doc.total_payments < 0, 0.00,
                                           doc.quantity - doc.total_payments)) END), 0.00)            saldo_compras_usd,
               COUNT(CASE WHEN doc.origen = 'COMPRA' AND doc.paid = 0 THEN 1 END)                     cuantos_compras,
               DATE(MIN(IF(doc.origen = 'COMPRA' AND doc.borrado = 'No' AND doc.paid = 0, doc.fecha,
                           null)))                                                                    compra_mas_antigua
        FROM doctos doc
        WHERE doc.categoria_id > 0
          AND IF(doc.cliente_id IS NULL, doc.cliente, doc.cliente_id) <> ''
          AND IF(doc.cliente_id IS NULL, doc.cliente, doc.cliente_id) = my_cliente_id
        GROUP BY doc.cliente_id, doc.categoria_id;


        SELECT IFNULL(SUM(IF(paid = 0, 1, 0)), 0)    AS cuantos_cheques,
               IFNULL(SUM(IF(paid = 1, 1, 0)), 0)    AS cuantos_cheques_pagados,
               SUM(IF(c.moneda_id = 1, quantity, 0)) AS cheques_totales_pesos,
               SUM(IF(c.moneda_id = 2, quantity, 0)) AS cheques_totales_usd
        INTO cuantosCheques, cuantosChequesPagados, chequesTotalesPesos, chequesTotalesUsd
        FROM cheque c
        WHERE c.cliente_id = my_cliente_id;

        SELECT IFNULL(SUM(IF(paid = 0, 1, 0)), 0)    AS cuantos_pagares,
               IFNULL(SUM(IF(paid = 1, 1, 0)), 0)    AS cuantos_pagares_pagados,
               SUM(IF(c.moneda_id = 1, quantity, 0)) AS pagares_totales_pesos,
               SUM(IF(c.moneda_id = 2, quantity, 0)) AS pagares_totales_usd
        INTO cuantosPagares, cuantosPagaresPagados, pagaresTotalesPesos, pagaresTotalesUsd
        FROM pagare c
        WHERE c.cliente_id = my_cliente_id;

        SELECT COUNT(*)                              AS cuantos_vales,
               SUM(IF(c.moneda_id = 1, quantity, 0)) AS vales_totales_pesos,
               SUM(IF(c.moneda_id = 2, quantity, 0)) AS vales_totales_usd
        INTO cuantosVales, valesTotalesPesos, valesTotalesUsd
        FROM vale c
        WHERE paid = 0
          AND cliente_id = my_cliente_id;

        SELECT COUNT(*) AS cuantos_vales_pagados
        INTO cuantosValesPagados
        FROM vale c
        WHERE paid = 1
          AND cliente_id = my_cliente_id;


        SELECT IFNULL(SUM(IF(paid = 0, 1, 0)), 0)    AS cuantos_compras,
               IFNULL(SUM(IF(paid = 1, 1, 0)), 0)    AS cuantos_compras_pagados,
               SUM(IF(c.moneda_id = 1, quantity, 0)) AS compras_totales_pesos,
               SUM(IF(c.moneda_id = 2, quantity, 0)) AS compras_totales_usd
        INTO cuantosCompras, cuantosComprasPagados, comprasTotalesPesos, comprasTotalesUsd
        FROM compra c
        WHERE c.cliente_id = my_cliente_id;

        SELECT MAX(fecha)
        INTO g_ultima_salida_bodega
        FROM nota_bodega
        WHERE nota_bodega.tipo = 'Movimiento'
          AND JSON_CONTAINS(cliente ,JSON_OBJECT("cliente_id", my_cliente_id,"fue_error","No"));


/*
        SELECT g_ultima_salida_bodega;
        SELECT CONCAT('["', my_cliente_id, '"]');

        INSERT INTO `campos_kv` (`campos_kv_id`, `concepto`, `valor`, `fecha`, `alta_db`, `extras`) VALUES (NULL, 'CALL actualiza_cliente_resumen', g_ultima_salida_bodega, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, '[]');
*/
        SET chequesTotalesPesos = IFNULL(chequesTotalesPesos, 0);
        SET chequesTotalesUsd = IFNULL(chequesTotalesUsd, 0);
        SET pagaresTotalesPesos = IFNULL(pagaresTotalesPesos, 0);
        SET pagaresTotalesUsd = IFNULL(pagaresTotalesUsd, 0);
        SET valesTotalesPesos = IFNULL(valesTotalesPesos, 0);
        SET valesTotalesUsd = IFNULL(valesTotalesUsd, 0);

        SET comprasTotalesPesos = IFNULL(comprasTotalesPesos, 0);
        SET comprasTotalesUsd = IFNULL(comprasTotalesUsd, 0);

        SET cuantosCheques = IFNULL(cuantosCheques, 0);
        SET cuantosChequesPagados = IFNULL(cuantosChequesPagados, 0);
        SET cuantosPagares = IFNULL(cuantosPagares, 0);
        SET cuantosPagaresPagados = IFNULL(cuantosPagaresPagados, 0);
        SET cuantosVales = IFNULL(cuantosVales, 0);
        SET cuantosValesPagados = IFNULL(cuantosValesPagados, 0);

        SET cuantosCompras = IFNULL(cuantosCompras, 0);
        SET cuantosComprasPagados = IFNULL(cuantosComprasPagados, 0);

        UPDATE cliente cte
            INNER JOIN (SELECT s.cliente_id,
                               SUM(s.saldo_cheques_pesos + s.saldo_pagares_pesos)                    saldo_pesos,
                               SUM(s.saldo_cheques_usd + s.saldo_pagares_usd)                        saldo_usd,
                               SUM(s.saldo_cheques_pesos)                                            saldo_cheques_pesos,
                               SUM(s.saldo_cheques_usd)                                              saldo_cheques_usd,
                               SUM(s.saldo_pagares_pesos)                                            saldo_pagares_pesos,
                               SUM(s.saldo_pagares_usd)                                              saldo_pagares_usd,
                               SUM(s.saldo_vales_pesos)                                              saldo_vales_pesos,
                               SUM(s.saldo_vales_usd)                                                saldo_vales_usd,
                               MAX(s.ultima_compra)                                                  ultima_compra,
                               SUM(s.saldo_cheques_pesos) + SUM(s.saldo_cheques_usd * s.tipo_cambio) saldo_total_pesos,
                               SUM(s.saldo_cheques_pesos / s.tipo_cambio + s.saldo_cheques_usd)      saldo_total_usd,

                               MIN(s.cheque_mas_antiguo)                                             cheque_mas_antiguo,
                               MIN(s.pagare_mas_antiguo)                                             pagare_mas_antiguo,
                               MIN(s.vale_mas_antiguo)                                               vale_mas_antiguo,
                               MIN(s.doc_mas_antiguo)                                                doc_mas_antiguo,
                               MAX(s.ultima_liquidacion)                                             ultima_liquidacion,
                               MAX(s.ultimo_pago)                                                    ultimo_pago,
                               SUM(s.saldo_compras_pesos)                                            saldo_compras_pesos,
                               SUM(s.saldo_compras_usd)                                              saldo_compras_usd,
                               SUM(s.compra_mas_antigua)                                             compra_mas_antigua
                        FROM clientes_saldos_cat s
                        GROUP BY cliente_id)
                sdo ON cte.cliente_id = sdo.cliente_id
        SET cte.cuantos_cheques          = cuantosCheques,
            cte.cuantos_pagares          = cuantosPagares,
            cte.cuantos_vales            = cuantosVales,
            cte.cuantos_cheques_pagados  = cuantosChequesPagados,
            cte.cuantos_pagares_pagados  = cuantosPagaresPagados,
            cte.cuantos_vales_pagados    = cuantosValesPagados,
            cte.cheques_totales          = cuantosCheques + cuantosChequesPagados,
            cte.pagares_totales          = cuantosPagares + cuantosPagaresPagados,
            cte.vales_totales            = cuantosVales + cuantosValesPagados,
            cte.cheques_totales_pesos    = chequesTotalesPesos,
            cte.cheques_totales_usd      = chequesTotalesUsd,
            cte.pagares_totales_pesos    = pagaresTotalesPesos,
            cte.pagares_totales_usd      = pagaresTotalesUsd,
            cte.vales_totales_pesos      = valesTotalesPesos,
            cte.vales_totales_usd        = valesTotalesUsd,
            cte.saldo_total_ventas_pesos = chequesTotalesPesos + pagaresTotalesPesos + valesTotalesPesos,
            cte.saldo_total_ventas_usd   = chequesTotalesUsd + pagaresTotalesUsd + valesTotalesUsd,

            cte.saldo_pesos              = sdo.saldo_pesos,
            cte.saldo_usd                = sdo.saldo_usd,
            cte.saldo_cheques_pesos      = sdo.saldo_cheques_pesos,
            cte.saldo_cheques_usd        = sdo.saldo_cheques_usd,
            cte.saldo_pagares_pesos      = sdo.saldo_pagares_pesos,
            cte.saldo_pagares_usd        = sdo.saldo_pagares_usd,
            cte.saldo_vales_pesos        = sdo.saldo_vales_pesos,
            cte.saldo_vales_usd          = sdo.saldo_vales_usd,
            cte.ultima_compra            = sdo.ultima_compra,
            cte.saldo_total_pesos        = sdo.saldo_total_pesos,
            cte.saldo_total_usd          = sdo.saldo_total_usd,

            cte.cheque_mas_antiguo       = sdo.cheque_mas_antiguo,
            cte.pagare_mas_antiguo       = sdo.pagare_mas_antiguo,
            cte.vale_mas_antiguo         = sdo.vale_mas_antiguo,
            cte.doc_mas_antiguo          = sdo.doc_mas_antiguo,
            cte.ultima_liquidacion       = sdo.ultima_liquidacion,
            cte.ultimo_pago              = sdo.ultimo_pago,


            cte.saldo_compras_pesos      = sdo.saldo_compras_pesos,
            cte.saldo_compras_usd        = sdo.saldo_compras_usd,
            cte.cuantos_compras          = cuantosCompras,
            cte.cuantos_compras_pagados  = cuantosComprasPagados,
            cte.compras_totales          = cuantosCompras + cuantosComprasPagados,
            cte.compra_mas_antigua       = sdo.compra_mas_antigua,
            cte.ultima_salida_bodega     = g_ultima_salida_bodega


        WHERE cte.cliente_id = my_cliente_id;

/*
        UPDATE cliente cte
        SET
            cte.ultima_salida_bodega = g_ultima_salida_bodega
        WHERE cte.cliente_id = my_cliente_id;*/

    END IF;

END;

