create
    definer = root@localhost procedure borra_tablas_temporales()
    comment 'Borra las tablas temporales, que inician con aa_tmp'
    modifies sql data
BEGIN
    DECLARE table_name VARCHAR(255);
    DECLARE end_of_tables INT DEFAULT 0;

    DECLARE cur CURSOR FOR
        SELECT t.table_name
        FROM information_schema.tables t
        WHERE t.table_schema = DATABASE() AND t.table_type='BASE TABLE' AND t.table_name LIKE 'aa_tmp%' AND t.create_time < (now()-interval 3 minute);
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET end_of_tables = 1;
    OPEN cur;
    tables_loop: LOOP
        FETCH cur INTO table_name;

        IF end_of_tables = 1 THEN
            LEAVE tables_loop;
        END IF;

        SET @s = CONCAT('DROP TABLE IF EXISTS ', table_name);
        PREPARE stmt FROM @s;
        EXECUTE stmt;

    END LOOP;

    CLOSE cur;
END;

