create
    definer = root@localhost function extract_pedido_por_ids(json_data json) returns varchar(512) deterministic
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE v_id VARCHAR(32);
    DECLARE result VARCHAR(512) DEFAULT NULL;

    DECLARE cur CURSOR FOR 
        SELECT jt.id
        FROM JSON_TABLE(json_data, '$[*]' COLUMNS (
            id VARCHAR(191) PATH '$.id',
fue_error CHAR(2) PATH '$.fue_error'
        )) AS jt
        WHERE
            jt.fue_error = 'No';
    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    -- Open cursor
    OPEN cur;

    -- Loop through values
    read_loop: LOOP
        FETCH cur INTO v_id;
        IF done THEN
            LEAVE read_loop;
        END IF;
        -- Concatenate values
        SET result = IFNULL(CONCAT(result, ', ', v_id), v_id);
    END LOOP;

    -- Close cursor
    CLOSE cur;

    RETURN result;
END;

