create
    definer = root@localhost procedure TruncateTableIfExists(IN tableName varchar(64))
BEGIN
    IF EXISTS (SELECT * FROM information_schema.tables 
               WHERE table_schema = DATABASE() -- Automatically uses the current database
               AND table_name = tableName) THEN
        SET @s = CONCAT('TRUNCATE TABLE ', tableName);
        PREPARE stmt FROM @s;
        EXECUTE stmt;
        DEALLOCATE PREPARE stmt;
    END IF;
END;

