create
    definer = root@localhost procedure existenciaBodegasProductoColor(IN fecha date, IN producto_general_id varchar(32),
                                                                      IN color_id varchar(32))
    comment 'Regresa la existencia en todas las bodegas a la fecha indicada'
    reads sql data
BEGIN
    DECLARE EXIT HANDLER FOR 1243
        BEGIN
            PREPARE stmtEBPC FROM
                'WITH hay as
                          (SELECT bodega_id,
                                  SUM(existencia_rollos_inicial) as rollos_inicial,
                                  SUM(existencia_rollos) as rollos_final,
                                  SUM(existencia_quantity_inicial) as quantity_inicial,
                                  SUM(existencia_quantity) as quantity_final
                           FROM bodega_existencia_diaria
                           WHERE fecha <= ? AND producto_general_id = ? AND color_id = ?
                           GROUP BY 1
                           HAVING MAX(fecha)
                          )
                 SELECT
                     SUM(rollos_inicial) as rollos_inicial,
                     SUM(rollos_final) as rollos_final,
                     SUM(quantity_inicial) as quantity_inicial,
                     SUM(quantity_final) as quantity_final
                 FROM hay';
            SET @fechaEBPC = fecha;
            SET @producto_general_idEBPC = producto_general_id;
            SET @color_idEBPC = color_id;
            EXECUTE stmtEBPC USING @fechaEBPC, @producto_general_idEBPC, @color_idEBPC;
        END;
    SET @fechaEBPC = fecha;
    SET @producto_general_idEBPC = producto_general_id;
    SET @color_idEBPC = color_id;
    EXECUTE stmtEBPC USING @fechaEBPC, @producto_general_idEBPC, @color_idEBPC;
END;

