create
    definer = root@localhost procedure insertAll(IN tableToFill varchar(1024), IN originalTable varchar(1024))
    comment 'Version 1.1 Inserta a tableToFill, con ON DUPLICATE KEY, todos los campos excepto los generated de originalTable'
    modifies sql data
BEGIN

    DECLARE getCols LONGTEXT;
    DECLARE colsToFill LONGTEXT;
    DECLARE inserter LONGTEXT;
    DECLARE onDupUpdate LONGTEXT;
    SET @getCols =
            'SELECT GROUP_CONCAT(DISTINCT CONCAT(\'`\',column_name,\'`\') SEPARATOR \',\r\n\t\'),
                GROUP_CONCAT(DISTINCT CONCAT(\'`\',column_name,\'` = VALUES(`\',column_name,\'`\)\') SEPARATOR \',\r\n\t\')
                INTO @colsToFill,@onDupUpdate
           FROM ( select column_name, ORDINAL_POSITION
                  from information_schema.columns
                  where length(generation_expression) = 0 AND table_schema = DATABASE()
                    AND table_name=?) as qry' ;

    SET @originalTable=originalTable;
    PREPARE stmtCols FROM @getCols;
    EXECUTE stmtCols USING @originalTable;
    DEALLOCATE PREPARE stmtCols;

    SET @inserter = CONCAT('INSERT INTO ', tableToFill, '(\r\n', @colsToFill, '\r\n) SELECT\r\n', @colsToFill,
        '\r\nFROM ', originalTable, ' ON DUPLICATE KEY UPDATE ',@onDupUpdate
        );

    PREPARE stmtInsert FROM @inserter;
    EXECUTE stmtInsert;
    DEALLOCATE PREPARE stmtInsert;

END;

