create
    definer = root@localhost procedure UpdateClienteActualID(IN row_id varchar(32), IN item_ano year)
BEGIN
    DECLARE selected_cliente_id VARCHAR(32);
    DECLARE selected_cliente_nombre VARCHAR(50);

    -- Attempt to select the cliente_id into the variable
    SELECT jt.cliente_id, jt.nombre INTO selected_cliente_id, selected_cliente_nombre
    FROM nota_bodega
        CROSS JOIN JSON_TABLE(nota_bodega.cliente, '$[*]' COLUMNS (
            cliente_id VARCHAR(32) PATH '$.cliente_id',
            fue_error CHAR(2) PATH '$.fue_error',
            nombre VARCHAR(50) PATH '$.nombre'
        )) AS jt
    WHERE jt.fue_error = 'no'
      AND nota_bodega.nota_bodega_id = row_id
      AND nota_bodega.ano = item_ano
    LIMIT 1;

    -- Check if a cliente_id was found; if so, proceed with the update
    IF selected_cliente_id IS NOT NULL THEN
        UPDATE nota_bodega
        SET cliente_actual_id = selected_cliente_id, cliente_actual = selected_cliente_nombre
        WHERE nota_bodega_id = row_id;
    END IF;
END;

