create
    definer = root@localhost procedure actualiza_donde_ayudantes(IN ayudante_id_in varchar(32))
    comment 'Actualiza campo ayudantes.donde'
    modifies sql data
BEGIN
	DECLARE cuantos_lugares INT  default 0 ;
	DECLARE HTML_TABLE LONGTEXT default '';
	DECLARE HTML_CONTADORES LONGTEXT default '';
    DECLARE ayudanteID varchar(32) CHARACTER SET utf8mb4;

    IF ayudante_id_in IS NOT NULL THEN

		SET ayudanteID =  CONVERT(ayudante_id_in USING utf8);
        SET cuantos_lugares = (SELECT IFNULL(COUNT(origen_bodega_id), 0) FROM origen_bodega_ayudantes WHERE ayudante_id = ayudanteID);

        IF cuantos_lugares>0 THEN
            SET HTML_TABLE = CONCAT('<table class="table"><thead><tr>',
                (SELECT CONCAT('<th>', GROUP_CONCAT(distinct CONCAT('Destinos: ', ob.es, 'S') SEPARATOR '<th>'))
                    FROM origen_bodega_ayudantes oba
                    JOIN origen_bodega ob using(origen_bodega_id)
                    WHERE ayudante_id = ayudanteID AND oba.activo = 'Si'
                    ORDER BY es),
                '</tr></thead><tbody><tr>',
                (
                    SELECT GROUP_CONCAT(body SEPARATOR '') FROM (
                        SELECT CONCAT('<td style="vertical-align:top">','<li>', GROUP_CONCAT(CONCAT(ob.clave, ' <i style="font-size:0.8em;font-weight:100">(', ob.es, ')</i>') SEPARATOR '<li>'), '</td>') body
                        FROM origen_bodega_ayudantes oba
                        JOIN origen_bodega ob using(origen_bodega_id) WHERE ayudante_id = ayudanteID AND oba.activo = 'Si' group by es order by es, clave
                    ) columnas
                ),
                '</tr></tbody></table>'
            );

            SET HTML_CONTADORES = (SELECT GROUP_CONCAT(CONCAT(es, '(s): ', conta) SEPARATOR '|') FROM (
				SELECT
					ob.es, count(ob.es) conta
				FROM origen_bodega_ayudantes oba
				JOIN origen_bodega ob USING (origen_bodega_id)
				WHERE oba.ayudante_id = ayudanteID AND oba.activo = 'Si'
				GROUP BY ob.es
			)LIS);

ELSE
            SET HTML_TABLE = '';
            SET HTML_CONTADORES = '';
END IF;
UPDATE ayudantes SET donde = HTML_TABLE, contadores = HTML_CONTADORES WHERE ayudante_id = ayudanteID;
ELSE
BEGIN
            DECLARE cur_ayudante_id VARCHAR(32);
            DECLARE cur_nombre_ayudante VARCHAR(100);
            DECLARE no_more_rows BOOLEAN;
            DECLARE cursor_ayudantes CURSOR FOR SELECT ayudante_id, nombre FROM ayudantes;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET no_more_rows = TRUE;
OPEN cursor_ayudantes;
loop_ayudantes: LOOP
                FETCH cursor_ayudantes INTO cur_ayudante_id, cur_nombre_ayudante;
                IF no_more_rows THEN
                    LEAVE loop_ayudantes;
END IF;
CALL actualiza_donde_ayudantes(cur_ayudante_id);
END LOOP loop_ayudantes;
CLOSE cursor_ayudantes;
END;
END IF;
END;

