create
    definer = root@localhost procedure actualiza_links_al_banco_live(IN fecha_limite varchar(32))
    comment 'Actualiza la tabla links_al_banco_live'
BEGIN
DROP TABLE IF EXISTS links_al_banco_live;
DROP TABLE IF EXISTS aa_tmp_xyz123;
CREATE TABLE IF NOT EXISTS links_al_banco_live LIKE links_al_banco_schema;

IF(fecha_limite = '') THEN
SELECT
fecha_cache_links_al_banco
INTO fecha_limite
FROM iac_parametros;
END IF;

TRUNCATE TABLE links_al_banco_live;

CREATE TEMPORARY TABLE aa_tmp_xyz123 (SELECT
  a.cuentat_a_banco_mov_id AS link_id,
  a.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  a.origen AS origen,
  a.cuentat_a_banco_mov_id AS doc_id,
  a.cuentaT_id AS cuentaT_id,
  a.tienda_id AS tienda_id,
  a.fecha AS fecha,
  a.banco_cuenta_id AS banco_cuenta_id,
  a.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id,
  a.deposit_total AS deposit_total,
  a.quantity_total AS quantity_total,
  a.ide_amount AS ide_amount,
  a.ide_percent AS ide_percent,
  a.egreso AS egreso,
  a.monto AS monto,
  a.tipo_cash_nota AS tipo_cash_nota,
  a.cash_nota_num AS cash_nota_num,
  a.deposit_fecha AS deposit_fecha,
  a.cliente AS cliente,
  a.factura AS factura,
  a.factura_numero AS factura_numero,
  a.iva_incluido AS iva_incluido,
  a.ivacobradox100 AS ivacobradox100,
  IF((a.iva_incluido = 'SI'),0.00,a.ivacobradototal) AS ivarealmentecobrado,
  IF((a.iva_incluido = 'NO'),0.00,a.ivacobradototal) AS ivacobradototal,
  a.alta_db AS alta_db,
  a.alta_por AS alta_por,
  a.numero_referencia AS numero_referencia,
  a.cash_num_cobro_iva AS cash_num_cobro_iva,
  a.empresa_id AS empresa_id,
  a.remarks AS remarks,
  a.puede_borrar AS puede_borrar,
  a.activo AS activo,
  a.afecta_cuentat AS afecta_cuentat,
  a.comments AS comments,
  a.autorizado AS autorizado,
  a.rechazado AS rechazado,
  a.revisado AS revisado,
  a.autorizado_el AS autorizado_el,
  a.autorizado_por AS autorizado_por,
  a.MetodoPago AS MetodoPago,
  a.FormaPago AS FormaPago,
  a.UsoCFDI AS UsoCFDI,
  a.iva_revisado AS iva_revisado,
  a.iva_revisado_por AS iva_revisado_por,
  a.iva_revisado_el AS iva_revisado_el,
  a.ultimo_cambio AS ultimo_cambio,
  a.ultimo_cambio_por AS ultimo_cambio_por,
  a.cliente_rfc AS cliente_rfc,
  a.referencia AS referencia,
  a.origen_mov_id AS origen_mov_id,
  a.factura_directa AS factura_directa,
  a.moneda_id AS moneda_id,
  a.fecha_capturado AS fecha_capturado,
  a.json_file_attachments AS json_file_attachments,
  a.cancelacion_revisada,
  a.cancelacion_revisada_por,
  a.cancelacion_revisada_el,
  a.cancelacion_el,
  a.cuentaT_mov_id as cuentat_mov_id
  FROM cuentat_a_banco a
   FORCE INDEX (links_al_banco_live)
  WHERE a.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  b.cheque_pago_id AS link_id,
  b.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  b.origen AS origen,
  b.cheque_id AS doc_id,
  b.cuentaT_id AS cuentaT_id,
  b.tienda_id AS tienda_id,
  b.fecha AS fecha,
  b.banco_cuenta_id AS banco_cuenta_id,
  b.metodo_pago_id AS cuentaT_tipo_mov_id,
  b.deposit_total AS deposit_total,
  b.quantity_total AS quantity_total,
  b.ide_amount AS ide_amount,
  b.ide_percent AS ide_percent,
  b.quantity_ctat AS egreso,
  0.00 AS monto,
  b.tipo_cash_nota AS tipo_cash_nota,
  b.cash_nota_num AS cash_nota_num,
  b.deposit_fecha AS deposit_fecha,
  b.cliente AS cliente,
  b.factura AS factura,
  b.factura_numero AS factura_numero,
  b.iva_incluido AS iva_incluido,
  b.ivacobradox100 AS ivacobradox100,
  IF((b.iva_incluido = 'SI'),0.00,b.ivacobradototal) AS ivarealmentecobrado,
  IF((b.iva_incluido = 'NO'),0.00,b.ivacobradototal) AS ivacobradototal,
  b.alta_db AS alta_db,
  b.alta_por AS alta_por,
  b.numero_referencia AS numero_referencia,
  b.cash_num_cobro_iva AS cash_num_cobro_iva,
  b.empresa_id AS empresa_id,
  b.comentario AS remarks,
  b.puede_borrar AS puede_borrar,
  b.activo AS activo,
  b.afecta_cuentat AS afecta_cuentat,
  b.comments AS comments,
  b.autorizado AS autorizado,
  b.rechazado AS rechazado,
  b.revisado AS revisado,
  b.autorizado_el AS autorizado_el,
  b.autorizado_por AS autorizado_por,
  b.MetodoPago AS MetodoPago,
  b.FormaPago AS FormaPago,
  b.UsoCFDI AS UsoCFDI,
  b.iva_revisado AS iva_revisado,
  b.iva_revisado_por AS iva_revisado_por,
  b.iva_revisado_el AS iva_revisado_el,
  b.ultimo_cambio AS ultimo_cambio,
  b.ultimo_cambio_por AS ultimo_cambio_por,
  b.cliente_rfc AS cliente_rfc,
  b.referencia AS referencia,
  b.cuenta_t_mov_id AS origen_mov_id,
  'NO' AS factura_directa,
  b.moneda_id AS moneda_id,
  b.fecha_capturado AS fecha_capturado,
  b.json_file_attachments AS json_file_attachments,
  b.cancelacion_revisada,
  b.cancelacion_revisada_por,
  b.cancelacion_revisada_el,
  b.cancelacion_el,
  b.cuenta_t_mov_id as cuentat_mov_id
  FROM cheque_pago b
   FORCE INDEX (links_al_banco_live)
  WHERE b.banco_cuenta_id > 0 AND b.banco_cuenta_mov_link_id <> ''  AND b.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  c.pagare_pago_id AS link_id,
  c.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  c.origen AS origen,
  c.pagare_id AS doc_id,
  c.cuentaT_id AS cuentaT_id,
  c.tienda_id AS tienda_id,
  c.fecha AS fecha,
  c.banco_cuenta_id AS banco_cuenta_id,
  c.metodo_pago_id AS cuentaT_tipo_mov_id,
  c.deposit_total AS deposit_total,
  c.quantity_total AS quantity_total,
  c.ide_amount AS ide_amount,
  c.ide_percent AS ide_percent,
  c.quantity_ctat AS egreso,
  0.00 AS monto,
  c.tipo_cash_nota AS tipo_cash_nota,
  c.cash_nota_num AS cash_nota_num,
  c.deposit_fecha AS deposit_fecha,
  c.cliente AS cliente,
  c.factura AS factura,
  c.factura_numero AS factura_numero,
  c.iva_incluido AS iva_incluido,
  c.ivacobradox100 AS ivacobradox100,
  IF((c.iva_incluido = 'SI'),0.00,c.ivacobradototal) AS ivarealmentecobrado,
  IF((c.iva_incluido = 'NO'),0.00,c.ivacobradototal) AS ivacobradototal,
  c.alta_db AS alta_db,
  c.alta_por AS alta_por,
  c.numero_referencia AS numero_referencia,
  c.cash_num_cobro_iva AS cash_num_cobro_iva,
  c.empresa_id AS empresa_id,
  c.comentario AS remarks,
  c.puede_borrar AS puede_borrar,
  c.activo AS activo,
  c.afecta_cuentat AS afecta_cuentat,
  c.comments AS comments,
  c.autorizado AS autorizado,
  c.rechazado AS rechazado,
  c.revisado AS revisado,
  c.autorizado_el AS autorizado_el,
  c.autorizado_por AS autorizado_por,
  c.MetodoPago AS MetodoPago,
  c.FormaPago AS FormaPago,
  c.UsoCFDI AS UsoCFDI,
  c.iva_revisado AS iva_revisado,
  c.iva_revisado_por AS iva_revisado_por,
  c.iva_revisado_el AS iva_revisado_el,
  c.ultimo_cambio AS ultimo_cambio,
  c.ultimo_cambio_por AS ultimo_cambio_por,
  c.cliente_rfc AS cliente_rfc,
  c.referencia AS referencia,
  c.cuenta_t_mov_id AS origen_mov_id,
  'NO' AS factura_directa,
  c.moneda_id AS moneda_id,
  c.fecha_capturado AS fecha_capturado,
  c.json_file_attachments AS json_file_attachments,
  c.cancelacion_revisada,
  c.cancelacion_revisada_por,
  c.cancelacion_revisada_el,
  c.cancelacion_el,
  c.cuenta_t_mov_id as cuentat_mov_id
  FROM pagare_pago c
   FORCE INDEX (links_al_banco_live)
  WHERE c.banco_cuenta_id > 0 AND c.banco_cuenta_mov_link_id <> '' AND c.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  j.vale_pago_id AS link_id,
  j.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  j.origen AS origen,
  j.vale_id AS doc_id,
  j.cuentaT_id AS cuentaT_id,
  j.tienda_id AS tienda_id,
  j.fecha AS fecha,
  j.banco_cuenta_id AS banco_cuenta_id,
  j.metodo_pago_id AS cuentaT_tipo_mov_id,
  j.deposit_total AS deposit_total,
  j.quantity_total AS quantity_total,
  j.ide_amount AS ide_amount,
  j.ide_percent AS ide_percent,
  j.quantity_ctat AS egreso,
  0.00 AS monto,
  j.tipo_cash_nota AS tipo_cash_nota,
  j.cash_nota_num AS cash_nota_num,
  j.deposit_fecha AS deposit_fecha,
  j.cliente AS cliente,
  j.factura AS factura,
  j.factura_numero AS factura_numero,
  j.iva_incluido AS iva_incluido,
  j.ivacobradox100 AS ivacobradox100,
  IF((j.iva_incluido = 'SI'),0.00,j.ivacobradototal) AS ivarealmentecobrado,
  IF((j.iva_incluido = 'NO'),0.00,j.ivacobradototal) AS ivacobradototal,
  j.alta_db AS alta_db,
  j.alta_por AS alta_por,
  j.numero_referencia AS numero_referencia,
  j.cash_num_cobro_iva AS cash_num_cobro_iva,
  j.empresa_id AS empresa_id,
  j.comentario AS remarks,
  j.puede_borrar AS puede_borrar,
  j.activo AS activo,
  j.afecta_cuentat AS afecta_cuentat,
  j.comments AS comments,
  j.autorizado AS autorizado,
  j.rechazado AS rechazado,
  j.revisado AS revisado,
  j.autorizado_el AS autorizado_el,
  j.autorizado_por AS autorizado_por,
  j.MetodoPago AS MetodoPago,
  j.FormaPago AS FormaPago,
  j.UsoCFDI AS UsoCFDI,
  j.iva_revisado AS iva_revisado,
  j.iva_revisado_por AS iva_revisado_por,
  j.iva_revisado_el AS iva_revisado_el,
  j.ultimo_cambio AS ultimo_cambio,
  j.ultimo_cambio_por AS ultimo_cambio_por,
  j.cliente_rfc AS cliente_rfc,
  j.referencia AS referencia,
  j.cuenta_t_mov_id AS origen_mov_id,
  'NO' AS factura_directa,
  j.moneda_id AS moneda_id,
  j.fecha_capturado AS fecha_capturado,
  '' AS json_file_attachments,
  j.cancelacion_revisada,
  j.cancelacion_revisada_por,
  j.cancelacion_revisada_el,
  j.cancelacion_el,
  j.cuenta_t_mov_id as cuentat_mov_id
  FROM vale_pago j

  WHERE j.banco_cuenta_id > 0 AND j.banco_cuenta_mov_link_id <> ''
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  d.vale_id AS link_id,
  d.banco_cuenta_mov_link_id,
  d.origen,
  d.vale_id AS doc_id,
  d.cuentaT_id,
  d.tienda_id,
  d.fecha,
  d.banco_cuenta_id,
  d.metodo_pago_id AS cuentaT_tipo_mov_id,
  d.deposit_total AS deposit_total,
  d.quantity_total AS quantity_total,
  d.ide_amount,
  d.ide_percent,
  d.quantity_total AS egreso,
  0.00 AS monto,
  d.tipo_cash_nota,
  d.cash_nota_num,
  d.deposit_fecha,
  IF((d.deposit_cliente is null OR d.deposit_cliente=''),IF((d.cliente_id is null),d.cliente,cliente.nombre), d.deposit_cliente) AS cliente,
  d.factura,
  d.factura_numero,
  d.iva_incluido AS iva_incluido,
  d.ivacobradox100,
  IF((d.iva_incluido = 'SI'),0.00,d.ivacobradototal) AS ivarealmentecobrado,
  IF((d.iva_incluido = 'NO'),0.00,d.ivacobradototal) AS ivacobradototal,
  d.alta_db,
  d.alta_por,
  d.numero_referencia AS numero_referencia,
  d.cash_num_cobro_iva,
  d.empresa_id,
  d.remarks,
  'NO' AS puede_borrar,
  IF((d.cancelado = 1),'No','Si') AS activo,
  d.afecta_cuentat AS afecta_cuentat,
  d.comments AS comments,
  d.autorizado AS autorizado,
  d.rechazado AS rechazado,
  d.revisado AS revisado,
  d.autorizado_el AS autorizado_el,
  d.autorizado_por AS autorizado_por,
  d.MetodoPago AS MetodoPago,
  d.FormaPago AS FormaPago,
  d.UsoCFDI AS UsoCFDI,
  d.iva_revisado AS iva_revisado,
  d.iva_revisado_por AS iva_revisado_por,
  d.iva_revisado_el AS iva_revisado_el,
  d.ultimo_cambio,
  d.ultimo_cambio_por,
  d.cliente_rfc,
  d.referencia,
  d.cuenta_t_mov_id AS origen_mov_id,
  'NO' AS factura_directa,
  d.recibido_moneda_id AS moneda_id,
  d.fecha_capturado AS fecha_capturado,
  d.json_file_attachments AS json_file_attachments,
  d.cancelacion_revisada,
  d.cancelacion_revisada_por,
  d.cancelacion_revisada_el,
  d.cancelacion_el,
  d.cuenta_t_mov_id as cuentat_mov_id
  FROM vale d LEFT JOIN cliente ON(d.cliente_id = cliente.cliente_id)
  WHERE d.banco_cuenta_id > 0 AND d.banco_cuenta_mov_link_id <> '' AND d.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (
 SELECT
 e.cuentat_a_banco_tc_mov_id AS link_id,
 e.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
 e.origen AS origen,
 e.cuentat_a_banco_tc_mov_id AS doc_id,
 e.cuentaT_id AS cuentaT_id,
 e.tienda_id AS tienda_id,
 e.fecha AS fecha,
 e.banco_cuenta_id AS banco_cuenta_id,
 e.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id,
 e.deposit_total AS quantity_total,
 e.quantity_total AS quantity_total,
 e.ide_amount AS ide_amount,
 e.ide_percent AS ide_percent,
 e.egreso AS egreso,
 e.monto AS monto,
 e.tipo_cash_nota AS tipo_cash_nota,
 e.cash_nota_num AS cash_nota_num,
 e.deposit_fecha AS deposit_fecha,
 e.cliente AS cliente,
 e.factura AS factura,
 e.factura_numero AS factura_numero,
 e.iva_incluido AS iva_incluido,
 e.ivacobradox100 AS ivacobradox100,
 IF((e.iva_incluido = 'SI'),0.00,e.ivacobradototal) AS ivarealmentecobrado,
 IF((e.iva_incluido = 'NO'),0.00,e.ivacobradototal) AS ivacobradototal,
 e.alta_db AS alta_db,
 e.alta_por AS alta_por,
 e.numero_referencia AS numero_referencia,
 e.cash_num_cobro_iva AS cash_num_cobro_iva,
 e.empresa_id AS empresa_id,
 e.remarks AS remarks,
 e.puede_borrar AS puede_borrar,
 e.activo AS activo,
 e.afecta_cuentat AS afecta_cuentat,
 e.comments AS comments,
 e.autorizado AS autorizado,
 e.rechazado AS rechazado,
 e.revisado AS revisado,
 e.autorizado_el AS autorizado_el,
 e.autorizado_por AS autorizado_por,
 e.MetodoPago AS MetodoPago,
 e.FormaPago AS FormaPago,
 e.UsoCFDI AS UsoCFDI,
 e.iva_revisado AS iva_revisado,
 e.iva_revisado_por AS iva_revisado_por,
 e.iva_revisado_el AS iva_revisado_el,
 e.ultimo_cambio AS ultimo_cambio,
 e.ultimo_cambio_por AS ultimo_cambio_por,
 e.cliente_rfc AS cliente_rfc,
 e.referencia AS referencia,
 e.origen_mov_id AS origen_mov_id,
 e.factura_directa AS factura_directa,
 e.moneda_id AS moneda_id,
 e.fecha_capturado AS fecha_capturado,
 e.json_file_attachments AS json_file_attachments,
 e.cancelacion_revisada,
 e.cancelacion_revisada_por,
 e.cancelacion_revisada_el,
 e.cancelacion_el,
 e.origen_mov_id as cuentat_mov_id
 FROM cuentat_a_banco_tc e
 WHERE e.alta_db > fecha_limite
 ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  f.banco_cuenta_trans_id AS link_id,
  f.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  f.origen AS origen,
  f.banco_cuenta_trans_id AS doc_id,
  f.cuentaT_id AS cuentaT_id,
  f.tienda_id AS tienda_id,
  f.fecha AS fecha,
  f.banco_cuenta_id AS banco_cuenta_id,
  f.cuentaT_tipo_mov_id AS cuentaT_tipo_mov_id,
  f.deposit_total AS quantity_total,
  f.quantity_total AS quantity_total,
  f.ide_amount AS ide_amount,
  f.ide_percent AS ide_percent,
  f.egreso AS egreso,
  f.monto AS monto,
  f.tipo_cash_nota AS tipo_cash_nota,
  f.cash_nota_num AS cash_nota_num,
  f.deposit_fecha AS deposit_fecha,
  f.cliente AS cliente,
  f.factura AS factura,
  f.factura_numero AS factura_numero,
  'No' AS iva_incluido,
  0.00 AS ivacobradox100,
  0.00 AS ivarealmentecobrado,
  0.00 AS ivacobradototal,
  f.alta_db AS alta_db,
  f.alta_por AS alta_por,
  f.numero_referencia AS numero_referencia,
  f.cash_num_cobro_iva AS cash_num_cobro_iva,
  f.empresa_id AS empresa_id,
  f.remarks AS remarks,
  f.puede_borrar AS puede_borrar,
  f.activo AS activo,
  f.afecta_cuentat AS afecta_cuentat,
  f.comments AS comments,
  f.autorizado AS autorizado,
  f.rechazado AS rechazado,
  f.revisado AS revisado,
  f.autorizado_el AS autorizado_el,
  f.autorizado_por AS autorizado_por,
  f.MetodoPago AS MetodoPago,
  f.FormaPago AS FormaPago,
  f.UsoCFDI AS UsoCFDI,
  f.iva_revisado AS iva_revisado,
  f.iva_revisado_por AS iva_revisado_por,
  f.iva_revisado_el AS iva_revisado_el,
  f.ultimo_cambio AS ultimo_cambio,
  f.ultimo_cambio_por AS ultimo_cambio_por,
  f.cliente_rfc AS cliente_rfc,
  f.referencia AS referencia,
  f.origen_banco_cuenta_id AS origen_mov_id,
  f.factura_directa AS factura_directa,
  f.moneda_id AS moneda_id,
  f.fecha_capturado AS fecha_capturado,
  f.json_file_attachments AS json_file_attachments,
  f.cancelacion_revisada,
  f.cancelacion_revisada_por,
  f.cancelacion_revisada_el,
  f.cancelacion_el,
  '' as cuentat_mov_id
  FROM banco_cuenta_trans f
  WHERE f.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  g.cheque_pago_log_id AS link_id,
  g.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  g.origen AS origen,
  g.cheque_id AS doc_id,
  g.cuentaT_id AS cuentaT_id,
  g.tienda_id AS tienda_id,
  g.fecha AS fecha,
  g.banco_cuenta_id AS banco_cuenta_id,
  g.metodo_pago_id AS cuentaT_tipo_mov_id,
  g.deposit_total AS deposit_total,
  g.quantity_total AS quantity_total,
  g.ide_amount AS ide_amount,
  g.ide_percent AS ide_percent,
  g.quantity_total AS egreso,
  0.00 AS monto,
  g.tipo_cash_nota AS tipo_cash_nota,
  g.cash_nota_num AS cash_nota_num,
  g.deposit_fecha AS deposit_fecha,
  g.cliente AS cliente,
  g.factura AS factura,
  g.factura_numero AS factura_numero,
  'NO' AS iva_incluido,
  g.ivacobradox100 AS ivacobradox100,
  g.ivacobradototal AS ivarealmentecobrado,
  g.ivacobradototal AS ivacobradototal,
  g.alta_db AS alta_db,
  g.alta_por AS alta_por,
  g.numero_referencia AS numero_referencia,
  null AS cash_num_cobro_iva,
  g.empresa_id AS empresa_id,
  g.comentario AS remarks,
  g.puede_borrar AS puede_borrar,
  g.activo AS activo,
  'NO' AS afecta_cuentat,
  '' AS comments,
  g.autorizado AS autorizado,
  g.rechazado AS rechazado,
  g.revisado AS revisado,
  g.autorizado_el AS autorizado_el,
  g.autorizado_por AS autorizado_por,
  g.MetodoPago AS MetodoPago,
  g.FormaPago AS FormaPago,
  g.UsoCFDI AS UsoCFDI,
  g.iva_revisado AS iva_revisado,
  g.iva_revisado_por AS iva_revisado_por,
  g.iva_revisado_el AS iva_revisado_el,
  g.ultimo_cambio AS ultimo_cambio,
  g.ultimo_cambio_por AS ultimo_cambio_por,
  '' AS cliente_rfc,
  g.referencia AS referencia,
  '' AS origen_mov_id,
  'NO' AS factura_directa,
  g.moneda_id AS moneda_id,
  g.alta_db AS fecha_capturado,
  g.json_file_attachments AS json_file_attachments,
  g.cancelacion_revisada,
  g.cancelacion_revisada_por,
  g.cancelacion_revisada_el,
  g.cancelacion_el,
  g.cuenta_t_mov_id as cuentat_mov_id
  FROM cheque_pago_log g
  WHERE g.banco_cuenta_id > 0 AND g.banco_cuenta_mov_link_id <> ''  AND g.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  h.pagare_pago_log_id AS link_id,
  h.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  h.origen AS origen,
  h.pagare_id AS doc_id,
  h.cuentaT_id AS cuentaT_id,
  h.tienda_id AS tienda_id,
  h.fecha AS fecha,
  h.banco_cuenta_id AS banco_cuenta_id,
  h.metodo_pago_id AS cuentaT_tipo_mov_id,
  h.deposit_total AS deposit_total,
  h.quantity_total AS quantity_total,
  h.ide_amount AS ide_amount,
  h.ide_percent AS ide_percent,
  h.quantity_total AS egreso,
  0.00 AS monto,
  h.tipo_cash_nota AS tipo_cash_nota,
  h.cash_nota_num AS cash_nota_num,
  h.deposit_fecha AS deposit_fecha,
  h.cliente AS cliente,
  h.factura AS factura,
  h.factura_numero AS factura_numero,
  'NO' AS iva_incluido,
  h.ivacobradox100 AS ivacobradox100,
  ivacobradototal AS ivarealmentecobrado,
  ivacobradototal AS ivacobradototal,
  h.alta_db AS alta_db,
  h.alta_por AS alta_por,
  h.numero_referencia AS numero_referencia,
  null AS cash_num_cobro_iva,
  h.empresa_id AS empresa_id,
  h.comentario AS remarks,
  h.puede_borrar AS puede_borrar,
  h.activo AS activo,
  'NO' AS afecta_cuentat,
  '' AS comments,
  h.autorizado AS autorizado,
  h.rechazado AS rechazado,
  h.revisado AS revisado,
  h.autorizado_el AS autorizado_el,
  h.autorizado_por AS autorizado_por,
  h.MetodoPago AS MetodoPago,
  h.FormaPago AS FormaPago,
  h.UsoCFDI AS UsoCFDI,
  h.iva_revisado AS iva_revisado,
  h.iva_revisado_por AS iva_revisado_por,
  h.iva_revisado_el AS iva_revisado_el,
  h.ultimo_cambio AS ultimo_cambio,
  h.ultimo_cambio_por AS ultimo_cambio_por,
  '' AS cliente_rfc,
  h.referencia AS referencia,
  '' AS origen_mov_id,
  'NO' AS factura_directa,
  h.moneda_id AS moneda_id,
  h.alta_db AS fecha_capturado,
  h.json_file_attachments AS json_file_attachments,
  h.cancelacion_revisada,
  h.cancelacion_revisada_por,
  h.cancelacion_revisada_el,
  h.cancelacion_el,
  h.cuenta_t_mov_id as cuentat_mov_id
  FROM pagare_pago_log h
  WHERE h.banco_cuenta_id > 0 AND h.banco_cuenta_mov_link_id <> ''  AND h.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (SELECT
  k.vale_pago_log_id AS link_id,
  k.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
  k.origen AS origen,
  k.vale_id AS doc_id,
  k.cuentaT_id AS cuentaT_id,
  k.tienda_id AS tienda_id,
  k.fecha AS fecha,
  k.banco_cuenta_id AS banco_cuenta_id,
  k.metodo_pago_id AS cuentaT_tipo_mov_id,
  k.deposit_total AS deposit_total,
  k.quantity_total AS quantity_total,
  k.ide_amount AS ide_amount,
  k.ide_percent AS ide_percent,
  k.quantity_total AS egreso,
  0.00 AS monto,
  k.tipo_cash_nota AS tipo_cash_nota,
  k.cash_nota_num AS cash_nota_num,
  k.deposit_fecha AS deposit_fecha,
  k.cliente AS cliente,
  k.factura AS factura,
  k.factura_numero AS factura_numero,
  'NO' AS iva_incluido,
  k.ivacobradox100 AS ivacobradox100,
  ivacobradototal AS ivarealmentecobrado,
  ivacobradototal AS ivacobradototal,
  k.alta_db AS alta_db,
  k.alta_por AS alta_por,
  k.numero_referencia AS numero_referencia,
  '' AS cash_num_cobro_iva,
  k.empresa_id AS empresa_id,
  k.comentario AS remarks,
  k.puede_borrar AS puede_borrar,
  k.activo AS activo,
  'NO' AS afecta_cuentat,
  '' AS comments,
  k.autorizado AS autorizado,
  k.rechazado AS rechazado,
  k.revisado AS revisado,
  k.autorizado_el AS autorizado_el,
  k.autorizado_por AS autorizado_por,
  k.MetodoPago AS MetodoPago,
  k.FormaPago AS FormaPago,
  k.UsoCFDI AS UsoCFDI,
  k.iva_revisado AS iva_revisado,
  k.iva_revisado_por AS iva_revisado_por,
  k.iva_revisado_el AS iva_revisado_el,
  k.ultimo_cambio AS ultimo_cambio,
  k.ultimo_cambio_por AS ultimo_cambio_por,
  '' AS cliente_rfc,
  k.referencia AS referencia,
  '' AS origen_mov_id,
  'NO' AS factura_directa,
  k.moneda_id AS moneda_id,
  k.alta_db AS fecha_capturado,
  '' AS json_file_attachments,
  k.cancelacion_revisada,
  k.cancelacion_revisada_por,
  k.cancelacion_revisada_el,
  k.cancelacion_el,
  k.cuenta_t_mov_id as cuentat_mov_id
  FROM vale_pago_log k
  WHERE k.banco_cuenta_id > 0 AND k.banco_cuenta_mov_link_id <> '' AND k.alta_db > fecha_limite
  ORDER BY fecha DESC, alta_db DESC)
 UNION ALL
 (
 SELECT
 i.inversion_reembolso_id AS link_id,
 i.banco_cuenta_mov_link_id AS banco_cuenta_mov_link_id,
 i.origen AS origen,
 i.inversion_id AS doc_id,
 0 AS cuentaT_id,
 null AS tienda_id,
 i.fecha AS fecha,
 i.banco_cuenta_id AS banco_cuenta_id,
 '22' AS cuentaT_tipo_mov_id,
 i.monto_global_reembolso AS quantity_total,
 i.monto_global_reembolso AS quantity_total,
 0.00 AS ide_amount,
 0.00 AS ide_percent,
 i.monto_reembolsado + i.monto_interes AS egreso,
 0.00 AS monto,
 i.tipo_cash_nota AS tipo_cash_nota,
 i.cash_nota_num AS cash_nota_num,
 i.fecha_deposito AS deposit_fecha,
 i.cliente AS cliente,
 i.factura AS factura,
 i.factura_numero AS factura_numero,
 'No' AS iva_incluido,
 0.00 AS ivacobradox100,
 0.00 AS ivarealmentecobrado,
 0.00 AS ivacobradototal,
 i.alta_db AS alta_db,
 i.alta_por AS alta_por,
 i.numero_referencia AS numero_referencia,
 null AS cash_num_cobro_iva,
 i.empresa_id AS empresa_id,
 i.remarks AS remarks,
 'No' AS puede_borrar,
 i.activo AS activo,
 'NO' AS afecta_cuentat,
 i.comments AS comments,
 i.autorizado AS autorizado,
 i.rechazado AS rechazado,
 i.revisado AS revisado,
 i.autorizado_el AS autorizado_el,
 i.autorizado_por AS autorizado_por,
 i.MetodoPago AS MetodoPago,
 i.FormaPago AS FormaPago,
 i.UsoCFDI AS UsoCFDI,
 'No' AS iva_revisado,
 '' AS iva_revisado_por,
 null AS iva_revisado_el,
 i.ultimo_cambio AS ultimo_cambio,
 i.ultimo_cambio_por AS ultimo_cambio_por,
 '' AS cliente_rfc,
 '' AS referencia,
 null AS origen_mov_id,
 'No' AS factura_directa,
 1 AS moneda_id,
 i.alta_db AS fecha_capturado,
 i.json_file_attachments AS json_file_attachments,
 i.cancelacion_revisada,
 i.cancelacion_revisada_por,
 i.cancelacion_revisada_el,
 i.cancelacion_el,
 '' as cuentat_mov_id
 FROM inversion_reembolso i
 WHERE i.alta_db > fecha_limite
 ORDER BY fecha DESC, alta_db DESC);

INSERT IGNORE INTO links_al_banco_live SELECT * FROM aa_tmp_xyz123 ORDER BY fecha DESC, alta_db DESC;

END;

