create
    definer = root@localhost procedure existenciaBodegasProducto(IN fecha date, IN producto_general_id varchar(32))
    comment 'Regresa la existencia en todas las bodegas a la fecha indicada del producto en todos sus colores'
    reads sql data
BEGIN
    DECLARE EXIT HANDLER FOR 1243
        BEGIN
            PREPARE stmtEBP FROM
                'WITH hay as
                          (SELECT bodega_id,
                                  SUM(existencia_rollos_inicial) as rollos_inicial,
                                  SUM(existencia_rollos) as rollos_final,
                                  SUM(existencia_quantity_inicial) as quantity_inicial,
                                  SUM(existencia_quantity) as quantity_final
                           FROM bodega_existencia_diaria
                           WHERE fecha <= ? AND producto_general_id = ?
                           GROUP BY 1
                           HAVING MAX(fecha)
                          )
                 SELECT
                     SUM(rollos_inicial) as rollos_inicial,
                     SUM(rollos_final) as rollos_final,
                     SUM(quantity_inicial) as quantity_inicial,
                     SUM(quantity_final) as quantity_final
                 FROM hay';
            SET @fechaEBP = fecha;
            SET @producto_general_idEBP = producto_general_id;
            EXECUTE stmtEBP USING @fechaEBP, @producto_general_idEBP;
        END;
    SET @fechaEBP = fecha;
    SET @producto_general_idEBP = producto_general_id;
    EXECUTE stmtEBP USING @fechaEBP, @producto_general_idEBP;
END;

