create
    definer = root@localhost function extract_cliente_ids(json_data json) returns varchar(1024) deterministic
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE v_cliente_id VARCHAR(191);
    DECLARE result VARCHAR(1024) DEFAULT NULL;

    DECLARE cur CURSOR FOR 
        SELECT jt.cliente_id
        FROM JSON_TABLE(json_data, '$[*]' COLUMNS (
            cliente_id VARCHAR(32) PATH '$.cliente_id',
fue_error CHAR(2) PATH '$.fue_error'
        )) AS jt
        WHERE
            jt.fue_error = 'No';

    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    -- Open cursor
    OPEN cur;

    -- Loop through values
    read_loop: LOOP
        FETCH cur INTO v_cliente_id;
        IF done THEN
            LEAVE read_loop;
        END IF;
        -- Concatenate values
        SET result = IFNULL(CONCAT(result, ', ', v_cliente_id), v_cliente_id);
    END LOOP;

    -- Close cursor
    CLOSE cur;

    RETURN result;
END;

