create
    definer = root@localhost function extract_cliente_nombre(json_data json) returns varchar(1024) deterministic
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE v_nombre VARCHAR(191);
    DECLARE result VARCHAR(1024) DEFAULT NULL;

    DECLARE cur CURSOR FOR 
        SELECT jt.nombre
        FROM JSON_TABLE(json_data, '$[*]' COLUMNS (
            nombre VARCHAR(191) PATH '$.nombre',
fue_error CHAR(2) PATH '$.fue_error'
        )) AS jt
        WHERE
            jt.fue_error = 'No';

    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    -- Open cursor
    OPEN cur;

    -- Loop through values
    read_loop: LOOP
        FETCH cur INTO v_nombre;
        IF done THEN
            LEAVE read_loop;
        END IF;
        -- Concatenate values
        SET result = IFNULL(CONCAT(result, ', ', v_nombre), v_nombre);
    END LOOP;

    RETURN result;
END;

