create
    definer = root@localhost function extract_pedido_por_values(json_data json) returns varchar(1024) deterministic
BEGIN
    DECLARE done INT DEFAULT FALSE;
    DECLARE v_lbl VARCHAR(191);
    DECLARE result VARCHAR(1024) DEFAULT NULL;

    DECLARE cur CURSOR FOR 
        SELECT jt.lbl
        FROM JSON_TABLE(json_data, '$[*]' COLUMNS (
            lbl VARCHAR(191) PATH '$.lbl',
fue_error CHAR(2) PATH '$.fue_error'
        )) AS jt
        WHERE
            jt.fue_error = 'No';
    
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

    -- Open cursor
    OPEN cur;

    -- Loop through values
    read_loop: LOOP
        FETCH cur INTO v_lbl;
        IF done THEN
            LEAVE read_loop;
        END IF;
        -- Concatenate values
        SET result = IFNULL(CONCAT(result, ', ', v_lbl), v_lbl);
    END LOOP;

    -- Close cursor
    CLOSE cur;

    RETURN result;
END;

