create
    definer = root@localhost procedure insertPorBodega(IN bodega_id varchar(32), IN whereField varchar(191),
                                                       IN tableToFill varchar(1024), IN originalTable varchar(1024))
    comment 'Version 1.1, Inserta a tableToFill los renglones con bodega_id todos los campos excepto los generated de originalTable'
    modifies sql data
BEGIN

    DECLARE getCols LONGTEXT;
    DECLARE colsToFill LONGTEXT;
    DECLARE inserter LONGTEXT;
    DECLARE onDupUpdate LONGTEXT;

    SET @getColsFiltraBodega =
            'SELECT GROUP_CONCAT(DISTINCT CONCAT(\'`\',column_name,\'`\') SEPARATOR \',\r\n\t\'),
                GROUP_CONCAT(DISTINCT CONCAT(\'`\',column_name,\'` = VALUES(`\',column_name,\'`\)\') SEPARATOR \',\r\n\t\')
                INTO @colsToFill,@onDupUpdate
           FROM ( select column_name, ORDINAL_POSITION
                  from information_schema.columns
                  where length(generation_expression) = 0 AND table_schema = DATABASE()
                    AND table_name=?) as qry' ;


    PREPARE stmtCols FROM @getColsFiltraBodega;
    SET @originalTableFiltraBodega=originalTable;
    EXECUTE stmtCols USING @originalTableFiltraBodega;
    DEALLOCATE PREPARE stmtCols;

    SET @inserterFiltraBodega = CONCAT('INSERT INTO ', tableToFill, '(\r\n', @colsToFill, '\r\n) SELECT\r\n', @colsToFill,
                                       '\r\nFROM ', originalTable, ' WHERE ', whereField , '=?'
                                           ' ON DUPLICATE KEY UPDATE ',@onDupUpdate
        );

    PREPARE stmtInsert FROM @inserterFiltraBodega;
    SET @bodega_idFiltraBodega=bodega_id;
    EXECUTE stmtInsert USING @bodega_idFiltraBodega;
    DEALLOCATE PREPARE stmtInsert;

END;

