<?php
    // v0.0
    /*
       	CAMPOS_EN_DB_START
		primary key: 'banco_cuenta_id' al 2026-01-13 16:39
		nombre,moneda_id,vale,numero,clabe,banco_id,ultima_conciliacion,banco_china,ignorar_bran,naturaleza,empresa_id,tipo_inversion_empresa_privada,ingresar_depositos,estus_depositos_a_mano,modificar_referencia_original,remarks,orden,ultima_check,dep_inactiva,banco_cuenta_id
	CAMPOS_EN_DB_END
    */
    /*
       	DELETE_RULES_START

	Dependen de banco_cuenta:
		banco_cuenta_mov:
			Restricts delete me: si. Is deleted with me: no.jqgrid/child. Links by banco_cuenta_id
		banco_cuenta_mov_con_links:
			Restricts delete me: NO. Is deleted with me: SI.jqgrid/child. Links by banco_cuenta_id
		banco_cuenta_mov_plantilla:
			Restricts delete me: NO. Is deleted with me: SI.jqgrid/child. Links by banco_cuenta_id
		banco_cuenta_trans:
			Restricts delete me: si. Is deleted with me: no.jqgrid/child. Links by banco_cuenta_id
		banco_cuenta_saldos:
			Restricts delete me: NO. Is deleted with me: no./. Links by es
		banco_cuenta_saldos_hist:
			Restricts delete me: NO. Is deleted with me: no./. Links by es
	Usa tablas:
		empresa:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by empresa_id
		banco:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_id
	DELETE_RULES_END
    */

class app_banco_cuenta extends iacase_base {

    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate;
        if( empty($table) )
            $table='banco_cuenta';

        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();
        $this->label="Cuentas bancarias";
        $this->modo='cardex_window';     // cardex, jqgrid_form forma de jqgrid, jqgrid_iacform forma de iacase, jqgrid_inline (inline falta)

        //$this->asChild=false;      // en true esta instancia es child table
        //$this->childTables=array();  // childTables to use
        $this->saveChilds=false;    // en false no hace child tables en el save
        $this->editChilds=false;    // en false no saca tablita add another editar childs
        $this->viewChilds=false;    // en false no muestra childs

        $puede= usuarioTipoRony($_SESSION['usuario_id']);
        //$this->permiso_app=true;
        $this->permiso_delete=$puede;
        //$this->permiso_export=true;
        $this->permiso_insert=$puede;
        $this->permiso_list=$puede;
        $this->permiso_read=$puede;
        $this->permiso_update=$puede;


        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        //$this->cols_list='*';
        /* ojo trae campos del momento de creacion
            banco_cuenta_id,nombre,empresa_id,banco_id,moneda_id,numero,clabe,naturaleza,orden,ultima_conciliacion,ultima_check,remarks
        */
        //$this->list_sortname_dflt='';
        //$this->list_sortorder_dflt='';
        $this->col_list_noShow=array('ultima_check','dep_inactiva');    // estas ni llegan al jqgrid
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->useJqueryValidate=false;

        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;
        //$this->formTypeChildsPerRow=2;

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->colModel_overRide=array(); // override generated colModel

        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica


        //$this->extraParams=array();    // parametros extra en links

        //$this->log_cardex_view=false; // ture log each iah=r pageview
    }

//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_banco_cuenta::campos_final
     * Redefine $campos del default en campos_default
     *
     */
    private function campos_final() {
        /*
        // pkfields=array( 'banco_cuenta_id' );
        */

        $this->campos['nombre']['label']='Cuenta';
        $this->campos['remarks']['formato']='fckeditor';
        $this->campos['ultima_conciliacion']['modo']='R/O';
        $this->campos['ultima_conciliacion']['label']='Última Conciliación';
        //$this->campos['ultima_conciliacion']['Type']='varchar';
        $this->campos['banco_china']['label']='¿Es Banco de China?';
        $this->campos['numero']['label']='Número';
        $this->campos['ultima_check']['modo']='Nada';
        $this->campos['orden']['modo']='Nada';
        $this->campos['dep_inactiva']['modo']='Nada';

        $this->campos['ignorar_bran']['label']='Ignorar Brain';
        $this->campos['vale']['label']='Estado';



        $this->campos['tipo_inversion_empresa_privada'] = [
            'title' => '',
            'display_group' => '',
            'label' => 'Tipo',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
//            'Type' => 'varchar',
            'modo' => 'R/W',
            'Default' => 'empresa',
        ];

        $this->campos['ingresar_depositos'] = [
            'title' => 'Forma en la que se ingresan los depósitos',
            'label' => 'Ingresar depósitos a Mano ó Automaicamente',
            'display_group' => 'parametros',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => 'Automatico',
        ];
        $this->campos['estus_depositos_a_mano'] = [
            'title' => 'Estatus de los depósitos al ingresar de manera manual en el banco',
            'label' => 'Estatus del depósito al ingresar a mano ',
            'display_group' => 'parametros',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => '',
        ];
        $this->campos['modificar_referencia_original'] = [
            'title' => 'Se Puede modificar referencia original en los movimientos de esta cuenta',
            'label' => 'Pueden capturar/modificar referencia original en la cuenta',
            'display_group' => 'parametros',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => 'No',
        ];

        $orden=array(
            'nombre','moneda_id','vale','numero','clabe','banco_id','ultima_conciliacion',
            'banco_china', 'ignorar_bran','naturaleza', 'empresa_id','tipo_inversion_empresa_privada',
            'ingresar_depositos', 'estus_depositos_a_mano', 'modificar_referencia_original',
            'remarks',
			'orden','ultima_check',

        );

        unset($this->campos['banco_china'], $this->campos['ignorar_bran'], $this->campos['naturaleza']);

        $this->campos_reorder($orden);
        $this->campos_set_attribute( array('nombre','numero','clabe'),'size','32' );
        $this->campos_set_attribute( array('nombre','moneda_id','numero','clabe','banco_id','ultima_conciliacion'),'display_group','Datos Bancarios' );
        $this->campos_set_attribute( array('nombre','moneda_id','numero','clabe','banco_id','ultima_conciliacion'),'display_group_label','Datos Bancarios' );

        $this->campos_set_attribute( array('banco_china', 'ignorar_bran', 'empresa_id','vale','naturaleza','tipo_inversion_empresa_privada'),'display_group','Tipo' );
        $this->campos_set_attribute( array('banco_china', 'ignorar_bran', 'empresa_id','vale','naturaleza','tipo_inversion_empresa_privada'),'display_group_label','Tipo' );

        $this->campos_set_attribute( ['ingresar_depositos', 'estus_depositos_a_mano', 'modificar_referencia_original'],'display_group','parametros' );
        $this->campos_set_attribute( ['ingresar_depositos', 'estus_depositos_a_mano', 'modificar_referencia_original'],'display_group_label','Parametros' );

        $tiene_saldo = $this->tiene_saldo();

        if(!empty($this->id) && $tiene_saldo['tiene_saldo'] ) {
            $this->campos_set_attribute('vale','modo','R/O');
            $su_saldo = (empty($tiene_saldo['saldo']) || $tiene_saldo['saldo']==0 ? "" : " Saldo: ".number_format($tiene_saldo['saldo'],2,'.',',') ).
                    (empty($tiene_saldo['sbc']) || $tiene_saldo['sbc']==0 ? "" : " SBC: ".number_format($tiene_saldo['sbc'],2,'.',',') );
            $this->campos_set_attribute('nombre','pie',"<br><i style='font-weight:normal'>$su_saldo</i>");
        }


        $this->colModel_overRide=array(
        'nombre'=>array('width'=>'250', 'classes'=>'bold txt15px')
        );

    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::insert_add_sql_queries()
     * permite agregar queries al transaction del insert
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    function insert_add_sql_queries(&$sql,&$log) {
        $id="'<_id_>'"; //strit($this->values['banco_cuenta_id']);
        //$sql[]="INSERT INTO mov_verificado_usuario(banco_cuenta_id,usuario_id,puede) (SELECT $id,iac_usr_id,IF(tipo='Super user','R/W','Nada') FROM iac_usr) ON DUPLICATE KEY UPDATE puede=puede";
        //$sql[]="INSERT INTO banco_cuenta_mov_usuario(banco_cuenta_id,usuario_id,puede) (SELECT $id,iac_usr_id,IF(tipo='Super user','R/W','Nada') FROM iac_usr) ON DUPLICATE KEY UPDATE puede=puede";

        $sql[]="INSERT INTO banco_cuenta_mov_plantilla(banco_cuenta_id,plantilla_id,puede) (SELECT $id,plantilla_id,'Nada' FROM plantilla) ON DUPLICATE KEY UPDATE puede=puede";
        $sql[]="INSERT INTO mov_verificado_plantilla(banco_cuenta_id,plantilla_id,puede) (SELECT $id,plantilla_id,'Nada' FROM plantilla) ON DUPLICATE KEY UPDATE puede=puede";

        return true;
    }

    function insert_post_save() {
        $sql = "SELECT banco_cuenta_id WHERE nombre=".strit($this->values['nombre']);
        $this->id = $this->values['id'] = ia_singleread("SELECT banco_cuenta_id FROM banco_cuenta WHERE nombre=".strit($this->values['nombre']));

        ia_query("INSERT INTO `banco_cuenta_saldos_hist` (`banco_cuenta_id`, `saldo_actual`, `sbc`, `deposit_cash`, `deposit_total`, `withdrawal_total`, `Ultimo_Movimiento`, `Ultimo_cash`, `Ultimo_deposit`, `Ultimo_withdrawal`, `ultima_conciliacion`, `orden`, `nombre`, `deposit_last_year`, `deposit_custom_where`, `fiduciario_all`, `fiduciario_this_month`, `fiduciario_last_month`, `fiduciario_this_year`, `fiduciario_last_year`, `fiduciario_custom`, `fiduciario_custom_where`, `fid_ingreso_today`, `fid_ingreso_this_month`, `fid_ingreso_last_month`, `fid_ingreso_this_year`, `fid_ingreso_last_year`, `fid_ingreso_custom`, `fid_ingreso_custom_where`, `inv_ingreso_today`, `inv_ingreso_this_month`, `inv_ingreso_last_month`, `inv_ingreso_this_year`, `inv_ingreso_last_year`, `inv_ingreso_custom`, `inv_ingreso_custom_where`, `ingreso_today`, `ingreso_this_month`, `ingreso_last_month`, `ingreso_this_year`, `ingreso_last_year`, `ingreso_custom`, `ingreso_custom_where`, `inversion_all`, `inversion_today`, `inversion_this_month`, `inversion_last_month`, `inversion_this_year`, `inversion_last_year`, `inversion_custom`, `inversion_custom_where`) VALUES ($this->id, '0.00', '0.00', '0.00', '0.00', '0.00', '2021-12-31 14:00:57', NULL, NULL, NULL, NULL, '1000', '', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '', '', '', '', '', '', '', '')");
        //VCA OCT2019
        @generaCatalogos('banco_cuenta');
        return true;
    }

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::update_pre_validate()
     *
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * iacase::update_validate()
     *
     * @return
     */
    function update_validate()  {
        if(!isset($this->values['vale'])) {
            $this->values['vale'] = $this->enDB['vale'];
        }
        if($this->values['vale'] === 'Inactive') {
            // con saldo no puede cambiarse a inactive
            $tiene_saldo = $this->tiene_saldo();
            if($tiene_saldo['tiene_saldo']) {
                $this->msg_err =  "No se puede poner Inactive,".
                    (empty($tiene_saldo['saldo']) ? "" : " tiene saldo de ".number_format($tiene_saldo['saldo'],2,'.',',') ).
                    (empty($tiene_saldo['sbc']) ? "" : " tiene salvo buen cobro de ".number_format($tiene_saldo['sbc'],2,'.',',') );
            return false;
            }

        }
        if($this->values['moneda_id'] !== $this->enDB['moneda_id']) {
            $tiene_movs = ia_singleread("SELECT COUNT(*) FROM  banco_cuenta_mov WHERE banco_cuenta_id = ".strit($this->id));
            $tiene_saldo = $this->tiene_saldo();
            if($tiene_saldo['tiene_saldo'] || $tiene_movs) {
                $this->msg_err =  "No se puede cambiar la moneda, tiene ".number_format($tiene_movs,0,'',',')." movimientos. ".
                    (empty($tiene_saldo['saldo']) || $tiene_saldo['saldo']==0 ? "" : " y tiene saldo de ".number_format($tiene_saldo['saldo'],2,'.',',') ).
                    (empty($tiene_saldo['sbc']) || $tiene_saldo['sbc']==0 ? "" : " y tiene salvo buen cobro de ".number_format($tiene_saldo['sbc'],2,'.',',') );
                return false;
            }

        }
        return $this->validate();
    }
    function tiene_saldo() {
        $saldo = ia_singleread("SELECT SUM(bcm.cash)+SUM(bcm.deposit)-SUM(bcm.withdrawal) AS saldo_actual
        FROM  banco_cuenta_mov bcm
        WHERE bcm.banco_cuenta_id = ".strit($this->id));

        $sbc = ia_singleread("SELECT SUM(bcm.cash)+SUM(bcm.deposit)-SUM(bcm.withdrawal) AS saldo_actual
        FROM  banco_cuenta_mov bcm
        WHERE bcm.banco_cuenta_id = ".strit($this->id)." AND bcm.link_vale='SBC'");

        return ["tiene_saldo"=> $saldo !=0 || $sbc != 0, "saldo"=>$saldo, "sbc"=>$sbc];

    }
    /**
     * iacase::update_pre_save()
     *
     * @return
     */
    //function update_pre_save()  { return true; }
    /**
     * iacase::update_post_save()
     *
     * @return
     */
    function update_post_save()
    {
        //VCA OCT2019
        $inv_sql = "UPDATE inversion SET tipo_inversion_empresa_privada='" . $this->values['tipo_inversion_empresa_privada'] ."' WHERE banco_cuenta_id ='$this->id'";
        ia_query($inv_sql);
        @async_ws_generaCatalogos(array('inversion','banco_cuenta'));
        $this->setEstadosDepostiosEnParametros();
        return true;
    }

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
/////////////////////////////////
    function delete_pre_validate($h) {
        //trace_sql(true);
        $tiene_saldo = $this->tiene_saldo();
        if($tiene_saldo['tiene_saldo']) {
            $this->msg_err =  "No se puede borrar,".
                (empty($tiene_saldo['saldo']) ? "" : " tiene saldo de ".number_format($tiene_saldo['saldo'],2,'.',',') ).
                (empty($tiene_saldo['sbc']) ? "" : " tiene salvo buen cobro de ".number_format($tiene_saldo['sbc'],2,'.',',') );
            return false;
        }
        return true;
    }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    function delete_post_delete($h)
    {
        //VCA OCT2019
        @async_ws_generaCatalogos('QWERTY');
        //VCA DIC2022
        ia_query("DELETE FROM banco_cuenta_saldos WHERE banco_cuenta_id = ".strit($this->id));
    }

//////////////////////////////////
// FORM override functions
/////////////////////////////////
    /**
     * iacase::forma_pre()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_pre(&$h,&$nexth) {
        if(!empty($this->enDB['ultima_conciliacion']) && empty($this->values['ultima_conciliacion']))
            $this->values['ultima_conciliacion'] = $this->enDB['ultima_conciliacion'];
        return true;
    }
    /**
     * iacase::forma_preFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    // public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_postFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    // public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_doChilds()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    // public function forma_doChilds(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_post()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    //public function forma_post(&$h,&$nexth,$ok=true) { return true; }
    /**
     * iacase::forma_postDiv()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    public function forma_postDiv($h,$nexth) {

        $this->scriptParametros();

        parent::forma_postDiv($h,$nexth);
    }


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
/////////////////////////////////
    /**
     * iacase::listme_pre()
     *
     * @param mixed $grid
     * @return
     */
    function listme_pre($grid) {

        $filter =  '{"groupOp":"AND","rules":[{"field":"vale","op":"eq","data":"Active"}]}';
        $grid->postData_set( array('filters'=>$filter) );

        return true;
    }
    /**
     * iacase::listme_preRender()
     *
     * @param mixed $grid
     * @return
     */
    //function listme_preRender($grid) {return true;}
    /**
     * iacase::listme_post()
     *
     * @param mixed $grid
     * @return void
     */
    function listme_postRender($grid)
    {
        $nombreDoc = $this->label_list();
        $elEstilo = 'toolbarTitleChequeDD';
        echo <<<TOOLBAR
    <script>
    var gridhandler;
$(document).ready(function(){
    $('.toolbarTitle').closest('td').addClass("$elEstilo");
    gridhandler = iajqgridbanco_cuenta_var;
    gridhandler.jqGrid("colMenuAdd", "all", {
            id : "myid",
            title: 'Hide me',
            funcname: jqgrid_hidecol
        });
    vx_asyncFunction( () => { $('#gs_vale').val('Active').change(); }, 50);
});
    </script>
TOOLBAR;
    }
//////////////////////////////////
// QBE FORM override functions
/////////////////////////////////

//////////////////////////////////
// QBE doWHere override functions
/////////////////////////////////

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////
    /**
     * app_banco_cuenta::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'banco_cuenta_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'auto_increment',
    'display_group_break' => false,
  ),
  'nombre' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
    'UNI' => true,
  ),
  'empresa_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'empresa',
    'formato' => 'link_one_select',
  ),
  'banco_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'moneda_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'Default' => '1',
  ),
  'numero' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
  ),
  'clabe' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
  ),
  'naturaleza' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Fiscal',
  ),
  'vale' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Active',
  ),
  'orden' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'Nada',
    'Default' => '1000',
  ),
  'ultima_conciliacion' => 
  array (
    'title' => '',
    'display_group' => 'ultima',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'ultima_check' => 
  array (
    'title' => '',
    'display_group' => 'ultima',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'remarks' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
    'formato' => 'fckeditor',
  ),
  'banco_china' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'ignorar_bran' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'dep_inactiva' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'Default' => '0',
  ),
  'tipo_inversion_empresa_privada' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'empresa',
  ),
  'ingresar_depositos' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Automatico',
  ),
  'estus_depositos_a_mano' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'modificar_referencia_original' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

    private function scriptParametros()
    {
        echo <<<HTML
        <script>
        $(function () {
            if ($('#ingresar_depositos').val().strcasecmp('manual')==0) {
                $('label[for="estus_depositos_a_mano"]').text('Estatus del depósito al ingresar manualmente');
            }
            else {
                $('label[for="estus_depositos_a_mano"]').text('Estatus del depósito al importarlo automaticamente');
            }
            $('#ingresar_depositos').change(function () {
                if (this.value.strcasecmp('manual')==0) {
                    $('#modificar_referencia_original')[0].selectize.setValue('Si');
                    $('label[for="estus_depositos_a_mano"]').text('Estatus del depósito al ingresar manualmente');
                }
                else {
                    $('label[for="estus_depositos_a_mano"]').text('Estatus del depósito al importarlo automaticamente');
                }
            });
            //Ph. 11 Abril 2025
            $('#tipo_inversion_empresa_privada').change(function () {
                if (this.value.strcasecmp('externa')==0) {
                    $('#ingresar_depositos').selectize()[0].selectize.setValue('Manual');
                    $('#estus_depositos_a_mano').selectize()[0].selectize.setValue('Q');
                }
            });
        });
        </script>
        HTML;
    }

    private function setEstadosDepostiosEnParametros(): void
    {
        $query_nd = "UPDATE iac_parametros SET banco_cuenta_poner_deposito_ND_a_mano = (SELECT GROUP_CONCAT(banco_cuenta_id SEPARATOR ',') FROM banco_cuenta WHERE vale = 'Active' AND estus_depositos_a_mano = 'ND') WHERE iac_parametros_id = '1'";
        ia_query($query_nd);

        $query_q = "UPDATE iac_parametros SET banco_cuenta_poner_deposito_Q_a_mano = (SELECT GROUP_CONCAT(banco_cuenta_id SEPARATOR ',') FROM banco_cuenta WHERE vale = 'Active' AND estus_depositos_a_mano = 'Q') WHERE iac_parametros_id = '1'";
        ia_query($query_q);
    }

}
?>