<?php
    // v0.0
    //marzo2020
    /*
       	CAMPOS_EN_DB_START
		primary key: 'banco_cuenta_mov_id','fecha' al 2026-01-13 16:39
		banco_cuenta_id,es,cash,deposit,withdrawal,banco_mov_tipo_id,numero,banco_id,usado,puede_editar,verificado,verificado_el,verificado_por,mov_verificado_id,link_vale,remarks,idex100,factura,ivacobradox100,withdrawal_autorizado,withdrawal_autorizado_el,withdrawal_autorizado_por,idetotal,ivacobradototal,empresa_id,factura_numero,cash_nota_num,cliente,tienda_id,tipo_cash_nota,cobra_iva,alta_tipo,cash_num_cobro_iva,linkconfirmado_tienda_id,linkconfirmado_a,linkconfirmado_el,linkconfirmado_por,contpaq_cliente_id,categoria_gasto_id,cliente_rfc,pendiente,comments,remarks_log,iva_incluido,estado,asignacion,supervision,poliza_contabilidad,detalle_links,json_file_attachments,fecha1,importante,bc_empresa_id,link_el,link_por,numero_original,repetido,mov_repetido_id,link_cuenta_t,html_asignaciones,asig_semaforo_rony,asig_semaforo_usuarios,anotaciones,remarks_wot,moneda_id,poliza_contable,poliza_contable_el,poliza_contable_por,verificado_list,rechazado_list,ano,dia,referencia_monex,withdrawal_rechazado,withdrawal_rechazado_el,withdrawal_rechazado_por,pendiente_edocta,estado_edocta,fecha_hora,puede_borrar,tiempo_restante_para_borrar,alta_db_real,plantilla_withdrawals_de_banco_id,plantilla_prohibida,plantilla_prohibida_porque,plantilla_prohibida_uso,plantilla_prohibida_autorizada,plantilla_prohibida_autorizada_por,plantilla_prohibida_autorizada_el,numero_original_tagged,banco_diccionario_dato_id,balance_prev,balance,balance_op_desc,plantilla_withdrawals_remarks,banco_diccionario_dato_remarks,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_cuenta_mov_id
	CAMPOS_EN_DB_END
    */
    /*
       	DELETE_RULES_START

	Dependen de banco_cuenta_mov:
		banco_cuenta_mov_con_links:
			Restricts delete me: NO. Is deleted with me: SI.link_one_select/catalog_entry. Links by banco_cuenta_mov_id
		banco_cuenta_mov_link:
			Restricts delete me: si. Is deleted with me: no.link_one_select/catalog_entry. Links by banco_cuenta_mov_id
	Usa tablas:
		banco_cuenta:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_cuenta_id
		banco_mov_tipo:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_mov_tipo_id
		banco:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_id
		banco:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by plantilla_withdrawals_de_banco_id
		empresa:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by empresa_id
		empresa:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by bc_empresa_id
		banco_diccionario_dato:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_diccionario_dato_id
	DELETE_RULES_END
    */

class app_banco_cuenta_mov extends iacase_base {

    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate;
        if( empty($table) )
            $table='banco_cuenta_mov';
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();

        $this->modo='cardex_window';     // cardex, jqgrid_form forma de jqgrid, jqgrid_iacform forma de iacase, jqgrid_inline (inline falta)

        //$this->asChild=false;      // en true esta instancia es child table
        //$this->childTables=array();  // childTables to use
        //$this->saveChilds=true;    // en false no hace child tables en el save
        //$this->editChilds=true;    // en false no saca tablita add another editar childs
        //$this->viewChilds=true;    // en false no muestra childs

        $puede=usuarioTipoRony();
        $this->permiso_app=$puede;
        $this->permiso_delete=false;
        $this->permiso_export=$puede;
        $this->permiso_insert=false;
        $this->permiso_list=$puede;
        $this->permiso_read=$puede;
        $this->permiso_update=false;


        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        //$this->cols_list='*';
        /* ojo trae campos del momento de creacion
            banco_cuenta_mov_id,banco_cuenta_id,fecha,es,cash,deposit,withdrawal,banco_mov_tipo_id,numero,banco_id,usado,puede_editar,verificado,verificado_el,verificado_por,mov_verificado_id,link_vale,remarks,idex100,factura,ivacobradox100,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por
        */
        //$this->list_sortname_dflt='';
        //$this->list_sortorder_dflt='';
        //$this->col_list_noShow=array();    // estas ni llegan al jqgrid
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->useJqueryValidate=false;

        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;
        //$this->formTypeChildsPerRow=2;

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->colModel_overRide=array(); // override generated colModel

        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica


        //$this->extraParams=array();    // parametros extra en links

        //$this->log_cardex_view=false; // ture log each iah=r pageview
    }

//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_banco_cuenta_mov::campos_final
     * Redefine $campos del default en campos_default
     *
     */
    private function campos_final() {
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'max',1e6 ); // a fieldnameN cambiales 'max' a 1e6
        // comunes atributes son br,required,max,min,display_group,display_group_label
        /*
        // ojo trae campos del momento de creacion
        // pkfields=array( 'banco_cuenta_mov_id' );
        $orden=array(
            'banco_cuenta_id','fecha','es','cash','deposit','withdrawal'
			,'banco_mov_tipo_id','numero','banco_id','usado','puede_editar','verificado','verificado_el','verificado_por','mov_verificado_id','link_vale','remarks','idex100','factura','ivacobradox100','alta_db','alta_por','ultimo_cambio','ultimo_cambio_por'

        );

        $this->campos_reorder($orden);
        //$this->campos['fieldName']['br']=true;
        */

        /*
        ,colNames : ['$id','Balance','Banco','Cuenta','Fecha','Es','Withdrawal','Deposit','Cash','Estado','Tipo Mov.','Usado','Editable','¿Verificado?'
        ,'Verif. Fecha','Verif. Por','$vid',$LM_colNames'Remarks(Concept/Explain)','Comisión %','IDE $','Net Deposit',
        'Referencia(Number)','Factura','IVA %','IVA $','alta_db','alta_por','ultimo_cambio','ultimo_cambio_por','Actions']
		,postData : {iajqtable:'$tbl',iajqcols:"$id,'1' as balance,banco_id,banco_cuenta_id,fecha,es,withdrawal,deposit,cash,link_vale,banco_mov_tipo_id,usado,puede_editar,verificado
        ,verificado_el,verificado_por
        ,$vid $LM_tbl_cols,remarks,idex100,(cash*idex100/100) as idetotal,IF(deposit%2Bcash-withdrawal-(cash*idex100/100)>0,deposit%2Bcash-withdrawal-(cash*idex100/100),0) as netdeposit
        ,numero,factura,ivacobradox100,'' as ivacobradototal,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,'' as actions",iauid:1,iabanco_cuenta_id:'$banco_cuenta_id',iajqwhere:"banco_cuenta_id=$banco_cuenta_id",iajqBalance:1}
				*/

  		$this->campos['balance'] =
            array (
            'title' => 'Balance',
            'label'=>'Balance',
            'display_group' => '',
            'Null' => true,
            'required' => false,
            'Type' => 'decimal',
            'enteros' => '10',
            'decimales' => '2',
            'numeric' => 1,
            'unsigned' => true,
            'min' => 0,
            'max' => '9999999999.99',
            'modo' => 'R/O',
            'virtual_sql'=>'1',
            'Default' => '0.00');

        $this->campos['banco_id']['label'] = 'Banco';
        $this->campos['banco_cuenta_id']['label'] = 'Cuenta';
        $this->campos['fecha']['label'] = 'Fecha';
        $this->campos['fecha1']['label'] = 'Fecha Corta';
        $this->campos['es']['label'] = 'Es';
        $this->campos['withdrawal']['label'] = 'Withdrawal';
        $this->campos['deposit']['label'] = 'Deposit';
        $this->campos['cash']['label'] = 'Cash';
        $this->campos['link_vale']['label'] = 'Estado';
        $this->campos['banco_mov_tipo_id']['label'] = 'Tipo Mov.';
        $this->campos['usado']['label'] = 'Usado';
        $this->campos['puede_editar']['label'] = 'Editable';
        $this->campos['verificado']['label'] = '¿Verificado?';
        $this->campos['verificado_por']['label'] = 'Verif. Por';
        $this->campos['verificado_el']['label'] = 'Verif. Fecha';
        $this->campos['remarks']['label'] = 'Remarks(Concept/Explain)';
        $this->campos['numero']['label'] = 'Referencia(Number)';
        $this->campos['numero_original']['label'] = 'Referencia Original';
        $this->campos['idex100']['label'] = 'Comisión %';
        $this->campos['idetotal']['label'] = 'Comisión $';

//        $this->campos['netdeposit'] =
//            array (
//            'title' => 'Net Deposit',
//            'label'=>'Net Deposit',
//            'display_group' => '',
//            'Null' => true,
//            'required' => false,
//            'Type' => 'decimal',
//            'enteros' => '10',
//            'decimales' => '2',
//            'numeric' => 1,
//            'unsigned' => true,
//            'min' => 0,
//            'max' => '9999999999.99',
//            'modo' => 'R/O',
//            'virtual_sql'=>'IF(deposit+cash-withdrawal-(cash*idex100/100)>0,deposit+cash-withdrawal-(cash*idex100/100),0)',
//            'Default' => '0.00');


        $this->campos['factura']['label'] = 'Tipo Venta';
        $this->campos['factura_numero']['label'] = '# Factura';
        $this->campos['cobra_iva']['label'] = '¿Cobra IVA?';
        $this->campos['ivacobradox100']['label'] = 'IVA %';
        $this->campos['ivacobradototal']['label'] = 'IVA $';
        $this->campos['tipo_cash_nota']['label'] = 'CASH/NOTA';
        $this->campos['cash_nota_num']['label'] = '# CASH/NOTA';
        $this->campos['tienda_id']['label'] = 'Tienda';
        $this->campos['empresa_id']['label'] = 'Empresa';
        $this->campos['cliente']['label'] = 'Cliente';

        $this->campos['cash_num_cobro_iva']['label'] = '# CASH IVA';

        //Los que de plano no nos interesan.
        unset($this->campos['withdrawal_autorizado']);
        unset($this->campos['withdrawal_autorizado_por']);
        unset($this->campos['withdrawal_autorizado_el']);
        unset($this->campos['banco_cuenta_mov_id']);

        $this->campos['json_file_attachments']['label']='Archivos Adjuntos';
        $this->campos['json_file_attachments']['Type']='json_file';
        $this->campos['json_file_attachments']['formato']='json_file';

        $this->campos['estado']['Type']='estado_formatter';
        $this->campos['estado_edocta']['Type']='estado_formatter';
        $this->campos['asignacion']['Type']='asignacion_formatter';
        $this->campos['supervision']['Type']='supervision_formatter';

        $this->campos['remarks']['Type']='html';
        $this->campos['banco_diccionario_dato_remarks'] = array (
      'title' => '',
            'label' => 'Remarks del importador',
      'display_group' => '',
      'Null' => true,
      'required' => false,
      'Type' => 'html',
      'modo' => 'R/O',
      'formato' => 'fckeditor',
  );
        $this->campos['plantilla_withdrawals_remarks'] = array (
      'title' => '',
            'label' => 'Remarks de la Plantilla',
      'display_group' => '',
      'Null' => true,
      'required' => false,
      'Type' => 'html',
      'modo' => 'R/O',
      'formato' => 'fckeditor',
  );

        $this->campos['banco_diccionario_dato_id'] = array (
            'label' => 'Diccionario Datos',
      'title' => '',
      'display_group' => '',
      'Null' => false,
      'required' => false,
      'Type' => 'varchar',
      'modo' => 'R/O',
      'display_group_break' => false,
      'link_table' => 'banco_diccionario_dato',
      'formato' => 'link_one_select',
  );

        $this->campos['plantilla_withdrawals_de_banco_id'] = array (
            'label' => 'Plantilla Withdrawals de Banco',
      'title' => '',
      'display_group' => '',
      'Null' => false,
      'required' => false,
      'Type' => 'varchar',
      'modo' => 'R/O',
      'display_group_break' => false,
      'link_table' => 'plantilla_withdrawals_de_banco',
      'formato' => 'link_one_select',
  );

    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::insert_pre_validate()
     *
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * iacase::insert_validate()
     *
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * iacase::insert_pre_save()
     *
     * @return
     */
    //function insert_pre_save()  { return true; }
    /**
     * iacase::insert_post_save()
     *
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::update_pre_validate()
     *
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * iacase::update_validate()
     *
     * @return
     */
    //function update_validate()  { return $this->validate(); }
    /**
     * iacase::update_pre_save()
     *
     * @return
     */
    //function update_pre_save()  { return true; }
    /**
     * iacase::update_post_save()
     *
     * @return
     */
    //function update_post_save()   {return true;}

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
/////////////////////////////////
    //function delete_pre_validate($h) { return true; }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    //function delete_post_delete($h) {  }

//////////////////////////////////
// FORM override functions
/////////////////////////////////
    /**
     * iacase::forma_pre()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_pre(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_preFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_postFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_doChilds()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_doChilds(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_post()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    public function forma_post(&$h,&$nexth,$ok=true) { return true; }
    /**
     * iacase::forma_postDiv()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    public function forma_postDiv($h,$nexth) {
        parent::forma_postDiv($h,$nexth);
    }


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
/////////////////////////////////
    function listme_setcols() {

        $ordenColsGrid=array('balance','banco_id','banco_cuenta_id'
        ,'fecha','es','withdrawal','deposit','cash','link_vale','banco_mov_tipo_id','usado','puede_editar','verificado'
        ,'verificado_el','verificado_por','remarks','numero'
        ,'alta_db','alta_por','ultimo_cambio','ultimo_cambio_por'
        ,'idex100','idetotal','factura','factura_numero','ivacobradox100','ivacobradototal'
        ,'tipo_cash_nota','cash_nota_num','tienda_id','empresa_id','cliente');
        //$this->jqGridHiddenCols = array('initial_payment','disponible_para_sustituir','deliverd_log','cuentaT_transferto_id');
        $this->campos_reorder($ordenColsGrid);
        $select=implode(',',$ordenColsGrid);
        $this->jqGridSelect="SELECT banco_cuenta_mov_id, $select FROM banco_cuenta_mov";
    }

    function listme($gridId='',$title='',$where='',$jsAfter='',$postData=array())
    {
        $this->listme_setcols();
        parent::listme($gridId,$title,$where,$this->export_gridvalues($gridId),$postData);
    }

    /**
     * iacase::listme_pre()
     *
     * @param mixed $grid
     * @return
     */
    function listme_pre($grid) { return true; }
    /**
     * iacase::listme_preRender()
     *
     * @param mixed $grid
     * @return
     */
    function listme_preRender($grid) { return true; }
    /**
     * iacase::listme_post()
     *
     * @param mixed $grid
     * @return void
     */
    function listme_postRender($grid) {  }
    /**
     * iacase::label_record_summary()
     *
     * @return
     */
    function label_record_summary() {
        $label = '';

        $campoMonto = $this->enDB['es'] == 'Retiro' ? 'withdrawal' : 'deposit';

        $label = strtoupper(obtenNombreBancoCuenta($this->enDB['banco_cuenta_id'])) . ": " . strtoupper($this->enDB['es']) . " de $ " . echonf($this->enDB[$campoMonto], true)
        . ", el " . get_date_spanish(strtotime($this->enDB['fecha']), false, 'small_date');

        return $label;
    }

//////////////////////////////////
// QBE FORM override functions
/////////////////////////////////

//////////////////////////////////
// QBE doWHere override functions
/////////////////////////////////

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////
    /**
     * app_banco_cuenta_mov::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'banco_cuenta_mov_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'uuid',
    'display_group_break' => false,
  ),
  'banco_cuenta_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco_cuenta',
    'formato' => 'link_one_select',
  ),
  'fecha' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'PK' => true,
    'PK_type' => 'value',
  ),
  'es' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Deposito',
  ),
  'cash' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'deposit' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'withdrawal' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'banco_mov_tipo_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco_mov_tipo',
    'formato' => 'link_one_select',
  ),
  'numero' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'banco_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'usado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'puede_editar' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Si',
    'display_group_break' => false,
  ),
  'verificado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'verificado_el' => 
  array (
    'title' => '',
    'display_group' => 'verificado',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'verificado_por' => 
  array (
    'title' => 'nick del usuario',
    'display_group' => 'verificado',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'mov_verificado_id' => 
  array (
    'title' => '',
    'display_group' => 'mov',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'link_vale' => 
  array (
    'title' => '',
    'display_group' => 'link',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'ND',
    'display_group_break' => false,
  ),
  'remarks' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'idex100' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'factura' => 
  array (
    'title' => 'FACT NUM., FACT PEND. O MST',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
    'Default' => 'MST',
  ),
  'ivacobradox100' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'alta_db' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'timestamp',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'alta_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'ultimo_cambio' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/O',
  ),
  'ultimo_cambio_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'withdrawal_autorizado' => 
  array (
    'title' => '',
    'display_group' => 'withdrawal',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'withdrawal_autorizado_el' => 
  array (
    'title' => '',
    'display_group' => 'withdrawal',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'withdrawal_autorizado_por' => 
  array (
    'title' => '',
    'display_group' => 'withdrawal',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'idetotal' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
  ),
  'ivacobradototal' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
  ),
  'empresa_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'empresa',
    'formato' => 'link_one_select',
  ),
  'factura_numero' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
  ),
  'cash_nota_num' => 
  array (
    'title' => '',
    'display_group' => 'cash',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cliente' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'tienda_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
  ),
  'tipo_cash_nota' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'cobra_iva' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'alta_tipo' => 
  array (
    'title' => '',
    'display_group' => 'alta',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cash_num_cobro_iva' => 
  array (
    'title' => '',
    'display_group' => 'cash',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'linkconfirmado_tienda_id' => 
  array (
    'title' => '',
    'display_group' => 'linkconfirmado',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'linkconfirmado_a' => 
  array (
    'title' => '',
    'display_group' => 'linkconfirmado',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'linkconfirmado_el' => 
  array (
    'title' => '',
    'display_group' => 'linkconfirmado',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'linkconfirmado_por' => 
  array (
    'title' => '',
    'display_group' => 'linkconfirmado',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'contpaq_cliente_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'int unsigned',
    'modo' => 'R/W',
  ),
  'categoria_gasto_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
  ),
  'cliente_rfc' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '13',
    'modo' => 'R/W',
  ),
  'pendiente' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'comments' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'remarks_log' => 
  array (
    'title' => '',
    'display_group' => 'remarks',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'iva_incluido' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'estado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '12',
    'modo' => 'R/W',
    'Default' => '000000000000',
  ),
  'asignacion' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '25',
    'modo' => 'R/W',
    'Default' => 'ZZZZZZZZZZZZ',
  ),
  'supervision' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '25',
    'modo' => 'R/W',
    'Default' => 'ZZZZZZZZZZZZ',
  ),
  'poliza_contabilidad' => 
  array (
    'title' => '',
    'display_group' => 'poliza',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'detalle_links' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'json_file_attachments' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'fecha1' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'date',
    'modo' => 'R/W',
  ),
  'importante' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'bc_empresa_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'empresa',
    'formato' => 'link_one_select',
  ),
  'link_el' => 
  array (
    'title' => '',
    'display_group' => 'link',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'link_por' => 
  array (
    'title' => '',
    'display_group' => 'link',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'numero_original' => 
  array (
    'title' => '',
    'display_group' => 'numero',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'repetido' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'mov_repetido_id' => 
  array (
    'title' => '',
    'display_group' => 'mov',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '1600',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'link_cuenta_t' => 
  array (
    'title' => '',
    'display_group' => 'link',
    'Null' => true,
    'required' => false,
    'Type' => 'mediumtext',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'html_asignaciones' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'asig_semaforo_rony' => 
  array (
    'title' => 'Semáforo de asignaciones para Rony. Los valores son verde, amarillo, naranja, rojo. Va actuar como un enum fléxible.',
    'display_group' => 'asig',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'asig_semaforo_usuarios' => 
  array (
    'title' => 'Semáforo de asignaciones para Usuarios. Campo con un JSON del tipo {usuario_id:semaforo}',
    'display_group' => 'asig',
    'Null' => false,
    'required' => true,
    'Type' => 'mediumtext',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'anotaciones' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'mediumtext',
    'modo' => 'R/W',
  ),
  'remarks_wot' => 
  array (
    'title' => '',
    'display_group' => 'remarks',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'moneda_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint',
    'modo' => 'R/W',
    'Default' => '1',
  ),
  'poliza_contable' => 
  array (
    'title' => '',
    'display_group' => 'poliza',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'poliza_contable_el' => 
  array (
    'title' => '',
    'display_group' => 'poliza',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'poliza_contable_por' => 
  array (
    'title' => '',
    'display_group' => 'poliza',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'verificado_list' => 
  array (
    'title' => '',
    'display_group' => 'verificado',
    'Null' => false,
    'required' => true,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'rechazado_list' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'ano' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'int',
    'modo' => 'R/W',
  ),
  'dia' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'int',
    'modo' => 'R/W',
  ),
  'referencia_monex' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
  ),
  'withdrawal_rechazado' => 
  array (
    'title' => '',
    'display_group' => 'withdrawal',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'withdrawal_rechazado_el' => 
  array (
    'title' => '',
    'display_group' => 'withdrawal',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'withdrawal_rechazado_por' => 
  array (
    'title' => '',
    'display_group' => 'withdrawal',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'pendiente_edocta' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'estado_edocta' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '12',
    'modo' => 'R/W',
    'Default' => '000000000000',
  ),
  'fecha_hora' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '8',
    'modo' => 'R/W',
  ),
  'puede_borrar' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'tiempo_restante_para_borrar' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '30',
    'modo' => 'R/W',
  ),
  'alta_db_real' => 
  array (
    'title' => '',
    'display_group' => 'alta',
    'Null' => false,
    'required' => true,
    'Type' => 'timestamp',
    'modo' => 'R/W',
    'Default' => 'CURRENT_TIMESTAMP',
    'display_group_break' => false,
  ),
  'plantilla_withdrawals_de_banco_id' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'plantilla_prohibida' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_prohibida_porque' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_prohibida_uso' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_prohibida_autorizada' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_prohibida_autorizada_por' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '30',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_prohibida_autorizada_el' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'numero_original_tagged' => 
  array (
    'title' => '',
    'display_group' => 'numero',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'banco_diccionario_dato_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco_diccionario_dato',
    'formato' => 'link_one_select',
  ),
  'balance_prev' => 
  array (
    'title' => '',
    'display_group' => 'balance',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'balance' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
  ),
  'balance_op_desc' => 
  array (
    'title' => '',
    'display_group' => 'balance',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_withdrawals_remarks' => 
  array (
    'title' => '',
    'display_group' => 'plantilla',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '512',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'banco_diccionario_dato_remarks' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '512',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

}
?>