<?php
/* 
   	CAMPOS_EN_DB_START
		primary key: 'banco_cuenta_trans_id' al 2026-01-13 16:39
		origen_banco_cuenta_id,origen_fecha,destino_banco_cuenta_id,destino_fecha,monto,referencia,activo,puede_borrar,status,banco_cuenta_mov_link_id,numero_referencia,cuentaT_id,fecha,cuentaT_tipo_mov_id,egreso,saldo_corriente_mxp,saldo_corriente_usd,moneda_id,tipo_cambio,banco_cuenta_id,remarks,cuentaT_deliveredto_id,esta_en,cuentaT_transferto_id,quantity_total,tipo,origen_mov_id,deposit_fecha,ide_amount,ide_percent,tarjeta_amount,tarjeta_percent,tienda_id,factura,ivacobradox100,ivacobradototal,empresa_id,factura_numero,cash_nota_num,cliente,tipo_cash_nota,cobra_iva,cash_num_cobro_iva,factura_directa,iva_incluido,fecha_factura,cliente_rfc,contpaq_cliente_id,origen,afecta_cuentat,deposit_total,comments,revisado,autorizado,autorizado_por,autorizado_el,rechazado,fecha_capturado,iva_revisado_por,iva_revisado,iva_revisado_el,MetodoPago,FormaPago,UsoCFDI,CuentadePago,origen_moneda_id,monto_origen,json_file_attachments,cancelacion_revisada,cancelacion_revisada_por,cancelacion_revisada_el,cancelacion_el,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_cuenta_trans_id
	CAMPOS_EN_DB_END
*/
/* 
   	DELETE_RULES_START

	Usa tablas:
		banco:
			Deletes me: SI. I restrict delete: NO. link_one_select/catalog. Links by origen_banco_cuenta_id
		banco:
			Deletes me: SI. I restrict delete: NO. link_one_select/catalog. Links by destino_banco_cuenta_id
		banco_cuenta_mov_link:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_cuenta_mov_link_id
		cuentat:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by cuentaT_id
		cuentat:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by cuentaT_tipo_mov_id
		cuentat:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by cuentaT_deliveredto_id
		cuentat:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by cuentaT_transferto_id
		banco_cuenta:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_cuenta_id
		empresa:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by empresa_id
	DELETE_RULES_END
*/
class app_banco_cuenta_trans extends iacase_base {
    
    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate; 
        if( empty($table) )
            $table='banco_cuenta_trans';    
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();
        
        // para tomar default de iacasebase
        //$this->modo='cardex_window';      // cardex misma ventana, cardex_window cardex in new window, jqgrid_iacform forma de iacase, jqgrid_form forma de jqgrid, jqgrid_inline (inline falta)
        
    //$this->asChild=false;      // en true esta instancia es child table
    //$this->childTables=array();  // childTables storage
    //$this->childTablesUse=array(); // solo considera estos child tables
    //$this->saveChilds=true;    // en false no hace child tables en el save
    //$this->editChilds=true;    // en false no saca tablita add another editar childs
    //$this->editChildsSetRO=false; // forza a todos los childs a ser R/O!
    //$this->viewChilds=true;    // en false no muestra childs
    //$this->childHide=array(); // array('childTableToHide');
    //$this->child_jqGrid_height=300;
    //$this->child_jqGrid_width="'50%'";
    //$this->child_jqGrid_cols=array();
    //$this->child_jqGrid_hiddenCols=array();
    //$this->child_jqGridSaveState=true; // guarda grid state
    //$this->child_jqGrid_option=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
    //$this->jqChildGridActions=array(); //actions cuando es child
    //$this->formTypeChildsPerRow=2;   
    //$this->asChild_update=true; // usandose como child es and permsio_update
    //$this->asChild_delete=true; // usandose como child es and permsio_update    
        
        $editar=true;
        $consultar=true;
        $this->permiso_app=$editar;
        $this->permiso_delete=$editar;
        $this->permiso_export=$consultar;
        $this->permiso_insert=$editar;
        $this->permiso_list=$consultar;
        $this->permiso_read=$consultar;
        $this->permiso_update=$editar;
        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica
        //$this->log_cardex_view=false; // ture log each iah=r pageview

        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        
        //$this->useJqueryValidate=false;
        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;

        //$this->input_max_size=40;          // en cardex
        //$this->input_max_size_child=30;    // en child        
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->jqGridSendOnly=array(); // mandar unicamente estas columnas
        //$this->colModel_overRide=array(); // override generated colModel
        //$this->cols_list='*';
        //$this->jqGrid_options=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
        
        //$this->list_sortname_dflt='';
        //$this->list_sortorder_dflt='';
        //$this->col_list_noShow=array();    // estas ni llegan al jqgrid        
        //$this->jqGridHiddenCols=array(); // estas llegan al grid pero quedan hidden
        
        //$this->extraParams=array();    // parametros extra en links
                       
        
    }
    
//////////////////////////////////
// PERMISOS
/////////////////////////////////
    /**
     * app_banco_cuenta_trans::permiso_por_record
     * Redefine permisos habiendo leido el record de la base de datos en $this->enDB
     *
     */
    //function permiso_por_record() { }
    /**
     * app_banco_cuenta_trans::may_add()
     * Permiso para ver la forma de dar alta, conviene mas usar las variables $this->permiso_*
     * @return  boolean TRUE puede, false no puede
     */
    //function may_add() { return $this->permiso_insert; }
    /**
     * app_banco_cuenta_trans::may_insert()
     * Permiso para dar altas, insert, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_insert() { return $this->may_add(); }
    /**
     * app_banco_cuenta_trans::may_edit()
     * Permiso para ver la forma de editar, conviene mas usar las variables $this->permiso_*
     * @return boolean
     */
    //function may_edit() { return $this->permiso_update; }
    /**
     * app_banco_cuenta_trans::may_update()
     * Permiso para hacer el update, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_update() { return $this->may_edit() && ($this->asChild ? $this->asChild_update : true); }
    /**
     * app_banco_cuenta_trans::may_delete()
     * Parmiso para borrar, se usa en confirmar y en borrar., conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_delete() { return $this->permiso_delete && ($this->asChild ? $this->asChild_delete : true); }
    /**
     * app_banco_cuenta_trans::may_read()
     * Permiso para ver el record, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_read() { return $this->permiso_read; }
    /**
     * app_banco_cuenta_trans::may_list()
     * Permiso para listar los records, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_list() { return $this->permiso_list; }
    /**
     * app_banco_cuenta_trans::may_export()
     * Permiso para exportar, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_export() { return $this->permiso_export; }
    /**
     * app_banco_cuenta_trans::may_print()
     * Permiso para imprimir, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_print() { return $this->may_export(); }
    /**
     * app_banco_cuenta_trans::may_viewLog()
     * Permiso para ver el log, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_viewLog() { return $this->permiso_export; }  
    
//////////////////////////////////
// Etiquetas o labels
/////////////////////////////////
    /**
     * app_banco_cuenta_trans::label_record()
     * Nombre corto del registro
     * @return string el nombre corto del registro
     */
    //function label_record() { }
    
    /**
     * app_banco_cuenta_trans:label_record_summary()
     * Resumen de registro
     * @return string el resumen del registro
     */
    //function label_record_summary() { }

    /**
     * app_banco_cuenta_trans::label_add()
     * Etiqueta para agregar un registro
     * @return string la etiqueta para agregar un registro si existe $this->table_info['label_add'], del contrario la arma
     */
   //public function label_add() {    }
    /**
     * app_banco_cuenta_trans::label_list()
     * Etiqueta para el listado
     * @return string la etiqueta del listado, si existe $this->table_info['label_list'] del contrario  $this->label_table_plural()
     */
    //public function label_list() { }
    /**
     * app_banco_cuenta_trans::label_table_singular()
     * Etiqueta para la tabla o tipos de registro en singular
     * @return string el label de la tabla en singular
     */
    //public function label_table_singular() { return $this->label; }
    /**
     * app_banco_cuenta_trans::label_table_plural()
     * Etiqueta para la tabla o tipos de registro en plural
     * @return string el label de la tabla en plural
     * @return
     */
    //public function label_table_plural() { }

      
//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_banco_cuenta_trans::campos_final
     * Redefine $campos del default en campos_default 
     *
     */
    public function campos_final() {
        // pkfields=array( 'banco_cuenta_trans_id' );
        /*	CAMPOS_START
				primary key: 'banco_cuenta_trans_id' al 2026-01-13 16:39
				origen_banco_cuenta_id,origen_fecha,destino_banco_cuenta_id,destino_fecha,monto,referencia,activo,puede_borrar,status,banco_cuenta_mov_link_id,numero_referencia,cuentaT_id,fecha,cuentaT_tipo_mov_id,egreso,saldo_corriente_mxp,saldo_corriente_usd,moneda_id,tipo_cambio,banco_cuenta_id,remarks,cuentaT_deliveredto_id,esta_en,cuentaT_transferto_id,quantity_total,tipo,origen_mov_id,deposit_fecha,ide_amount,ide_percent,tarjeta_amount,tarjeta_percent,tienda_id,factura,ivacobradox100,ivacobradototal,empresa_id,factura_numero,cash_nota_num,cliente,tipo_cash_nota,cobra_iva,cash_num_cobro_iva,factura_directa,iva_incluido,fecha_factura,cliente_rfc,contpaq_cliente_id,origen,afecta_cuentat,deposit_total,comments,revisado,autorizado,autorizado_por,autorizado_el,rechazado,fecha_capturado,iva_revisado_por,iva_revisado,iva_revisado_el,MetodoPago,FormaPago,UsoCFDI,CuentadePago,origen_moneda_id,monto_origen,json_file_attachments,cancelacion_revisada,cancelacion_revisada_por,cancelacion_revisada_el,cancelacion_el,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_cuenta_trans_id
			CAMPOS_END 
        */
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'display_group','string' ); // a fieldnameN cambiales 'max' a 1e6 
        //$this->campos['fieldName']['br']=true;
        /* comunes atributes son 
            required,max,min,display_group,display_group_label, hidden_value pone hidden en modo R/O
            label_br: normalmente es label<br />input si existe pone label $x[label_br] input 
            br pasa al siguiente renlgon
        */
        
        $orden=array(
            'origen_banco_cuenta_id','origen_fecha','destino_banco_cuenta_id','destino_fecha','monto','referencia'
			,'alta_db','alta_por','ultimo_cambio','ultimo_cambio_por','activo','puede_borrar','status','banco_cuenta_mov_link_id'                
        );
        $this->campos_reorder($orden);
        
        $this->jqGridId = 'iajqgridbancoabanco_mov';


        $this->campos['banco_cuenta_trans_id']['label']='Transfer ID';
        $this->campos['origen_banco_cuenta_id']['label']='Cuenta Origen';
        $this->campos['origen_fecha']['label']='Fecha Origen';
        $this->campos['destino_banco_cuenta_id']['label']='Cuenta Destino';
        $this->campos['destino_fecha']['label']='Fecha Destino';
        $this->campos['monto']['label']='Monto';
        $this->campos['status']['label']='Status';
        $this->campos['referencia']['label']='Referencia';
        $this->campos['alta_db']['label']='Fecha Alta';
        $this->campos['alta_por']['label']='Alta Por';
        $this->campos['puede_borrar']['label']='Puede Borrar';
        $this->campos['activo']['label']='Activa';
    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_banco_cuenta_trans::insert_pre_validate()
     * 
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * app_banco_cuenta_trans::insert_validate()
     * 
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * app_banco_cuenta_trans::insert_pre_save()
     * 
     * @return
     */
     //function insert_pre_save()  { return true; }

    /**
     * app_banco_cuenta_trans::insert_extra_values()
     * permite agregar valores al insert sql statement o modificar el array del que hacer el insert
     * @param string $insArray  agregar insert clause, terminar con coma ie: $ins.=",campo1"
     * @param string $log   agregar o cambiar el log
     * @return boolean TRUE continua con el isnert, FALSE cancela el insert en este caso avisar en $this->msg_err.="<li>explica..."
    */
    //function insert_extra_values(&$insArray,&$log) { return true; }
         
    /**
     * app_banco_cuenta_trans::insert_add_sql_queries()
     * permite agregar queries al transaction del insert
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    //function insert_add_sql_queries(&$sql,&$log) { return true;}
    
    /**
     * app_banco_cuenta_trans::insert_post_save()
     * 
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_banco_cuenta_trans::update_pre_validate()
     * 
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * app_banco_cuenta_trans::update_validate()
     * 
     * @return
     */
    //function update_validate()  { return $this->validate(); }
    /**
     * app_banco_cuenta_trans::update_pre_save()
     * 
     * @return
     */
    //function update_pre_save()  { return true; }

    /**
     * app_banco_cuenta_trans::update_extra_sql()
     * permite agregar valores al update sql
     * @param string $updArray  array de valores 
     * @param string $log  agregar <li> al log ie: $log.="<li>..."
     * @return boolean TRUE continua con el update FALSE no hace el update poner mensaje en $this->msg_err.="<li>..."
    */
    //function update_extra_sql(&$updArray,&$log) { return true; }
        
    /**
     * app_banco_cuenta_trans::update_add_sql_queries()
     * permite agregar queries al transaction del update
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    function update_add_sql_queries(&$sql,&$log) { return true;}
        
    /**
     * app_banco_cuenta_trans::update_post_save()
     * 
     * @return
     */
    //function update_post_save()   {return true;}  

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
///////////////////////////////// 
    //function delete_pre_validate($h) { return true; }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    //function delete_post_delete($h) {  }
    /**
     * app_banco_cuenta_trans::delete_sql()
     *
     * @param string $record record values to delete, normalmente $this->values
     * @param array $sql array de sql commands al que agregar queries
     * @return void
     */
    //function delete_sql_extra($record,&$sql) {  }
    
//////////////////////////////////
// FORM override functions
///////////////////////////////// 
    /**
     * app_banco_cuenta_trans::forma_pre()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_pre(&$h,&$nexth) { return true; }
    /**
     * app_banco_cuenta_trans::forma_preFields()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * app_banco_cuenta_trans::forma_postFields()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * app_banco_cuenta_trans::forma_doChilds()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_doChilds(&$h,&$nexth) { return true; }  
    /**
     * app_banco_cuenta_trans::forma_post()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    //public function forma_post(&$h,&$nexth) { return true; }
    /**
     * app_banco_cuenta_trans::forma_postDiv()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    //public function forma_postDiv($h,$nexth) {}


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
///////////////////////////////// 
    function listme_setcols() {

        $ordenColsGrid=array('banco_cuenta_trans_id','origen_banco_cuenta_id','origen_fecha','destino_banco_cuenta_id','destino_fecha','monto','status','referencia','alta_db'
        ,'alta_por','puede_borrar','activo');
        
        $this->campos_reorder($ordenColsGrid);
        $select=implode(',',$ordenColsGrid);
        $this->jqGridSelect="SELECT banco_cuenta_trans_id, $select FROM banco_cuenta_trans";           
        
    }
    function listme($gridId='',$title='',$where='',$jsAfter='',$postData=array())
    {
        $this->listme_setcols();
        parent::listme($gridId,$title,$where,$this->export_gridvalues($gridId),$postData);
    }
    /**
     * app_banco_cuenta_trans::listme_pre()
     * 
     * @param mixed $grid
     * @return
     */
    //function listme_pre($grid) { return true; }
    /**
     * app_banco_cuenta_trans::listme_preRender()
     * 
     * @param mixed $grid
     * @return
     */
    //function listme_preRender($grid) { return true; }
    /**
     * app_banco_cuenta_trans::listme_post()
     * 
     * @param mixed $grid
     * @return void
     */
    //function listme_postRender($grid) { parent::listme_postRender($grid); }
    
//////////////////////////////////
// QBE FORM override functions
///////////////////////////////// 
    /**
     * app_banco_cuenta_trans::qbe_forma()
     *
     * @return @void
     */
    // public function qbe_forma() {}
    
//////////////////////////////////
// QBE doWHere override functions
///////////////////////////////// 

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////    
    /**
     * app_banco_cuenta_trans::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'banco_cuenta_trans_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'uuid',
    'display_group_break' => false,
  ),
  'origen_banco_cuenta_id' => 
  array (
    'title' => '',
    'display_group' => 'origen',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'origen_fecha' => 
  array (
    'title' => '',
    'display_group' => 'origen',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'destino_banco_cuenta_id' => 
  array (
    'title' => '',
    'display_group' => 'destino',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'destino_fecha' => 
  array (
    'title' => '',
    'display_group' => 'destino',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'monto' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
  ),
  'referencia' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'alta_db' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'timestamp',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'alta_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'Default' => 'sistema',
  ),
  'ultimo_cambio' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/O',
  ),
  'ultimo_cambio_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'activo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Si',
  ),
  'puede_borrar' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'status' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'PENDIENTE',
  ),
  'banco_cuenta_mov_link_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco_cuenta_mov_link',
    'formato' => 'link_one_select',
  ),
  'numero_referencia' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '15',
    'modo' => 'R/W',
  ),
  'cuentaT_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'cuentat',
    'formato' => 'link_one_select',
  ),
  'fecha' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/W',
  ),
  'cuentaT_tipo_mov_id' => 
  array (
    'title' => '',
    'display_group' => 'cuentaT',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'Default' => '1',
    'display_group_break' => false,
    'link_table' => 'cuentat',
    'formato' => 'link_one_select',
  ),
  'egreso' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '10',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'saldo_corriente_mxp' => 
  array (
    'title' => 'No cambiar ni truquear alta_db',
    'display_group' => 'saldo',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '12',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-999999999999.99',
    'max' => '999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
    'display_group_break' => false,
  ),
  'saldo_corriente_usd' => 
  array (
    'title' => 'No cambiar ni truquear alta_db',
    'display_group' => 'saldo',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '12',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-999999999999.99',
    'max' => '999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
    'display_group_break' => false,
  ),
  'moneda_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'Default' => '1',
  ),
  'tipo_cambio' => 
  array (
    'title' => '',
    'display_group' => 'tipo',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '10',
    'decimales' => '6',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999.999999',
    'modo' => 'R/W',
    'Default' => '1.000000',
    'display_group_break' => false,
  ),
  'banco_cuenta_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'Default' => '0',
    'display_group_break' => false,
    'link_table' => 'banco_cuenta',
    'formato' => 'link_one_select',
  ),
  'remarks' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'text',
    'modo' => 'R/W',
  ),
  'cuentaT_deliveredto_id' => 
  array (
    'title' => '',
    'display_group' => 'cuentaT',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'cuentat',
    'formato' => 'link_one_select',
  ),
  'esta_en' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'user',
  ),
  'cuentaT_transferto_id' => 
  array (
    'title' => '',
    'display_group' => 'cuentaT',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'cuentat',
    'formato' => 'link_one_select',
  ),
  'quantity_total' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '10',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'tipo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Ingreso',
  ),
  'origen_mov_id' => 
  array (
    'title' => 'movimiento relacionado a este',
    'display_group' => 'origen',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'deposit_fecha' => 
  array (
    'title' => '',
    'display_group' => 'deposit',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'ide_amount' => 
  array (
    'title' => '',
    'display_group' => 'ide',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '10',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
    'display_group_break' => false,
  ),
  'ide_percent' => 
  array (
    'title' => '',
    'display_group' => 'ide',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '3',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
    'display_group_break' => false,
  ),
  'tarjeta_amount' => 
  array (
    'title' => '',
    'display_group' => 'tarjeta',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '10',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
    'display_group_break' => false,
  ),
  'tarjeta_percent' => 
  array (
    'title' => '',
    'display_group' => 'tarjeta',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '3',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
    'display_group_break' => false,
  ),
  'tienda_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
  ),
  'factura' => 
  array (
    'title' => 'FACT NUM., FACT PEND. O MST',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
    'Default' => 'MST',
  ),
  'ivacobradox100' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'Default' => '0.00',
  ),
  'ivacobradototal' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
  ),
  'empresa_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'link_table' => 'empresa',
    'formato' => 'link_one_select',
  ),
  'factura_numero' => 
  array (
    'title' => '',
    'display_group' => 'factura',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cash_nota_num' => 
  array (
    'title' => '',
    'display_group' => 'cash',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cliente' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'tipo_cash_nota' => 
  array (
    'title' => '',
    'display_group' => 'tipo',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cobra_iva' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'cash_num_cobro_iva' => 
  array (
    'title' => '',
    'display_group' => 'cash',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'factura_directa' => 
  array (
    'title' => '',
    'display_group' => 'factura',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'NO',
    'display_group_break' => false,
  ),
  'iva_incluido' => 
  array (
    'title' => '',
    'display_group' => 'iva',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'NO',
    'display_group_break' => false,
  ),
  'fecha_factura' => 
  array (
    'title' => '',
    'display_group' => 'fecha',
    'Null' => true,
    'required' => false,
    'Type' => 'date',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cliente_rfc' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '13',
    'modo' => 'R/W',
  ),
  'contpaq_cliente_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'int',
    'modo' => 'R/W',
  ),
  'origen' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '15',
    'modo' => 'R/W',
    'Default' => 'PROP',
  ),
  'afecta_cuentat' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'NO',
  ),
  'deposit_total' => 
  array (
    'title' => '',
    'display_group' => 'deposit',
    'Null' => true,
    'required' => false,
    'Type' => 'decimal',
    'enteros' => '10',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999.99',
    'max' => '9999999999.99',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'comments' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '1024',
    'modo' => 'R/W',
  ),
  'revisado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'autorizado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'autorizado_por' => 
  array (
    'title' => '',
    'display_group' => 'autorizado',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'autorizado_el' => 
  array (
    'title' => '',
    'display_group' => 'autorizado',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'rechazado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'fecha_capturado' => 
  array (
    'title' => '',
    'display_group' => 'fecha',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'Default' => 'CURRENT_TIMESTAMP',
    'display_group_break' => false,
  ),
  'iva_revisado_por' => 
  array (
    'title' => '',
    'display_group' => 'iva',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'iva_revisado' => 
  array (
    'title' => '',
    'display_group' => 'iva',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'iva_revisado_el' => 
  array (
    'title' => '',
    'display_group' => 'iva',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'MetodoPago' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
  ),
  'FormaPago' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
  ),
  'UsoCFDI' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
  ),
  'CuentadePago' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '20',
    'modo' => 'R/W',
  ),
  'origen_moneda_id' => 
  array (
    'title' => '',
    'display_group' => 'origen',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'monto_origen' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '19',
    'decimales' => '2',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '9999999999999999999.99',
    'modo' => 'R/W',
  ),
  'json_file_attachments' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '4092',
    'modo' => 'R/W',
    'formato' => 'attachment',
    'file_max_entries' => 9,
    'file_private' => false,
    'accept' => 'jpg,png,gif,jpeg,pdf,doc,docx,xls,xlsx,csv,ppt,pptx,pps,ppsx,txt',
  ),
  'cancelacion_revisada' => 
  array (
    'title' => '',
    'display_group' => 'cancelacion',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cancelacion_revisada_por' => 
  array (
    'title' => '',
    'display_group' => 'cancelacion',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cancelacion_revisada_el' => 
  array (
    'title' => '',
    'display_group' => 'cancelacion',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'cancelacion_el' => 
  array (
    'title' => '',
    'display_group' => 'cancelacion',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */
    
}
?>