<?php
/*
   	CAMPOS_EN_DB_START
		primary key: 'banco_diccionario_dato_id' al 2026-01-13 16:39
		activo,nombre,es,palabra_clave,descripcion_a_poner,agregar_palabra_clave,banco_mov_tipo_id,withdrawal_autorizado,link_vale,banco_cuenta_no_aplica,categoria_gasto_id,accion_extra,orden,vale,plantilla_withdrawals_de_banco_id,agregar_titulo,titulo_para_agregar,monto_minimo,monto_maximo,banco_cuenta_si_aplica,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_diccionario_dato_id
	CAMPOS_EN_DB_END
*/
/*
   	DELETE_RULES_START

	Dependen de banco_diccionario_dato:
		banco_cuenta_mov:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by banco_diccionario_dato_id
	Usa tablas:
		banco_mov_tipo:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by banco_mov_tipo_id
		banco:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by plantilla_withdrawals_de_banco_id
	DELETE_RULES_END
*/
class app_banco_diccionario_dato extends iacase_base {

    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate;

//$gAppRelate->enums['banco_diccionario_dato.activo'] = array('Si'=>'Muy bueno <b>BOLD</b>','No'=>'MALO');
        if( empty($table) )
            $table='banco_diccionario_dato';
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();

        // para tomar default de iacasebase
        $this->modo='cardex_window';      // cardex misma ventana, cardex_window cardex in new window, jqgrid_iacform forma de iacase, jqgrid_form forma de jqgrid, jqgrid_inline (inline falta)

    //$this->asChild=false;      // en true esta instancia es child table
    //$this->childTables=array();  // childTables storage
    //$this->childTablesUse=array(); // solo considera estos child tables
    //$this->saveChilds=true;    // en false no hace child tables en el save
    //$this->editChilds=true;    // en false no saca tablita add another editar childs
    //$this->editChildsSetRO=false; // forza a todos los childs a ser R/O!
    //$this->viewChilds=true;    // en false no muestra childs
    //$this->childHide=array(); // array('childTableToHide');
    //$this->child_jqGrid_height=300;
    //$this->child_jqGrid_width="'50%'";
    //$this->child_jqGrid_cols=array();
    //$this->child_jqGrid_hiddenCols=array();
    //$this->child_jqGridSaveState=true; // guarda grid state
    //$this->child_jqGrid_option=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
    //$this->jqChildGridActions=array(); //actions cuando es child
    //$this->formTypeChildsPerRow=2;
    //$this->asChild_update=true; // usandose como child es and permsio_update
    //$this->asChild_delete=true; // usandose como child es and permsio_update


        $consultar = $editar = puedeGastosBanco() === 'Si'; //puedeDiccionarioDatos();
        $this->permiso_app=$editar;
        $this->permiso_delete=$editar;
        $this->permiso_export=$consultar;
        $this->permiso_insert=$editar;
        $this->permiso_list=$consultar;
        $this->permiso_read=$consultar;
        $this->permiso_update=$editar;
        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica
        //$this->log_cardex_view=false; // ture log each iah=r pageview

        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';

        //$this->useJqueryValidate=false;
        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;

        //$this->input_max_size=40;          // en cardex
        //$this->input_max_size_child=30;    // en child
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->jqGridSendOnly=array(); // mandar unicamente estas columnas
        //$this->colModel_overRide=array(); // override generated colModel
        //$this->cols_list='*';
        //$this->jqGrid_options=array(); // options a poner en el jqgrid array('autowidth'=>true,...)

        $this->list_sortname_dflt='alta_db';
        $this->list_sortorder_dflt='DESC';
        $this->col_list_noShow=array('categoria_gasto_id','parent','grandparent',);    // estas ni llegan al jqgrid
        $this->jqGridHiddenCols=array('accion_extra'); // estas llegan al grid pero quedan hidden
/**
$this->jqGridSelect = "SELECT banco_diccionario_dato.*, p.nombre as parent, a.nombre as grandparent FROM banco_diccionario_dato
    LEFT OUTER JOIN categoria_gasto c ON c.categoria_gasto_id=banco_diccionario_dato.categoria_gasto_id
    LEFT OUTER JOIN categoria_gasto p ON p.categoria_gasto_id = c.categoria_gasto_parent_id
    LEFT OUTER JOIN categoria_gasto a ON a.categoria_gasto_id = p.categoria_gasto_parent_id
";
**/
//        $this->jqGridSelect = "SELECT banco_diccionario_dato.*, '' as parent, '' as grandparent FROM banco_diccionario_dato";
        //$this->extraParams=array();    // parametros extra en links


    }

//////////////////////////////////
// PERMISOS
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::permiso_por_record
     * Redefine permisos habiendo leido el record de la base de datos en $this->enDB
     *
     */
    //function permiso_por_record() { }
    /**
     * app_banco_diccionario_dato::may_add()
     * Permiso para ver la forma de dar alta, conviene mas usar las variables $this->permiso_*
     * @return  boolean TRUE puede, false no puede
     */
    //function may_add() { return $this->permiso_insert; }
    /**
     * app_banco_diccionario_dato::may_insert()
     * Permiso para dar altas, insert, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_insert() { return $this->may_add(); }
    /**
     * app_banco_diccionario_dato::may_edit()
     * Permiso para ver la forma de editar, conviene mas usar las variables $this->permiso_*
     * @return boolean
     */
    //function may_edit() { return $this->permiso_update; }
    /**
     * app_banco_diccionario_dato::may_update()
     * Permiso para hacer el update, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_update() { return $this->may_edit() && ($this->asChild ? $this->asChild_update : true); }
    /**
     * app_banco_diccionario_dato::may_delete()
     * Parmiso para borrar, se usa en confirmar y en borrar., conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_delete() { return $this->permiso_delete && ($this->asChild ? $this->asChild_delete : true); }
    /**
     * app_banco_diccionario_dato::may_read()
     * Permiso para ver el record, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_read() { return $this->permiso_read; }
    /**
     * app_banco_diccionario_dato::may_list()
     * Permiso para listar los records, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_list() { return $this->permiso_list; }
    /**
     * app_banco_diccionario_dato::may_export()
     * Permiso para exportar, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_export() { return $this->permiso_export; }
    /**
     * app_banco_diccionario_dato::may_print()
     * Permiso para imprimir, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_print() { return $this->may_export(); }
    /**
     * app_banco_diccionario_dato::may_viewLog()
     * Permiso para ver el log, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_viewLog() { return $this->permiso_export; }

//////////////////////////////////
// Etiquetas o labels
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::label_record()
     * Nombre corto del registro
     * @return string el nombre corto del registro
     */
    //function label_record() { }

    /**
     * app_banco_diccionario_dato:label_record_summary()
     * Resumen de registro
     * @return string el resumen del registro
     */
    //function label_record_summary() { }

    /**
     * app_banco_diccionario_dato::label_add()
     * Etiqueta para agregar un registro
     * @return string la etiqueta para agregar un registro si existe $this->table_info['label_add'], del contrario la arma
     */
   //public function label_add() {    }
    /**
     * app_banco_diccionario_dato::label_list()
     * Etiqueta para el listado
     * @return string la etiqueta del listado, si existe $this->table_info['label_list'] del contrario  $this->label_table_plural()
     */
    //public function label_list() { }
    /**
     * app_banco_diccionario_dato::label_table_singular()
     * Etiqueta para la tabla o tipos de registro en singular
     * @return string el label de la tabla en singular
     */
    //public function label_table_singular() { return $this->label; }
    /**
     * app_banco_diccionario_dato::label_table_plural()
     * Etiqueta para la tabla o tipos de registro en plural
     * @return string el label de la tabla en plural
     * @return
     */
    //public function label_table_plural() { }


//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::campos_final
     * Redefine $campos del default en campos_default
     *
     */
    public function campos_final() {
        // pkfields=array( 'banco_diccionario_dato_id' );
        /*	CAMPOS_START
				primary key: 'banco_diccionario_dato_id' al 2026-01-13 16:39
				activo,nombre,es,palabra_clave,descripcion_a_poner,agregar_palabra_clave,banco_mov_tipo_id,withdrawal_autorizado,link_vale,banco_cuenta_no_aplica,categoria_gasto_id,accion_extra,orden,vale,plantilla_withdrawals_de_banco_id,agregar_titulo,titulo_para_agregar,monto_minimo,monto_maximo,banco_cuenta_si_aplica,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_diccionario_dato_id
			CAMPOS_END
        */
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'display_group','string' ); // a fieldnameN cambiales 'max' a 1e6
        //$this->campos['fieldName']['br']=true;
        /* comunes atributes son
            required,max,min,display_group,display_group_label, hidden_value pone hidden en modo R/O
            label_br: normalmente es label<br />input si existe pone label $x[label_br] input
            br pasa al siguiente renlgon
        */
if($this->h=='' || $this->h=='l') {
        $this->campos['parent'] =
            array (
            'title' => 'Parent',
            'label'=>'Parent',
            'display_group' => 'Dato',
            'Null' => true,
            'required' => false,
            'Type' => 'varchar',
            'modo' =>   'R/O',
            //'virtual_sql'=>'parent',
            'Default' => '',
            'filter'=>false
            );

        $this->campos['grandparent'] =
            array (
            'title' => 'Grandparent',
            'label'=>'Grandparent',
            'display_group' => 'Dato',
            'Null' => true,
            'required' => false,
            'Type' => 'varchar',
            'modo' => 'R/O',
            //'virtual_sql'=>'parent',
            'Default' => '');
}

        $this->campos['banco_cuenta_no_aplica'] =
            array (
            'title' => 'Esta regla aplica en',
            'label'=>'Esta regla aplica en',
            'display_group' => 'Acciones',
            'Null' => true,
            'required' => false,
            'Type' => 'varchar',
            'modo' => 'R/O',
            //'virtual_sql'=>'parent',
            'Default' => '');

        $this->campos['plantilla_withdrawals_de_banco_id'] = [
            'title' => '',
            'display_group' => '',
            'Null' => true,
            'required' => false,
            'Type' => 'varchar',
            'maxlength' => '32',
            'modo' => 'R/W',
            'link_table' => 'plantilla_withdrawals_de_banco',
            'formato' => 'link_one_select',
            'display_group_break' => false,
        ];

        $this->campos['monto_maximo'] = $this->campos['monto_minimo'] =
            array (
                'display_group' => 'Dato',
                'Null' => false,
                'required' => false,
                'Type' => 'decimal',
                'enteros' => '16',
                'decimales' => '2',
                'numeric' => 1,
                'unsigned' => true,
                'min' => 0,
                'max' => '9999999999.99',
                'modo' => 'R/W',
                'Default' => '0.00');

        $orden=array('activo','nombre','es', 'palabra_clave','descripcion_a_poner','agregar_palabra_clave','banco_mov_tipo_id','withdrawal_autorizado','link_vale','banco_cuenta_no_aplica',
            'alta_db','alta_por','ultimo_cambio','ultimo_cambio_por','categoria_gasto_id','parent','grandparent','accion_extra','plantilla_withdrawals_de_banco_id'
        );
        $this->campos_reorder($orden);

        $this->campos['descripcion_a_poner']['label']='Descripción a poner';
        $this->campos['descripcion_a_poner']['required']=false;
        $this->campos['es']['label']='Aplica cuando el movimiento es';
        $this->campos['accion_extra']['label']='Acción Extra';
        $this->campos['accion_extra']['required']=false;
        $this->campos['activo']['label']='Regla Activa';
        $this->campos['ultimo_cambio']['label']='Último Cambio';
        $this->campos['ultimo_cambio_por']['label']='Último Cambio Por';

        $this->campos['palabra_clave']['Type']='longtext';
        $this->campos['palabra_clave']['label']='Palabras clave (separadas por coma)';
        $this->campos['banco_mov_tipo_id']['label']='Tipo Movimiento Bancario';
        $this->campos['agregar_palabra_clave']['label']='Agregar Palabra Clave a Descripción';

        $this->campos['categoria_gasto_id']['required']=false;
        $this->campos['categoria_gasto_id']['Null']=true;
        $this->campos['categoria_gasto_id']['class']='notSelectize';

        $this->campos['withdrawal_autorizado']['modo']= 'Nada';
        $this->campos['vale']['modo']= 'Nada';

        $this->campos['descripcion_a_poner']['Type']='longtext';

        $this->campos['orden']['modo']='Nada';
        $this->campos['orden']['Type']='numeric';

        $this->campos['parent']['modo']='Nada';
        $this->campos['grandparent']['modo']='Nada';

        $this->campos_set_attribute( array( 'activo','nombre','es', 'monto_maximo', 'monto_minimo'),'display_group','Dato' );
        $this->campos_set_attribute( array( 'activo','nombre','es', 'monto_maximo', 'monto_minimo'),'display_group_label','Dato' );

        $this->campos_set_attribute( array( 'accion_extra', 'plantilla_withdrawals_de_banco_id'),'display_group','Solo_programadores' );
        $this->campos_set_attribute( array( 'accion_extra', 'plantilla_withdrawals_de_banco_id'),'display_group_label','Sólo programadores' );

        $this->campos_set_attribute( array( 'palabra_clave','descripcion_a_poner','agregar_palabra_clave','banco_mov_tipo_id','withdrawal_autorizado','link_vale',),'display_group','Acciones' );
        $this->campos_set_attribute( array( 'palabra_clave','descripcion_a_poner','agregar_palabra_clave','banco_mov_tipo_id','withdrawal_autorizado','link_vale',),'display_group_label','Acciones' );

        $this->campos_set_attribute( array('descripcion_a_poner','palabra_clave','accion_extra'), 'data-class', 'dontUpperCase' );
        $this->campos_push_attribute( array('descripcion_a_poner','palabra_clave','accion_extra'),'input', 'data-class', 'dontUpperCase' );

        if(!usuarioTipoRony())
            $this->campos['accion_extra']['modo']= 'R/O';

        $this->campos['descripcion_a_poner']['formato']='fckeditor';
        $this->campos['descripcion_a_poner']['type']='html';
        $this->campos['agregar_palabra_clave']['display_group_break']=true;

        $this->campos_push_attribute(array('descripcion_a_poner'), 'input', 'class', 'width-100');
    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::insert_pre_validate()
     *
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * app_banco_diccionario_dato::insert_validate()
     *
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * app_banco_diccionario_dato::insert_pre_save()
     *
     * @return
     */
     function insert_pre_save()  {
        $this->values['descripcion_a_poner'] = trimandAddNewLineandBR($this->values['descripcion_a_poner'] ?? "");
        $this->values['descripcion_a_poner'] = html_entity_decode($this->values['descripcion_a_poner']);
        return true;
    }

    /**
     * app_banco_diccionario_dato::insert_extra_values()
     * permite agregar valores al insert sql statement o modificar el array del que hacer el insert
     * @param string $insArray  agregar insert clause, terminar con coma ie: $ins.=",campo1"
     * @param string $log   agregar o cambiar el log
     * @return boolean TRUE continua con el isnert, FALSE cancela el insert en este caso avisar en $this->msg_err.="<li>explica..."
    */
    //function insert_extra_values(&$insArray,&$log) { return true; }

    /**
     * app_banco_diccionario_dato::insert_add_sql_queries()
     * permite agregar queries al transaction del insert
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    //function insert_add_sql_queries(&$sql,&$log) { return true;}

    /**
     * app_banco_diccionario_dato::insert_post_save()
     *
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::update_pre_validate()
     *
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * app_banco_diccionario_dato::update_validate()
     *
     * @return
     */
    //function update_validate()  { return $this->validate(); }
    /**
     * app_banco_diccionario_dato::update_pre_save()
     *
     * @return
     */
    function update_pre_save()  {

        $this->values['descripcion_a_poner'] = trimandAddNewLineandBR($this->values['descripcion_a_poner'] ?? "");
        $this->values['descripcion_a_poner'] = html_entity_decode($this->values['descripcion_a_poner']);


        return true;
    }

    /**
     * app_banco_diccionario_dato::update_extra_sql()
     * permite agregar valores al update sql
     * @param string $updArray  array de valores
     * @param string $log  agregar <li> al log ie: $log.="<li>..."
     * @return boolean TRUE continua con el update FALSE no hace el update poner mensaje en $this->msg_err.="<li>..."
    */
    //function update_extra_sql(&$updArray,&$log) { return true; }

    /**
     * app_banco_diccionario_dato::update_add_sql_queries()
     * permite agregar queries al transaction del update
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    //function update_add_sql_queries(&$sql,&$log) { return true;}

    /**
     * app_banco_diccionario_dato::update_post_save()
     *
     * @return
     */
    //function update_post_save()   {return true;}

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
/////////////////////////////////
    //function delete_pre_validate($h) { return true; }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    //function delete_post_delete($h) {  }
    /**
     * app_banco_diccionario_dato::delete_sql()
     *
     * @param string $record record values to delete, normalmente $this->values
     * @param array $sql array de sql commands al que agregar queries
     * @return void
     */
    //function delete_sql_extra($record,&$sql) {  }

//////////////////////////////////
// FORM override functions
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::forma_pre()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_pre(&$h,&$nexth) {


        $this->campos['categoria_gasto_id']['modo']= 'Nada';
        $this->campos['parent']['modo']='Nada';
        $this->campos['grandparent']['modo']='Nada';

        $this->values['descripcion_a_poner'] = (removeBrTags($this->values['descripcion_a_poner']));
        return true;
    }
    /**
     * app_banco_diccionario_dato::forma_preFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * app_banco_diccionario_dato::forma_postFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * app_banco_diccionario_dato::forma_doChilds()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_doChilds(&$h,&$nexth) { return true; }
    /**
     * app_banco_diccionario_dato::forma_post()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
//    public function forma_post(&$h, &$nexth, $ok = true) {
//
//global $verJS;
//
//        if($this->h=='e' || $this->h=='i' || $this->h=='a') {
//            echo <<< JSSCRIPT
//<script src="../js2/clasificator.js?$verJS"></script>
//<script>
//$(function(){
// $("#categoria_gasto_id").Clasificator({
//        'readurl':'ajax/categoria_gasto_do.php',
//        editable:true,
//        maxLevel:3,
//        uniqueNameBy:'level',
//        topOffsetScroll:200,
//    }).Clasificator('selectChained');
//    window.setTimeout(function(){iaFormDirty=false;}, 500);
//});
//</script>
//JSSCRIPT;
//        } elseif($this->h=='r') {
//            $value = $this->values['categoria_gasto_id'];
//            echo <<< JSSCRIPT
//<script src="../js2/clasificator.js?$verJS"></script>
//<script>
//$(function(){
//    $("<div>").Clasificator({
//        'readurl':'ajax/categoria_gasto_do.php',
//        editable:false,
//        maxLevel:3,
//        uniqueNameBy:'level',
//        topOffsetScroll:200,
//    }).Clasificator('ancestors', '$value', function(x){
//       var lbl= x.map(function(v){return v.label; }).reverse().slice(1).reverse().join(" <- ");
//       if(lbl)
//        $("#div_categoria_gasto_id").append( " <- " + lbl  );
//    });
//});
//</script>
//JSSCRIPT;
//
//        }
//        return true;
//    }
    /**
     * app_banco_diccionario_dato::forma_postDiv()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    public function forma_postDiv($h,$nexth) {
        global $verJS;
        $ret_arr_cuentas=$this->leer_banco_cuenta_no_aplica();
        $txt_cuenta_no_aplica = $ret_arr_cuentas["txt_cuenta_no_aplica"];
        $txt_cuenta_si_aplica = $ret_arr_cuentas["txt_cuenta_si_aplica"];
        $div_cuenta_no_no_aplica = $ret_arr_cuentas["div_cuenta_no_no_aplica"];
        $div_cuenta_no_aplica = $ret_arr_cuentas["div_cuenta_no_aplica"];

        $values_clasificador_cuentas_aplica = json_encode($ret_arr_cuentas['data']??[]);

        $func_modifica_cuenta_no_aplica = '<a href="#" onclick="modifica_banco_cuenta();"><img src="../img/20-edit.png" width="20" height="20" alt="Modificar las Cuentas en las que no no aplica esta regla" title="Modificar las Cuentas en las que no no aplica esta regla"/></a>';

        // $this->values['palabra_clave'] ='/*243 ARREN/, /SANTANDER00* 014 *ARREN/, /SANTANDER00* 014 *REN/,/BANORTE00* 072 *ARREN/,/*8177 ARREN/, /SANTANDER00* 014 *ARREN/';
        $palabras_clave = array_filter(array_map('trim', explode(',', $this->values['palabra_clave'])));
        $details_parse = '';
        if (!empty($palabras_clave))
            $details_parse = str_replace("\\", "\\\\",details_parse_to_regex($palabras_clave));
?>
<!-- PLANTILLAS DE WITHDRAWALS -->
<script charset="UTF-8" src="../js2/plantillas_withdrawal.js?<?= $verJS; ?>" defer="defer"></script>
<script>
    const id = "<?=$this->id?>";
    var clasificador_cuentas_aplica;
    var values_clasificador_cuentas_aplica = <?=$values_clasificador_cuentas_aplica?>;

    function iacase_submit() {
        $('#descripcion_a_poner').val(nl2br($('#descripcion_a_poner').val()));
        
        return true;
    }

    function modifica_banco_cuenta(){
        
        
        let txt_titulo_dialogo = "Modificación de Cuentas en las que no aplica esta regla",
        dialog_div_id = "div_cuenta_no_aplica";
        
        $('#'+dialog_div_id).dialog({
            resizable: false,
            modal: true,
            width: 'auto',
            position: {
                my: "center",
                at: "center",
                of: window
            },
            title: txt_titulo_dialogo,
            open: function(event, ui) {
                $("html, body").animate({ scrollTop: 1000000 }); //Arregla un bug que hace que aparezca el dialogo a media pantalla.
                //$(this).parent().css('position', 'fixed');
                //setTimeout(function(){ $(this).dialog('option', 'position', 'center');}, 200);
                //Llenamos ambos DIVs
                },
            close: function(event, ui) {
                //location.reload();// Cambiar a actualizar via ajax.
                },
            buttons: [
                {
                    html: "Guardar",
                    click: function() {
                        $(this).dialog( "close" );
                        set_cuentas_aplica(clasificador_cuentas_aplica.clasificame('value')||[]);
                    }
                },
                {
                    html: "Cerrar<br><small>No se guardan los cambios</small>",
                    click: function() {
                        close_from = 'close';
                        $(this).dialog( "close" );
                        clasificador_cuentas_aplica.clasificame('restore')
                    }
                }
            ]
        });
    }
    
    function quita_cuenta(banco_cuenta_id, permiso){
        
        if(banco_cuenta_id==0)
            return;
    
        var permisoO = new Object;
        permisoO.banco_cuenta_id = banco_cuenta_id;
        permisoO.banco_diccionario_dato_id = $("#iaid").val();
        permisoO.banco_cuenta = $("#" +permisoO.banco_cuenta_id).text().trim();
        
        do_quita_cuenta(permisoO, permiso);
    
        let div_id_pos = "div_cuenta_no_aplica";
        let div_id_neg = "div_cuenta_no_no_aplica";
        
        $('#'+div_id_neg).append('<div id="'+permisoO.banco_cuenta_id+'" data-banco_cuenta_id="'+permisoO.banco_cuenta_id+'" data-nombre="'+permisoO.banco_cuenta+'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'+permisoO.banco_cuenta+'</strong><a href="javascript:void(0);" onclick="agrega_cuenta('+permisoO.banco_cuenta_id+','+permiso+');">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Poner depósitos en ND." title="Poner depósitos en ND." /></a>&nbsp;&nbsp;</div>');
      
        $('#'+div_id_pos+' [data-banco_cuenta_id="'+banco_cuenta_id+'"]').remove();
    }
    
    function agrega_cuenta(banco_cuenta_id, permiso){
        
        if(banco_cuenta_id==0)
            return;

        var permisoO = new Object;
        permisoO.banco_cuenta_id = banco_cuenta_id;
        permisoO.banco_diccionario_dato_id = $("#iaid").val();
        permisoO.banco_cuenta = $("#" +permisoO.banco_cuenta_id).text().trim();
        
        do_agrega_cuenta(permisoO, permiso);
        
        let div_id_pos = "vale_cuenta_no_aplica";
        let div_id_neg = "vale_cuenta_no_no_aplica";

        $('#'+div_id_pos).append('<div id="'+permisoO.banco_cuenta_id+'" data-banco_cuenta_id="'+permisoO.banco_cuenta_id+'" data-nombre="'+permisoO.banco_cuenta+'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'+permisoO.banco_cuenta+'</strong><a href="javascript:void(0);" onclick="quita_cuenta('+permisoO.banco_cuenta_id+','+permiso+');">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>');
    
        $('#'+div_id_neg+' [data-banco_cuenta_id="'+banco_cuenta_id+'"]').remove();
    }

    function do_agrega_cuenta(permisoO, permiso){

        var json_cpnd = JSON.stringify(permisoO);
        
        let txt_cuenta = "txt_cuenta_no_aplica";
        let div_actuales = "cpnd_actuales";
    
        $.ajax({
            url: "ajax/banco_acciones.php",
            cache: false,
            type: "get",
            async: false,
            data: {'accion':'agrega_cuenta_no_aplica', 'json_cpnd':json_cpnd},
    
            beforeSend: function(jqXHR, settings)
            {
                return true;
            },
            success: function(response, textStatus, jqXHR){
                try {
                    var json_res_cpnd = eval('(' + response + ')');
                    if(json_res_cpnd.Status == 'OK'){
                        permisoO.banco_cuenta = json_res_cpnd.banco_cuenta;
                        $('#'+div_actuales).html(json_res_cpnd[txt_cuenta]);
                    }
                    else{
                        vx_alert(divIDError, json_res_cpnd.Error, 'agrega_cuenta' + permiso);
                    }
                }catch(err){alert(err.message);console.log(response) }
            },
            error: function (xhr, ajaxOptions, thrownError){
                try {
                    var json_res_cpnd = eval('(' + xhr.responseText + ')');
                    if(json_res_cpnd.Status == 'OK'){
                        permisoO.banco_cuenta = json_res_cpnd.banco_cuenta;
                        $('#'+div_actuales).html(json_res_cpnd[txt_cuenta]);
                    }
                    else{
                        vx_alert(divIDError, thrownError, 'agrega_cuenta' + permiso);
                    }
                }catch(err){alert(err.message);console.log(xhr) }
            }
        });
    }
    
    function do_quita_cuenta(permisoO, permiso = '_no_aplica'){

        var json_cpnd = JSON.stringify(permisoO);
        
        let txt_cuenta = "txt_cuenta_no_aplica";
        let div_actuales = "cpnd_actuales";
    
        $.ajax({
            url: "ajax/banco_acciones.php",
            cache: false,
            type: "post",
            async: false,
            data: {'accion':'quita_cuenta_no_aplica', 'json_cpnd':json_cpnd, 'permiso':permiso},
    
            beforeSend: function(jqXHR, settings)
            {
                return true;
            },
            success: function(response, textStatus, jqXHR){
                try {
                    var json_res_cpnd = eval('(' + response + ')');
                    if(json_res_cpnd.Status == 'OK'){
                        permisoO.banco_cuenta = json_res_cpnd.banco_cuenta;
                        $('#'+div_actuales).html(json_res_cpnd[txt_cuenta]);
                    }
                    else{
                        vx_alert(divIDError, json_res_cpnd.Error, 'quita_cuenta' + permiso);
                    }
                }catch(err){alert(err.message);console.log(response) }
            },
            error: function (xhr, ajaxOptions, thrownError){
                try {
                    var json_res_cpnd = eval('(' + xhr.responseText + ')');
                    if(json_res_cpnd.Status == 'OK'){
                        permisoO.banco_cuenta = json_res_cpnd.banco_cuenta;
                        $('#'+div_actuales).html(json_res_cpnd[txt_cuenta]);
                    }
                    else{
                        vx_alert(divIDError, thrownError, 'quita_cuenta' + permiso);
                    }
                }catch(err){alert(err.message);console.log(xhr) }
            }
        });
    }

    $(function() {
        let $div_banco_cuenta_no_aplica = $('#div_banco_cuenta_no_aplica'), label_banco_cuenta_no_aplica = $div_banco_cuenta_no_aplica.find('label');
        $div_banco_cuenta_no_aplica.html("").append(label_banco_cuenta_no_aplica);

        /* <?php echo $div_cuenta_no_aplica.$div_cuenta_no_no_aplica;?> */
        $("body").append('<div id="div_cuenta_no_aplica" style="display:none;"><div id="clasificador_cuentas_aplica"></div></div>');
        $div_banco_cuenta_no_aplica.append('<br/><div class="dvrd" style="float:left;"><?php echo $func_modifica_cuenta_no_aplica;?></div><div class="dvrd" id="container_banco_cuenta_no_aplica" style="float:left; max-width: 350px;max-height: 150px; overflow-y: scroll;"><div id="cpnd_actuales" class="bold fieldset-3d-base fieldset-green"><?php echo $txt_cuenta_si_aplica; ?></div></div>');

        $('#Solo_programadores').append(`<div id="div_accion_extra" class="dved " style="float:left;">
<details class="default" style="margin:1em;"><summary>&nbsp;Diccionario de variables <strong class="txt_shadow_violeta" >%VAR%</strong></summary>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%TWOMONTHSAGO%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El nombre del mes, hace dos meses desde la fecha actual.</span></span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%TWOMONTHSAGOYEAR%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El año, hace dos meses desde la fecha actual.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%LASTMONTH%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El nombre del mes pasado desde la fecha actual.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%LASTMONTHYEAR%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El año del mes pasado desde la fecha actual.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%MONTH%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El nombre del mes actual desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%YEAR%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El año actual desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%FIRSTDAYMONTH%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El primer día del mes actual, siempre "01".</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%LASTDAYMONTH%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El último día del mes actual desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%FIRSTDAYLASTMONTH%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El primer día del mes pasado, siempre "01".</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%LASTDAYLASTMONTH%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El último día del mes pasado desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%FIRSTDAYTWOMONTHSAGO%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El primer día de hace dos meses, siempre "01".</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%LASTDAYTWOMONTHSAGO%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El último día de hace dos meses desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%THISWEEK%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El número de la semana del año actual desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%FIRSTDAYTHISWEEK%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El día del mes para el lunes de la semana actual desde la fecha proporcionada.</span>
<li style="margin-bottom: 5px; margin-top: 1px;"><strong class="txt_shadow_violeta" >%LASTDAYTHISWEEK%</strong> => <span style="font-weight: normal !important; font-size: 1.1em; color: #000000 !important;" >El día del mes para el domingo de la semana actual desde la fecha proporcionada.</span></details>`);

        $('#Solo_programadores').append(`<div id="div_diccionario_regex" class="dved " style="float:left;"><?=$details_parse?></div>`);
        
        plantilla.init();

        clasificador_cuentas_aplica = $('#clasificador_cuentas_aplica').clasificame({
            clasificacion: [
                {clasificaId:'Si', label:'Si', title:'Si aplicar', userSortable:true},
                {clasificaId:'No', label:'No', title:'No aplicar', userSortable:true}
            ],
            valueId: 'banco_cuenta_id',
            valueDisplay: 'cuenta',
            valueColumnKey: 'aplica',
            values: values_clasificador_cuentas_aplica,
            modalGroup: true,
            title: 'Aplicar reglas: '
        });

        const params = getQueryParams();
        if (params.kw) {
            var kw_search = params.kw;
            var is_regex = false;
            var origen = '';
            if (params.match) {
                kw_search = atob(params.match)
                is_regex = true;
                origen = 'from_match';
            }
            else { // buscamos en las palabras
                origen = 'from_key_word';
                $('#palabra_clave').val().split(",").some(function (palabra) {
                    if (palabra.includes("/") || palabra.includes("*") || palabra.includes("d+")) {
                        const regexString = palabra.slice(1, -1); // Quitar las barras
                        const regex = new RegExp(regexString); // Crear el objeto RegExp
                        // Probar la expresión regular
                        if (regex.test(kw_search)) { // si coincide con la expresión, cambiamos la palabra para el highlight
                            kw_search = palabra;
                            is_regex = true;
                        }
                        return true;
                    }
                    return false;
                });
            }

            console.log("Busqueda: "+origen, kw_search);
            let kw_search_map = kw_search;
            // kw_search = !is_regex ? ('(?<=,\\s?)'+kw_search+'(?=,|$)'):kw_search;
            kw_search = !is_regex ? (kw_search+'(?=,|$)'):kw_search;
            $('#palabra_clave').vx_highlight({
                words:  [[kw_search, kw_search_map]],
                blink: true,
                blink_time: 5000,
                width:  718,
                height: 200,
            });
        }
    });

    const plantilla = {
        plantilla_id: '',
        init: function () {
            const self = this;
            this.plantilla_id = $('#plantilla_withdrawals_de_banco_id').val();

            $('label[for=plantilla_withdrawals_de_banco_id]').after(`<sup style='margin-left:10px'><a id='link_to_plantillas' href='#df' target='_blank'><i class='fa-icon txt_shadow_blue fa-duotone fa-solid fa-link'></i></a></sup>`);
            plantilla.prepara_link();

            $('#plantilla_withdrawals_de_banco_id').change(function () {
                self.prepara_link();
                self.prepara_descripcion();
            });

            // preparamos las pantillas
            plantillas.getPlantillasHtml((response) => {
                plantillas.plantillas = response.plantillas_json;
                if (!empty(plantilla.plantilla_id))
                    plantilla.prepara_descripcion();
            });
        },
        prepara_link: function () {
            let params_to_plantillas = {};
            let plantilla_id = $('#plantilla_withdrawals_de_banco_id').val();
            this.plantilla_id = plantilla_id;
            if (!empty(plantilla_id)) {
                params_to_plantillas.id = plantilla_id;
                params_to_plantillas.iah = 'e';
            }
            $('#link_to_plantillas').attr('href', prepareUrl(getUrlBase('backoffice/plantilla_withdrawals_de_banco.php'), params_to_plantillas));
        },
        
        prepara_descripcion: function () {
            var div_content_descripcion = $('#div_descripcion_a_poner');
            $('#plantilla_descripcion').remove();
            if (empty(this.plantilla_id)) {
                vx_asyncFunction(function () {
                    $('.tox.tox-tinymce', div_content_descripcion).show();
                    // setTimeout(function () {
                    //     tinymce.get('descripcion_a_poner').setContent('');
                    // }, 10);
                }, 100);
            }
            else {
                $('#descripcion_a_poner').hide();
                let div_descripcion = $('<div id="plantilla_descripcion">');
                div_descripcion.html('La descripción se tomará con base a la plantilla seleccionada');
                let form_plantilla = $('<div>').html(plantillas.get_html_form_template(this.plantilla_id, {}));
                form_plantilla.hide();
                div_descripcion.append(form_plantilla);
                div_content_descripcion.append(div_descripcion);
                vx_asyncFunction(function () {
                    $('.tox.tox-tinymce', div_content_descripcion).hide();
                    var preview_plantilla = plantillas.get_remarks_from_template(plantilla.plantilla_id, false);
                    div_descripcion.append('<div style="font-weight: normal;" class="form-build">'+preview_plantilla+'</div>');
                    setTimeout(function () {
                        tinymce.get('descripcion_a_poner').setContent(preview_plantilla);
                    }, 100);
                }, 100);
            }

        }

    };


    function set_cuentas_aplica(cuentas_aplica)
    {
        let request = {
            url: getUrlForAjax('banco_acciones'),
            data: {
                accion: 'set_cuentas_aplica_reglas',
                values: cuentas_aplica,
                banco_diccionario_dato_id: id
            }
        };
        
        jqAjax(request, function (response) {
            if (response.code == 200 && response.status ==true)
            {
                let componentes = response.componentes;
                clasificador_cuentas_aplica.clasificame('setValues', componentes.data);
                $('#cpnd_actuales').html(componentes.txt_cuenta_si_aplica);
                // localStorage.setItem('reloadTime', new Date().getTime());
            }
            else {
                console.log(response);
                $.notify(response.message, 'error');
                clasificador_cuentas_aplica.clasificame('restore');
            }
        });
    }


</script>

<script type="text/javascript">
    /**
     * USE
     *  $('[input, textarea]_id').highlight({
            words:  ['palabra1', 'palabra2',...], // array de palabras ['word1', 'word2'...] | [['search_1', 'display1'], ['search_2', 'display2'],...];
            width:  600,
            height: 200,
            backGround: 'blue', // [#hexadecimal | rgb(0,0,0) | rgba(0, 0, 0, 1) | name_color]
            color: 'white', // [#hexadecimal | rgb(0,0,0) | rgba(0, 0, 0, 1) | name_color]
            left_highlighterContainer: '0px', // para ajustar posición del shadow para la marca
            top_highlighterContainer: '0px' // para ajustar posición del shadow para la marca
            blink: false, [true|false]
            blink_time: 3000, // tiempo para parpadear en milisegundos (default 3s)
        });
     */
    // the plugin that would do the trick
    (function($){
        $.fn.extend({
            vx_highlight: function() {
                var new_this;
                // the main class
                var pluginClass = function() {};
                // init the class
                // Bootloader
                pluginClass.prototype.__init = function (element) {
                    try {
                        this.preparaUI(element);
                        this.tagElement = element[0].tagName;
                        element = $('#container_highlight_'+element[0].id);
                        new_this = $('#'+element[0].id);
                        this.element = element;
                    } catch (err) {
                        this.error(err);
                    }
                };
                // centralized error handler
                pluginClass.prototype.error = function (e) {
                    // manage error and exceptions here
                    //console.info("error!",e);
                };
                // Centralized routing function
                pluginClass.prototype.execute = function (fn, options) {
                    try {
                        // options = $.extend({},options);
                        if (typeof(this[fn]) == "function") {
                            var output = this[fn].apply(this, [options]);
                        } else {
                            this.error("undefined_function");
                        }
                    } catch (err) {
                        this.error(err);
                    }
                };
                // **********************
                // Plugin Class starts here
                // **********************

                // prepare interfaz to use
                pluginClass.prototype.preparaUI = function (element) {
                    addCss();
                    var template = `<div id="container_highlight_${element[0].id}" class="container_highlight">
                        <div class="highlighterContainer">
                            <div class="highlighter"></div>
                        </div>
                        <div class="inputContainer">
                            ${element[0].outerHTML}
                        </div>
                    </div>`;
                    element.after(template);
                    element.remove();

                    function addCss()
                    {
                        if (document.getElementById('css_vx_highlight')) // Ya se agrego el css
                            return;
                        var head = document.head || document.getElementsByTagName('head')[0],
                            style = document.createElement('style');
                        style.id = 'css_vx_highlight';
                        style.type = 'text/css';
                        var css = `.blink_vx_highlight{animation:blink_vx_highlight 1s linear infinite;}
                        @keyframes blink_vx_highlight{0%{opacity:1;}
                        50%{opacity:1;}
                        50.01%{opacity:0;}
                        100%{opacity:0;}}`;
                        if (style.styleSheet){
                            // This is required for IE8 and below.
                            style.styleSheet.cssText = css;
                        } else {
                            style.appendChild(document.createTextNode(css));
                        }
                        head.append(style);
                    }
                };
                // init the component
                pluginClass.prototype.init = function (options) {
                    try {
                        // the element's reference ( $("#container") ) is stored into "this.element"
                        var scope                   = this;
                        this.options                = options;

                        this.options_org = options;

                        // just find the different elements we'll need

                        this.highlighterContainer   = this.element.find('.highlighterContainer');
                        this.inputContainer         = this.element.find('.inputContainer');
                        this.textarea               = this.inputContainer.find(this.tagElement.toLowerCase());
                        this.highlighter            = this.highlighterContainer.find('.highlighter');

                        // apply the css
                        this.element.css({
                            'position':'relative',
                            'overflow':'hidden',
                            'height':this.options.height,
                            'width':this.options.width+2,
                        });

                        // place both the highlight container and the textarea container
                        // on the same coordonate to superpose them.
                        this.highlighterContainer.css({
                            'position':         'absolute',
                            'left':             this.options.left_highlighterContainer||'1px',
                            'top':              this.options.top_highlighterContainer||'1px',
                            'width':            this.options.width,
                            'height':           this.options.height,
                            'cursor':           'text',
                            'z-index':          '1',
                            'font-weight':      'normal'
                        });
                        this.inputContainer.css({
                            'position':         'relative',
                            'left':             '0',
                            'top':              '0',
                            'z-index':          '2',
                            'height':this.options.height,
                            'width':this.options.width,
                        });


                        this.highlighter.css({
                            'color':            '#eeeeee',
                            'background': '#ffffff',
                            'margin':           '0px',
                            'font-size':        '1em' ,
                            'height':this.options.height,
                            'width':this.options.width,
                            'word-wrap': 'break-word'
                        });

                        // the textarea must have a transparent background so we can see the highlight div behind it
                        this.textarea.css({
                            'background': 'transparent',
                            'padding':          '0',
                            'margin':           '0',
                            'width':this.options.width,
                            'font-size':        '1em' ,
                        });

                        // apply the hooks
                        this.highlighterContainer.bind('click', function() {
                            scope.textarea.focus();
                        });
                        this.textarea.bind('keyup', function() {
                            // when we type in the textarea,
                            // we want the text to be processed and re-injected into the div behind it.
                            scope.options.blink = false;
                            scope.applyText($(this).val());
                        });

                        scope.applyText(this.textarea.val());

                    } catch (err) {
                        this.error(err)
                    }
                    return true;
                };
                pluginClass.prototype.applyText = function (text) {
                    try {
                        var scope = this;

                        // parse the text:
                        // replace all the line braks by <br/>, and all the double spaces by the html version &nbsp;
                        text = this.replaceAll(text,'\n','<br/>');
                        /* text = this.replaceAll(text,'  ','&nbsp;&nbsp;');
                        text = this.replaceAll(text,' ','&nbsp;'); */

                        var styles = ['color: black'];
                        var classes = ['vx_highlight_word'];
                        if (this.options.backGround)
                            styles.push('background: '+this.options.backGround);

                        if (this.options.color)
                            styles.push('color: '+this.options.color);

                        if (this.options.blink)
                            classes.push('blink_vx_highlight');

                        // replace the words by a highlighted version of the words
                        this.options.words.forEach(function (word) {
                            let search = '', set_word = '';
                            if (!Array.isArray(word)) {
                                search = set_word= word;
                            }
                            else {
                                search = word[0];
                                set_word = word[1];
                            }
                            text = scope.replaceAll(text, search, '<mark style="'+styles.join("; ")+'" class="'+classes.join(" ")+'">'+set_word+'</mark>');
                        })
                        // re-inject the processed text into the div
                        this.highlighter.html(text);

                        if (this.options.blink) {
                            setTimeout(function () {
                                $('mark.vx_highlight_word.blink_vx_highlight', scope.highlighter).removeClass('blink_vx_highlight');
                            }, this.options.blink_time||3000);
                        }

                    } catch (err) {
                        console.log(err);
                        this.error(err);
                    }
                    return true;
                };
                // "replace all" function
                pluginClass.prototype.replaceAll = function(txt, replace, with_this) {
                    txt = txt.replaceAll(/&nbsp;/g, ' ');

                    if (replace.includes("/") || replace.includes("*") || replace.includes("d+")) // buscamos un regex
                        return txt.replaceAll(replace, with_this);

                    return txt.replace(new RegExp(replace, 'g'), with_this);
                };


                pluginClass.prototype.destroy = function () {
                    this.textarea.css({
                        'background': 'inherit',
                        'padding': 'revert',
                        'margin': 'revert',
                        'width': 'unset',
                        'font-size': 'unset',
                    });
                    this.element.before(this.textarea[0].outerHTML);
                    this.element.remove();
                };
                pluginClass.prototype.setWords = function (words) {
                    var scope = this;
                    if (!Array.isArray(words))
                        words = [words];

                    this.options.words = words;
                    this.applyText(this.textarea.val());
                    if (this.options_org.blink)
                    {
                        scope.blink();
                        setTimeout(function () {
                            scope.blink(false);
                        }, scope.options.blink_time||3000);
                    }
                };

                pluginClass.prototype.blink = function (on=true) {
                    if (on)
                        $('mark.vx_highlight_word', this.highlighter).addClass('blink_vx_highlight');
                    else
                        $('mark.vx_highlight_word.blink_vx_highlight', this.highlighter).removeClass('blink_vx_highlight');
                };




                // don't worry about this part, it's just the required code for the plugin to handle the methods and stuffs. Not relevant here.
                //**********************
                // process
                var fn;
                var options;
                if (arguments.length == 0) {
                    fn = "init";
                    options = {};
                } else if (arguments.length == 1 && typeof(arguments[0]) == 'object') {
                    fn = "init";
                    options = $.extend({},arguments[0]);
                } else {
                    fn = arguments[0];
                    options = arguments[1];
                }
                $.each(this, function(idx, item) {
                    var item_ = $(item);
                    // if the component is not yet existing, create it.
                    if (item_.data('vx_highlight') == null) {
                        const plugin = new pluginClass();
                        plugin.__init(item_);
                        item_ = $('#'+item.id);
                        item_.data('vx_highlight', plugin);
                        // item_[0].vx_highlight = plugin;
                    }
                    item_.data('vx_highlight').execute(fn, options);
                });
                return new_this;
            }
        });

    })(jQuery);
</script>

<?php
    }

    public function leer_banco_cuenta_no_aplica(){

        $ret_arr_cuentas=array( "txt_cuenta_no_aplica" => "",
            "div_cuenta_no_aplica" => "",
            "div_cuenta_no_no_aplica" => "");

        $txt_cuenta_no_aplica="";
        $div_cuenta_no_aplica="";
        $div_cuenta_no_no_aplica="";

        $cpnd_csv = $this->values['banco_cuenta_no_aplica'] ?? $this->enDB['banco_cuenta_no_aplica'] ?? "";

        //echo "<li>$cpnd_csv";

        $cpnd_array = explode(",", $cpnd_csv);

        //echo "<pre>cpnd_array" . print_r($cpnd_array, true) . "</pre>";

        if(is_array($cpnd_array) && !empty($cpnd_array)) {
            $cpnd_in = "banco_cuenta_id IN ('" . join("','", $cpnd_array) . "')";
            $cpnd_not_in = "banco_cuenta_id NOT IN ('" . join("','", $cpnd_array) . "')";
        }
        else {
            $cpnd_in = "banco_cuenta_id = -1";
            $cpnd_not_in = "banco_cuenta_id > 0";
        }

        $cpnd_fin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_in ORDER BY 2";

        // $cpnd_fin_arr tiene las cuentas que sí tienen sus depositos en ND.
        // Son las que No aplica;
        $cpnd_fin_arr = ia_sqlArrayIndx($cpnd_fin_sql);

        $cpnd_sin_sql = "SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active' AND $cpnd_not_in ORDER BY 2";

        // $cpnd_sin_arr tiene las cuentas que no tienen sus depositos en ND.
        // Son las que Si aplica;
        $cpnd_sin_arr = ia_sqlArrayIndx($cpnd_sin_sql);

        //echo "<pre>fin" . print_r($cpnd_fin_arr, true) . "</pre>";
        //echo "<pre>sin" . print_r($cpnd_sin_arr, true) . "</pre>";

//        if(!is_array($cpnd_fin_arr) || empty($cpnd_fin_arr))
//            return $ret_arr_cuentas;

//        echo "<li>$cpnd_fin_sql";
//        echo "<li>$cpnd_sin_sql";

        $data = [];
        // No aplica
        foreach($cpnd_fin_arr as $k=>$v)
        {
            $cuenta=$v['nombre'];
            $txt_cuenta_no_aplica.="<li>$cuenta";
            $div_cuenta_no_aplica.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5px;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="quita_cuenta('.$v['banco_cuenta_id'].');">&nbsp;&nbsp;<img src="../img/delete.png" width="14" height="14" alt="Dejar de poner depósitos en ND." title="Dejar de poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';

            $data[] = [
                'banco_cuenta_id' => $v['banco_cuenta_id'],
                'cuenta' => $cuenta,
                'aplica' => 'No'
            ];
        }

//        if(!empty($txt_cuenta_no_aplica))
//            $txt_cuenta_no_aplica = substr_replace($txt_cuenta_no_aplica,"",-1);
        // Si aplica
        $txt_cuenta_si_aplica= '';
        foreach($cpnd_sin_arr as $k=>$v)
        {
            $cuenta=$v['nombre'];
            $div_cuenta_no_no_aplica.='<div id="'.$v['banco_cuenta_id'].'" data-banco_cuenta_id="'.$v['banco_cuenta_id'].'" data-nombre="'.$cuenta.'" class="ui-menu ui-widget ui-widget-content ui-corner-all" style="padding: 5;"><strong>'.$cuenta.'</strong><a href="javascript:void(0);" onclick="agrega_cuenta('.$v['banco_cuenta_id'].');">&nbsp;&nbsp;<img src="../img/add.png" width="14" height="14" alt="Poner depósitos en ND." title="Poner depósitos en ND." /></a>&nbsp;&nbsp;</div>';

            $txt_cuenta_si_aplica.="<li>$cuenta";
            $data[] = [
                'banco_cuenta_id' => $v['banco_cuenta_id'],
                'cuenta' => $cuenta,
                'aplica' => 'Si'
            ];
        }

        $div_cuenta_no_aplica='<div id="vale_cuenta_no_aplica" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= No aplica la regla en: =-</strong><hr/><br/>'.$div_cuenta_no_aplica.'</div>';
        $div_cuenta_no_no_aplica='<div id="vale_cuenta_no_no_aplica" class="ui-widget ui-widget-header ui-corner-all" style="float: left; width: 49%; text-align:center;"><strong>-= Sí aplica la regla en: =-</strong><hr/><br/>'.$div_cuenta_no_no_aplica.'</div>';

        return array(
            "txt_cuenta_no_aplica"   => "$txt_cuenta_no_aplica",
            "txt_cuenta_si_aplica"   => $txt_cuenta_si_aplica,
            "div_cuenta_no_aplica" => "$div_cuenta_no_aplica",
            "div_cuenta_no_no_aplica" => "$div_cuenta_no_no_aplica",
            'data' => $data
        );
    }


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::listme_pre()
     *
     * @param mixed $grid
     * @return
     */
    function listme_pre($grid)
    {
        $this->colModel_overRide=array( 'activo'=>array('width'=>'60', 'classes'=>'bold'),
                                        'nombre'=>array('width'=>'300', 'classes'=>'bold'),
                                        'es'=>array('width'=>'70', 'classes'=>'bold'),
                                        'palabra_clave'=>array('width'=>'300', 'classes'=>'bold'),
                                        'descripcion_a_poner'=>array(
                                            'width'=>'250',
                                            'classes'=>'bold',
                                            'formatter' => 'iaHtmlFormatterPlantilla',
                                            'cellattr' => 'function (rowId, cellValue, rowObject, cm, rdata) {
                                                return iaAttrDescPlantilla(rowId, cellValue, rowObject, cm, rdata)
                                            }'
                                        ),
                                        'agregar_palabra_clave'=>array('width'=>'80', 'classes'=>'bold'),
                                        'banco_mov_tipo_id'=>array('width'=>'150', 'classes'=>'bold '),
                                        'withdrawal_autorizado'=>array('width'=>'90', 'classes'=>'bold'),
                                        'link_vale'=>array('width'=>'90', 'classes'=>'bold'),
                                        'banco_cuenta_no_aplica' => array(
                                            'formatter' => 'iaBancoCuentaAplica',
                                            'width'=>'200'
                                        ),

        );

        $orden=array('activo','nombre','es', 'palabra_clave','descripcion_a_poner','agregar_palabra_clave','banco_mov_tipo_id','withdrawal_autorizado','link_vale','banco_cuenta_no_aplica',
            'alta_db','alta_por','ultimo_cambio','ultimo_cambio_por','categoria_gasto_id','parent','grandparent','accion_extra',
        );
        $this->campos_reorder($orden);


        return true;
    }
    /**
     * app_banco_diccionario_dato::listme_preRender()
     *
     * @param mixed $grid
     * @return
     */
    function listme_preRender($grid) {
        $plantillas = json_encode(generaHtmlPlantillasWithdrawalsBanco('a'));
        $banco_cuentas = json_encode(ia_sqlKeyValue("SELECT banco_cuenta_id, nombre FROM banco_cuenta WHERE vale='Active'"));
        
        echo <<<HTML
        <script>
            gridhandler = 'iajqgridbanco_diccionario_dato_var';
            const jsonPlantillas = $plantillas;
            const banco_cuentas = $banco_cuentas;
            function iaHtmlFormatterPlantilla(cellvalue, options, rowObject)
            {
                let plantilla_id = rowObject.plantilla_withdrawals_de_banco_id || rowObject[getColNum(gridhandler, 'plantilla_withdrawals_de_banco_id')]||'';

                if (empty(plantilla_id)) {
                    return iaHtmlFormatter(cellvalue, options, rowObject);
                }
                else {
                    let plantilla = jsonPlantillas[plantilla_id] || null;
                    if (plantilla == null)
                        return iaHtmlFormatter(cellvalue, options, rowObject);

                    if (plantilla.tiene_restricciones !== 'Si')
                        return iaHtmlFormatter(cellvalue, options, rowObject);
                    
                    try {
                        return '<div class="jqgRZ jqgRS cellGrowShrink ' + jqGridRowResizer.cellGrowShrink + '" style="position:relative">' + plantilla.nombre+'<a href="'+prepareUrl(getUrlBase('backoffice/plantilla_withdrawals_de_banco.php'), {id: plantilla_id, iah:'e'})+'" target="_blank" style="float:right; background: white; " title="Ver plantilla"><i class="fa-icon txt_shadow_blue fa-duotone fa-solid fa-link txt_1_3em tooltip_toolbar_wohtml"></i></a></div>';
                    } catch (er){
                        console.log('iaHtmlFormatterPlantilla', er);
                        return cellvalue;
                    }
                }
            }

            function iaAttrDescPlantilla(rowId, cellValue, rowObject, cm, rdata)
            {
                let plantilla_id = rowObject.plantilla_withdrawals_de_banco_id || rowObject[getColNum(gridhandler, 'plantilla_withdrawals_de_banco_id')]||'';
                if (empty(plantilla_id))
                    return;

                let plantilla = jsonPlantillas[plantilla_id] || null;
                if (plantilla == null)
                    return;

                return `style="background:#\${plantilla.bkgcolor}; color: #\${plantilla.color}"`;
            }

            function iaBancoCuentaAplica(cellvalue, options, rowObject)
            {
                if (!empty(cellvalue)) {
                    console.log(cellvalue);
                    let no_aplica = cellvalue.split(",");
                    cellvalue = [];
                    $.each(banco_cuentas, function (banco_cuenta_id, nombre) {
                        if (!no_aplica.includes(banco_cuenta_id))
                            cellvalue.push(banco_cuentas[banco_cuenta_id]||'(NOT FOUND)');
                    });
                    cellvalue = "<li>"+cellvalue.join("<li>");
                }
                else {
                    cellvalue = "<li>Todas las cuentas Bancarias";
                }
                return "<div style='height: 200px; overflow-y: auto;'>"+cellvalue+"</div>";
            }
        </script>
        HTML;
        return true;
    }
    /**
     * app_banco_diccionario_dato::listme_post()
     *
     * @param mixed $grid
     * @return void
     */
    //function listme_postRender($grid) { parent::listme_postRender($grid); }

//////////////////////////////////
// QBE FORM override functions
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::qbe_forma()
     *
     * @return @void
     */
    // public function qbe_forma() {}

//////////////////////////////////
// QBE doWHere override functions
/////////////////////////////////

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////
    /**
     * app_banco_diccionario_dato::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'banco_diccionario_dato_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'uuid',
    'display_group_break' => false,
  ),
  'nombre' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
  ),
  'categoria_gasto_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
  ),
  'banco_mov_tipo_id' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'banco_mov_tipo',
    'formato' => 'link_one_select',
  ),
  'palabra_clave' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '1000',
    'modo' => 'R/W',
  ),
  'descripcion_a_poner' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '1000',
    'modo' => 'R/W',
  ),
  'agregar_palabra_clave' => 
  array (
    'title' => '',
    'display_group' => 'agregar',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'es' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Retiro',
  ),
  'accion_extra' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'Default' => 'Nada',
  ),
  'activo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Si',
  ),
  'withdrawal_autorizado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'link_vale' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'ND',
  ),
  'alta_db' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'alta_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'ultimo_cambio' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/O',
  ),
  'ultimo_cambio_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'orden' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint',
    'modo' => 'Nada',
  ),
  'vale' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Active',
  ),
  'banco_cuenta_no_aplica' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => false,
    'required' => true,
    'Type' => 'mediumtext',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'plantilla_withdrawals_de_banco_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'agregar_titulo' => 
  array (
    'title' => '',
    'display_group' => 'agregar',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'titulo_para_agregar' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'monto_minimo' => 
  array (
    'title' => '',
    'display_group' => 'monto',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'monto_maximo' => 
  array (
    'title' => '',
    'display_group' => 'monto',
    'Null' => false,
    'required' => true,
    'Type' => 'decimal',
    'enteros' => '16',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-9999999999999999.99',
    'max' => '9999999999999999.99',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'banco_cuenta_si_aplica' => 
  array (
    'title' => '',
    'display_group' => 'banco',
    'Null' => true,
    'required' => false,
    'Type' => 'mediumtext',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

}
?>