<?php
/* 
   	CAMPOS_EN_DB_START
		primary key: 'banco_gasto_diccionario_dato_id' al 2026-01-13 16:39
		titulo,subtitulo,palabra_clave,beneficiario,buscar_repetidos,link_vale,activo,resalta_subtitulo,resalta_palabras,resalta_palabras_tipo,background_color,text_color,color_resaltar,plantilla_withdrawals_de_banco_id,descripcion_a_poner,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_gasto_diccionario_dato_id
	CAMPOS_EN_DB_END
*/
/* 
   	DELETE_RULES_START

	Usa tablas:
		banco:
			Deletes me: SI. I restrict delete: NO. link_one_select/catalog. Links by plantilla_withdrawals_de_banco_id
	DELETE_RULES_END
*/
class app_banco_gasto_diccionario_dato extends iacase_base {
    
    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate; 
        if( empty($table) )
            $table='banco_gasto_diccionario_dato';    
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();
        
        // para tomar default de iacasebase
        $this->modo='cardex_window';      // cardex misma ventana, cardex_window cardex in new window, jqgrid_iacform forma de iacase, jqgrid_form forma de jqgrid, jqgrid_inline (inline falta)
        
    //$this->asChild=false;      // en true esta instancia es child table
    //$this->childTables=array();  // childTables storage
    //$this->childTablesUse=array(); // solo considera estos child tables
    //$this->saveChilds=true;    // en false no hace child tables en el save
    //$this->editChilds=true;    // en false no saca tablita add another editar childs
    //$this->editChildsSetRO=false; // forza a todos los childs a ser R/O!
    //$this->viewChilds=true;    // en false no muestra childs
    //$this->childHide=array(); // array('childTableToHide');
    //$this->child_jqGrid_height=300;
    //$this->child_jqGrid_width="'50%'";
    //$this->child_jqGrid_cols=array();
    //$this->child_jqGrid_hiddenCols=array();
    //$this->child_jqGridSaveState=true; // guarda grid state
    //$this->child_jqGrid_option=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
    //$this->jqChildGridActions=array(); //actions cuando es child
    //$this->formTypeChildsPerRow=2;   
    //$this->asChild_update=true; // usandose como child es and permsio_update
    //$this->asChild_delete=true; // usandose como child es and permsio_update    
        
        $editar=usuarioTipoRony();
        $consultar=$editar;
        $this->permiso_app=$editar;
        $this->permiso_delete=$editar;
        $this->permiso_export=$consultar;
        $this->permiso_insert=$editar;
        $this->permiso_list=$consultar;
        $this->permiso_read=$consultar;
        $this->permiso_update=$editar;
        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica
        //$this->log_cardex_view=false; // ture log each iah=r pageview

        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        
        //$this->useJqueryValidate=false;
        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;

        //$this->input_max_size=40;          // en cardex
        //$this->input_max_size_child=30;    // en child        
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->jqGridSendOnly=array(); // mandar unicamente estas columnas
        //$this->colModel_overRide=array(); // override generated colModel
        //$this->cols_list='*';
        //$this->jqGrid_options=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
        
        //$this->list_sortname_dflt='';
        //$this->list_sortorder_dflt='';
        //$this->col_list_noShow=array();    // estas ni llegan al jqgrid        
        //$this->jqGridHiddenCols=array(); // estas llegan al grid pero quedan hidden
        
        //$this->extraParams=array();    // parametros extra en links
                       
        
    }
    
//////////////////////////////////
// PERMISOS
/////////////////////////////////
    /**
     * app_banco_gasto_diccionario_dato::permiso_por_record
     * Redefine permisos habiendo leido el record de la base de datos en $this->enDB
     *
     */
    //function permiso_por_record() { }
    /**
     * app_banco_gasto_diccionario_dato::may_add()
     * Permiso para ver la forma de dar alta, conviene mas usar las variables $this->permiso_*
     * @return  boolean TRUE puede, false no puede
     */
    //function may_add() { return $this->permiso_insert; }
    /**
     * app_banco_gasto_diccionario_dato::may_insert()
     * Permiso para dar altas, insert, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_insert() { return $this->may_add(); }
    /**
     * app_banco_gasto_diccionario_dato::may_edit()
     * Permiso para ver la forma de editar, conviene mas usar las variables $this->permiso_*
     * @return boolean
     */
    //function may_edit() { return $this->permiso_update; }
    /**
     * app_banco_gasto_diccionario_dato::may_update()
     * Permiso para hacer el update, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_update() { return $this->may_edit() && ($this->asChild ? $this->asChild_update : true); }
    /**
     * app_banco_gasto_diccionario_dato::may_delete()
     * Parmiso para borrar, se usa en confirmar y en borrar., conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_delete() { return $this->permiso_delete && ($this->asChild ? $this->asChild_delete : true); }
    /**
     * app_banco_gasto_diccionario_dato::may_read()
     * Permiso para ver el record, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_read() { return $this->permiso_read; }
    /**
     * app_banco_gasto_diccionario_dato::may_list()
     * Permiso para listar los records, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_list() { return $this->permiso_list; }
    /**
     * app_banco_gasto_diccionario_dato::may_export()
     * Permiso para exportar, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_export() { return $this->permiso_export; }
    /**
     * app_banco_gasto_diccionario_dato::may_print()
     * Permiso para imprimir, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_print() { return $this->may_export(); }
    /**
     * app_banco_gasto_diccionario_dato::may_viewLog()
     * Permiso para ver el log, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_viewLog() { return $this->permiso_export; }  
    
//////////////////////////////////
// Etiquetas o labels
/////////////////////////////////
    /**
     * app_banco_gasto_diccionario_dato::label_record()
     * Nombre corto del registro
     * @return string el nombre corto del registro
     */
    //function label_record() { }
    
    /**
     * app_banco_gasto_diccionario_dato:label_record_summary()
     * Resumen de registro
     * @return string el resumen del registro
     */
    //function label_record_summary() { }

    /**
     * app_banco_gasto_diccionario_dato::label_add()
     * Etiqueta para agregar un registro
     * @return string la etiqueta para agregar un registro si existe $this->table_info['label_add'], del contrario la arma
     */
   //public function label_add() {    }
    /**
     * app_banco_gasto_diccionario_dato::label_list()
     * Etiqueta para el listado
     * @return string la etiqueta del listado, si existe $this->table_info['label_list'] del contrario  $this->label_table_plural()
     */
    //public function label_list() { }
    /**
     * app_banco_gasto_diccionario_dato::label_table_singular()
     * Etiqueta para la tabla o tipos de registro en singular
     * @return string el label de la tabla en singular
     */
    //public function label_table_singular() { return $this->label; }
    /**
     * app_banco_gasto_diccionario_dato::label_table_plural()
     * Etiqueta para la tabla o tipos de registro en plural
     * @return string el label de la tabla en plural
     * @return
     */
    //public function label_table_plural() { }

      
//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_banco_gasto_diccionario_dato::campos_final
     * Redefine $campos del default en campos_default 
     *
     */
    public function campos_final() {
        // pkfields=array( 'banco_gasto_diccionario_dato_id' );
        /*	CAMPOS_START
				primary key: 'banco_gasto_diccionario_dato_id' al 2026-01-13 16:39
				titulo,subtitulo,palabra_clave,beneficiario,buscar_repetidos,link_vale,activo,resalta_subtitulo,resalta_palabras,resalta_palabras_tipo,background_color,text_color,color_resaltar,plantilla_withdrawals_de_banco_id,descripcion_a_poner,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,banco_gasto_diccionario_dato_id
			CAMPOS_END 
        */
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'display_group','string' ); // a fieldnameN cambiales 'max' a 1e6 
        //$this->campos['fieldName']['br']=true;
        /* comunes atributes son 
            required,max,min,display_group,display_group_label, hidden_value pone hidden en modo R/O
            label_br: normalmente es label<br />input si existe pone label $x[label_br] input 
            br pasa al siguiente renlgon
        */

        $this->campos['palabra_clave']['Type']='longtext';
        $this->campos['beneficiario']['Type']='longtext';
        $this->campos['subtitulo']['Type']='longtext';

        $this->campos['palabra_clave']['label']=' ';
        $this->campos['beneficiario']['label']='Beneficiarios (separados por coma)';
        $this->campos['subtitulo']['label']='Subtítulos (separados por coma)';

        $this->campos['link_vale']['required']=false;
        $this->campos['beneficiario']['required']=false;
        $this->campos['palabra_clave']['required']=false;
        $this->campos['subtitulo']['required']=false;

        $this->campos['buscar_repetidos']['modo'] = 'Nada';

        $this->campos['color_resaltar'] = [
            'title' => '',
            'display_group' => 'resalta',
            'Null' => false,
            'required' => false,
            'Type' => 'varchar',
            'maxlength' => '30',
            'modo' => 'R/W',
        ];

        $this->campos['plantilla_withdrawals_de_banco_id'] = [
            'title' => '',
            'display_group' => 'Plantilla',
            'display_group_label' => 'Plantilla',
            'Null' => true,
            'required' => false,
            'Type' => 'varchar',
            'maxlength' => '32',
            'modo' => 'R/W',
            'link_table' => 'plantilla_withdrawals_de_banco',
            'formato' => 'link_one_select',
            'display_group_break' => false,
        ];



        $this->campos_set_attribute( array('activo','titulo','resalta_palabras', 'color_resaltar', 'link_vale','resalta_subtitulo'),'display_group_label','Principal' );
        $this->campos_set_attribute( array('activo','titulo','resalta_palabras', 'color_resaltar', 'link_vale','resalta_subtitulo'),'display_group','Principal' );

        $this->campos_set_attribute( array('palabra_clave'),'display_group_label','Palabras clave (separadas por coma)' );
        $this->campos_set_attribute( array('palabra_clave'),'display_group','Palabras clave (separadas por coma)' );

        $this->campos_set_attribute( array('subtitulo', 'beneficiario'),'display_group_label',' ' );
        $this->campos_set_attribute( array('subtitulo', 'beneficiario'),'display_group',' ' );


        $orden=array(
            'titulo','subtitulo','palabra_clave','beneficiario','buscar_repetidos','link_vale','activo','alta_db','alta_por'
			,'ultimo_cambio','ultimo_cambio_por'                
        );
        $this->campos_reorder($orden);
        
        
    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_banco_gasto_diccionario_dato::insert_pre_validate()
     * 
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * app_banco_gasto_diccionario_dato::insert_validate()
     * 
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * app_banco_gasto_diccionario_dato::insert_pre_save()
     * 
     * @return
     */
     function insert_pre_save()  { 
        $this->values['descripcion_a_poner'] = trimandAddNewLineandBR(param('descripcion_a_poner'));
        $this->values['descripcion_a_poner'] = html_entity_decode($this->values['descripcion_a_poner']);
        return true; 
    }

    /**
     * app_banco_gasto_diccionario_dato::insert_extra_values()
     * permite agregar valores al insert sql statement o modificar el array del que hacer el insert
     * @param string $insArray  agregar insert clause, terminar con coma ie: $ins.=",campo1"
     * @param string $log   agregar o cambiar el log
     * @return boolean TRUE continua con el isnert, FALSE cancela el insert en este caso avisar en $this->msg_err.="<li>explica..."
    */
    //function insert_extra_values(&$insArray,&$log) { return true; }
         
    /**
     * app_banco_gasto_diccionario_dato::insert_add_sql_queries()
     * permite agregar queries al transaction del insert
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    //function insert_add_sql_queries(&$sql,&$log) { return true;}
    
    /**
     * app_banco_gasto_diccionario_dato::insert_post_save()
     * 
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_banco_gasto_diccionario_dato::update_pre_validate()
     * 
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * app_banco_gasto_diccionario_dato::update_validate()
     * 
     * @return
     */
    //function update_validate()  { return $this->validate(); }
    /**
     * app_banco_gasto_diccionario_dato::update_pre_save()
     * 
     * @return
     */
    function update_pre_save()  {
        $this->values['descripcion_a_poner'] = trimandAddNewLineandBR(param('descripcion_a_poner'));
        $this->values['descripcion_a_poner'] = html_entity_decode($this->values['descripcion_a_poner']);
        return true;
    }

    /**
     * app_banco_gasto_diccionario_dato::update_extra_sql()
     * permite agregar valores al update sql
     * @param string $updArray  array de valores 
     * @param string $log  agregar <li> al log ie: $log.="<li>..."
     * @return boolean TRUE continua con el update FALSE no hace el update poner mensaje en $this->msg_err.="<li>..."
    */
    //function update_extra_sql(&$updArray,&$log) { return true; }
        
    /**
     * app_banco_gasto_diccionario_dato::update_add_sql_queries()
     * permite agregar queries al transaction del update
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    function update_add_sql_queries(&$sql,&$log) { return true;}
        
    /**
     * app_banco_gasto_diccionario_dato::update_post_save()
     * 
     * @return
     */
    //function update_post_save()   {return true;}  

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
///////////////////////////////// 
    //function delete_pre_validate($h) { return true; }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    //function delete_post_delete($h) {  }
    /**
     * app_banco_gasto_diccionario_dato::delete_sql()
     *
     * @param string $record record values to delete, normalmente $this->values
     * @param array $sql array de sql commands al que agregar queries
     * @return void
     */
    //function delete_sql_extra($record,&$sql) {  }
    
//////////////////////////////////
// FORM override functions
///////////////////////////////// 
    /**
     * app_banco_gasto_diccionario_dato::forma_pre()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_pre(&$h,&$nexth) {


        $orden=array(
            'titulo','activo','resalta_palabras', 'color_resaltar', 'link_vale','palabra_clave','subtitulo','beneficiario'
        );
        $this->campos_reorder($orden);

        return true;
    }
    /**
     * app_banco_gasto_diccionario_dato::forma_preFields()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * app_banco_gasto_diccionario_dato::forma_postFields()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * app_banco_gasto_diccionario_dato::forma_doChilds()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_doChilds(&$h,&$nexth) { return true; }  
    /**
     * app_banco_gasto_diccionario_dato::forma_post()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    //public function forma_post(&$h,&$nexth) { return true; }
    /**
     * app_banco_gasto_diccionario_dato::forma_postDiv()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    public function forma_postDiv($h,$nexth) {
        global $verJS;
        echo <<<HTML
        <!-- PLANTILLAS DE WITHDRAWALS -->
        <script charset="UTF-8" src="../js2/plantillas_withdrawal.js?$verJS" defer="defer"></script>
        <script>
            activa_resalta_palabras = function(){
                let me = $('#resalta_palabras');
                if(me.val() == 'Si'){
                    $('#div_link_vale, #div_resalta_subtitulo, #div_subtitulo, #div_beneficiario').hide();
                    $('#div_color_resaltar').show();
                    $('#color_resaltar').attr('required', true);
                    $('#color_resaltar').attr('data-validation-engine', 'validate[required]');
                }
                else{
                    $('#div_link_vale, #div_resalta_subtitulo, #div_subtitulo, #div_beneficiario').show();
                    $('#div_color_resaltar').hide();
                    $('#color_resaltar').removeAttr('required');
                    $('#color_resaltar').removeAttr('data-validation-engine');
                }
                $('#$this->formId').validationEngine();
            };
            
            $(document).ready(function(){
                $('#resalta_palabras').on('change', activa_resalta_palabras);
                
                activa_resalta_palabras();        
                initThisColorPicker('#color_resaltar', true, false);
                $('#$this->formId').validationEngine();


                $('#Plantilla').append(`<div id="div_descripcion_a_poner" class="dved " style="float:left;"><textarea name="descripcion_a_poner" id="descripcion_a_poner" cols="30" rows="10" disabled readonly style="display:none"></textarea></div>`);
                plantilla.init();


            }); 
            
            function iacase_submit()
            {
                return $('#$this->formId').validationEngine('validate');
            }

            const plantilla = {
                plantilla_id: '',
                init: function () {
                    const self = this;
                    this.plantilla_id = $('#plantilla_withdrawals_de_banco_id').val();

                    $('label[for=plantilla_withdrawals_de_banco_id]').after(`<sup style='margin-left:10px'><a id='link_to_plantillas' href='#df' target='_blank'><i class='fa-icon txt_shadow_blue fa-duotone fa-solid fa-link'></i></a></sup>`);
                    this.prepara_link();

                    $('#plantilla_withdrawals_de_banco_id').change(function () {
                        self.prepara_link();
                        self.prepara_descripcion();
                    });

                    // preparamos las pantillas
                    plantillas.getPlantillasHtml((response) => {
                        plantillas.plantillas = response.plantillas_json;
                        if (!empty(plantilla.plantilla_id))
                            plantilla.prepara_descripcion();
                    });
                },
                prepara_link: function () {
                    let params_to_plantillas = {};
                    let plantilla_id = $('#plantilla_withdrawals_de_banco_id').val();
                    this.plantilla_id = plantilla_id;
                    if (!empty(plantilla_id)) {
                        params_to_plantillas.id = plantilla_id;
                        params_to_plantillas.iah = 'e';
                    }
                    $('#link_to_plantillas').attr('href', prepareUrl(getUrlBase('backoffice/plantilla_withdrawals_de_banco.php'), params_to_plantillas));
                },
                
                prepara_descripcion: function () {
                    var div_content_descripcion = $('#div_descripcion_a_poner');
                    $('#plantilla_descripcion').remove();
                    if (empty(this.plantilla_id)) {
                        vx_asyncFunction(function () {
                            $('.tox.tox-tinymce', div_content_descripcion).show();
                            // setTimeout(function () {
                            //     tinymce.get('descripcion_a_poner').setContent('');
                            // }, 10);
                        }, 100);
                    }
                    else {
                        let div_descripcion = $('<div id="plantilla_descripcion">');
                        div_descripcion.html('La descripción se tomará con base a la plantilla seleccionada');
                        let form_plantilla = $('<div>').html(plantillas.get_html_form_template(this.plantilla_id, {}));
                        form_plantilla.hide();
                        div_descripcion.append(form_plantilla);
                        div_content_descripcion.append(div_descripcion);
                        vx_asyncFunction(function () {
                            $('.tox.tox-tinymce', div_content_descripcion).hide();
                            var preview_plantilla = plantillas.get_remarks_from_template(plantilla.plantilla_id, false);
                            div_descripcion.append('<div style="font-weight: normal;" class="form-build">'+preview_plantilla+'</div>');
                            $('#descripcion_a_poner').val(preview_plantilla);
                            /* setTimeout(function () {
                                tinymce.get('descripcion_a_poner').setContent(preview_plantilla);
                            }, 100); */
                        }, 100);
                    }

                }

            };

        </script>
        HTML;
    }

    function show($fieldName,$value=null,$editAtributes=array(),$displayAtributes=array(),&$modo=null)
    {
        if ($this->h == 'r')
            return parent::show($fieldName, $value, $editAtributes, $displayAtributes, $modo);

        switch($fieldName)
        {
            case 'color_resaltar':
                return $this->inputColorResaltar($fieldName);
                break;
            default:
                return parent::show($fieldName, $value, $editAtributes, $displayAtributes, $modo);
                break;
        }
    }


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
///////////////////////////////// 
    /**
     * app_banco_gasto_diccionario_dato::listme_pre()
     * 
     * @param mixed $grid
     * @return
     */
    //function listme_pre($grid) { return true; }
    /**
     * app_banco_gasto_diccionario_dato::listme_preRender()
     * 
     * @param mixed $grid
     * @return
     */
    //function listme_preRender($grid) { return true; }
    /**
     * app_banco_gasto_diccionario_dato::listme_post()
     * 
     * @param mixed $grid
     * @return void
     */
    //function listme_postRender($grid) { parent::listme_postRender($grid); }
    
//////////////////////////////////
// QBE FORM override functions
///////////////////////////////// 
    /**
     * app_banco_gasto_diccionario_dato::qbe_forma()
     *
     * @return @void
     */
    // public function qbe_forma() {}
    
//////////////////////////////////
// QBE doWHere override functions
///////////////////////////////// 

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////    
    /**
     * app_banco_gasto_diccionario_dato::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'banco_gasto_diccionario_dato_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'uuid',
  ),
  'titulo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'subtitulo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '200',
    'modo' => 'R/W',
  ),
  'palabra_clave' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '1000',
    'modo' => 'R/W',
  ),
  'beneficiario' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '1000',
    'modo' => 'R/W',
  ),
  'buscar_repetidos' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'activo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Si',
  ),
  'link_vale' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '20',
    'modo' => 'R/W',
  ),
  'alta_db' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'alta_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'ultimo_cambio' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/O',
  ),
  'ultimo_cambio_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'resalta_subtitulo' => 
  array (
    'title' => '',
    'display_group' => 'resalta',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'resalta_palabras' => 
  array (
    'title' => '',
    'display_group' => 'resalta',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'resalta_palabras_tipo' => 
  array (
    'title' => 'frase, palabra',
    'display_group' => 'resalta',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'background_color' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '10',
    'modo' => 'R/W',
  ),
  'text_color' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '10',
    'modo' => 'R/W',
  ),
  'color_resaltar' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '30',
    'modo' => 'R/W',
  ),
  'plantilla_withdrawals_de_banco_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'link_table' => 'banco',
    'formato' => 'link_one_select',
  ),
  'descripcion_a_poner' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

    private function inputColorResaltar($fieldName): string {
        // $styles = [];
        // if ($this->values['resalta_palabras'] == 'No') {
        //     $styles[]="display:none;";
        // }
        //
        // $style = implode("; ", $styles);
        $set_value = $this->values['color_resaltar']??'';
        return <<<HTML
        <input type="text" name="$fieldName" id="$fieldName" style="width: 100%" value="$set_value" autocomplete="off">
        HTML;
    }
    
}
?>