<?php
    // v0.0
    /*
       	CAMPOS_EN_DB_START
		primary key: 'empresa_id' al 2026-01-13 16:39
		empresa,razon_social,orden,remarks,vale,representante_legal,firma_representante_legal,telefono,email,ultimo_cambio,empresa_id
	CAMPOS_EN_DB_END
    */
    /*
       	DELETE_RULES_START

	Dependen de empresa:
		banco_cuenta:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by empresa_id
		banco_cuenta_mov:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by empresa_id
		banco_cuenta_mov:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by bc_empresa_id
		banco_cuenta_mov_con_links:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by empresa_id
		banco_cuenta_trans:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by empresa_id
	DELETE_RULES_END
    */

class app_empresa extends iacase_base {

    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate;
        if( empty($table) )
            $table='empresa';
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();

        $this->modo='cardex_window';     // cardex, cardex_window, jqgrid_form forma de jqgrid, jqgrid_iacform forma de iacase, jqgrid_inline (inline falta)

        //$this->asChild=false;      // en true esta instancia es child table
        //$this->childTables=array();  // childTables to use
        //$this->saveChilds=true;    // en false no hace child tables en el save
        //$this->editChilds=true;    // en false no saca tablita add another editar childs
        //$this->viewChilds=true;    // en false no muestra childs
        $this->editChildsSetRO=true;

        //$this->permiso_app=true;
        $this->permiso_delete=false;
        $this->permiso_export=false;
        //$this->permiso_insert=true;
        //$this->permiso_list=true;
        //$this->permiso_read=true;
        //$this->permiso_update=true;


        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        //$this->cols_list='*';
        /* ojo trae campos del momento de creacion
            empresa_id,empresa,orden,remarks
        */
        $this->list_sortname_dflt='empresa';
        //$this->list_sortorder_dflt='';
        //$this->col_list_noShow=array();    // estas ni llegan al jqgrid
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->useJqueryValidate=false;

        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;
        //$this->formTypeChildsPerRow=2;

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->colModel_overRide=array(); // override generated colModel
        //$this->jqGridHiddenCols=array('cp_cliente_direccion_id_real');

        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica


        //$this->extraParams=array();    // parametros extra en links

        //$this->log_cardex_view=false; // ture log each iah=r pageview
    }




//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_empresa::campos_final
     * Redefine $campos del default en campos_default
     *
     */
    private function campos_final() {
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'max',1e6 ); // a fieldnameN cambiales 'max' a 1e6
        // comunes atributes son br,required,max,min,display_group,display_group_label
        /*
        // ojo trae campos del momento de creacion
        // pkfields=array( 'empresa_id' );
        $orden=array(
            'empresa','orden','remarks'

        );

        $this->campos_reorder($orden);
        //$this->campos['fieldName']['br']=true;
        */
        $this->campos['remarks']['formato']='';

        $iah = param('iah');


        $this->campos['razon_social'] = [
          'title' => '',
          'display_group' => '',
          'Null' => false,
          'required' => true,
          'Type' => 'varchar',
          'maxlength' => '255',
          'modo' => 'R/W',
        ];


        $orden=array(
            'empresa','vale','remarks','orden'
        );
        $this->campos_reorder($orden);

    }

    public function toolbar_set($h=null,$imgPath=null,$extraParams=array(),$label_plural='' )
    {
        parent::toolbar_set($h,$imgPath,$extraParams,$label_plural);

        $this->toolbar['close']['condition'] = "return (\$h=='e' || \$h=='a'|| \$h=='r');";
        $this->toolbar['close']['html'] = "<a href='../backoffice/empresa.php' id='iaCloseItem' class='txt_1_1em tooltip_toolbar bold' title='<div class=\"ui_tooltip_grid_nota_bodega_consultar_nota bold\">Ver Empresas</div>'><i class='fa-icon fa-solid fa-database txt_1_8em bg-secondary text-white' style='padding: 0.2em; border-radius: 5px'></i><br/>Empresas <strong>(F4)</strong></a>";
    }

    //////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::insert_pre_validate()
     *
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * iacase::insert_validate()
     *
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * iacase::insert_pre_save()
     *
     * @return
     */
    //function insert_pre_save()  { return true; }
    /**
     * iacase::insert_post_save()
     *
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::update_pre_validate()
     *
     * @return
     */
    //function update_pre_validate() { return true; }
    /**
     * iacase::update_validate()
     *
     * @return
     */
    function update_validate()
    {
        $ok = true;

        if($this->values['vale'] == 'Inactive')
        {
            $cuentasCuentas = ia_singleread("SELECT COUNT(*) FROM banco_cuenta WHERE empresa_id = '$this->id' AND vale='Active'");
            if($cuentasCuentas)
            {
                $this->msg_err = "<li>Esta empresa tiene <strong>$cuentasCuentas cuentas bancarias activas</strong>.";
                $ok = false;
            }
        }

        return $ok && $this->validate();
    }
    /**
     * iacase::update_pre_save()
     *
     * @return
     */
    //function update_pre_save()  { return true; }
    /**
     * iacase::update_post_save()
     *
     * @return
     */
    function update_post_save()
    {
        @async_ws_generaCatalogos();
        return true;
    }

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
/////////////////////////////////
    function delete_pre_validate($h)
    {
        $ok = true;

        $cuentasCuentas = ia_singleread("SELECT COUNT(*) FROM banco_cuenta WHERE empresa_id = '$this->id' AND vale='Active'");
        if($cuentasCuentas)
        {
            $this->msg_err = "<li>Esta empresa tiene <strong>$cuentasCuentas cuentas bancarias activas</strong>.";
            $ok = false;
        }
        return $ok;
    }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    function delete_post_delete($h)
    {
        @async_ws_generaCatalogos('QWERTY');
    }

//////////////////////////////////
// FORM override functions
/////////////////////////////////
    /**
     * iacase::forma_pre()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_pre(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_preFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_postFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_doChilds()
     *
     * @param mixed $h
     * @param mixed $nexth;
     * @return
     */
    public function forma_doChilds(&$h,&$nexth) {
        if ($this->h == 'e' || $this->h == 'r')
            echo EmpresaTiene::queTieneDisplay($this->id);
        return true;
    }
    /**
     * iacase::forma_post()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    public function forma_post(&$h,&$nexth,$ok=true) { return true; }
    /**
     * iacase::forma_postDiv()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    public function forma_postDiv($h,$nexth) {
        if($this->modo == 'jqgrid_iacform')
        {
            echo <<<RESIZEJQFORM
<script>
$(function() {
    if(actaDialogVar.length)
    {
        $(actaDialogVar).dialog('option','height',$('#iafrm_empresa',actaDialogVar).height() + 200);
        $(actaDialogVar).dialog('option','width', 600);
    }
});
</script>
RESIZEJQFORM;
        }
    }



//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
/////////////////////////////////
    /**
     * iacase::listme_pre()
     *
     * @param mixed $grid
     * @return
     */
    function listme_pre($grid) { return true; }
    /**
     * iacase::listme_preRender()
     *
     * @param mixed $grid
     * @return
     */
    function listme_preRender($grid) { return true; }
    /**
     * iacase::listme_post()
     *
     * @param mixed $grid
     * @return void
     */
    function listme_postRender($grid) {
        echo <<<JS
<script>
$(document).ready(function(){
    vx_asyncFunction(function() {
$('#gs_vale').val('Active');
gridhandler[0].triggerToolbar();
}, 300);
});
</script>
JS;
        parent::listme_postRender($grid);
    }

//////////////////////////////////
// QBE FORM override functions
/////////////////////////////////

//////////////////////////////////
// QBE doWHere override functions
/////////////////////////////////

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////
    /**
     * app_empresa::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'empresa_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'auto_increment',
  ),
  'empresa' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
    'UNI' => true,
  ),
  'razon_social' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
  ),
  'orden' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'Nada',
    'Default' => '1000',
  ),
  'remarks' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
    'formato' => 'fckeditor',
  ),
  'vale' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Active',
  ),

  'representante_legal' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'firma_representante_legal' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'telefono' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'email' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
    'formato' => 'email',
  ),
  'ultimo_cambio' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

}
?>