<?php
    // v0.0
    /*
       	CAMPOS_EN_DB_START
		primary key: 'iac_usr_id' al 2026-01-13 16:39
		nick,celular,nombre,email,pwd,vale,tipo,plantilla_id,plantillatienda_id,puede_deuda,puede_gasto,cuentat_propia,ultimo_login,logins,remarks,anexos,cuentat_preferida_id,cuentat_unica,puede_clientes,puede_gasto_ctat,puede_banco_china,poner_delivered_cheques,poner_delivered_pagares,puede_ingreso_directo_a_cuentat,puede_modificar_reportes_grid,usuario_tipo_rony,puede_link_tc,puede_fiduciario,puede_facturas,orden,puede_depositar_en,puede_inversion,puede_reembolso_inversion,puede_revisar_gastos_cuentaT,puede_revisar_movimientos_banco,puede_ser_supervisor_banco,puede_ser_supervisor,ultimo_cambio_password,forza_cambio_password,puede_cheque_dd,activa_alerta_gastos,puede_compra,puede_supervisar_bodega,puede_ser_encargado_bodega,puede_solo_consultar_bodegas,puede_registrar_todas_bodegas,puede_solicitar_traslado_efectivo,puede_ver_modulo_solicitar_traslado_efectivo,puede_ver_traslados_match,puede_ver_traslados,puede_bodega_destinos_especiales,puede_ver_acuentas,puede_ver_doctos,puede_ver_deliveries,puede_consultar_existencia,puede_autorizar_notas_ultimo_movimiento,puede_hacer_reset_producto_color,puede_hacer_reset_inconsistencias,notificar_nuevas_cartas_porte,puede_editar_campos_cash_nota_bodega,puede_hacer_ajuste_producto_color,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,iac_usr_id
	CAMPOS_EN_DB_END
    */
    /*
       	DELETE_RULES_START

	Dependen de iac_usr:
		cuentat:
			Restricts delete me: si. Is deleted with me: no.link_one_select/catalog_entry. Links by usuario_id
		iac_field_permission:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by iac_usr_id
		iac_table_permission:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by iac_usr_id
		jqgridcolssorter:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by iac_usr_id
		login_log:
			Restricts delete me: si. Is deleted with me: no.link_one_select/catalog_entry. Links by usuario_id
	Usa tablas:
		cuentat:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by cuentat_preferida_id
	DELETE_RULES_END
    */

use Iac\inc\sql\IacSqlBuilder;

class app_iac_usr extends iacase_base {

    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate;
        if( empty($table) )
            $table='iac_usr';
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();
        $this->label='Usuarios internos';

        $this->modo='cardex_window';     // cardex, jqgrid_form forma de jqgrid, jqgrid_iacform forma de iacase, jqgrid_inline (inline falta)
       // $this->modo='cardex';

        //$this->asChild=false;      // en true esta instancia es child table
        //$this->childTables=array();  // childTables to use
        //$this->saveChilds=true;    // en false no hace child tables en el save
        $this->editChilds=true;    // en false no saca tablita add another editar childs
        $this->viewChilds=true;    // en false no muestra childs
        $this->child_jqGridSaveState=true;
        $this->child_jqGrid_cols=array( 'iac_usr_id','nick','nombre','usuario_tipo_rony','cuentat_propia');

        $puedeEdit = usuarioTipoRony($_SESSION['usuario_id']) ? true : false;
        $this->permiso_app=$puedeEdit;
        $this->permiso_delete=$puedeEdit;
        $this->permiso_export=$puedeEdit;
        $this->permiso_insert=$puedeEdit;
        $this->permiso_list=$puedeEdit;
        $this->permiso_read=$puedeEdit;
        $this->permiso_update=$puedeEdit;


        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        //$this->cols_list='nick, nombre, email, vale, usuario_tipo_rony, cuenta_propia, ultimo_login, logins, alta_db, alta_por, ultimo_cambio, ultimo_cambio_por';
        /*
            'nick, nombre, email, pwd, vale, tipo, cuenta_propia, ultimo_login, logins, alta_db, alta_por, ultimo_cambio, ultimo_cambio_por'
        */
        $this->list_sortname_dflt='orden';
        //$this->list_sortorder_dflt='';
        $this->col_list_noShow=array('pwd');    // estas ni llegan al jqgrid
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        $this->cols_export='nick, nombre, email, vale, usuario_tipo_rony, cuenta_propia, ultimo_login, logins, alta_db, alta_por, ultimo_cambio, ultimo_cambio_por';
        //$this->cols_search='*';

        //$this->useJqueryValidate=false;

        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;
        $this->formTypeChildsPerRow=2;

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        $this->colModel_overRide=array(
            'nick'=>array('width'=>'110', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/iac_usr_nick.html')),
            'nombre'=>array('width'=>'130', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/iac_usr_nombre.html')),
            'plantillatienda_id'=>array('width'=>'150', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/iac_usr_plantillatienda_id.html')),
            'plantilla_id'=>array('width'=>'150', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/iac_usr_plantilla_id.html')),
            'cuentat_preferida_id'=>array('width'=>'100', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/iac_usr_cuentat_preferida_id.html')),
            'vale' => array(  'width'=>'80', 'searchoptions'=>array('defaultValue'=>'Active')),
            'usuario_tipo_rony' => array( 'width'=>'80'),
            'forza_cambio_password' => array( 'width'=>'80'),
        ); // override generated colModel

        
        $this->min_delete_id=1; // no vale delete id menor a esto null no aplica

        $this->child_label_prefixme = true;
        $this->activeBA = true;
        $this->busqueda_rapida_automatica=true; // activa la busqueda rápida

        // dd_($this);

        //$this->extraParams=array();    // parametros extra en links

        //$this->log_cardex_view=false; // ture log each iah=r pageview
    }

//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_iac_usr::campos_final
     * Redefine $campos del default en campos_default
     *
     */
    private function campos_final() {
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'max',1e6 ); // a fieldnameN cambiales 'max' a 1e6
        // comunes atributes son br,required,max,min,display_group,display_group_label
        /*
        // ojo trae campos del momento de creacion
        // pkfields=array( 'iac_usr_id' );
        $orden=array(
            'nick','nombre','email','pwd','vale','tipo','cuenta_propia'
			,'ultimo_login','logins','alta_db','alta_por','ultimo_cambio','ultimo_cambio_por'

        );




        $this->campos_reorder($orden);
        //$this->campos['fieldName']['br']=true;
        */

        unset(
            $this->campos['puede_supervisar_bodega'],
            $this->campos['puede_ser_encargado_bodega'],
            $this->campos['puede_solo_consultar_bodegas'],
            $this->campos['puede_ver_traslados_match'],
            $this->campos['puede_ver_traslados'],
            $this->campos['puede_bodega_destinos_especiales']
        );

        $this->campos['iac_usr_id']['PK_type']='uuid';
        $this->table_info['pk_single_type']='uuid';
        $this->table_info['pk_single_type_iauid']=true;

        $this->campos['celular'] =
          [
            'label' => 'Celular',
            'title' => 'Número celular a 12 digitos, incluya el 52 ejemplo 52-55-12-34-56',
              'pie' => '52-55-12-34-56-78',
            'display_group' => '',
            'Null' => false,
            'required' => false,
            'Type' => 'varchar',
            'maxlength' => '17',
            'modo' => 'R/W',


          ];
        $this->campos['cuentat_propia_nombre'] =
            array (
            'title' => 'Nombre Cuenta T Propia',
            'label'=>'Nombre Cuenta T Propia',
            'display_group' => '',
            'Null' => false,
            'required' => true,
            'Type' => 'varchar',
            'maxlength' => '16',
            'modo' => 'R/W',
            'virtual_sql'=>"(SELECT usuario FROM cuentat WHERE usuario_id=iac_usr_id)");

        $this->campos['on_hand_mx'] =
            array (
            'title' => 'Saldo PESOS',
            'label'=>'Saldo PESOS',
            'display_group' => '',
            'Null' => false,
            'required' => false,
            'Type' => 'decimal',
            'enteros' => '10',
            'decimales' => '2',
            'numeric' => 1,
            'unsigned' => true,
            'min' => 0,
            'max' => '9999999999.99',
            'modo' => 'R/O',
            'virtual_sql'=>'(SELECT on_hand_mx FROM cuentat WHERE usuario_id=iac_usr_id)',
            'Default' => '0.00');

        $this->campos['transfering_mx'] =
            array (
            'title' => 'Transfer PESOS',
            'label'=>'Transfer PESOS',
            'display_group' => '',
            'Null' => false,
            'required' => false,
            'Type' => 'decimal',
            'enteros' => '10',
            'decimales' => '2',
            'numeric' => 1,
            'unsigned' => true,
            'min' => 0,
            'max' => '9999999999.99',
            'modo' => 'R/O',
            'virtual_sql'=>'(SELECT transfering_mx FROM cuentat WHERE usuario_id=iac_usr_id)',
            'Default' => '0.00');

        $this->campos['on_hand_usd'] =
            array (
            'title' => 'Saldo USD',
            'label'=>'Saldo USD',
            'display_group' => '',
            'Null' => false,
            'required' => false,
            'Type' => 'decimal',
            'enteros' => '10',
            'decimales' => '2',
            'numeric' => 1,
            'unsigned' => true,
            'min' => 0,
            'max' => '9999999999.99',
            'modo' => 'R/O',
            'virtual_sql'=>'(SELECT on_hand_usd FROM cuentat WHERE usuario_id=iac_usr_id)',
            'Default' => '0.00');

        $this->campos['transfering_usd'] =
            array (
            'title' => 'Transfer USD',
            'label'=>'Transfer USD',
            'display_group' => '',
            'Null' => false,
            'required' => false,
            'Type' => 'decimal',
            'enteros' => '10',
            'decimales' => '2',
            'numeric' => 1,
            'unsigned' => true,
            'min' => 0,
            'max' => '9999999999.99',
            'modo' => 'R/O',
            'virtual_sql'=>'(SELECT transfering_usd FROM cuentat WHERE usuario_id=iac_usr_id)',
            'Default' => '0.00');

      $this->campos['ultimo_cambio_password'] = 
          array (
            'title' => 'Último cambio al password',
            'label' => 'Cambio pwd el',
            'display_group' => '',
            'Null' => false,
            'required' => false,
            'Type' => 'timestamp',
            'modo' => 'R/O',
            'Default' => 'CURRENT_TIMESTAMP',
            'formato' => '',);

        $this->campos['forza_cambio_password'] = [
            'title' => 'Forza cambiar pwd',
            'label' => 'Forza cambiar pwd',
            'display_group' => '',
            'Null' => false,
            'required' => true,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => 'No',
        ];

        $this->campos['puede_ver_acuentas'] = [
            'title' => '',
            'label' => 'Puede acceder a A Cuentas',
            'display_group' => 'Permisos Relacionados',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => 'No',
            'display_group_break' => true,
        ];

        $this->campos['puede_ver_doctos'] = [
            'title' => '',
            'label' => 'Puede acceder a Autorización de Documentos',
            'display_group' => 'Permisos Relacionados',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => 'No',
            'display_group_break' => false,
        ];

        $this->campos['puede_ver_deliveries'] = [
            'title' => '',
            'label' => 'Puede acceder a Recibir Delivered',
            'display_group' => 'Permisos Relacionados',
            'Null' => false,
            'required' => false,
            'Type' => 'enum',
            'modo' => 'R/W',
            'Default' => 'No',
            'display_group_break' => false,
        ];
  
        $orden=array(
            'nick','nombre','pwd', 'ultimo_cambio_password','forza_cambio_password','vale','usuario_tipo_rony','plantillatienda_id','plantilla_id','cuentat_preferida_id'
            ,'cuentat_unica','puede_deuda','puede_gasto','puede_gasto_ctat','puede_banco_china','puede_clientes','poner_delivered_cheques','puede_revisar_gastos_cuentaT'
            ,'poner_delivered_pagares','puede_ingreso_directo_a_cuentat','puede_modificar_reportes_grid','puede_link_tc','puede_fiduciario','puede_facturas'
            ,'puede_revisar_gastos_cuentaT','puede_ser_supervisor','puede_revisar_movimientos_banco','puede_ser_supervisor_banco'

        , 'puede_solicitar_traslado_efectivo','puede_ver_modulo_solicitar_traslado_efectivo'
        , 'celular'  ,'email','ultimo_login','logins','alta_db','alta_por','ultimo_cambio','ultimo_cambio_por','cuentat_propia','cuentat_propia_nombre','on_hand_mx','on_hand_usd',
            'transfering_mx','transfering_usd'
        );

      

        $this->campos_reorder($orden);


        //$this->campos_set_attribute('pwd', 'formato', 'html'); //2020-PWD_EXPIRE
        $this->campos_set_attribute( array('nick','nombre','celular','email', 'pwd', 'ultimo_cambio_password','forza_cambio_password'),'display_group','Identificacion' );
        $this->campos_set_attribute( array('nick','nombre','celular', 'email', 'pwd','ultimo_cambio_password','forza_cambio_password'),'display_group_label','Identificacion' );

        $this->campos_set_attribute( array('vale','usuario_tipo_rony','cuentat_preferida_id','cuentat_unica','cuentat_propia','cuentat_propia_nombre','on_hand_mx','on_hand_usd','transfering_mx','transfering_usd'),'display_group','Cuenta T' );
        $this->campos_set_attribute( array('vale','usuario_tipo_rony','cuentat_preferida_id','cuentat_unica','cuentat_propia','cuentat_propia_nombre','on_hand_mx','on_hand_usd','transfering_mx','transfering_usd'),'display_group_label','Cuenta T' );

        $this->campos['cuentat_propia']['display_group_break']=true;

        $this->campos_set_attribute( array('plantilla_id','puede_cheque_dd','plantillatienda_id','puede_gasto','puede_banco_china','puede_clientes','puede_modificar_reportes_grid','puede_link_tc','puede_depositar_en','puede_fiduciario', 'puede_inversion', 'puede_reembolso_inversion'),'display_group','Permisos' );
        $this->campos_set_attribute( array('plantilla_id','puede_cheque_dd','plantillatienda_id','puede_gasto','puede_banco_china','puede_clientes','puede_modificar_reportes_grid','puede_link_tc','puede_depositar_en','puede_fiduciario', 'puede_inversion', 'puede_reembolso_inversion'),'display_group_label','Permisos' );


        $this->campos_set_attribute( array('puede_deuda','puede_gasto_ctat','poner_delivered_cheques','poner_delivered_pagares','puede_ingreso_directo_a_cuentat','puede_compra'),'display_group','Permisos Relacionados' );
        $this->campos_set_attribute( array('puede_deuda','puede_gasto_ctat','poner_delivered_cheques','poner_delivered_pagares','puede_ingreso_directo_a_cuentat','puede_compra'),'display_group_label','Permisos Relacionados' );

        $this->campos_set_attribute( array('puede_revisar_gastos_cuentaT','puede_ser_supervisor'),'display_group','Revisión de Gastos de Cuenta T' );
        $this->campos_set_attribute( array('puede_revisar_gastos_cuentaT','puede_ser_supervisor'),'display_group_label','Revisión de Gastos de Cuenta T' );

        $this->campos_set_attribute( array('puede_revisar_movimientos_banco','puede_ser_supervisor_banco'),'display_group','Revisión de Gastos del Banco' );
        $this->campos_set_attribute( array('puede_revisar_movimientos_banco','puede_ser_supervisor_banco'),'display_group_label','Revisión de Gastos del Banco' );

        $this->campos['puede_revisar_gastos_cuentaT']['label']='Puede revisar Gastos de Cuenta T';
        $this->campos['puede_ser_supervisor']['label']='Puede ser supervisor de Gastos de Cuenta T';
        $this->campos['puede_revisar_movimientos_banco']['label']='Puede revisar Gastos del Banco';
        $this->campos['puede_ser_supervisor_banco']['label']='Puede ser supervisor de Gastos del Banco';



        $this->campos['cuentat_propia']['label']='Cuenta T Propia Activa';
        $this->campos['remarks']['formato']='fckeditor';
        $this->campos['anexos']['accept']= 'jpg,png,gif,jpeg,pdf,doc,docx,xls,xlsx,ppt,pptx,pps,ppsx,txt';

        $this->campos['cuentat_preferida_id']['label']='Cuenta T Preferida';
        $this->campos['cuentat_unica']['label']='Cuenta T Unica';
        $this->campos['cuentat_preferida_id']['link_item'] = $this->id;

        $this->campos['puede_gasto']['label']='Puede Justificar Retiros de Banco';
        $this->campos['puede_gasto_ctat']['label']='Puede Hacer Gastos de Cuenta T (Efectivo)';

        $this->campos['poner_delivered_cheques']['label']='Aparece en Listado Delivered To de Cheques';
        $this->campos['poner_delivered_pagares']['label']='Aparece en Listado Delivered To de Pagares';

        $this->campos['puede_ingreso_directo_a_cuentat']['label']='Puede Hacer Ingresos Directos a Cuenta T';

        //CAMBIAPLANTILLATIENDAS
        $this->campos['plantilla_id']['label']='Plantilla para Bancos';
        $this->campos['plantillatienda_id']['label']='Plantilla para Cheques, Pagarés y Vales';


        $this->campos_push_attribute( array('plantillatienda_id', 'plantilla_id'),'input', 'style', 'width:380px;' );

        $this->campos['vale']['label']='Usuario Activo';

        $this->campos['puede_modificar_reportes_grid']['label']='Puede Modificar Perfiles para Reportes';

        $this->campos['puede_deuda']['label']='Puede Acceder a Deudas';
        $this->campos['puede_banco_china']['label']='Puede Hacer Transferencias a China';
        $this->campos['puede_clientes']['label']='Puede Acceder a Clientes';

        $this->campos_set_attribute( array('nick','email','pwd','cuentat_propia_nombre'), 'data-class', 'dontUpperCase' );
        $this->campos_push_attribute( array('nick','email','pwd','cuentat_propia_nombre'),'input', 'data-class', 'dontUpperCase' );

        $this->campos_set_attribute( array('on_hand_usd','transfering_usd'), 'class', 'txt_color_USD');
        $this->campos_push_attribute( array('on_hand_usd','transfering_usd'), 'input', 'class', 'txt_color_USD');

        $this->campos['tipo']['modo'] = 'Nada';

        $this->campos['poner_delivered_pagares']['modo'] = 'Nada';

        $this->campos['ultimo_login']['label'] = 'Último Login';
        $this->campos['ultimo_cambio']['label'] = 'Último Cambio';
        $this->campos['ultimo_cambio_por']['label'] = 'Último Cambio Por';

        $this->campos['puede_link_tc']['label']='Puede Hacer Link de Tarjetas de Crédito';

        $this->campos['puede_fiduciario']['modo']='R/W';
        $this->campos['puede_facturas']['modo']='Nada';
        $this->campos['puede_deuda']['modo']='Nada';
        $this->campos['puede_banco_china']['modo']='Nada';
        $this->campos['activa_alerta_gastos']['modo']='Nada';

        $this->campos['puede_compra']['label']='Puede Acceder a Compras';
        $this->campos['puede_cheque_dd']['label']='Puede Acceder a Notas';


        $this->campos['puede_depositar_en']['label']='Puede establecer en qué Cuentas Depositar';

        //VCA 18-09-2021 Rony pidió que sólo  pueda poner tipo Rony.
        //if(!usuarioTipoRony($_SESSION['usuario_id']))
        if($_SESSION['usuario_id'] == 1) {
            $this->campos['usuario_tipo_rony']['modo'] = 'R/O';
            $this->campos_set_attribute(array('usuario_tipo_rony'),'readonly','readonly' );
            $this->campos_push_attribute(array('usuario_tipo_rony'),'input', 'readonly', 'readonly' );
        }
        else
            $this->campos['usuario_tipo_rony']['modo'] = 'Nada';
//
//        $this->campos_set_attribute( array('compra_mas_antigua
//
//saldo_compras_usd
//
//saldo_compras_pesos
//
//compras_totales
//
//cuantos_compras_pagados
//
//cuantos_compras
//
//compras_totales_usd
//
//compras_totales_pesos','doc_mas_antiguo','vale_mas_antiguopagare_mas_antiguo','cheque_mas_antiguo','saldo_total_ventas_usd','saldo_total_ventas_peso','vales_totales_usd','vales_totales_pesos','pagares_totales_usd','pagares_totales_pesos','cheques_totales_usd','cheques_totales_pesos','saldo_total_usd','saldo_total_pesos','transfering_usd'), 'class', 'txt_color_USD');


        $this->campos_set_attribute( array('puede_solicitar_traslado_efectivo','puede_ver_modulo_solicitar_traslado_efectivo'),'display_group','Solicitud de traslado de efectivo' );
        $this->campos_set_attribute( array('puede_solicitar_traslado_efectivo','puede_ver_modulo_solicitar_traslado_efectivo'),'display_group_label','Solicitud de traslado de efectivo' );
    }

    function validate() {
        $pwd2 = $_REQUEST['pwd2'] ?? '';
        if(empty($this->values['pwd']) && empty($pwd2))
            return parent::validate();
        $ok = true;
       
        if($this->values['pwd'] !== $pwd2) {
            unset($this->values['pwd']);
            $this->msg_err.="<li>No coinicide el password nuevo";
            $ok = false;
        }
        return $ok & parent::validate();
    }
//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::insert_pre_validate()
     *
     * @return
     */
    function insert_pre_validate()  { return true; }
    /**
     * iacase::insert_validate()
     *
     * @return
     */
    function insert_validate()
    {
        $this->campos['cuentat_propia']['required'] = false;
        $this->campos['cuentat_propia_nombre']['required'] = false;
        $this->campos['cuentat_preferida_id']['required'] = false;
        $this->campos['cuentat_unica']['required'] = false;

        $this->campos['cuentat_propia']['modo'] = 'R/W';
        $this->campos['cuentat_propia_nombre']['modo'] = 'Nada';
        $this->campos['cuentat_preferida_id']['modo'] = 'Nada';
        $this->campos['cuentat_unica']['modo'] = 'Nada';
        $this->campos['on_hand_mx']['modo'] = 'Nada';
        $this->campos['on_hand_usd']['modo'] = 'Nada';
        $this->campos['transfering_mx']['modo'] = 'Nada';
        $this->campos['transfering_usd']['modo'] = 'Nada';

        return $this->validate();
    }
    /**
     * iacase::insert_pre_save()
     *
     * @return
     */
    //function insert_pre_save()  { return true; }

    /**
     * iacase::insert_add_sql_queries()
     * permite agregar queries al transaction del insert
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    function insert_add_sql_queries(&$sql,&$log) {
        //$id="'<_id_>'";
        $id=strit($this->id);

        $sql[] = "UPDATE iac_usr SET pwd = " . strit(Pwd::encripta($this->id . $this->values['pwd'])) . " WHERE iac_usr_id=".strit($this->id);
        
        /*if($this->values['tipo']=='Super user') {
            $cuentaTStatus='Active';
            $tiendaPuede='Editar';
            $puedeMovBancario='R/W';
        } else {
            $cuentaTStatus='Inactive';
            $tiendaPuede='Nada';
            $puedeMovBancario='Nada';
        }*/
        $this->values['cuentat_propia']='Si';
        $cuentaTStatus='Active';
        $nick=ia_singleread("SELECT usuario FROM cuentat WHERE usuario=".strit($this->values['nick']));
        if(empty($nick))
           $nick=$this->values['nick'];
        else
           $nick=$this->values['nick']."_$this->id";

        $sql[]="INSERT INTO cuentat(vale,cuentaT_id,usuario,usuario_id,poner_delivered_cheques,poner_delivered_pagares) value(".stritc($cuentaTStatus)."$id,".stritc($nick).$id.",".strit($this->values['poner_delivered_cheques']).",".strit($this->values['poner_delivered_cheques']).")";

        //$plantilla_id=strit($this->values['plantilla_id']);
        //$sql[]="INSERT INTO mov_verificado_usuario(banco_cuenta_id,usuario_id,puede) (SELECT banco_cuenta_id,$id,puede FROM mov_verificado_plantilla WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE puede=VALUES(puede)";
        //$sql[]="INSERT INTO banco_cuenta_mov_usuario(banco_cuenta_id,usuario_id,puede) (SELECT banco_cuenta_id,$id,puede FROM banco_cuenta_mov_plantilla WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE puede=VALUES(puede)";
        //$sql[]="INSERT INTO usuario_cobranza(iac_usr_id,tienda_id,permiso) (SELECT $id,tienda_id,permiso FROM plantilla_cobranza WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE permiso=VALUES(permiso)";
        //$sql[]="INSERT INTO usuario_cobranza(iac_usr_id,tienda_id,permiso_cheque,permiso_pagare,permiso_cobranza) (SELECT $id,tienda_id,permiso_cheque,permiso_pagare,permiso_cobranza FROM plantilla_cobranza WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE permiso_cheque=VALUES(permiso_cheque)";
        //$sql[]="insert into permiso_ctat(iac_usr_id,cuentaT_id) (select u.iac_usr_id, t.cuentat_id from iac_usr u join cuentat t) on duplicate key update iac_usr_id=u.iac_usr_id";

        //Permisos de Cuenta T
        //Que siempre cree los permisos.
        //if($this->values['cuentat_propia']=='Si')
        $sql[]="INSERT INTO permiso_ctat(iac_usr_id,cuentaT_id,es_de)
            (SELECT u.iac_usr_id, t.cuentat_id, t.es_de FROM iac_usr u JOIN cuentat t WHERE t.vale = 'Active')
            ON DUPLICATE KEY UPDATE iac_usr_id=VALUES(iac_usr_id)";

        /*$sql[]="UPDATE permiso_ctat SET
            acceso = 'Si',
            link_cuentat_a_banco = 'Si',
            transfer_entre_cuentast = 'Si',
            ver_saldo_y_movimientos = 'Si',
            emitido_por_en_vales = 'Si',
            pagar_deudas = 'Si',
            pagar_gastos = 'Si',
            poner_delivered_cheques = 'Si',
            aceptar_delivered_cheques = 'Si',
            elegir_cuentat_origen_cheques = 'Si',
            abonar_a_cheques = 'Si',
            poner_delivered_pagares = 'Si',
            aceptar_delivered_pagares = 'Si',
            elegir_cuentat_origen_pagares = 'Si',
            ingreso_directo = 'Si'
            WHERE iac_usr_id = '1'";*/

        return true;
    }
    /**
     * iacase::insert_post_save()
     *
     * @return
     */
    function insert_post_save()   {
        @async_ws_generaCatalogos(array('iac_usr'));
        return true;
    }

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::update_pre_validate()
     *
     * @return
     */
    //function update_pre_validate(){ return true; }
    /**
     * iacase::update_validate()
     *
     * @return
     */
    function update_validate()
    {
        $iacusrid=$this->id;
        $saldos = obtenOnHandCuentasT($iacusrid);

        $ok=true;
        if(!empty($saldos) && !empty($this->values['cuentat_propia']) && $this->values['cuentat_propia'] == 'No' &&
          ($saldos[0]['on_hand_mx'] <> 0 || $saldos[0]['on_hand_usd'] <> 0 || $saldos[0]['transfering_mx'] <> 0 || $saldos[0]['transfering_usd'] <> 0))
        {
            $ok=false;
            $this->msg_err.="<li><strong>Cuenta T con saldo. No se puede inactivar.</strong>";
        }

        $ctanombre=$this->values['cuentat_propia_nombre'];
        $this->enDB['cuentat_propia_nombre']=ia_singleread("SELECT usuario FROM cuentat WHERE usuario_id=".strit($iacusrid));
        if(!empty($ctanombre))
        {
            if($ctanombre != $this->enDB['cuentat_propia_nombre'])
            {
                $nombreExiste=ia_singleread("SELECT COUNT(usuario) AS existe FROM cuentat WHERE usuario=".strit($ctanombre)." AND usuario_id<>".strit($iacusrid));
                if($nombreExiste)
                {
                    $ok=false;
                    $this->msg_err.="<li><strong>Ya existe una Cuenta T con el nombre: $ctanombre.</strong>";
                }
            }
        }
        if($ok) $this->campos['cuentat_propia_nombre']['modo']='R/O';
        else $this->campos['cuentat_propia_nombre']['modo']='R/W';

        if($_SESSION['usuario_id'] == 1 && ($_SESSION['activa_usuario_tipo_rony'] ?? 'NO') == 'SI') {
            $this->campos['usuario_tipo_rony']['modo'] = 'R/W';
            $this->values['usuario_tipo_rony'] = param('usuario_tipo_rony', $this->enDB['usuario_tipo_rony']);
        }
        return $ok && $this->validate();
    }
    /**
     * iacase::update_pre_save()
     *
     * @return
     */
    function update_pre_save()
    {
        if($this->values['vale'] == 'Inactive')
        {
            $this->values['usuario_tipo_rony'] = 'No';
            $this->values['cuentat_preferida_id'] = NULL;
            $this->values['cuentat_unica'] = 'No';
            //$this->values['cuentat_propia'] = 'No';

        }
        if(!empty($this->values['pwd'])) {
          $this->values['pwd'] = Pwd::encripta($this->id.$this->values['pwd']); 
        }

        //VCA Puede estar como supervisor y no como revisor, y no se le asigna nada. Fix.
        if($this->values['puede_ser_supervisor'] == 'Si')
            $this->values['puede_revisar_gastos_cuentaT'] = 'Si';

        if($this->values['puede_ser_supervisor_banco'] == 'Si')
            $this->values['puede_revisar_movimientos_banco'] = 'Si';

//        echo "<pre>this->values".print_r($this->values, true)."</pre>";
//        die();


        return true;
    }

    function revisaPermisosAsignacion(&$sql)
    {
      $user_id = $this->id;
      if ($this->values['puede_revisar_movimientos_banco'] == 'Si') {
        $existeEstado = $this->existeEstado('banco_cuenta_mov_asignacion');
        if ($existeEstado === false) {
          $estado_id = $this->calculaEstadoDispobible('banco_cuenta_mov_asignacion');
          $pos = getPosEstado($estado_id);
          $clave = substr($this->values['nombre'], 0, 3);
          $desc = $this->values['nombre'];
          $sql[] = "UPDATE estado SET clave = '$clave', descripcion = '$desc', usuario_id = $user_id, posicion = $pos WHERE estado_id = '$estado_id'";
        }/*  else {
          $sql[] = "UPDATE estado SET activo = 'Si' WHERE estado_id = '$existeEstado[estado_id]'";
        } */
      } else {
        $existeEstado = $this->existeEstado('banco_cuenta_mov_asignacion');
        if ($existeEstado != false) {
          $sql[] = "UPDATE estado SET activo = 'No' WHERE estado_id = '$existeEstado[estado_id]'";
        }
      }
      if ($this->values['puede_ser_supervisor_banco'] == 'Si') {
        $existeEstado = $this->existeEstado('banco_cuenta_mov_supervision');
        if ($existeEstado === false) {
          $estado_id = $this->calculaEstadoDispobible('banco_cuenta_mov_supervision');
          $pos = getPosEstado($estado_id);
          $clave = substr($this->values['nombre'], 0, 3);
          $desc = $this->values['nombre'];
          $sql[] = "UPDATE estado SET clave = '$clave', descripcion = '$desc', usuario_id = $user_id, posicion = $pos WHERE estado_id = '$estado_id'";
        }/*  else {
          $sql[] = "UPDATE estado SET activo = 'Si' WHERE estado_id = '$existeEstado[estado_id]'";
        } */
      } else {
        $existeEstado = $this->existeEstado('banco_cuenta_mov_supervision');
        if ($existeEstado != false) {
          $sql[] = "UPDATE estado SET activo = 'No' WHERE estado_id = '$existeEstado[estado_id]'";
        }
      }
      if ($this->values['puede_revisar_gastos_cuentaT'] == 'Si') {
        $existeEstado = $this->existeEstado('cuentat_gasto_asignacion');
        if ($existeEstado === false) {
          $estado_id = $this->calculaEstadoDispobible('cuentat_gasto_asignacion');
          $pos = getPosEstado($estado_id);
          $clave = substr($this->values['nombre'], 0, 3);
          $desc = $this->values['nombre'];
          $sql[] = "UPDATE estado SET clave = '$clave', descripcion = '$desc', usuario_id = $user_id, posicion = $pos WHERE estado_id = '$estado_id'";
        }/*  else {
          $sql[] = "UPDATE estado SET activo = 'Si' WHERE estado_id = '$existeEstado[estado_id]'";
        } */
      } else {
        $existeEstado = $this->existeEstado('cuentat_gasto_asignacion');
        if ($existeEstado != false) {
          $sql[] = "UPDATE estado SET activo = 'No' WHERE estado_id = '$existeEstado[estado_id]'";
        }
      }
      if ($this->values['puede_ser_supervisor'] == 'Si') {
        $existeEstado = $this->existeEstado('cuentat_gasto_supervision');
        if ($existeEstado === false) {
          $estado_id = $this->calculaEstadoDispobible('cuentat_gasto_supervision');
          $pos = getPosEstado($estado_id);
          $clave = substr($this->values['nombre'], 0, 3);
          $desc = $this->values['nombre'];
          $sql[] = "UPDATE estado SET clave = '$clave', descripcion = '$desc', usuario_id = $user_id, posicion = $pos WHERE estado_id = '$estado_id'";
        } /* else {
          $sql[] = "UPDATE estado SET activo = 'Si' WHERE estado_id = '$existeEstado[estado_id]'";
        } */
      } else {
        $existeEstado = $this->existeEstado('cuentat_gasto_supervision');
        if ($existeEstado != false) {
          $sql[] = "UPDATE estado SET activo = 'No' WHERE estado_id = '$existeEstado[estado_id]'";
        }
      }
    }

    function existeEstado ($origen)
    {
      $user_id = $this->id;
      $query = "SELECT * FROM estado WHERE origen = '$origen' AND usuario_id = '$user_id'";
      $estado = ia_singleton($query);
      if (empty($estado)){
        return false;
      }
      return $estado;
    }

    function calculaEstadoDispobible($origen)
    {
      $query = "SELECT * FROM estado WHERE origen = '$origen' ORDER BY orden ASC";
      $estados = ia_sqlArrayIndx($query);
      if (!empty($estados)) {
        foreach ($estados as $item => $estado) {
          if ($estado['usuario_id'] == '0' || $estado['usuario_id'] == 0) {
            return $estado['estado_id'];
            break;
          }
        }
      }
      /* $estados_disponibles = [
        'cuentat_gasto_asignacion' => ia_sqlArray("SELECT * FROM estado WHERE origen = 'cuentat_gasto_asignacion' ORDER BY orden ASC", 'estado_id'),
        'cuentat_gasto_supervision' => ia_sqlArray("SELECT * FROM estado WHERE origen = 'cuentat_gasto_supervision' ORDER BY orden ASC", 'estado_id'),
        'banco_cuenta_mov_asignacion' => ia_sqlArray("SELECT * FROM estado WHERE origen = 'banco_cuenta_mov_asignacion' ORDER BY orden ASC", 'estado_id'),
        'banco_cuenta_mov_supervision' => ia_sqlArray("SELECT * FROM estado WHERE origen = 'banco_cuenta_mov_supervision' ORDER BY orden ASC", 'estado_id')
      ]; */
    }
    /**
     * iacase::update_post_save()
     *
     * @return
     */
    function update_post_save()   {
        $sql = array();
        $updateFields="";
        if(!empty($this->values['cuentat_propia']) /** && !usuarioTipoRony($this->id) **/)
        {
            if($this->values['cuentat_propia']=='Si')
            {
                $cuentaTStatus='Active';
            }
            else
            {
                $cuentaTStatus='Inactive';

                $this->values['poner_delivered_pagares'] = 'No';
                $this->values['poner_delivered_cheques'] = 'No';
            }

            $updateFields.=" vale=".stritc($cuentaTStatus);
        }
        $usuario_tipo_rony_values = $this->values['usuario_tipo_rony'] ?? 'No';
        $usuario_tipo_rony_enDB = $this->enDB['usuario_tipo_rony'] ?? 'No';
        if($usuario_tipo_rony_values === 'Si' && $usuario_tipo_rony_enDB === 'No')
           ia_query("DELETE FROM permiso_usuario WHERE iac_usr_id=" . strit($this->id));

        $updateFields.=" poner_delivered_cheques=".stritc($this->values['poner_delivered_cheques'])." poner_delivered_pagares=".strit($this->values['poner_delivered_cheques']);

        $ctanombre=$this->values['cuentat_propia_nombre'];
        if(!empty($ctanombre) && $ctanombre != $this->enDB['cuentat_propia_nombre'])
            $updateFields.=(empty($updateFields) ? "":",")." usuario=".strit($ctanombre);

        if($this->values['vale'] == 'Inactive')
        {
            $es_de='Huerfana';
        }
        else
        {
            $es_de='Usuario';
        }

        $updateFields.=", es_de=".strit($es_de);


        $sql[]="UPDATE /**update iac_usr**/ cuentat SET $updateFields WHERE usuario_id=".strit($this->id);
        /*
        if(array_key_exists('iac_usr_id',$this->values) && $this->values['iac_usr_id']==1 && $this->values['tipo']!='Super user')
            $sql[]="UPDATE iac_usr  SET tipo='Super User' WHERE ".strit($this->id)." LIMIT 1";*/

        if(!empty($this->values['cuentat_propia']) && $this->enDB['cuentat_propia'] != $this->values['cuentat_propia'])
        {
            if($this->values['cuentat_propia']=='Si')
                $sql[]="INSERT /**update iac_usr**/ INTO permiso_ctat(iac_usr_id,cuentaT_id,es_de) (SELECT u.iac_usr_id, t.cuentat_id, t.es_de FROM iac_usr u JOIN cuentat t WHERE t.vale = 'Active') ON DUPLICATE KEY UPDATE iac_usr_id=u.iac_usr_id";
            else
                $sql[]="DELETE /**update iac_usr**/ FROM permiso_ctat WHERE cuentaT_id=(SELECT t.cuentat_id FROM iac_usr u, cuentat t WHERE u.iac_usr_id = t.usuario_id AND u.iac_usr_id=".strit($this->enDB['iac_usr_id']).")";
        }

        //$sql[]="UPDATE permiso_ctat SET acceso = 'Si', link_cuentat_a_banco = 'Si', transfer_entre_cuentast = 'Si', ver_saldo_y_movimientos = 'Si', emitido_por_en_vales = 'Si', pagar_deudas = 'Si', pagar_gastos = 'Si', poner_delivered_cheques = 'Si', aceptar_delivered_cheques = 'Si', elegir_cuentat_origen_cheques = 'Si', abonar_a_cheques = 'Si', poner_delivered_pagares = 'Si', aceptar_delivered_pagares = 'Si', elegir_cuentat_origen_pagares = 'Si', ingreso_directo = 'Si' WHERE iac_usr_id = '1'";



        $this->revisaPermisosAsignacion($sql);



        ia_transaction($sql);


        $this->campos['cuentat_propia_nombre']['modo']='R/W';
        unset($_SESSION['activa_usuario_tipo_rony']);
        @async_ws_generaCatalogos(array('iac_usr'));

        return true;
    }

    /**
     * iacase::update_add_sql_queries()
     * permite agregar queries al transaction del update
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    function update_add_sql_queries(&$sql,&$log) {
        $method = __METHOD__;
        $id=$this->id;
        $plantilla_id=strit($this->values['plantilla_id']); //plantilla_id
        if($this->values['plantilla_id']!=$this->ori['plantilla_id']) {

            // queries de seguridad no realmente necesarias
            //$sql[]="DELETE FROM mov_verificado_usuario WHERE usuario_id=$id";
            //$sql[]="DELETE FROM banco_cuenta_mov_usuario WHERE usuario_id=$id";
            //$sql[]="DELETE FROM usuario_cobranza WHERE iac_usr_id=$id";
            // queries ponen plantilla nueva
            //$sql[]="INSERT INTO mov_verificado_usuario(banco_cuenta_id,usuario_id,puede) (SELECT banco_cuenta_id,$id,puede FROM mov_verificado_plantilla WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE puede=VALUES(puede)";
            //$sql[]="INSERT INTO banco_cuenta_mov_usuario(banco_cuenta_id,usuario_id,puede) (SELECT banco_cuenta_id,$id,puede FROM banco_cuenta_mov_plantilla WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE puede=VALUES(puede)";
            //$sql[]="INSERT INTO usuario_cobranza(iac_usr_id,tienda_id,permiso_cheque,permiso_pagare,permiso_cobranza) (SELECT $id,tienda_id,permiso_cheque,permiso_pagare,permiso_cobranza FROM plantilla_cobranza WHERE plantilla_id=$plantilla_id) ON DUPLICATE KEY UPDATE permiso_cheque=VALUES(permiso_cheque)";


            if($this->id==$_SESSION['usuario_id'])
                $_SESSION['plantilla']=ia_singleread("SELECT plantilla FROM plantilla WHERE plantilla_id=$plantilla_id");
        }

        $plantilla_bancos = ia_singleread("SELECT banco_a_banco_list FROM plantilla WHERE plantilla_id=$plantilla_id");

        $builder = new IacSqlBuilder();
        $puedeLinksPropias = $plantilla_bancos;
        $puedeLinksPropias = empty($puedeLinksPropias) ? 'No' : $puedeLinksPropias;

        $iac_usr_id = $this->id;
        $insert = [];
        $insert[] = $builder->insertValues(['permiso_nombre' => 'banco_a_banco_list', 'puede' => $puedeLinksPropias, 'iac_usr_id' => $iac_usr_id]);

        $sql[] = "INSERT /** $method **/ INTO permiso_usuario (permiso_nombre, puede, iac_usr_id) VALUES" .
        implode(",", $insert) . " ON DUPLICATE KEY UPDATE puede = " . strit($puedeLinksPropias);
        //            ia_query($sql);

        if($this->values['vale'] == 'Inactive'){
            $sql[]  = "DELETE FROM vale_permiso WHERE iac_usr_id = '$iac_usr_id'";
        }

        return true;
    }

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
/////////////////////////////////
    //function delete_pre_validate($h) { return true; }

    function delete_post_validate($h)
    {
        $iacusrid=$this->id;
        $saldos = obtenOnHandCuentasT($iacusrid);

        $ok=true;
        if($saldos[0]['on_hand_mx'] <> 0 || $saldos[0]['on_hand_usd'] <> 0 || $saldos[0]['transfering_mx'] <> 0 || $saldos[0]['transfering_usd'] <> 0)
        {
            $ok=false;
            $this->msg_err.="<li><strong>Cuenta T con saldo. No se puede borrar.</strong>";
        }

        return $ok;
    }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    function delete_post_delete($h)
    {
        $sql="UPDATE /**update iac_usr**/ cuentat SET es_de='Huerfana' WHERE usuario_id=".strit($this->id);
        ia_query($sql);
        @async_ws_generaCatalogos('QWERTY');
    }

//////////////////////////////////
// FORM override functions
/////////////////////////////////
    /**
     * iacase::forma_pre()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_pre(&$h,&$nexth)
    {
        $saldos = obtenOnHandCuentasT($this->values['iac_usr_id']);

        //echo "<pre>".print_r($saldos,true)."</pre>";
        if($h=='a' || $h=='i')
        {
            unset($_SESSION['activa_usuario_tipo_rony']);
            $this->campos['cuentat_propia']['modo'] = 'Nada';
            $this->campos['cuentat_propia_nombre']['modo'] = 'Nada';
            $this->campos['cuentat_preferida_id']['modo'] = 'Nada';
            $this->campos['cuentat_unica']['modo'] = 'Nada';
            $this->campos['on_hand_mx']['modo'] = 'Nada';
            $this->campos['on_hand_usd']['modo'] = 'Nada';
            $this->campos['transfering_mx']['modo'] = 'Nada';
            $this->campos['transfering_usd']['modo'] = 'Nada';
            $this->campos['usuario_tipo_rony']['modo'] = 'Nada';

            //$this->enDB['iac_usr_id'] = $this->values['iac_usr_id'] = $this->id = ia_singleread("SELECT MAX(iac_usr_id)+1 as iac_usr_id FROM iac_usr");

        }
        else
        {
            if($saldos === false)
                $this->campos['cuentat_propia']['modo'] = 'R/W';
            elseif(array_key_exists(0, $saldos) && ($saldos[0]['on_hand_mx'] <> 0 || $saldos[0]['on_hand_usd'] <> 0 || $saldos[0]['transfering_mx'] <> 0 || $saldos[0]['transfering_usd'] <> 0))
                $this->campos['cuentat_propia']['modo'] = 'R/O';

            $this->enDB['cuentat_propia_nombre'] = $this->values['cuentat_propia_nombre'] = ia_singleread("SELECT usuario FROM cuentat WHERE usuario_id=".strit($this->values['iac_usr_id']));
            $this->enDB['on_hand_mx'] = $this->values['on_hand_mx'] = !is_array($saldos) ? 0 : $saldos[0]['on_hand_mx'];
            $this->enDB['on_hand_usd'] = $this->values['on_hand_usd'] = !is_array($saldos) ? 0 : $saldos[0]['on_hand_usd'];
            $this->enDB['transfering_mx'] = $this->values['transfering_mx'] = !is_array($saldos) ? 0 : $saldos[0]['transfering_mx'];
            $this->enDB['transfering_usd'] = $this->values['transfering_usd'] = !is_array($saldos) ? 0 : $saldos[0]['transfering_usd'];

            if($this->values['cuentat_propia'] == 'No')
                $this->campos['cuentat_propia_nombre']['modo'] = 'R/O';
        }
        //echo "<pre>".print_r($this->enDB,true)."</pre>"; die();

        $orden = [
            'nick', 'nombre', 'email', 'pwd', 'ultimo_cambio_password', 'forza_cambio_password',
            'vale', 'usuario_tipo_rony', 'cuentat_preferida_id', 'cuentat_unica', 'cuentat_propia', 'cuentat_propia_nombre', 'on_hand_mx', 'on_hand_usd', 'transfering_mx', 'transfering_usd',
            'plantillatienda_id',  'puede_cheque_dd', 'plantilla_id','puede_gasto', 'puede_banco_china', 'puede_clientes', 'puede_modificar_reportes_grid', 'puede_link_tc', 'puede_depositar_en', 'puede_fiduciario', 'puede_inversion', 'puede_reembolso_inversion',
            'puede_deuda', 'puede_gasto_ctat', 'poner_delivered_cheques', 'poner_delivered_pagares', 'puede_ingreso_directo_a_cuentat', 'puede_compra',
            'puede_revisar_gastos_cuentaT', 'puede_ser_supervisor',
            'puede_revisar_movimientos_banco', 'puede_ser_supervisor_banco'
        ];




        $this->campos_reorder($orden);
        $this->values['usuario_tipo_rony'] = $this->values['usuario_tipo_rony'] ?? 'No';
        if($this->values['usuario_tipo_rony'] == 'Si') {

            foreach($this->campos as $fieldName=>$f){
                if(!in_array($fieldName, array('nick','nombre','email','pwd', 'ultimo_cambio_password','forza_cambio_password','cuentat_propia','cuentat_propia_nombre','cuentat_preferida_id','cuentat_unica')))
                    $this->campos[$fieldName]['modo'] = 'R/O';
            }
        }

        return true;
    }
    /**
     * iacase::forma_preFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_postFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_doChilds()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    public function forma_doChilds(&$h,&$nexth)
    {
        if($this->id == 1)
            return false;
        return true;
    }
    /**
     * iacase::forma_post()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    public function forma_post(&$h,&$nexth,$ok=true) { return true; }
    /**
     * iacase::forma_postDiv()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    public function forma_postDiv($h,$nexth) {

        if($h=='e' || $h=='s')
        {
            $ctatp = $this->values['cuentat_preferida_id'];
            $cuid = $this->enDB['iac_usr_id'];

            $ctatunica = $this->enDB['cuentat_unica']=='Si' ? "bg_purple":"";

            echo <<<FOCUS
        <script>
            $('#cuentat_preferida_id').change(function(){
                 cuentaTPreferida = $(this).val();
                 if(typeof acpermiso_ctat_var != "undefined")
                 {
                    var ids = $(acpermiso_ctat_var).jqGrid('getDataIDs'), cl=0, rowData={}, ids_length=ids.length, i=0;
                    $(acpermiso_ctat_var).find('.gcellCuentaTPreferida').addClass('bold').removeClass('gcellCuentaTPreferida');
                    for(i=0;i<ids_length;i++)
                    {
                        cl = ids[i];
                        rowData = $(acpermiso_ctat_var).jqGrid('getRowData',cl);
                        if(rowData['cuentaT_id']==cuentaTPreferida)
                        $(acpermiso_ctat_var).setCell(cl,'cuentaT_id','','gcellCuentaTPreferida');
                    }
                 }
                    //$(acpermiso_ctat_var).trigger('reloadGrid');
            });

            $(function() {
                if(window.opener != null && window.opener.selected_row_id != null && window.opener.iajqgridiac_usr_var != null)
                {
                    window.opener.selected_row_id = '$this->id';
                }

                $("#div_cuentat_unica").after("<div class='dvrd' style='float:left;'><h1 id='pcm' class='txt_bold_red'></h1></div>");
                $('label[for="cuentat_unica"]').closest('div').addClass('$ctatunica');
            });

            var cuentaTPreferida='$ctatp', cuid='$cuid';
        </script>
FOCUS;

            if($_SESSION['usuario_id'] == 1) {
                echo <<<SCRIPTPWD
    <script>

    function activa_usuario_tipo_rony(){
        
        //Confirmo y solicito contraseña
        var txtRC = "Por favor, escribe tu <strong>contraseña</strong> para confirmar.<br/><br/><label for='pwd' class='lbl'><strong>Contraseña:</strong></label> <input type='password' id='pwd_usuario_tipo_rony' name='pwd_usuario_tipo_rony' value=''/>",
        n=0;
    
        $("#" + divIDInfo).html(txtRC).dialog({
            resizable: false,
            modal: true,
            width: 400,
            title: "¿Activar campo Tipo Rony?",
            open: function(){
    
            },
            buttons: {
            'Activar': function() {
                $.ajax({
                    url: "ajax/iac_usr_acciones.php",
                    cache: false,
                    type: "post",
                    async: false,
                    data: {'accion':'valida', 'pwd':$('#pwd_usuario_tipo_rony').val()},
                    beforeSend: function(jqXHR, settings){
                        n++;
                        if(n>3)
                        {
                            window.location = '../backoffice/';
                            return false;
                        }
                        return true;
                    }}).done(function(response, textStatus, jqXHR){
                        try {
                            var jsonResponseU = eval('(' + response + ')');

                            if(jsonResponseU.Status == 'OK'){ 
                                $("#" + divIDInfo).dialog( "close" );
                                do_activa_usuario_tipo_rony();
                            }
                            else{
                                vx_alert(divIDError, jsonResponseU.Error, '¿Activar campo Tipo Rony?','', '','','','SI');
                                if(n>2)
                                    vx_alert(divIDError, "Demasiados intentos con una <strong>contraseña inválida</strong>", 'Visualizar columna pwd','','',"window.location = '../backoffice/';");
                                
                            }
                        }catch(err){alert(err.message);
                            
                        }
                    }).fail(function (xhr, ajaxOptions, thrownError){
                        try {
                            var jsonResponseU = eval('(' + xhr.responseText + ')');
                        }catch(err){
                            alert(err.message);
                            console.log(xhr) 
                        }
                    });
            },
            'Cancelar': function() {
                $(this).dialog( "close" );
            }
        }});
    }
    
    function do_activa_usuario_tipo_rony(){
        $.ajax({
            url: "ajax/iac_usr_acciones.php",
            cache: false,
            type: "post",
            async: false,
            data: {'accion':'activa_usuario_tipo_rony', 'id':$('#iaid').val()},
            dataType: 'json',
            beforeSend: function(jqXHR, settings){
                return true;
            }}).done(function(response, textStatus, jqXHR){
            try {
                var jsonResponseU = response;
                if(jsonResponseU.Status == 'OK'){                               
                    $('#div_usuario_tipo_rony').replaceWith(jsonResponseU.div_usuario_tipo_rony);
                    $('#usuario_tipo_rony').on('change',function(){ iaFormSetDirty();}).selectize();
                }
                else{
                    vx_alert(divIDError, jsonResponseU.Error, 'Visualizar columna pwd','pwd');
                }
            }catch(err){alert(err.message);}
            }).fail(function (xhr, ajaxOptions, thrownError){
                try {
                    var jsonResponseU = xhr;
                }catch(err){
                    alert(err.message);
                    console.log(xhr) 
                }
            });
    };
    
    if({$this->values['iac_usr_id']} !== 1){
        $(function() {
            $('#div_usuario_tipo_rony').on('dblclick', function(){activa_usuario_tipo_rony();}).css({'cursor': 'pointer'});
        });
    }

    </script>
SCRIPTPWD;
            }
            else{
            echo <<<SCRIPTPWD
    <script>
    $(function() {
        $('#div_usuario_tipo_rony').remove();
});
    </script>
SCRIPTPWD;
            }
        }

        parent::forma_postDiv($h,$nexth);
    }


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
/////////////////////////////////
    /**
     * iacase::listme_pre()
     *
     * @param mixed $grid
     * @return
     */
     function listme_pre($grid) {

         $orden=array(
             'nick','nombre','pwd', 'ultimo_cambio_password','forza_cambio_password','vale','usuario_tipo_rony','plantillatienda_id','plantilla_id','cuentat_preferida_id'
         ,'cuentat_unica','puede_deuda','puede_gasto','puede_gasto_ctat','puede_banco_china','puede_clientes','poner_delivered_cheques','puede_revisar_gastos_cuentaT'
         ,'poner_delivered_pagares','puede_ingreso_directo_a_cuentat','puede_modificar_reportes_grid','puede_link_tc','puede_fiduciario','puede_facturas'
         ,'puede_revisar_gastos_cuentaT','puede_ser_supervisor','puede_revisar_movimientos_banco','puede_ser_supervisor_banco'

         , 'puede_solicitar_traslado_efectivo','puede_ver_modulo_solicitar_traslado_efectivo'
         ,'email','ultimo_login','logins','alta_db','alta_por','ultimo_cambio','ultimo_cambio_por','cuentat_propia','cuentat_propia_nombre','on_hand_mx','on_hand_usd',
             'transfering_mx','transfering_usd'
         );



         $this->campos_reorder($orden);

         unset($_SESSION['activa_usuario_tipo_rony']);
         global $verJS;
        $gSaveId = "savd_$grid->element_id-$verJS";
        $this->list_sortname_dflt=" getObjectFromLocalStorage('$gSaveId')==null || typeof getObjectFromLocalStorage('$gSaveId').sortname=='undefined' ? '' : getObjectFromLocalStorage('$gSaveId').sortname";

        $grid->set_option('url','ajax/jqgrid_read_ver2.php');
        $filters = '{"groupOp":"AND","rules":[{"field":"vale","op":"eq","data":"Active"}]}';
        $grid->postData_set( array('filters'=>$filters) );
        return true;
     }
    /**
     * iacase::listme_preRender()
     *
     * @param mixed $grid
     * @return
     */
    function listme_preRender($grid)
    {
        //Preguntamos si mandaron alguna variable para filtrar el grid y seleccionar una fila.
        $selected_row_id = param('selected_row_id');

        echo "<script> selected_row_id = '$selected_row_id'; </script>";

        $code = "
                gridhandler = iajqgridiac_usr_var;
                if(selected_row_id.length)
                    setGridSelectedRow(selected_row_id);
                else
                    focusGrid();
                ";
        $grid->add_event_code('loadComplete',$code);

//        $code = "if(id.length)
//                    selected_row_id = id;
//                else
//                    setGridSelectedRow(selected_row_id)";
//
//        $grid->add_event_code('onSelectRow',$code, 'function(id)');

        $su = json_encode(ia_sqlKeyValue("SELECT iac_usr_id, iac_usr_id FROM iac_usr WHERE tipo = 'Super user'"));
        $rowattr= <<< COLOREAEND
function(rd,inputRowData) { try {
    var clase='', su=$su;
    if(rd.usuario_tipo_rony == "Si" || ( rd.iac_usr_id != "1" && su.hasOwnProperty(rd.iac_usr_id) ) )
        clase+=" rojo ";
    if(clase!="")
        return {"class": clase};
} catch(er) {} }
COLOREAEND;
        $grid->set_option('rowattr',$rowattr);
        
echo <<< gridvardef

<script>var camposConAutoComplete=[];\$(function(){ gridhandler = \$("#iajqgridiac_usr"); }); </script>
gridvardef;

        //parent::listme_preRender($grid);

        $grid->set_option('iaSumaGridServer',array(
                'ia_showpass'=>"NO"
                ));
        return true;
    }
    /**
     * iacase::listme_post()
     *
     * @param mixed $grid
     * @return void
     */
    function listme_postRender($grid) {
/* jul/2020 passwords encriptados
        echo <<<PASSWORDS
<script>
$(function(){
    if($('#gbox_iajqgridiac_usr').length)
    {
        $('#gbox_iajqgridiac_usr').after('<a id="clearCuentasT" href="javascript:void(0);" onclick="activaClearCuentasT();" class="toButton ui-button ui-corner-all ui-widget" role="button">Mostrar Contraseñas</a>');
    }
});

</script>
PASSWORDS;
*/

        
        parent::listme_postRender($grid);
    }

    function redirect()
    {
        //Redirección para quitar el POST.
        if($this->h == 'a' || $this->h == 'i' || empty($_POST))
        {
            //$this->enDB['iac_usr_id'] = $this->values['iac_usr_id'] = $this->id = ia_singleread("SELECT MAX(iac_usr_id)+1 as iac_usr_id FROM iac_usr");
            $_SESSION["$this->id"] = (!empty($_SERVER['HTTPS'])) ? "https://$_SERVER[SERVER_NAME]:$_SERVER[SERVER_PORT]$_SERVER[REQUEST_URI]" : "http://$_SERVER[SERVER_NAME]:$_SERVER[SERVER_PORT]$_SERVER[REQUEST_URI]";
            if($this->h == 'a' || $this->h == 'i')
            {
                if(strrpos($_SESSION["$this->id"], "iah=a") === false)
                   $_SESSION["$this->id"] .= "?iah=a&iagridvar=iajqgridiac_usr_var";
                $_SESSION["$this->id"] = str_replace('iah=a','iah=e',$_SESSION["$this->id"]);
                $_SESSION["$this->id"] .= "&id=$this->id";
                //echo "<pre>$this->h".print_r($_SESSION, true)."</pre>";
            }
        }
        else
        {
            //echo "<pre>".print_r($_POST, true)."</pre>";
            if(empty($this->id))
                $this->id=param('iaid');


            $_SESSION["$this->id"] = "?iah=e&iagridvar=iajqgridiac_usr_var&id=$this->id";
            //echo "<pre>$this->h".print_r($_SESSION, true)."</pre>";
            //die();
        if(!empty($_POST) && empty($this->msg_err) && array_key_exists("$this->id",$_SESSION) && !empty($_SESSION["$this->id"]) && $this->h != 'a' && $this->h != 'i')
        {
            $pa = $this->id;
            echo <<<REDIRECTA
            <script>
            window.location = "$_SESSION[$pa]";
            </script>
REDIRECTA;
        }
        }

        //echo "<pre>$this->h".print_r($_SESSION, true)."</pre>";

        ////////////////////////////////////////////////////////////////////////////////////////
    }

//////////////////////////////////
// QBE FORM override functions
/////////////////////////////////

//////////////////////////////////
// QBE doWHere override functions
/////////////////////////////////

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////
    /**
     * app_iac_usr::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'iac_usr_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'mediumint unsigned',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'auto_increment',
  ),
  'nick' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '16',
    'modo' => 'R/W',
    'UNI' => true,
  ),
  'celular' => 
  array (
    'title' => 'Numero con clave de pais 52...',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '17',
    'modo' => 'R/W',
  ),
  'email' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '64',
    'modo' => 'R/W',
    'formato' => 'email',
  ),
  'nombre' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '64',
    'modo' => 'R/W',
  ),
  'pwd' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
    'formato' => 'password',
  ),
  'vale' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Active',
  ),
  'tipo' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Normal',
  ),
  'plantilla_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
  ),
  'plantillatienda_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'Default' => 'dflt',
  ),
  'puede_deuda' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_gasto' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'cuentat_propia' => 
  array (
    'title' => '',
    'display_group' => 'cuentat',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'ultimo_login' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'datetime',
    'modo' => 'R/O',
  ),
  'logins' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'mediumint unsigned',
    'modo' => 'R/O',
    'Default' => '0',
  ),
  'alta_db' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'timestamp',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'alta_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'Default' => 'Sistema',
  ),
  'ultimo_cambio' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/O',
  ),
  'ultimo_cambio_por' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'Default' => 'Sistema',
  ),
  'remarks' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
    'formato' => 'fckeditor',
  ),
  'anexos' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
    'formato' => 'attachment',
    'file_max_entries' => 9,
    'file_private' => false,
    'accept' => 'jpg,png,gif,jpeg,pdf,doc,docx,xls,xlsx,csv,ppt,pptx,pps,ppsx,txt',
  ),
  'cuentat_preferida_id' => 
  array (
    'title' => '',
    'display_group' => 'cuentat',
    'Null' => true,
    'required' => false,
    'Type' => 'mediumint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'cuentat',
    'formato' => 'link_one_select',
  ),
  'cuentat_unica' => 
  array (
    'title' => '',
    'display_group' => 'cuentat',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_clientes' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_gasto_ctat' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_banco_china' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'poner_delivered_cheques' => 
  array (
    'title' => '',
    'display_group' => 'poner',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'poner_delivered_pagares' => 
  array (
    'title' => '',
    'display_group' => 'poner',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ingreso_directo_a_cuentat' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_modificar_reportes_grid' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'usuario_tipo_rony' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'puede_link_tc' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_fiduciario' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_facturas' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'orden' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'Nada',
    'Default' => '1000',
  ),
  'puede_depositar_en' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_inversion' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_reembolso_inversion' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_revisar_gastos_cuentaT' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_revisar_movimientos_banco' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ser_supervisor_banco' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ser_supervisor' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'ultimo_cambio_password' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'datetime',
    'modo' => 'R/W',
    'Default' => 'CURRENT_TIMESTAMP',
    'formato' => 'password',
  ),
  'forza_cambio_password' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'formato' => 'password',
  ),
  'puede_cheque_dd' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'activa_alerta_gastos' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'puede_compra' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_supervisar_bodega' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ser_encargado_bodega' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_solo_consultar_bodegas' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_registrar_todas_bodegas' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_solicitar_traslado_efectivo' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ver_modulo_solicitar_traslado_efectivo' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ver_traslados_match' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ver_traslados' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_bodega_destinos_especiales' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ver_acuentas' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ver_doctos' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_ver_deliveries' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_consultar_existencia' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_autorizar_notas_ultimo_movimiento' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_hacer_reset_producto_color' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_hacer_reset_inconsistencias' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'notificar_nuevas_cartas_porte' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
  'puede_editar_campos_cash_nota_bodega' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
  'puede_hacer_ajuste_producto_color' => 
  array (
    'title' => '',
    'display_group' => 'puede',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
    'display_group_break' => false,
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

}
