<?php
    // v0.0
    /*
       	CAMPOS_EN_DB_START
		primary key: 'kv_record_log' al 2026-01-13 16:39
		collection_id,record_id,usuario,kv_accion_log_id,note,revisado,alta_db,kv_record_log
	CAMPOS_EN_DB_END
    */
    /*
       	DELETE_RULES_START

	Usa tablas:
		kv_accion_log:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by kv_accion_log_id
	DELETE_RULES_END
    */

class app_kv_record_log extends iacase_base {

    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
    global $gAppRelate;
        if( empty($table) )
            $table='kv_record_log';
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();
        $this->label='Bitacora';
        $this->label_plural = 'Bitácora';
        $this->modo='cardex_window';     // cardex, jqgrid_form forma de jqgrid, jqgrid_iacform forma de iacase, jqgrid_inline (inline falta)
        //$this->modo='jqgrid_iacform';

        //$this->asChild=false;      // en true esta instancia es child table
        //$this->childTables=array();  // childTables to use
        //$this->saveChilds=true;    // en false no hace child tables en el save
        //$this->editChilds=true;    // en false no saca tablita add another editar childs
        //$this->viewChilds=true;    // en false no muestra childs

        //$this->permiso_app=true;
        $this->permiso_delete=usuarioTipoRony($_SESSION['usuario_id']) ? true:false;
        $this->permiso_export=true;
        $this->permiso_insert=false;
        $this->permiso_list=usuarioTipoRony($_SESSION['usuario_id']) ? true:false;
        $this->permiso_read=false;
        $this->permiso_update=false;

        $this->jqGridHiddenCols = array('record_id');

        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        //$this->cols_list='*';
        /* ojo trae campos del momento de creacion
            kv_record_log,collection_id,record_id,alta_db,usuario,kv_accion_log_id,note
        */
        $this->list_sortname_dflt='kv_record_log.alta_db';
        $this->list_sortorder_dflt='DESC';
        $this->col_list_noShow=array('revisado');    // estas ni llegan al jqgrid
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->useJqueryValidate=false;

        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;
        //$this->formTypeChildsPerRow=2;

        $this->jqGridId='bitac'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->colModel_overRide=array(); // override generated colModel

        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica


        //$this->extraParams=array();    // parametros extra en links

        //$this->log_cardex_view=false; // ture log each iah=r pageview
    }

    function listme($gridId='',$title='',$where='',$jsAfter='',$postData=array()) {
        $gridId = $this->jqGridId;
        $table=param('table', $this->table);


        if($where==''&& $table != 'cliente') {
            if(!empty($table)) {
                $table_id=ia_singleread("SELECT tabla_id FROM tablas WHERE tabla=".strit($table));
                if($table_id!='') {
                    $this->jqGridHiddenCols[]='collection_id';
                    $this->jqGridHiddenCols[]='iac_table_id';

                    $gridId='bitac_table';
                    //$where=" collection_id=".strit($table_id);
                    $postData['iacrelTable']=$table;
                    $postData['iacrelTableId']=$table_id;
                    $record_id = param('record');
                    if(!empty($record_id)) {
                        $where.= " AND (record_id=" . strit($record_id) . " OR record_id IN (SELECT doc_id as record_id FROM doctos WHERE doc_origen_id = ".strit($record_id) . ")) "; //VCA 27-11-2020 Que traiga todos los documentos verificados.
                        $gridId = 'bitac_rec';
                        $this->jqGridHiddenCols[]='documento';
                    }
                }
            }
        }
        $this->jqGridId = $gridId;


        parent::listme($gridId,$title,$where,$jsAfter,$postData);
    }
//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_kv_record_log::campos_final
     * Redefine $campos del default en campos_default
     *
     */
    private function campos_final() {
        //$this->campos_set_required(false); // todos los campos pon required en
        //$this->campos_set_required(true,array('campo1','campo2')); // cambia required en campos del array
        //$this->campos_set_attribute( array('fieldname1','fieldname2'),'max',1e6 ); // a fieldnameN cambiales 'max' a 1e6
        // comunes atributes son br,required,max,min,display_group,display_group_label
        /*
        // ojo trae campos del momento de creacion
        // pkfields=array( 'kv_record_log' );
        $orden=array(
            'collection_id','record_id','alta_db','usuario','kv_accion_log_id','note'


        );

        $this->campos_reorder($orden);
        //$this->campos['fieldName']['br']=true;
        */
             $this->campos['collection_id'] =
              array (
                'title' => 'Collectión',
                'display_group' => '',
                'Null' => false,
                'required' => true,
                'Type' => 'smallint',
                'enteros' => '5',
                'decimales' => 0,
                'unsigned' => true,
                'min' => 0,
                'numeric' => 1,
                'modo' => 'R/W',
                'link_table' => 'tablas',
                'formato' => 'link_one_select',
              );


        $this->campos_set_attribute('alta_db','label','Fecha' );
        $this->campos_set_attribute('kv_accion_log_id','label','Acción' );
        $this->campos_set_attribute('record_id','label','Record Id' );
        $this->campos_set_attribute('collection_id','label','Tema' );
        
        $this->campos_set_attribute('note','formato','fckeditor' );
        //$this->campos['note']['type']='html'; //Para que se muestre bien el codigo HTML que traiga el texto. 24-11-2020
        $this->campos['note']['extraClass4Child']='txt_left_aligned';

    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::insert_pre_validate()
     *
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * iacase::insert_validate()
     *
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * iacase::insert_pre_save()
     *
     * @return
     */
    //function insert_pre_save()  { return true; }
    /**
     * iacase::insert_post_save()
     *
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * iacase::update_pre_validate()
     *
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * iacase::update_validate()
     *
     * @return
     */
    //function update_validate()  { return $this->validate(); }
    /**
     * iacase::update_pre_save()
     *
     * @return
     */
    //function update_pre_save()  { return true; }
    /**
     * iacase::update_post_save()
     *
     * @return
     */
    //function update_post_save()   {return true;}

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
/////////////////////////////////
    //function delete_pre_validate($h) { return true; }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    //function delete_post_delete($h) {  }

//////////////////////////////////
// FORM override functions
/////////////////////////////////
    /**
     * iacase::forma_pre()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_pre(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_preFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_postFields()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
   // public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_doChilds()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_doChilds(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_post()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
   // public function forma_post(&$h,&$nexth) { return true; }
    /**
     * iacase::forma_postDiv()
     *
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
   // public function forma_postDiv($h,$nexth) {}


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
/////////////////////////////////
    /**
     * iacase::listme_pre()
     *
     * @param mixed $grid
     * @return
     */
    function listme_pre($grid)
    {

        //if(usuarioTipoRony($_SESSION['usuario_id'])) $actionsWidth = '80';
        $this->colModel_overRide=array(
            'alta_db'=>array('width'=>'200', 'classes'=>'bold'),
            'usuario'=>array('width'=>'100', 'classes'=>'bold'),
            'kv_accion_log_id'=>array('width'=>'100', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/kv_accion_log_id.html')),
            'collection_id'=>array('width'=>'100', 'classes'=>'bold', 'comboBoxAutoComplete'=>array('dataUrl'=>'./json/collection_id.html')),
            'note'=>array('width'=>'1500', 'classes'=>'txt17px'));
        return true;
    }
    /**
     * iacase::listme_preRender()
     *
     * @param mixed $grid
     * @return
     */
    //function listme_preRender($grid) { return true; }
    /**
     * iacase::listme_post()
     *
     * @param mixed $grid
     * @return void
     */
    //function listme_postRender($grid) {  }

//////////////////////////////////
// QBE FORM override functions
/////////////////////////////////

//////////////////////////////////
// QBE doWHere override functions
/////////////////////////////////

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////
    /**
     * app_kv_record_log::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'kv_record_log' => 
  array (
    'title' => '',
    'display_group' => 'kv',
    'Null' => false,
    'required' => true,
    'Type' => 'bigint unsigned',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'auto_increment',
    'display_group_break' => false,
  ),
  'collection_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'smallint unsigned',
    'modo' => 'R/W',
  ),
  'record_id' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'char',
    'maxlength' => '32',
    'modo' => 'R/W',
  ),
  'alta_db' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'usuario' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '16',
    'modo' => 'R/W',
  ),
  'kv_accion_log_id' => 
  array (
    'title' => '',
    'display_group' => 'kv',
    'Null' => false,
    'required' => true,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'display_group_break' => false,
    'link_table' => 'kv_accion_log',
    'formato' => 'link_one_select',
  ),
  'note' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'longtext',
    'modo' => 'R/W',
  ),
  'revisado' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'No',
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */

}
?>