<?php
/*
   	CAMPOS_EN_DB_START
		primary key: 'propiedad_id' al 2026-01-13 16:39
		vale,nombre_propiedad,propietario_id,direccion,num_deptos,nombre_propiedad_original,departamento,numero_unidad,tipo_unidad,orientacion,metros_cuadrados,recamaras,banos,estacionamientos,bodega,balcon,amueblado,piso,propietario_nombre_propiedad,propietario_match_tier,propietario_match_confidence,propietario_match_pattern,propietario_match_explanation,propietario_match_scores,propietario_match_timestamp,codigo_postal,colonia,estado,estado_descripcion,municipio,municipio_descripcion,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,propiedad_id
	CAMPOS_EN_DB_END
*/
/* 
   	DELETE_RULES_START

	Dependen de propiedad:
		cloudbeds_reserva:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by propiedad_id
		hostify_reserva:
			Restricts delete me: si. Is deleted with me: no.jqgrid/catalog_entry. Links by propiedad_id
		propiedad_backup_20250102:
			Restricts delete me: NO. Is deleted with me: SI.link_one_select/catalog_entry. Links by propiedad_id
		propiedad_pms_analytics:
			Restricts delete me: NO. Is deleted with me: SI.jqgrid/child. Links by propiedad_id
		v_propiedad_latest_analytics:
			Restricts delete me: si. Is deleted with me: no.jqgrid/child. Links by propiedad_id
	Usa tablas:
		propietario:
			Deletes me: no. I restrict delete: si. link_one_select/catalog. Links by propietario_id
	DELETE_RULES_END
*/
class app_propiedad extends iacase_base {
    
    function __construct($h='',$table='',$usuario_id=null,$usuario=null) {
    global $gAppRelate; 
        if( empty($table) )
            $table='propiedad';    
        parent::__construct($h,$table,$usuario_id,$usuario);
        $this->campos_default();
        $this->campos_final();
        
        // para tomar default de iacasebase
        $this->modo='cardex_window';      // cardex misma ventana, cardex_window cardex in new window, jqgrid_iacform forma de iacase, jqgrid_form forma de jqgrid, jqgrid_inline (inline falta)
        
    //$this->asChild=false;      // en true esta instancia es child table
    //$this->childTables=array();  // childTables storage
    //$this->childTablesUse=array(); // solo considera estos child tables
    //$this->saveChilds=true;    // en false no hace child tables en el save
    //$this->editChilds=true;    // en false no saca tablita add another editar childs
    //$this->editChildsSetRO=false; // forza a todos los childs a ser R/O!
    //$this->viewChilds=true;    // en false no muestra childs
    //$this->childHide=array(); // array('childTableToHide');
    //$this->child_jqGrid_height=300;
    //$this->child_jqGrid_width="'50%'";
    //$this->child_jqGrid_cols=array();
    //$this->child_jqGrid_hiddenCols=array();
    //$this->child_jqGridSaveState=true; // guarda grid state
    //$this->child_jqGrid_option=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
    //$this->jqChildGridActions=array(); //actions cuando es child
    //$this->formTypeChildsPerRow=2;   
    //$this->asChild_update=true; // usandose como child es and permsio_update
    //$this->asChild_delete=true; // usandose como child es and permsio_update    
        
        $editar=true;
        $consultar=true;
        $this->permiso_app=$editar;
        $this->permiso_delete=$editar;
        $this->permiso_export=$consultar;
        $this->permiso_insert=$editar;
        $this->permiso_list=$consultar;
        $this->permiso_read=$consultar;
        $this->permiso_update=$editar;
        //$this->min_delete_id=0; // no vale delete id menor a esto null no aplica
        //$this->log_cardex_view=false; // ture log each iah=r pageview

        //$this->cols_read='*';      // columnas a leer
        //$this->cols_update='*';
        //$this->cols_insert='*';
        
        //$this->useJqueryValidate=false;
        //$this->useFormChanged=true;
        //$this->formId='frm';           // id del tag form
        //$this->useBlockUI=true;
        //$this->formType='deduce'; // deduce, seauencial, db
        //$this->formTypeSecuencialCols=4;

        //$this->input_max_size=40;          // en cardex
        //$this->input_max_size_child=30;    // en child        
        //$this->list_where='';      // filtro para el list iacwhere de jqgrid
        //$this->cols_export='*';
        //$this->cols_search='*';

        //$this->jqGridId_Prefix='iajqgrid'; // el prfiex luego le agrega table
        //$this->jqGridSaveState=true; // guarda grid state
        //$this->jqGridFilters=true; // pone o quita filters de jqgrid
        //$this->jqGridSearch=true; // pone o quita search de jqgrid
        //$this->jqGridSendOnly=array(); // mandar unicamente estas columnas
        //$this->colModel_overRide=array(); // override generated colModel
        //$this->cols_list='*';
        //$this->jqGrid_options=array(); // options a poner en el jqgrid array('autowidth'=>true,...)
        
        //$this->list_sortname_dflt='';
        //$this->list_sortorder_dflt='';
        //$this->col_list_noShow=array();    // estas ni llegan al jqgrid        
        //$this->jqGridHiddenCols=array(); // estas llegan al grid pero quedan hidden
        
        //$this->extraParams=array();    // parametros extra en links

        // Con este parametro se activa la busqueda rapida
        $this->activeBA = true;
        $this->busqueda_rapida_automatica  = true; // activa la busqueda rápida

    }
    
//////////////////////////////////
// PERMISOS
/////////////////////////////////
    /**
     * app_propiedad::permiso_por_record
     * Redefine permisos habiendo leido el record de la base de datos en $this->enDB
     *
     */
    //function permiso_por_record() { }
    /**
     * app_propiedad::may_add()
     * Permiso para ver la forma de dar alta, conviene mas usar las variables $this->permiso_*
     * @return  boolean TRUE puede, false no puede
     */
    //function may_add() { return $this->permiso_insert; }
    /**
     * app_propiedad::may_insert()
     * Permiso para dar altas, insert, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_insert() { return $this->may_add(); }
    /**
     * app_propiedad::may_edit()
     * Permiso para ver la forma de editar, conviene mas usar las variables $this->permiso_*
     * @return boolean
     */
    //function may_edit() { return $this->permiso_update; }
    /**
     * app_propiedad::may_update()
     * Permiso para hacer el update, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_update() { return $this->may_edit() && ($this->asChild ? $this->asChild_update : true); }
    /**
     * app_propiedad::may_delete()
     * Parmiso para borrar, se usa en confirmar y en borrar., conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_delete() { return $this->permiso_delete && ($this->asChild ? $this->asChild_delete : true); }
    /**
     * app_propiedad::may_read()
     * Permiso para ver el record, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_read() { return $this->permiso_read; }
    /**
     * app_propiedad::may_list()
     * Permiso para listar los records, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_list() { return $this->permiso_list; }
    /**
     * app_propiedad::may_export()
     * Permiso para exportar, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_export() { return $this->permiso_export; }
    /**
     * app_propiedad::may_print()
     * Permiso para imprimir, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_print() { return $this->may_export(); }
    /**
     * app_propiedad::may_viewLog()
     * Permiso para ver el log, conviene mas usar las variables $this->permiso_*
     * @return boolean TRUE puede, false no puede
     */
    //function may_viewLog() { return $this->permiso_export; }  
    
//////////////////////////////////
// Etiquetas o labels
/////////////////////////////////
    /**
     * app_propiedad::label_record()
     * Nombre corto del registro
     * @return string el nombre corto del registro
     */
    //function label_record() { }
    
    /**
     * app_propiedad:label_record_summary()
     * Resumen de registro
     * @return string el resumen del registro
     */
    //function label_record_summary() { }

    /**
     * app_propiedad::label_add()
     * Etiqueta para agregar un registro
     * @return string la etiqueta para agregar un registro si existe $this->table_info['label_add'], del contrario la arma
     */
   //public function label_add() {    }
    /**
     * app_propiedad::label_list()
     * Etiqueta para el listado
     * @return string la etiqueta del listado, si existe $this->table_info['label_list'] del contrario  $this->label_table_plural()
     */
    //public function label_list() { }
    /**
     * app_propiedad::label_table_singular()
     * Etiqueta para la tabla o tipos de registro en singular
     * @return string el label de la tabla en singular
     */
    //public function label_table_singular() { return $this->label; }
    /**
     * app_propiedad::label_table_plural()
     * Etiqueta para la tabla o tipos de registro en plural
     * @return string el label de la tabla en plural
     * @return
     */
    //public function label_table_plural() { }

      
//////////////////////////////////
// CAMPOS override functions
/////////////////////////////////
    /**
     * app_propiedad::campos_final
     * Redefine $campos del default en campos_default 
     *
     */
    public function campos_final() {
        // pkfields=array( 'propiedad_id' );
        /*	CAMPOS_START
				primary key: 'propiedad_id' al 2026-01-13 16:39
				vale,nombre_propiedad,propietario_id,direccion,num_deptos,nombre_propiedad_original,departamento,numero_unidad,tipo_unidad,orientacion,metros_cuadrados,recamaras,banos,estacionamientos,bodega,balcon,amueblado,piso,propietario_nombre_propiedad,propietario_match_tier,propietario_match_confidence,propietario_match_pattern,propietario_match_explanation,propietario_match_scores,propietario_match_timestamp,codigo_postal,colonia,estado,estado_descripcion,municipio,municipio_descripcion,alta_db,alta_por,ultimo_cambio,ultimo_cambio_por,propiedad_id
			CAMPOS_END
        */

        // Field labels in Spanish
        $this->campos['numero_unidad']['label'] = 'No. Unidad';
        $this->campos['piso']['label'] = 'Piso';
        $this->campos['tipo_unidad']['label'] = 'Tipo';
        $this->campos['orientacion']['label'] = 'Orientación';
        $this->campos['metros_cuadrados']['label'] = 'M²';
        $this->campos['recamaras']['label'] = 'Recámaras';
        $this->campos['banos']['label'] = 'Baños';
        $this->campos['estacionamientos']['label'] = 'Estacionamientos';
        $this->campos['bodega']['label'] = 'Bodega';
        $this->campos['balcon']['label'] = 'Balcón/Terraza';
        $this->campos['amueblado']['label'] = 'Amueblado';

        // Display groups for organization
        $this->campos['nombre_propiedad']['display_group'] = 'Identificación';
        $this->campos['numero_unidad']['display_group'] = 'Identificación';
        $this->campos['piso']['display_group'] = 'Identificación';
        $this->campos['tipo_unidad']['display_group'] = 'Identificación';
        $this->campos['propietario_id']['display_group'] = 'Identificación';

        $this->campos['direccion']['display_group'] = 'Ubicación';
        $this->campos['codigo_postal']['display_group'] = 'Ubicación';
        $this->campos['colonia']['display_group'] = 'Ubicación';
        $this->campos['estado']['display_group'] = 'Ubicación';
        $this->campos['estado_descripcion']['display_group'] = 'Ubicación';
        $this->campos['municipio']['display_group'] = 'Ubicación';
        $this->campos['municipio_descripcion']['display_group'] = 'Ubicación';

        $this->campos['metros_cuadrados']['display_group'] = 'Características';
        $this->campos['recamaras']['display_group'] = 'Características';
        $this->campos['banos']['display_group'] = 'Características';
        $this->campos['orientacion']['display_group'] = 'Características';
        $this->campos['estacionamientos']['display_group'] = 'Características';
        $this->campos['bodega']['display_group'] = 'Características';
        $this->campos['balcon']['display_group'] = 'Características';
        $this->campos['amueblado']['display_group'] = 'Características';

        // Make num_deptos read-only and hidden (always 1 after expansion)
        $this->campos['num_deptos']['modo'] = 'R/O';
        $this->campos['num_deptos']['hidden'] = true;

        // Field order - organized by groups
        $orden = array(
           'propiedad_id'
          ,'vale'
          ,'nombre_propiedad'
          ,'propietario_id'
          ,'direccion'
          ,'num_deptos'
          ,'numero_unidad'
          ,'tipo_unidad'
          ,'orientacion'
          ,'metros_cuadrados'
          ,'recamaras'
          ,'banos'
          ,'estacionamientos'
          ,'bodega'
          ,'balcon'
          ,'amueblado'
          ,'piso'
          ,'codigo_postal'
          ,'colonia'
          ,'estado'
          ,'estado_descripcion'
          ,'municipio'
          ,'municipio_descripcion'
          ,'alta_db'
          ,'alta_por'
          ,'ultimo_cambio'
          ,'ultimo_cambio_por'

        );
        $this->campos_reorder($orden);


    }

//////////////////////////////////
// INSERT override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_propiedad::insert_pre_validate()
     * 
     * @return
     */
    //function insert_pre_validate()  { return true; }
    /**
     * app_propiedad::insert_validate()
     * 
     * @return
     */
    //function insert_validate()  { return $this->validate(); }
    /**
     * app_propiedad::insert_pre_save()
     * 
     * @return
     */
     //function insert_pre_save()  { return true; }

    /**
     * app_propiedad::insert_extra_values()
     * permite agregar valores al insert sql statement o modificar el array del que hacer el insert
     * @param string $insArray  agregar insert clause, terminar con coma ie: $ins.=",campo1"
     * @param string $log   agregar o cambiar el log
     * @return boolean TRUE continua con el isnert, FALSE cancela el insert en este caso avisar en $this->msg_err.="<li>explica..."
    */
    //function insert_extra_values(&$insArray,&$log) { return true; }
         
    /**
     * app_propiedad::insert_add_sql_queries()
     * permite agregar queries al transaction del insert
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    //function insert_add_sql_queries(&$sql,&$log) { return true;}
    
    /**
     * app_propiedad::insert_post_save()
     * 
     * @return
     */
    //function insert_post_save()   {return true;}

//////////////////////////////////
// UPDATE override functions return true continua, false no sigue
/////////////////////////////////
    /**
     * app_propiedad::update_pre_validate()
     * 
     * @return
     */
    //function update_pre_validate()  { return true; }
    /**
     * app_propiedad::update_validate()
     * 
     * @return
     */
    //function update_validate()  { return $this->validate(); }
    /**
     * app_propiedad::update_pre_save()
     * 
     * @return
     */
    //function update_pre_save()  { return true; }

    /**
     * app_propiedad::update_extra_sql()
     * permite agregar valores al update sql
     * @param string $updArray  array de valores 
     * @param string $log  agregar <li> al log ie: $log.="<li>..."
     * @return boolean TRUE continua con el update FALSE no hace el update poner mensaje en $this->msg_err.="<li>..."
    */
    //function update_extra_sql(&$updArray,&$log) { return true; }
        
    /**
     * app_propiedad::update_add_sql_queries()
     * permite agregar queries al transaction del update
     * Tipo de regresar false llenar  $this->msg_err
     * @param array $sql  agregar queries al array $sql[]="";
     * @param string $log  agregar info al log $log.="<li>.."
     * @return boolean true continuar, false no continuar - no se hace el insert
    */
    function update_add_sql_queries(&$sql,&$log) { return true;}
        
    /**
     * app_propiedad::update_post_save()
     * 
     * @return
     */
    //function update_post_save()   {return true;}  

//////////////////////////////////
// DELETE override functions. return true continua, false no sigue
///////////////////////////////// 
    //function delete_pre_validate($h) { return true; }
    //function delete_post_validate($h) { return true; }
    //function delete_pre_confirm_delete() { return true; }
    //function delete_pre_delete($h) { return true; }
    //function delete_post_delete($h) {  }
    /**
     * app_propiedad::delete_sql()
     *
     * @param string $record record values to delete, normalmente $this->values
     * @param array $sql array de sql commands al que agregar queries
     * @return void
     */
    //function delete_sql_extra($record,&$sql) {  }
    
//////////////////////////////////
// FORM override functions
///////////////////////////////// 
    /**
     * app_propiedad::forma_pre()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_pre(&$h,&$nexth) { return true; }
    /**
     * app_propiedad::forma_preFields()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_preFields(&$h,&$nexth) { return true; }
    /**
     * app_propiedad::forma_postFields()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_postFields(&$h,&$nexth) { return true; }
    /**
     * app_propiedad::forma_doChilds()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return
     */
    //public function forma_doChilds(&$h,&$nexth) { return true; }  
    /**
     * app_propiedad::forma_post()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return FALSE no hagas los childs en automatico, si lo demas. TRUE haz los childs en automatico
     */
    //public function forma_post(&$h,&$nexth) { return true; }
    /**
     * app_propiedad::forma_postDiv()
     * 
     * @param mixed $h
     * @param mixed $nexth
     * @return void
     */
    //public function forma_postDiv($h,$nexth) {}


//////////////////////////////////
// LIST override functions  return true continua, false no sigue. $grid es jqgrid class
///////////////////////////////// 
    /**
     * app_propiedad::listme_pre()
     * 
     * @param mixed $grid
     * @return
     */
    //function listme_pre($grid) { return true; }
    /**
     * app_propiedad::listme_preRender()
     * 
     * @param mixed $grid
     * @return
     */
    //function listme_preRender($grid) { return true; }
    /**
     * app_propiedad::listme_post()
     * 
     * @param mixed $grid
     * @return void
     */
    //function listme_postRender($grid) { parent::listme_postRender($grid); }
    
//////////////////////////////////
// QBE FORM override functions
///////////////////////////////// 
    /**
     * app_propiedad::qbe_forma()
     *
     * @return @void
     */
    // public function qbe_forma() {}
    
//////////////////////////////////
// QBE doWHere override functions
///////////////////////////////// 

//////////////////////////////////
// DEFINE CAMPOS
/////////////////////////////////    
    /**
     * app_propiedad::campos_default
     * Definicion define campos, no cambiar cambiar en campos_final()
     *
     */
   	/* TALBE_DEFAULT_INFO START */
	public function campos_default() {
	global $gAppRelate;
	$campos=array (
  'propiedad_id' => 
  array (
    'title' => 'UUID primary key',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'PK' => true,
    'PK_type' => 'uuid',
  ),
  'num_deptos' => 
  array (
    'title' => 'num_deptos',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'int',
    'modo' => 'R/W',
  ),
  'nombre_propiedad' => 
  array (
    'title' => 'nombre_propiedad',
    'display_group' => 'nombre',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '50',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'nombre_propiedad_original' => 
  array (
    'title' => 'Backup of original name before AI-suggested modification',
    'display_group' => 'nombre',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '255',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'direccion' => 
  array (
    'title' => 'direccion',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'vale' => 
  array (
    'title' => 'direccion Active',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'departamento' => 
  array (
    'title' => 'departamento',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '200',
    'modo' => 'R/W',
  ),
  'alta_db' => 
  array (
    'title' => 'Timestamp del momento de inserción del registro',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/O',
    'Default' => 'CURRENT_TIMESTAMP',
  ),
  'alta_por' => 
  array (
    'title' => 'Usuario que insertó el registro',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
    'Default' => 'system',
  ),
  'ultimo_cambio' => 
  array (
    'title' => 'Timestamp del último cambio al registro',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/O',
  ),
  'ultimo_cambio_por' => 
  array (
    'title' => 'Usuario que hizo el último cambio',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/O',
  ),
  'numero_unidad' => 
  array (
    'title' => 'Unit number: 01, 02, 101, 201, A, B, etc.',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '10',
    'modo' => 'R/W',
  ),
  'piso' => 
  array (
    'title' => 'Floor number (extracted from unit number or manually set)',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'int',
    'modo' => 'R/W',
  ),
  'tipo_unidad' => 
  array (
    'title' => 'Type of unit',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
    'Default' => 'Departamento',
  ),
  'orientacion' => 
  array (
    'title' => 'Unit orientation/facing direction',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'metros_cuadrados' => 
  array (
    'title' => 'Square meters (M²)',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'decimal',
    'enteros' => '8',
    'decimales' => '2',
    'numeric' => 1,
    'min' => '-99999999.99',
    'max' => '99999999.99',
    'modo' => 'R/W',
  ),
  'recamaras' => 
  array (
    'title' => 'Number of bedrooms',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'Default' => '0',
  ),
  'banos' => 
  array (
    'title' => 'Number of bathrooms (e.g., 2.5 = 2 full + 1 half)',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'decimal',
    'enteros' => '3',
    'decimales' => '1',
    'numeric' => 1,
    'unsigned' => true,
    'min' => 0,
    'max' => '999.9',
    'modo' => 'R/W',
    'Default' => '0.0',
  ),
  'estacionamientos' => 
  array (
    'title' => 'Number of parking spaces',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'tinyint unsigned',
    'modo' => 'R/W',
    'Default' => '0',
  ),
  'bodega' => 
  array (
    'title' => 'Has storage unit (bodega)',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'tinyint',
    'enteros' => '1',
    'decimales' => 0,
    'numeric' => 1,
    'modo' => 'R/W',
    'Default' => '0',
  ),
  'balcon' => 
  array (
    'title' => 'Has balcony/terrace',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'tinyint',
    'enteros' => '1',
    'decimales' => 0,
    'numeric' => 1,
    'modo' => 'R/W',
    'Default' => '0',
  ),
  'amueblado' => 
  array (
    'title' => 'Furnished status',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'enum',
    'modo' => 'R/W',
  ),
  'propietario_id' => 
  array (
    'title' => 'Reference to propietario.propietario_id (no FK constraint)',
    'display_group' => '',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '32',
    'modo' => 'R/W',
    'link_table' => 'propietario',
    'formato' => 'link_one_select',
  ),
  'propietario_nombre_propiedad' => 
  array (
    'title' => 'Matched propietario.departamento via THOTH algorithm (full text with pipes)',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'propietario_match_tier' => 
  array (
    'title' => 'Match tier: 0=combo, 1=perfect(95-100%), 2=high(80-94%), 3=medium(65-79%), 4=low(40-64%)',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'int',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'propietario_match_confidence' => 
  array (
    'title' => 'Match confidence percentage (0-100)',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'int',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'propietario_match_pattern' => 
  array (
    'title' => 'Match pattern used: tier1_exact, tier2_contains, tier3_similarity, tier4_street, combo_*',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'propietario_match_explanation' => 
  array (
    'title' => 'AI-generated explanation: tier name, score breakdown, method, warnings',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'text',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'propietario_match_scores' => 
  array (
    'title' => 'Multi-dimensional scores: {street:95, building:100, unit:90, overall:95, tier:1}',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'json',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'propietario_match_timestamp' => 
  array (
    'title' => 'When this match was created/updated by THOTH algorithm',
    'display_group' => 'propietario',
    'Null' => true,
    'required' => false,
    'Type' => 'timestamp',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'codigo_postal' => 
  array (
    'title' => '',
    'display_group' => 'direccion',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '5',
    'modo' => 'R/W',
    'display_group_label' => 'Dirección',
    'display_group_break' => false,
  ),
  'colonia' => 
  array (
    'title' => '',
    'display_group' => 'direccion',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
    'display_group_break' => true,
  ),
  'estado' => 
  array (
    'title' => '',
    'display_group' => 'direccion',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '5',
    'modo' => 'R/W',
    'display_group_break' => false,
  ),
  'estado_descripcion' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
  'municipio' => 
  array (
    'title' => '',
    'display_group' => 'direccion',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '5',
    'modo' => 'R/W',
    'display_group_break' => true,
  ),
  'municipio_descripcion' => 
  array (
    'title' => '',
    'display_group' => '',
    'Null' => false,
    'required' => true,
    'Type' => 'varchar',
    'maxlength' => '100',
    'modo' => 'R/W',
  ),
);

	$this->campos = $gAppRelate->campos_incorpora($this->table,$campos);
	}
	/* TALBE_DEFAULT_INFO END */
    
}
?>