<?php
use Iac\inc\sql\IacSqlBuilder;
class iacase_base extends iacase  {
    protected $autoFiltraOnly = [];
    public $jqGridSelectRows = true;
    public $my_ia_case_Lock;
    public $_autoFiltraPorRequest = false; //Un hack al conmutador de Pepe. Susceptible de mejorarse.
    function __construct($h='',$table='',?string $usuario_id=null,?string $usuario=null) {
        parent::__construct($h,$table,$usuario_id,$usuario);

        $this->log_cardex_view=false; // true log each iah=r pageview

        $this->jqGridId_Prefix='idxjqgrid'; // prefix para id y _var del jqgrid y su pager
        $this->jqGridSaveState=true; // guarda grid state
        $this->jqGridFilters=true; // pone o quita filters de jqgrid
        $this->jqGridSearch=true; // pone o quita search de jqgrid

        $this->jqGridFiltersVisible = true;
        $this->jqGridSelectRows = true;
        $this->useJqueryValidate=false;
        $this->useFormChanged=true;
        $this->useBlockUI=true;

    }

    /**
     * Si en parametros viene un campo=valor, lo muestra o filtra segun $this->h
     * poner en construct
     *   $this->campos_final();
     *   $this->autoFiltraPorRequest();
     *   para grid ver app_pedido.php =>function listme_preRender($grid) y poner en
     *    en postRender     $(document).ready(function(){
     *                          jqGridFillToolBarFiltersFromPostData(gridhandler);
     *                        });
     * @return array con filtro solicitado en $_REQUEST
     */
    protected function autoFiltraPorRequest():array {
        if(empty($_REQUEST))
            return [];
        $this->h = $_REQUEST['iah'] ?? '';

        $esListGrid = $this->h === '' || $this->h === 'l';
        if(!$esListGrid && $this->h !== 'e'  && $this->h !== 'r'  && $this->h !== 'b')
            return [];
        $quiereFiltrar = array_intersect_key($_REQUEST,
            empty($this->autoFiltraOnly) ? $this->campos :
                array_intersect_key($this->campos,array_flip($this->autoFiltraOnly))
        );
        if(empty($quiereFiltrar))
            return [];

        if($esListGrid)
            return $quiereFiltrar;
        if(!empty(array_intersect_key($_REQUEST, [$this->pk_field=>1, 'id'=>1])))
            return [];
        $builder = new IacSqlBuilder();

        $ids = ia_sqlVector(
            "SELECT $this->pk_field FROM $this->table WHERE " . $builder->where($quiereFiltrar) . " ORDER BY 1 LIMIT 3" );
        if($ids === false)
            $ids = ['Sql Error'];
        switch(count($ids)) {
            case 1:
                $_REQUEST['id'] = $this->id = reset($ids); break;
            case 0:
                $_REQUEST['id'] = $this->id = "NOT FOUND"; break;
            default:
                $this->h = $_REQUEST['iah'] = '';
        }
        return $quiereFiltrar;
    }

    function toolbar_set($h=null,$imgPath=null,$extraParams=array(),$label_plural='' ) {
        global $gIAParametros, $gPermisoClick;

        if($imgPath==null)
            $imgPath='/img';
        parent::toolbar_set($h,$imgPath,$extraParams );

        //Ph.23-04-205
        $estoy_en_prices = false;
        if($this->table=='iac_log' || $this->table=='iac_log_view' || $this->table=='kv_record_log' || str_contains( $this->table, "_prices") )
        {
            unset( $this->toolbar['list']);
            unset( $this->toolbar['log']);
            unset( $this->toolbar['log_all']);
            if(param('table')!='')
                $this->label.=": ".to_label(param('table'));
            if(param('record')!='')
                $this->label.=": ".to_label(param('table'))." (record)";

            if(str_contains( $this->table, "_prices")){
                $estoy_en_prices = true;
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                unset( $this->toolbar['save']);
                unset( $this->toolbar['close']);
                unset( $this->toolbar['new_img']);
                unset( $this->toolbar['new_pdf']);
                unset( $this->toolbar['print']);
                unset( $this->toolbar['img']);
                unset( $this->toolbar['pdf']);
                unset( $this->toolbar['export_cardex']);
                unset( $this->toolbar['delete']);
                unset( $this->toolbar['delete_ask']);
                unset( $this->toolbar['read']);
                unset( $this->toolbar['edit']);
                unset( $this->toolbar['save_new']);
            }
        }
        if($this->table=='cuentat_mov') {
            unset( $this->toolbar['list']);
        }

        if( empty($this->h) && array_key_exists('orden',$this->campos)) {
            $urlToOrder = getUrlBase() . "backoffice/iac_orden.php";
            $this->toolbar['orden']="<a href='$urlToOrder?t=$this->table'><img src='$imgPath/sort.png' title='Reordenar' alt='Reordenar' /><br /><strong>Reordenar</strong></a>";
         }

        //CAMBIA SESSION/COPIAPROGRAMA
        global $gProgramName;
        $reload_button_nota_bodega = "";
        if($this->table == 'nota_bodega'){
            $reload_button_nota_bodega = '<br><a href="javascript:void(0);" onclick="location.reload();">
        <span class="fa-icon fa-solid fa-rotate-reverse txt_shadow_purple_ bold txt_2em"></span>
    </a>';
        }
        $this->toolbar['useris']=array('html'=>'<div id="logged_in_as_div" style="width:160px; max-width: 180px;"><strong>'.ia_htmlentities($_SESSION['usuario'])
        .'@<em><span class="txt_bold_brightred txt12px">'
        .$_SERVER['SERVER_NAME']
        .'</span></em><br /><span style="color:blue;">'.$gProgramName.'</strong>'.$reload_button_nota_bodega.'</div>', 'TDclass' => 'logged_in_as_toolbar');
        if(usuarioTipoRony($_SESSION['usuario_id']) && empty($this->h) && array_key_exists('orden',$this->campos)) {
            $urlToOrder = getUrlBase() . "backoffice/iac_orden.php";
            $this->toolbar['orden']="<a href='$urlToOrder?t=$this->table'><img src='$imgPath/sort.png' title='Reordenar' alt='Reordenar' /><br /><strong>Reordenar</strong></a>";
        }

        //Quitamos los que no queremos.
        if(array_key_exists('save_new',$this->toolbar))
            $this->toolbar['save_new']['condition']="return false;";
        if(array_key_exists('export_cardex',$this->toolbar))
            $this->toolbar['export_cardex']['condition']="return false;";
        if($this->table != 'banco_diccionario_dato')
            unset($this->toolbar['list']);
        if(array_key_exists('search',$this->toolbar))
            $this->toolbar['search']['condition']="return false;";


        /*
        if(array_key_exists('first',$this->toolbar))
            $this->toolbar['first']['condition']="return false;";
        if(array_key_exists('prev',$this->toolbar))
            $this->toolbar['prev']['condition']="return false;";
        if(array_key_exists('next',$this->toolbar))
            $this->toolbar['next']['condition']="return false;";
        if(array_key_exists('last',$this->toolbar))
            $this->toolbar['last']['condition']="return false;";
        */
        $estoy_en_bodega = !usuarioSupervisaBodega() && str_contains($_SERVER['REQUEST_URI'], 'bodega')
            && !str_contains($_SERVER['REQUEST_URI'], '/bodega.php')
            && !str_contains($_SERVER['REQUEST_URI'], '/permisos_bodega.php')
            && !str_contains($_SERVER['REQUEST_URI'], '/estado_bodega.php')
            && !str_contains($_SERVER['REQUEST_URI'], '/producto_bodega.php')
        ;
        //$estoy_en_bodega = false;
        $estoy_en_carta_porte =!usuarioSupervisaBodega() && str_contains($_SERVER['REQUEST_URI'], 'porte');
        $estoy_en_inversion = false;
        //Ponemos "los manuales"
        switch($this->table)
        {
            case 'cuenta_t_banco_tc_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='newItem();' id='iaNewItemClick' data-id='iaCtaTBancoTC' target='_self' ><img src='../img/icons/New.png' title='Nuevo Link de Tarjeta de Crédito' alt='Nuevo Link de Tarjeta de Crédito' /><br/><strong>Nuevo Link<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Links de Tarjetas de Crédito.';
            break;


            case 'cuenta_t_banco_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkCuentaTBancario();' id='iaNewItemClick' data-id='iaCtaTBanco' target='_self' ><img src='../img/icons/New.png' title='Nuevo Link de Cuenta T al Banco' alt='Nuevo Link de Cuenta T al Banco' /><br/><strong>Nuevo Link<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Links de Cuenta T al Banco.';

                if(false && puedeBancosChina())
                    $this->toolbar['addChina'] = array('html'=>"<a href='../backoffice/cuentat_a_china.php' id='iaNewItemChina' data-id='iaCtaTBanco' target='_self' ><img src='../img/icons/New.png' title='Nuevo Link de Cuenta T a China' alt='Nuevo Link de Cuenta T a a China' /><br/><strong>Nuevo Link<br/>a CHINA</strong></a>");

            break;

            case 'todo_a_banco_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkCuentaTBancario();' id='iaNewItemClick' data-id='iaCtaTBanco' target='_self' ><img src='../img/icons/New.png' title='Nuevo Link de Cuenta T al Banco' alt='Nuevo Link de Cuenta T al Banco' /><br/><strong>Nuevo Link<br/>(F3)</strong></a>");
                //$this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkCuentaTBancario();' id='iaNewItemClick' data-id='iaCtaTBanco' target='_blank' ><img src='../img/icons/New.png' title='Nuevo Link de Cuenta T a Cuenta Bancaria' alt='Nuevo Link de Cuenta T a Cuenta Bancaria' /><br/><strong>Nuevo Link<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Links de Todo al Banco.';
                $this->table_info['label_plural'].=brtbNotificaciones($this->table);

            break;

            case 'factura_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkCuentaTBancario();' id='iaNewItemClick' data-id='iaCtaTBanco' target='_self' ><img src='../img/icons/New.png' title='Nueva Solicitud de Factura' alt='Nueva Solicitud de Factura' /><br/><strong>Nueva Factura<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Solicitudes de Facturas.';
                $this->table_info['label_plural_extra']=brtbNotificaciones($this->table);

            break;

            case 'fiduciario_list':
                $puedeFiduciario = puedeFiduciario();

                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='agregarFiduciario();' id='iaNewItemClick' data-id='iaNuevoFiduciario'><img src='../img/icons/New.png' title='Nuevo Fiduciario Manual.' alt='Nuevo Fiduciario Manual.' /><br/><strong>Nuevo<br />Fiduciario</strong></a>");
                $this->toolbar['list'] = array('html'=>"<a href='fiduciario_contenedor_list.php'><img src='$imgPath/listado.png' title='Listado de Contenedores (Fiduciario)' alt='Listado de Contenedores (Fiduciario)' /><br/><strong>Contenedores<br/>(Fiduciario)</strong></a>");
                $this->toolbar['refund'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkFiduciario();'><img src='$imgPath/25-refund.png' title='Nuevo Reembolso de Fiduciario con Link.' alt='Nuevo Reembolso de Fiduciario con Link.' /><br/><strong>Nuevo<br />Reembolso</strong></a>");
                $this->toolbar['estado'] = array('html'=>"<a href='estado.php?origen=fiduciario' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Cambiar<br/>Estados</strong></a>");
                if(usuarioTipoRony()) $this->toolbar['param'] = array('html'=>"<a href='javascript:void(0);' onclick='mostrarConfig();' id='butMostrarConfig' onclick='mostrarConfig();'><img src='$imgPath/25-settings.png' title='Parámetros' alt='Parámetros' /><br/><strong>Parámetros</strong></a>");
                $this->toolbar['fid_reem'] = array('html'=>"<a href='fiduciario_reembolso.php' target='_blank'><img src='$imgPath/32-money_refund.png' title='Reembolsos de Fiduciario' alt='Reembolsos de Fiduciario'/><br/><strong>Reembolsos</strong></a>");
                $this->table_info['label_plural']='Movimientos de Fiduciario.';
                $this->table_info['label_field'] = $this->table_info['label_plural'].=brtbNotificaciones($this->table);

                if(!$puedeFiduciario){

                    //echo "<li>".$puedeFiduciario."@@@@";
                    unset( $this->toolbar['add']);
                    unset( $this->toolbar['refund']);
                }

            break;

            case 'fiduciario_contenedor_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['list'] = array('html'=>"<a href='fiduciario_list.php'><img src='$imgPath/listado.png' title='Movimientos de Fiduciario' alt='Movimientos de Fiduciario' /><br/><strong>Movimientos de <br/>Fiduciario</strong></a>");
                $this->toolbar['estado'] = array('html'=>"<a href='estado.php?origen=fiduciario_contenedor' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Cambiar<br/>Estados</strong></a>");
                $this->toolbar['fid_reem'] = array('html'=>"<a href='fiduciario_reembolso.php' target='_blank'><img src='$imgPath/32-money_refund.png' title='Reembolsos de Fiduciario' alt='Reembolsos de Fiduciario'/><br/><strong>Reembolsos</strong></a>");
                $this->table_info['label_plural']='Contenedores de Fiduciario.';
                $this->table_info['label_plural'].=brtbNotificaciones($this->table);

            break;

            case 'inversion_list':
                $estoy_en_inversion = true;
                $puedeInversion = puedeInversion();

                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='agregarInversion();' id='iaNewItemClick' data-id='iaNuevoFiduciario' class='txt_shadow_azul_marino tooltip_toolbar' title='<div class=\"txt_1_1em ui_tooltip_remarks_por_usuario\">Nueva Inversion Manual</div>'><img src='../img/icons/New.png' alt='Nueva Inversion Manual.' /><br/><strong>Nueva<br />Inversión</strong></a>");

                //VCA Rony Inversion 14-10-2021
                //VCA 23-03-2022 $_SESSION['usuario_id'] == 1 se vuelve usuarioTipoRony()
                $permiso_nueva_inversion_informativa = Permisador::puede(Permisador::nueva_inversion_informativa, 'No');
                $puede_nueva_inversion_informativa = usuarioTipoRony() || $permiso_nueva_inversion_informativa === 'Si';

                $permiso_puede_nueva_inversion_interes = Permisador::puede(Permisador::nueva_inversion_interes, 'No');
                $puede_nueva_inversion_interes = usuarioTipoRony() || $permiso_puede_nueva_inversion_interes === 'Si';


                if($puede_nueva_inversion_informativa)
                    $this->toolbar['add_inf'] = array('html'=>"<a href='javascript:void(0);' onclick='agregarInversion(\"info\");' class='txt_shadow_violeta txt_1_1em tooltip_toolbar' title='<div class=\"ui_tooltip_inversion_informativa\">Nueva Inversion Informativa</div>'><img src='$imgPath/32-add.png' alt='Nueva Inversion Informativa.' /><br/><strong>Inversión<br />Informativa</strong></a>" . $gPermisoClick('puede_nueva_inversion_informativa', '', true));

                if($puede_nueva_inversion_interes)
                    $this->toolbar['add_int'] = array('html'=>"<a href='javascript:void(0);' onclick='agregarInversion(\"interes\");' class='txt_shadow_rosa tooltip_toolbar' title='<div class=\"ui_tooltip_inversion_ajuste\">Nueva Inversion de Interés</div>' alt='Nueva Inversion de Interés.'><img src='$imgPath/profit-growth.png'/><br/><strong>Inversión<br />Interés</strong></a>" . $gPermisoClick('puede_nueva_inversion_interes', '', true));


                $this->toolbar['refund'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkInversion();'><img src='$imgPath/25-refund.png' title='Nuevo Reembolso de Inversion con Link.' alt='Nuevo Reembolso de Inversion con Link.' /><br/><strong>Nuevo<br />Reembolso</strong></a>");
                $this->toolbar['estado'] = array('html'=>"<a href='estado.php?origen=inversion' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Cambiar<br/>Estados</strong></a>");
                if(usuarioTipoRony()) $this->toolbar['param'] = array('html'=>"<a href='javascript:void(0);' onclick='mostrarConfig();' id='butMostrarConfig' onclick='mostrarConfig();'><img src='$imgPath/25-settings.png' title='Parámetros' alt='Parámetros' /><br/><strong>Parámetros</strong></a>");

                $tipo_inversion_empresa_privada = param('tipo_inversion_empresa_privada', 'empresa');

                $this->toolbar['inv_reem'] = array('html'=>"<a href='inversion_reembolso.php?tipo_inversion_empresa_privada=$tipo_inversion_empresa_privada' target='_blank'><img src='$imgPath/32-money_refund.png' title='Reembolsos de Inversión' alt='Reembolsos de Inversión'/><br/><strong>Reembolsos</strong></a>");
                //$this->table_info['label_plural']='Saldos de Todas las Cuentas Bancarias.';
//                $this->table_info['label_plural']='Apertura de Inversión.';
                $this->table_info['label_field'] = $this->table_info['label_plural'].=brtbNotificaciones($this->table);

                if(!$puedeInversion){
                    unset( $this->toolbar['add']);
                    unset( $this->toolbar['refund']);
                }

                break;

            case 'inversion_reembolso':
                $this->toolbar['inversiones'] = array('html'=>"<a href='inversion_list.php' target='_blank'><img src='$imgPath/32-inversiones.png' title='Inversiones' alt='Inversiones'/><br/><strong>Inversiones</strong></a>");
                break;

            case 'cuenta_t_banco':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Solicitar un Link de Cuenta T al Banco.';
                $this->toolbar['close'] = array('TDid'=>'iac_cardex_close', 'html'=>"<a href='javascript:void(0);' onclick='closewin();' id='iaCloseItem' title='Cerrar ventana para ver el listado' target='_blank'><img src='$imgPath/tache_rojo.png' /><br/><strong>Cerrar</strong></a>");
            break;

            case 'banco_a_banco_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='newItem();' id='iaNewItemClick' data-id='iaBancoaBanco' onclick='nuevoLinkentreCuentasBancarias();'><img src='../img/icons/New.png' title='Nuevo Link entre Cuentas Bancarias.' alt='Nuevo Link entre Cuentas Bancarias.' /><br/><strong>Nuevo Link<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Links entre Cuentas Bancarias.';
            break;

            case 'banco_a_banco':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Nuevo Link entre Cuentas Bancarias.';
                $this->toolbar['close'] = array('TDid'=>'iac_cardex_close', 'html'=>"<a href='#' onclick='closewin();' id='iaCloseItem' title='Cerrar ventana para ver el listado'><img src='$imgPath/tache_rojo.png' /><br/>Cerrar <strong>(F4)</strong></a>");
            break;

            case 'banco_cuenta_mov':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='ORIGINAL';
                $this->table_info['label_plural'].=brtbNotificaciones($this->table);
                $this->toolbar['first'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"first\");' id='iaFirstListItem' data-id='banco_cuenta_id' title='Ir a la primera Cuenta Bancaria'><img src='../$imgPath/icons/First.png' alt='Primera Cuenta Bancaria' title='Primera Cuenta Bancaria' /><br/><strong>Primera</strong></a>");
                $this->toolbar['prev'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"prev\");' id='iaPrevListItem' data-id='banco_cuenta_id' title='Ir a la anterior Cuenta Bancaria'><img src='../$imgPath/icons/Back.png' alt='Anterior Cuenta Bancaria' title='Anterior Cuenta Bancaria' /><br/><strong>Anterior</strong></a>");
                $this->toolbar['next'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"next\");' id='iaNextListItem' data-id='banco_cuenta_id' title='Ir a la siguiente Cuenta Bancaria'><img src='../$imgPath/icons/Forward.png' alt='Siguiente Cuenta Bancaria' title='Siguiente Cuenta Bancaria' /><br/><strong>Siguiente</strong></a>");
                $this->toolbar['last'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"last\");' id='iaLastListItem' data-id='banco_cuenta_id' title='Ir a la última Cuenta Bancaria'><img src='../$imgPath/icons/Last.png' alt='Última Cuenta Bancaria' title='Última Cuenta Bancaria' /><br/><strong>Última</strong></a>");
            break;
/*
            case 'mov_verificado_con_links':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='VERIFICACIÓN';
                $this->toolbar['first'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"first\");' id='iaFirstListItem' data-id='banco_cuenta_id' title='Ir a la primera Cuenta Bancaria'><img src='$imgPath/first.png' alt='Primera Cuenta Bancaria' title='Primera Cuenta Bancaria' /><br/><strong>Primera</strong></a>");
                $this->toolbar['prev'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"prev\");' id='iaPrevListItem' data-id='banco_cuenta_id' title='Ir a la anterior Cuenta Bancaria'><img src='$imgPath/previous.png' alt='Anterior Cuenta Bancaria' title='Anterior Cuenta Bancaria' /><br/><strong>Anterior</strong></a>");
                $this->toolbar['next'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"next\");' id='iaNextListItem' data-id='banco_cuenta_id' title='Ir a la siguiente Cuenta Bancaria'><img src='$imgPath/next.png' alt='Siguiente Cuenta Bancaria' title='Siguiente Cuenta Bancaria' /><br/><strong>Siguiente</strong></a>");
                $this->toolbar['last'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"last\");' id='iaLastListItem' data-id='banco_cuenta_id' title='Ir a la última Cuenta Bancaria'><img src='$imgPath/last.png' alt='Última Cuenta Bancaria' title='Última Cuenta Bancaria' /><br/><strong>Última</strong></a>");
            break;
*/
            case 'gastos_banco_list':

                /*$grid_normal = param('normal', 'SI');
                $usuario_revisor_id = param('user_id', 0);

                $origen = "banco_cuenta_mov_asignacion";

                $titulo_replace = 'WITHDRAWALS';

                $revisar_txt = "";

                if($grid_normal == 'NO' && $usuario_revisor_id) {
                    $usuario_revisor_id = empty($usuario_revisor_id) ? $usuario_id : $usuario_revisor_id;
                    $query = "SELECT clave FROM estado WHERE usuario_id = $usuario_revisor_id AND origen = '$origen'";
                    $usuario_revisor = ia_singleread($query);
                    $revisar_txt = $grid_normal == 'NO' ? "<span class='txt18px txt_color_red bold'>REVISAR $titulo_replace DE </span><span class='txt18pxfr txt_color_PESOS bold'>$usuario_revisor</span>" : "";
                }

//                $this->title(empty($revisar_txt) ? $titulo_replace : $titulo_replace);
                $label = (empty($revisar_txt) ? $titulo_replace : $revisar_txt);
                */

                $a_asignacion = usuarioTipoRony() ? "<br/><a href='estado.php?origen=banco_cuenta_mov_asignacion' target='_blank' ><strong>Revisores</strong></a>" : "";
                $a_supervision = usuarioTipoRony() ? "<br/><a href='estado.php?origen=banco_cuenta_mov_supervision' target='_blank' ><strong>Supervisiones</strong></a>" : "";
                $label = "WITHDRAWALS";
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']= "";
                //$this->table_info['label_plural'].=brtbNotificaciones($this->table);
                if(usuarioTipoRony())
                    $this->toolbar['estado'] = array('html'=>"<a href='estado.php?origen=banco_cuenta_mov&script=withdrawals_de_banco_list' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Estados</strong></a>$a_asignacion$a_supervision");
                /*$this->toolbar['asignacion'] = array('html'=>);
                $this->toolbar['supervision'] = array('html'=>"<a href='estado.php?origen=banco_cuenta_mov_supervision' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Supervisiones' alt='Cambiar Supervisiones' /><br/><strong>Cambiar<br/>Supervisiones</strong></a>");*/
                //$this->toolbar['first'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"first\");' id='iaFirstListItem' data-id='banco_cuenta_id' title='Ir a la primera Cuenta Bancaria'><img src='$imgPath/first.png' alt='Primera Cuenta Bancaria' title='Primera Cuenta Bancaria' /><br/><strong>Primera<br/>(Alt+P)</strong></a>");
                //$this->toolbar['prev'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"prev\");' id='iaPrevListItem' data-id='banco_cuenta_id' title='Ir a la anterior Cuenta Bancaria'><img src='$imgPath/previous.png' alt='Anterior Cuenta Bancaria' title='Anterior Cuenta Bancaria' /><br/><strong>Anterior<br/>(Alt+A)</strong></a>");
                //$this->toolbar['next'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"next\");' id='iaNextListItem' data-id='banco_cuenta_id' title='Ir a la siguiente Cuenta Bancaria'><img src='$imgPath/next.png' alt='Siguiente Cuenta Bancaria' title='Siguiente Cuenta Bancaria' /><br/><strong>Siguiente<br/>(Alt+S)</strong></a>");
                //$this->toolbar['last'] = array('html'=>"<a href='javascript:void(0);' onclick='eligeBancoCuenta(\"last\");' id='iaLastListItem' data-id='banco_cuenta_id' title='Ir a la última Cuenta Bancaria'><img src='$imgPath/last.png' alt='Última Cuenta Bancaria' title='Última Cuenta Bancaria' /><br/><strong>Última<br/>(Alt+U)</strong></a>");

            break;

            case 'links_pendientes':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Links Pendientes.';
            break;
            case 'cliente_saldo':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Estado de Cuenta de Cliente';
            break;

            case 'cuentat_gasto_list':

                $grid_normal = param('normal', 'SI');
                $usuario_revisor_id = param('user_id', 0);

                $titulo_replace = 'GASTOS DE CUENTA T';

                $origen = "cuentat_gasto_asignacion";

                $revisar_txt = "";

                if($grid_normal == 'NO' && $usuario_revisor_id) {
                    $usuario_revisor_id = empty($usuario_revisor_id) ? $usuario_id : $usuario_revisor_id;
                    $query = "SELECT clave FROM estado WHERE usuario_id = $usuario_revisor_id AND origen = '$origen'";
                    $usuario_revisor = ia_singleread($query);
                    $revisar_txt = $grid_normal == 'NO' ? "<span class='txt14px txt_color_red bold'>REVISAR $titulo_replace DE </span><span class='txt17px txt_color_PESOS bold'>$usuario_revisor</span>" : "";
                }

//                $this->title(empty($revisar_txt) ? $titulo_replace : $titulo_replace);
                $label = (empty($revisar_txt) ? $titulo_replace : $revisar_txt);

                $a_asignacion = usuarioTipoRony() ? "<br/><a href='estado.php?origen=cuentat_gasto_asignacion' target='_blank' ><strong>Revisores</strong></a>" : "";
                $a_supervision = usuarioTipoRony() ? "<br/><a href='estado.php?origen=cuentat_gasto_supervision' target='_blank' ><strong>Supervisiones</strong></a>" : "";

                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='newItem();' id='iaNewItem' data-id='iaCtaTGasto' target='_self' ><img src='../img/icons/New.png' title='Nuevo Gasto de Cuenta T' alt='Nuevo Gasto de Cuenta T' /><br/><strong>Nuevo Gasto<br/>(F3)</strong></a>");
                $this->toolbar['addTmplt'] = array('html'=>"<a href='javascript:void(0);' onclick='newItem(\"SI\");' id='iaNewItemTmplt' data-id='iaCtaTGasto' target='_self' ><img src='$imgPath/32-nuevo-azul.png' title='Nuevo Gasto de Cuenta T con Plantilla' alt='Nuevo Gasto de Cuenta T con Plantilla' /><br/><strong>Nvo Gasto<br/>con Plantilla</strong></a>");
                $this->table_info['label_plural']=$label;
                $this->table_info['label_plural'].=brtbNotificaciones($this->table);

                if(usuarioTipoRony())
                    $this->toolbar['estado'] = array('html'=>"<a href='estado.php?origen=cuentat_gasto' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Estados</strong></a>$a_asignacion$a_supervision");
/*
                $this->toolbar['estado'] = array('html'=>"<a href='estado.php?origen=cuentat_gasto' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Estados' alt='Cambiar Estados' /><br/><strong>Cambiar<br/>Estados</strong></a>");
                
                $this->toolbar['asignacion'] = array('html'=>"<a href='estado.php?origen=cuentat_gasto_asignacion' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Asignaciones' alt='Cambiar Asignaciones' /><br/><strong>Cambiar<br/>Asignaciones</strong></a>");
                $this->toolbar['supervision'] = array('html'=>"<a href='estado.php?origen=cuentat_gasto_supervision' target='_blank' ><img src='$imgPath/32-status-change.png' title='Cambiar Supervisiones' alt='Cambiar Supervisiones' /><br/><strong>Cambiar<br/>Supervisiones</strong></a>");*/

                $this->toolbar['tiempo'] = array('html'=>"<a href='".(usuarioTipoRony()?"iac_parametros.php?id=1&iah=e":"#")."' target='".(usuarioTipoRony()?"_blank":"_self")."' title='Tiempo para Modificar/Cancelar' ><img src='$imgPath/32-sand-watch.png' title='Tiempo para Modificar/Cancelar' alt='Tiempo para Modificar/Cancelar' /><br/><strong>$gIAParametros[tiempo_para_borrar_gasto_cuentat] min</strong></a>");

            break;
            case 'estado':
                $origen = param('origen');
                if (empty($origen)) {
                    $this->table_info['label_plural']='Estados';
                } else {
                    if ($origen == 'banco_cuenta_mov_supervision') $this->table_info['label_plural']='Supervisores de retiros del banco';
                    if ($origen == 'banco_cuenta_mov_asignacion') $this->table_info['label_plural']='Revisores de retiros del banco';
                    if ($origen == 'cuentat_gasto_supervision') $this->table_info['label_plural']='Supervisores de gastos de cuenta T';
                    if ($origen == 'cuentat_gasto_asignacion') $this->table_info['label_plural']='Revisores de gastos de cuenta T';
                }
            break;
            case 'cuentat_gasto':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Nuevo Gasto de Cuenta T.';
                $this->toolbar['close'] = array('TDid'=>'iac_cardex_close', 'html'=>"<a href='javascript:void(0);' onclick='closewin();' id='iaCloseItem' title='Cerrar ventana para ver el listado'><img src='$imgPath/tache_rojo.png' /><br/>Cerrar <strong>(F4)</strong></a>");

            break;

            case 'movimiento_divisa_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Movimientos con Tipo de Cambio.';
                $this->toolbar['list'] = array('html'=>'<a href="../backoffice/tc_log.php" target="_blank" class="bold txt_1_1em toolbar_vales tooltip_toolbar_wohtml" title="Bitácora de Tipos de Cambio" ><span style="margin-top: 2px; margin-right: 3px;" class="bold fa-duotone fa-books txt_1_8em toolbar_vales"></span><br>Log</a>');
            break;

            case 'cuentat_ingreso_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='newItem();' id='iaNewItem' data-id='iaCtaTIngreso' target='_self' ><img src='../img/icons/New.png' title='Nuevo Ingreso Directo a Cuenta T' alt='Nuevo Ingreso Directo a Cuenta T' /><br/><strong>Nuevo Ingreso <br/>Directo a Cuenta T (F3)</strong></a>");
                $this->table_info['label_plural']='Ingresos Directos a Cuenta T.';
            break;

            case 'cuentat_ingreso':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Nuevo Ingreso Directo a Cuenta T';
                $this->toolbar['close'] = array('TDid'=>'iac_cardex_close', 'html'=>"<a href='javascript:void(0);' onclick='closewin();' id='iaCloseItem' title='Cerrar ventana para ver el listado'><img src='$imgPath/tache_rojo.png' /><br/>Cerrar <strong>(F4)</strong></a>");
            break;

            case 'cuentat_ingreso_xtienda_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='newItem();' id='iaNewItem' data-id='iaCtaTIngreso' target='_self' ><img src='../img/icons/New.png' title='Nuevo Ingreso por Venta de Tienda' alt='Nuevo Ingreso por Venta de Tienda' /><br/><strong>Nuevo Ingreso<br/>por Venta de Tienda (F3)</strong></a>");
                $this->table_info['label_plural']='Ingresos Directos a Cuenta T por Venta de Tienda.';
                $this->toolbar['tiempo'] = array('html'=>"<a href='".(usuarioTipoRony()?"iac_parametros.php?id=1&iah=e":"#")."' target='".(usuarioTipoRony()?"_blank":"_self")."' title='Tiempo para Cancelar'><img src='$imgPath/32-sand-watch.png' title='Tiempo para Cancelar' alt='Tiempo para Cancelar' /><br/><strong>$gIAParametros[tiempo_para_borrar_gasto_cuentat] min</strong></a>");
            break;

            case 'cuentat_ingreso_xtienda':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Nuevo Ingreso por Venta de Tienda';
                $this->toolbar['close'] = array('TDid'=>'iac_cardex_close', 'html'=>"<a href='javascript:void(0);' onclick='closewin();' id='iaCloseItem' title='Cerrar ventana para ver el listado'><img src='$imgPath/tache_rojo.png' /><br/>Cerrar <strong>(F4)</strong></a>");
            break;

            case 'saldos_cuentas_t':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['pdf'] = array('html'=>"<a href='javascript:void(0);' onclick='cuentasT2Export(\"PDF\");' title='PDF' target='_blank'><img src='$imgPath/32-pdf.png' alt='PDF' title='PDF' /><br/><strong>PDF</strong></a>");
                $this->toolbar['xls'] = array('html'=>"<a href='javascript:void(0);' onclick='cuentasT2Export(\"XLS\");' title='Excel' target='_blank'><img src='$imgPath/32-xls.png' alt='Excel' title='Excel' /><br/><strong>Excel</strong></a>");
              //  $this->toolbar['doc'] = array('html'=>"<a href='javascript:void(0);' onclick='cuentasT2Export(\"DOC\");' title='Word' target='_blank'><img src='$imgPath/32-doc.png' alt='Word' title='Word' /><br/><strong>Word</strong></a>");
                $this->table_info['label_plural']='Resumen de Cuentas T.';
            break;

            case 'ajuste_cuentat':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Ajuste de Cuentas T.';
            break;

            case 'perfil_reporte_grid_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                if(puedePermisoUsuario('','puede_modificar_reportes_grid'))
                    $this->toolbar['add'] = array('html'=>"<a href='../backoffice/perfil_reporte_grid_edit.php' id='iaNewItem' data-id='iaPerfilReporte' target='_blank' ><img src='../img/icons/New.png' title='Nuevo Perfil para Reporte.' alt='Nuevo Perfil para Reporte.' /><br/><strong>Nuevo Perfil<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Perfiles para Reportes en PDF, XLS y DOC.';
            break;

            case 'perfil_reporte_grid_edit':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']=$label_plural;

                if(puedePermisoUsuario('','puede_modificar_reportes_grid'))
                {
                    $this->toolbar['save'] = array('html'=>"<a href='javascript:void(0);' onclick='guardaPerfilReporteGrid();' id='iaGuardar' title='Guardar Perfil'><img src='$imgPath/guardar.png' /><br/>Guardar Perfil <strong>(F2)</strong></a>");
                    $this->toolbar['close'] = array('TDid'=>'iac_cardex_close', 'html'=>"<a href='javascript:void(0);' onclick='closewin();' id='iaCloseItem' title='Cerrar ventana para ver el listado'><img src='$imgPath/tache_rojo.png' /><br/>Cerrar <strong>(F4)</strong></a>");
                }
            break;

            case 'limpiar_prog':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']=$label_plural;
            break;

            case 'comparacion_banco':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Comparación de Movimientos Bancarios.';
            break;

            case 'file2EdoCta':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Importar Estado de Cuenta.';
            break;

            case 'saldos_bancos':
            case 'ingresos_bancos':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['saldosxempresa'] = array('html'=>"<a href='bancos_empresa_saldos.php'><img src='$imgPath/32-balance.png' title='Saldos por Empresa' alt='Saldos por Empresa' /><br/><strong>Saldos<br/>por Empresa</strong></a>");
                $this->table_info['label_plural']='Saldos de Todas las Cuentas Bancarias.';
                break;

            case 'saldos_bancos_empresa':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->toolbar['saldos'] = array('html'=>"<a href='bancos_saldos.php'><img src='$imgPath/32-balance.png' title='Saldos por Cuenta' alt='Saldos por Cuenta' /><br/><strong>Saldos<br/>por Cuenta</strong></a>");
                $this->toolbar['ingresosxempresa'] = array('html'=>"<a href='bancos_empresa_ingresos.php'><img src='$imgPath/32-balance.png' title='Saldos por Empresa' alt='Saldos por Empresa' /><br/><strong>Ingresos<br/>por Empresa</strong></a>");
                $this->table_info['label_plural']='Saldos de las Cuentas por Empresa.';
            break;

            case 'doctos':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']='Cheques, Pagarés y Vales.';
                // $this->table_info['label_plural_extra']=brtbNotificaciones($this->table);
            break;

            case 'permiso_ctat':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                $this->table_info['label_plural']=$label_plural;
                $this->table_info['label_plural'].="<div id='divirPermiso' style='margin-top: 12px;'>
Ir a permisos por: <select id='irPermisos' class='ui-front'>
<option value='permiso_usuario_generales.php' style='color:blue' ".($label_plural=="Permisos Generales"?"selected='selected'":"")." >Permisos Generales</option>
<option value='permiso_usuario_banco_cuenta.php' style='color:blue' ".($label_plural=="Permisos de Usuarios en Bancos"?"selected='selected'":"")." >Usuarios en Bancos</option>
<option value='permiso_usuario_cuenta_t.php' style='color:blue' ".($label_plural=="Permisos de Usuarios en Cuentas T"?"selected='selected'":"")." >Usuarios en Cuentas T</option>
<option value='permiso_usuario_cobranza_tienda.php' style='color:blue' ".($label_plural=="Permisos de Usuarios en Tiendas"?"selected='selected'":"")." >Usuarios en Tiendas</option>
<option value='permiso_banco_cuenta_usuario.php' ".($label_plural=="Permisos en Bancos por Usuarios"?"selected='selected'":"")." >Bancos por Usuarios</option>
<option value='permiso_cuenta_t_usuario.php' ".($label_plural=="Permisos en Cuenta T por Usuarios"?"selected='selected'":"")." >Cuentas T por Usuarios</option>
<option value='permiso_cobranza_tienda_usuario.php' ".($label_plural=="Permisos en Tiendas por Usuarios"?"selected='selected'":"")." >Tiendas por Usuarios</option>
</select>
</div>";

            break;

            case 'cuentat_transfer_list':
                unset( $this->toolbar['list']);
                unset( $this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                unset( $this->toolbar['add']);
                unset( $this->toolbar['find']);
                unset( $this->toolbar['search']);
                //$this->toolbar['add'] = array('html'=>"<a href='javascript:void(0);' onclick='nuevoLinkCuentaTBancario();' id='iaNewItemClick' data-id='iaCtaTBanco' target='_blank' ><img src='../img/icons/New.png' title='Nuevo Link de Cuenta T a Cuenta Bancaria' alt='Nuevo Link de Cuenta T a Cuenta Bancaria' /><br/><strong>Nuevo Link<br/>(F3)</strong></a>");
                $this->table_info['label_plural']='Transferencias entre Cuentas T.';
                $this->table_info['label_plural'].=brtbNotificaciones($this->table);

            break;

            case 'clientes_saldos':
                unset($this->toolbar['list']);
                unset($this->toolbar['log']);
                unset($this->toolbar['log_all']);
                unset($this->toolbar['add']);
                unset($this->toolbar['find']);
                unset($this->toolbar['search']);
                unset($this->toolbar['orden']);
                unset($this->toolbar['log_all']);
                //$this->table_info['label_plural_extra']='Clientes Saldos';
                $this->table_info['label_plural_extra']=brtbNotificaciones($this->table);
                //die("<pre>" . print_r($this, true) . "</pre>");
                break;

            case 'nota_bodega':
                $estoy_en_bodega = true;
                $es_solicitud_carta_porte = $this->es_solicitud_carta_porte ?? false;
                if (!$es_solicitud_carta_porte) {
                    unset($this->toolbar['add'] );
                    //  if (!($this->es_salidas_para_tiendas??false)) {
                        //  if ($this->permiso_insert) {
                         //   $this->toolbar['add'] = array('html' => "<a href='javascript:dialogConsultarExistencia.dialog_consulta_nota();' id='iaNewItem' target='_self' class='toolbar_notas_bodega'><img src='../img/icons/New.png' title='Nueva Nota' alt='Nueva Nota' /><br/><strong>Nueva Nota</strong></a>");
                        //  }
                    //   }
                    $this->table_info['label_plural']='NOTAS';
                    $this->table_info['label_plural_extra']= brtbNotificaciones($this->table, $this);
                }
                break;
            case 'nota_bodega_verificacion':
                $estoy_en_bodega = true;
                if ($this->permiso_insert) {
                    $this->toolbar['add'] = array('html'=>"<a href='javascript:agregarNuevaNotaVerificacion()' id='iaNewItem' target='_self' ><img src='../img/icons/New.png' title='Nueva Nota de Verificación' alt='Nueva Nota de Verificación' /><br/><strong>Nueva Nota de Verificación<br/>(F3)</strong></a>");
                }
                $this->table_info['label_plural']='VERIFICACIONES';
                $this->table_info['label_plural_extra']= brtbNotificaciones($this->table);
                break;
            case 'color':
                $this->table_info['label_plural']='COLORES';
                $this->table_info['label_plural_extra']= brtbNotificaciones($this->table);
                $this->toolbar['add_grupo'] = array('html'=>"<div style='display:flex; gap: 10px'><div title='Grupos de colores' style='cursor:pointer; margin-top:8px;' onclick='dialogAgrupador()'><i class='fa-duotone fa-paint-roller' style='font-size: 1rem;'></i><p style='font-size: 12px;margin: 0; margin-top: 5px'>Grupos de <br> colores</p></div> <div id='div_filter_color'><div onclick='inicializandoFilterGroup();' title='Filtrar grid'  style='cursor:pointer;'> <i class='fa-duotone fa-filters fa-xl' style=' padding: 0.8rem;font-size: 1.5rem;margin-top:5px; --fa-primary-color: #a9692d; --fa-secondary-color: #b88656;'></i><p style='font-size: 12px;'>Filtrar por <br> grupos</p></div></div> </div>");
                break;
            case 'producto_general':
                $this->toolbar['add_grupo'] = array('html'=>"<div style='display:flex; gap: 20px'><div title='Grupos de productos' style='cursor:pointer; margin-top:5px;font-size: 0.8rem;' onclick='dialogAgrupador()'><i class='fa-duotone fa-boxes-packing' style='font-size: 1.5rem;background: #f9f9e5;color: #b76e0f;padding: 5px;border-radius: 5px;border: 2px #b76e0f solid;'></i><p style='margin: 0; margin-top: 5px; font-size: 0.8rem;font-weight: bold;color: #7f5900;'>Grupos</p></div><div id='div_filter_color'><div onclick='inicializandoFilterGroup();' title='Filtrar por productos'  style='cursor:pointer;'> <i class='fa-duotone fa-filters fa-xl' style=' padding: 0.8rem;font-size: 1.5rem;margin-top:5px; --fa-primary-color: #a9692d; --fa-secondary-color: #b88656;'></i><p style='margin: 0;margin-top: 5px;font-size: 0.8rem;font-weight: bold;color: #7f5900;'>Filtrar por <br> grupos</p></div> </div>");
                break;
            case 'iac_usr':
                $this->toolbar['add_grupo'] = array('html'=>"<div style='display:flex; gap: 20px'><div style='cursor:pointer; margin-top:5px;font-size: 0.8rem;' onclick='dialogAgrupador()'><i class='fa-duotone fa-users-viewfinder' style='font-size: 1.5rem;background: #f9f9e5;color: #b76e0f;'></i><p style='margin: 0; margin-top: 5px; font-size: 0.8rem;font-weight: bold;color: #7f5900;'>Grupos</p></div><div id='div_filter_color'><div onclick='inicializandoFilterGroup();'  style='cursor:pointer;'> <i class='fa-duotone fa-filters fa-xl' style=' padding: 0.8rem;font-size: 1.5rem;margin-top:5px; --fa-primary-color: #a9692d; --fa-secondary-color: #b88656;'></i><p style='margin: 0;margin-top: 5px;font-size: 0.8rem;font-weight: bold;color: #7f5900;'>Filtrar por <br> grupos</p></div> </div>");
                break;
            

            case 'solicitud_carta_porte':
                $estoy_en_bodega = true;
                $this->toolbar['add'] = array('html'=>"<a href='../tienda/solicitar_carta_porte.php' id='iaNewItem' target='_self' ><img src='../img/icons/New.png' title='Solicitar' alt='Solicitar' /><br/><strong>Nueva Solicitud<br/>(F3)</strong></a>");
                $this->toolbar['list'] = array('html'=>"<a href='../backoffice/solicitud_carta_porte.php' id='iaList' target='_blank' ><img src='$imgPath/32-docs-azules.png' title='Solicitudes de Carta Porte' alt='Solicitudes de Carta Porte' /><br/><strong>Cartas Porte</strong></a>");
                // $this->table_info['label_plural']='NOTAS';
                $this->table_info['label_plural_extra']= brtbNotificaciones($this->table);

                unset($this->toolbar['log']);
                unset( $this->toolbar['log_all']);
                break;

            case 'movimientos':
                $estoy_en_bodega = true;
                $claves_para_verificacion = ['VERIFICACIÓN', 'verificación', 'Verificación', 'VERIFICACION', 'verificacion', 'Verificacion'];
                $es_verificacion = false;
                foreach ($claves_para_verificacion as $clave) {
                    if (str_contains($this->table_info['label_plural_extra'], $clave)) {
                        $es_verificacion = true;
                        break;
                    }
                }
                $file_destino = "nota_bodega.php";
                $file_destino_consult = "edita_movimiento.php";
                if ($es_verificacion) {
                    $file_destino = "nota_bodega_verificacion.php";
                    $file_destino_consult = "edita_verificacion.php";
                    // unset($this->toolbar['pdf']);
                }
                $extra_params = [];
                $_app_prefix = param('_app_prefix');
                if (!empty($_app_prefix))
                    $extra_params['_app_prefix'] = $_app_prefix;

                $extra_params = (!empty($extra_params)) ? "&".http_build_query($extra_params):'';

                // dd_($this->toolbar);
                if (empty($this->h))
                    $this->h = 'a';

                $abre_notas_bodega_func = "abre_notas_bodega";
                if ($this->h == 'e' || $this->h == 'a') {
                    $this->toolbar['read'] = array('html'=>"<a href='javascript:goToReadNote(\"./$file_destino_consult?iah=r$this->paramsAmp$extra_params\")' title='Ver'><img src='$imgPath/ver.png' alt='Consultar' title='Ver' /><br />Consultar</a>");
                    $this->toolbar['print'] = array('html'=>"<a href='javascript:void(0);' id='a_print_nota' onclick='print_nota();' title='Print' target='_self'><img src='../img/icons/printer.png' alt='Print' title='Print' /><br/><strong>Print</strong></a>");

                    $iah = param('iah', 'e');
                    // if ($iah === 'e')
                    if (!$es_verificacion) {
                        /*$this->toolbar['print']['html'] = "<div style='display: flex; justify-content: space-around;'><a href='javascript:void(0);' onclick='cancelarNota();' title='Cancelar Nota' target='_self' id='a_cancelar_nota'><img src='../img/16-blocked.png' alt='Cancel' title='Cancelar Nota' /><br/><strong>Cancelar</strong></a>". $this->toolbar['print']['html'] ??''. "</div>";*/
                        /*$this->toolbar['cancelar'] = array('html'=>"<a href='javascript:void(0);' onclick='cancelarNota();' title='Cancelar Nota' target='_self' id='a_cancelar_nota'><img src='../img/16-blocked.png' alt='Cancel' title='Cancelar Nota' /><br/><strong>Cancelar</strong></a>");*/
                        if($_REQUEST['_app_prefix'] ?? '' === 'archive_')
                            $cancelar = '';
                        else
                            $cancelar = "<a href='javascript:void(0);' onclick='cancelarNota();' title='Cancelar Nota' target='_self' id='a_cancelar_nota'><img src='../img/icons/No.png' alt='Cancel' title='Cancelar Nota' /><br/><strong>Cancelar</strong></a>";

                        // dd_($this->enDB);

                        // $this->toolbar['delete_ask']['condition'] = "return \$this->may_delete();";
                        /*$this->toolbar['delete_ask']['html'] = "<a href='../backoffice/nota_bodega.php?iah=b&iaid=$this->id$this->paramsAmp' title='Solicitar Borrar este registro'><img alt='Borrar' src='/img/borrar.png' title='Solicitar Borrar este registro' /><br />Borrar</a>";*/
                        // $this->toolbar['delete_ask']['condition'] = "return false;";
                        // if (usuarioTipoRony())
                        //     $this->toolbar['delete_ask']['condition'] = "return true;";
                        // elseif (usuarioSupervisaBodega()) {
                        //     $this->toolbar['delete_ask']['condition'] = "return true;";
                        // }
                        $this->toolbar['delete_ask']['condition'] = "return true;";
                        $this->toolbar['delete_ask']['html'] = "<a href='javascript:void(0);' onclick='borrarNota()' title='Solicitar Borrar este registro' id='a_borrar_nota' style='visibility: hidden'><img alt='Borrar' src='/img/borrar.png' title='Solicitar Borrar este registro' /><br />Borrar</a>";

                        // Permiso para editar notas
                        /*$bodegas_id_permiso = array_keys($this->bodegas_puede_hacer_movimientos);
                        if ($this->puede_editar_notas || $this->puede_editar_campos_cash) {
                            if (in_array($this->values['bodega_id']??'', $bodegas_id_permiso)) {
                                $this->toolbar['edit']['html'] = "<a href='./$file_destino_consult?iah=e&iaid=$this->id$this->paramsAmp$extra_params' title='Editar'><img src='../img/icons/Pencil.png' alt='Editar' title='Cambiar el registro' /><br />Editar</a>";
                                $this->toolbar['edit']['condition'] = "return (\$iah=='r' || \$iah=='b') && !empty(\$id);";
                            } else {
                                $cancelar = '';
                            }
                        } else {
                            $cancelar = '';
                        }*/

                        $this->toolbar['edit']['html'] = "<a href='./$file_destino_consult?iah=e&iaid=$this->id$this->paramsAmp$extra_params' title='Editar' style='visibility: hidden'><img src='../img/icons/Pencil.png' alt='Editar' title='Cambiar el registro' /><br />Editar</a>";
                        $this->toolbar['edit']['condition'] = "return true;";

                        $borrarAndDisponible = '';
                        if (usuarioTipoRony()){
                            $borrarAndDisponible = "<a href='javascript:void(0);' onclick='notaForm.borrarNotaAndDisponible()' title='Borrar y dejar disponible' id='a_borrar_and_disponible'><img alt='Borrar' src='/img/borrar.png' title='Solicitar Borrar este registro' /></i><br>Borrar Disp.</a>";
                        }

                        $cancelar = $borrarAndDisponible . "<a href='javascript:void(0);' onclick='cancelarNota();' title='Cancelar Nota' target='_self' id='a_cancelar_nota'><img src='../img/icons/No.png' alt='Cancel' title='Cancelar Nota' /><br/><strong>Cancelar</strong></a>";
                        $print = $cancelar . $this->toolbar['print']['html'];

                        $this->toolbar['print']['html'] = "<div style=''><div style='display: flex; justify-content: space-around;'>$print</div></div>";

                        $this->toolbar['pdf']['condition'] = "return false;";
                        $this->toolbar['pdf']['html'] = '<a href="#" onclick="opcionesDePDF(\'movimientos\', \'\');" id="iaDoc2PDF" title="Generar PDF" style="visibility: hidden"><i class="fa-regular fa-file-pdf fa-xl" title="Generar PDF" style="color: blue;height:19px;width:25px;"></i><br><strong>PDF</strong></a>';
                        $this->toolbar['img']['condition'] = "return true;";
                        $this->toolbar['img']['html'] = '<a href="#" onclick="opcionesDePDF(\'movimientos\',\'\' ,\'\',\'JPG\');" id="iaDoc2PDF" class="getImgNota" title="Generar JPG" style="visibility: hidden"><img src="../img/icons/Pictures.png" alt="Generar JPG" title="Generar JPG"><br><strong>JPG</strong></a>';

                        $this->toolbar['img_copy']['condition'] = "return true;";
                        $this->toolbar['img_copy']['html'] = '<a href="#" onclick="exporter.imageCopy();" id="iaCopyJPG" title="Copiar JPG"><img src="../img/icons/Paste.png" alt="Copiar JPG" title="Copiar JPG"><br><strong>Copy JPG</strong></a>';

                        $this->toolbar['close']['condition'] = "return false;";
                        // dd_($this->toolbar);
                    }
                    else {
                        $this->toolbar['edit']['html'] = "<a href='./$file_destino_consult?iah=e&iaid=$this->id$this->paramsAmp$extra_params' title='Editar'><img src='../img/icons/Pencil.png' alt='Editar' title='Cambiar el registro' /><br />Editar</a>";
                        $this->toolbar['edit']['condition'] = "return (\$iah=='r' || \$iah=='b') && !empty(\$id);";

                        $cancelar = "<a href='javascript:void(0);' onclick='cancelarNota();' title='Cancelar Nota' target='_self' id='a_cancelar_nota'><img src='../img/icons/No.png' alt='Cancel' title='Cancelar Nota' /><br/><strong>Cancelar</strong></a>";


                        $this->toolbar['img']['condition'] = "return true;";
                        $this->toolbar['img']['html'] = '<a href="#" onclick="opcionesDePDF(\'movimientos\',\'\' ,\'\',\'JPG\');" id="iaDoc2PDF" class="getImgNota" title="Generar JPG"><img src="../img/icons/Pictures.png" alt="Generar JPG" title="Generar JPG"><br><strong>JPG</strong></a>';

                        $this->toolbar['img_copy']['condition'] = "return true;";
                        $this->toolbar['img_copy']['html'] = '<a href="#" onclick="exporter.imageCopy();" id="iaCopyJPG" title="Copiar JPG"><img src="../img/icons/Paste.png" alt="Copiar JPG" title="Copiar JPG"><br><strong>Copy JPG</strong></a>';

                        $print = $cancelar . $this->toolbar['print']['html'];
                        $this->toolbar['print']['html'] = "<div style='display: flex; justify-content: space-around;'>$print</div>";

                        $this->toolbar['delete_ask']['condition'] = "return true;";
                        $this->toolbar['delete_ask']['html'] = "<a href='javascript:void(0);' onclick='borrarNota()' title='Solicitar Borrar este registro' id='a_borrar_nota' style='display: none'><img alt='Borrar' src='/img/borrar.png' title='Solicitar Borrar este registro' /><br />Borrar</a>";
                        $this->toolbar['pdf']['condition'] = "return false;";
                        //$this->toolbar['img']['condition'] = "return false;";
                        $this->toolbar['close']['condition'] = "return false;";
                    }

                    $this->toolbar['read']['condition'] = "return (\$iah=='e' || \$iah=='b') && !empty(\$id);";
                    // $this->toolbar['edit']['condition'] = "return false;";
                    unset($this->toolbar['read']);
                    $abre_notas_bodega_func = "abre_edita_movimientos_bodega";
                }


                $bodega_id = $this->enDB['bodega_id'] ?? param('bodega_id');
                $this->toolbar['list'] = array(
                    'html'=>"<strong style='font-size: 12px;'>Nueva Nota: </strong>" . bodega_id_select($bodega_id, null, "onchange='$abre_notas_bodega_func(this);'", "select_toolbar_bodega_id", false) . "<br/><div><a href='../backoffice/nota_bodega.php?bodega_id=$bodega_id' id='iaList' target='_blank' class='toolbar_notas_bodega' title='Consultar Notas' alt='Consultar Notas' ><img src='$imgPath/report-go.png' style='height: 24px; width: 24px; margin-top: 0.2em;'/><strong>Notas</strong></a></div>");

                if($es_verificacion && isset($_REQUEST['grupo_verificador']) && !empty($_REQUEST['grupo_verificador'])){
                    $grupo_verificador = $_REQUEST['grupo_verificador'];
                    $abre_notas_bodega_ver = "abre_edita_movimientos_bodega_verificacion";
                    $on_change_ver = "onchange='$abre_notas_bodega_ver(this, $grupo_verificador);'";
                    $this->toolbar['list']['html'] .= "<strong style='font-size: 12px;'>Nueva Verificacion: </strong>" .
                        bodega_id_select($bodega_id, null, $on_change_ver, "select_toolbar_bodega_id", false, true, $_REQUEST['grupo_verificador']) .
                        "<br/><div>";

                }


                // unset($this->toolbar['log']);
                unset($this->toolbar['log_all']);
                // dd_($this->toolbar);
                // $this->table_info['label_plural']='NOTAS';
                // $this->table_info['label_plural_extra']= brtbNotificaciones($this->table);
                break;
            case 'bodega_grupo_verificador':
                $this->toolbar['add'] = array('html' => "<a href='javascript:nuevoGrupoVerificacion()' id='iaNewItem' target='_self' ><img src='../img/icons/New.png' title='Nuevo Lugarde Verificación' alt='Nuevo lugar de Verificación' /><br/><strong>Nuevo<br/>(F3)</strong></a>");
                break;

            case 'ayudantes':case 'pedido':
                $this->table_info['label_plural_extra']= $this->h==='a' ? '':brtbNotificaciones($this->table);
                $this->table_info['label_plural_extra']= $this->h==='a' ? '':brtbNotificaciones($this->table);
                if ($this->table == 'pedido' && empty(($_GET['iagridvar']??'')))
                        unset($this->toolbar['first'], $this->toolbar['prev'], $this->toolbar['next'], $this->toolbar['last']);
                break;

            case 'ajuste':
                if (!empty($this->h)) {
                    $label_cancelar = "Cancelar";
                    if ($this->enDB['cancelado'] === 'Si')
                    {
                        $label_cancelar = "Descancelar";
                    }
                    $option_cancelar = ['cancelar' => [
                        'html' => "<a href='javascript:void(0);' onclick='notaAjuste.cancelar();' title='$label_cancelar Ajuste' target='_self' id='a_cancelar_ajuste'><img src='../img/icons/No.png' alt='Cancel' title='$label_cancelar Ajuste' /><br/><strong>$label_cancelar</strong></a>",
                        'condition' => "return (\$iah=='e' || \$iah=='r') && \$this->may_cancel();"
                    ]];
                    $this->toolbar = addAfterKey($option_cancelar, "add", $this->toolbar);
                    $this->toolbar['delete_ask']['condition'] = "return !empty(\$id) && (\$iah=='e' || \$iah=='r') && \$this->may_delete();";
                    $this->toolbar['delete_ask']['html'] = "<a href='javascript:notaAjuste.borrar()' title='Solicitar Borrar este registro' id='a_borrar_nota'><img alt='Borrar' src='/img/borrar.png' title='Solicitar Borrar este registro' /><br />Borrar</a>";

                    // $this->toolbar['read']['condition'] = "return (\$h=='e' || $h=='b') && !empty($id) && $this->may_read();"
                    $this->toolbar['read']['condition'] = "return (\$iah=='e' || \$iah=='b') && !empty(\$id);";

                    // dd_($this->toolbar);
                }
                $this->table_info['label_plural_extra']= $this->h==='a' ? '': brtbNotificaciones($this->table);
                unset($this->toolbar['log_all']);
                // dd_($this->toolbar);
                break;

            case 'cliente':
                if(usuarioTipoRony() && empty($this->h)) {
                    $cuantos_clientes = ia_singleread("SELECT COUNT(*) FROM cliente where receive_cheques = 1 and cheques_totales = 0 and pagares_totales = 0 and vales_totales = 0");

                    $class_blink = $cuantos_clientes ? "blink" : "";

                    $this->toolbar['log_all']['html'] = "<div style='text-align: center; width: fit-content;'><a href='javascript:cliente.limpia_clientes_cobranza()' title='<div class=\"ui_tooltip_grid_notas_modificacion_importante_si bold\">Limpiar Clientes que no son de Cobranza</div>' class='txt_shadow_rojo_quemado  tooltip_toolbar' id='toolbar_limpia_clientes_cobranza'><i class='fa-icon fa-duotone fa-hammer-brush txt_shadow_rojo_light txt_1_8em'></i><br />
<span class='fa-text-grid txt_shadow_rojo_light txt_1_2em' style='margin-left: -30px;'>Limpiar</span></a><br>
<a href='javascript:cliente.filtra_clientes_cobranza_para_limpiar()' title='<div class=\"ui_tooltip_grid_notas_verificacion_incompleta bold\">Filtrar en el grid los Clientes que no son de Cobranza</div>' class='toolbar_vales   tooltip_toolbar'>
<span id='limpia_clientes_cobranza' class='$class_blink fa-text-grid txt_shadow_purple txt_1_3em $h' style='margin-left: -10px;'></span>
</a></div>";


                }
                else
                    unset( $this->toolbar['log_all']);
                break;

            case 'tc_log':
                $this->table_info['label_plural_extra']= $this->h==='a' ? '': brtbNotificaciones($this->table);
                // dd_($this->toolbar);
                break;

            default:
                //die("<pre>" . print_r($this, true) . "</pre>");
                if(!empty($label_plural))
                    $this->table_info['label_plural']=$label_plural;
            break;
        }
        unset( $this->toolbar['log']);

        //Agregamos nuevos para todos.
        //VCA Aquí agregas un DD para el toolbar de arriba, y quita los iconos del toolbatr de chequeDD
        //$puedeDD = puedePermisoUsuario("","puede_cheque_dd", true);

//        $txt_cheque_dd = "";//$puedeDD != 'No' ? "<br/><a href='../backoffice/cheque.php?CDD=SI' id='iaChequeDD' title='Cheques DD'><strong>Cheques DD</strong></a>" : "";
//        if(!$estoy_en_inversion && !$estoy_en_bodega && !$estoy_en_carta_porte && !$estoy_en_prices) {
//            $this->toolbar['cheques'] = array('html' => "<a href='../backoffice/cheque.php' id='iaCheque' title='<div class=\"ui_tooltip_grid_notas_verificacion_completa\">Cheques</div>'  class='toolbar_cheques tooltip_toolbar'><img src='..$imgPath/icons/Message.png' alt='Cheques' /><br/><strong>Cheques</strong></a>$txt_cheque_dd");
//            $this->toolbar['pagares'] = array('html' => "<a href='../backoffice/pagare.php' id='iaPagare' title='<div class=\"ui_tooltip_grid_nota_bodega_entrada\">Pagarés</div>' class='toolbar_pagares tooltip_toolbar'><img src='..$imgPath/icons/money.png' alt='Pagares'  /><br/><strong>Pagares</strong></a>");
//            $this->toolbar['vales'] = array('html' => "<a href='../backoffice/vale.php' id='iaVale' title='<div  class=\"ui_tooltip_grid_notas_verificacion_incompleta\" >Vales</div>' class='toolbar_vales tooltip_toolbar'><img src='..$imgPath/icons/Wallet.png' alt='Vales'  /><br/><strong>Vales</strong></a>");
//            $this->toolbar['bancos'] = array('html' => "<a href='../cobranza/edocta.php' id='iaBancos' title='<div  class=\"ui_tooltip_toolbar_bancos\" >Bancos</div>' class='toolbar_bancos txt_1_1em tooltip_toolbar'><img src='..$imgPath/icons/coins.png' alt='Bancos'  /><br/><strong>Bancos</strong></a>");
//        }
//        if($estoy_en_carta_porte)
//            $this->toolbar['bancos'] = array('html' => "<a href='../cobranza/edocta.php' id='iaBancos' title='<div  class=\"ui_tooltip_toolbar_bancos\" >Bancos</div>' class='toolbar_bancos txt_1_1em tooltip_toolbar'><img src='..$imgPath/icons/coins.png' alt='Bancos'  /><br/><strong>Bancos</strong></a>");
       // $ctasTSaldoHTML = obtenCuentasTToolbar();
//arrayMovetoTop($arr_ctaTPuede,$userProfile['cuentat_preferida_id']);
//        $this->toolbar['ctasT']=array('html'=>$this->cuentaTPreferidaToolbar()); // .$ctasTSaldoHTML
        //$this->toolbar['ctasT']=array('html'=>obtenCuentasTToolbar() ); // .

        //die("<pre>" . print_r($this, true) . "</pre>");
    }

        function cuentaTPreferidaToolbar() {
            $ctasTSaldoHTML = "";
            return $ctasTSaldoHTML;
            $ctasTSaldo = obtenOnHandCuentasT();
            if( !empty($ctasTSaldo))
            {

                $ctaT = $ctasTSaldo[0];
                $ctasTSaldoHTML = "<table id='tablectasTSaldo' style='width: 280px;margin-top:0;padding-top:0;'>";
                $ctasTSaldoHTML .= "<tr><td colspan='3' class='tbctasTSaldo' style='text-align:left;'>".$this->brainTToolbarTitle()
                    ."</td></tr><tr><td class='tbctasTSaldo' > <a style='float:right;padding-right:4px;' href='../backoffice/cuentat_mov.php?cuentat=".$ctaT['usuario']."' target='_blank'><strong>".$ctaT['usuario']."</strong></a></td>
                    <td class='tbPESOS' id='brn_tmxp_$ctaT[cuentaT_id]'>".echonf($ctaT['on_hand_mx'],true)."</td>
                    <td class='tbUSD' id='brn_tusd_$ctaT[cuentaT_id]'>".echonf($ctaT['on_hand_usd'],true)."</td></tr>";
                $ctasTSaldoHTML .= "</table><a href='../backoffice/cuentat_mov.php' target='_blank' title='Movimientos de todas las Cuentas T'><strong>Mov Cuentas T</strong></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

                if(sizeof($ctasTSaldo)>=2) {
                    $ctasTSaldoHTML .= "<a id='amuestraMasCuentasTToolbar' href='javascript:void(0);' onclick='muestraMasCuentasTToolbar(true);'><strong>Cuentas T </strong><img style='width: 16px !important; height: 16px !important;' src='../img/add.png' alt='Mostrar más Cuentas T' title='Mostrar más Cuentas T' /></a>";
                    $ctasTSaldoHTML .= "<a id='aocultaMasCuentasTToolbar' href='javascript:void(0);' onclick='muestraMasCuentasTToolbar(false);' style='display:none;' ><strong>Cuentas T </strong><img style='width: 16px !important; height: 16px !important;' src='../img/delete.png' alt='Ocultar las Cuentas T' title='Ocultar las Cuentas T' /></a>";

                    $ctasTSaldoHTML .= "<div id='divctasTSaldoMas' style='position: fixed; z-index:1001; display: none; overflow-x: hidden; overflow-y: scroll; height: 510px; background-color: #ffffff;'>";
                    $ctasTSaldoHTML .= "<hr/><a href='../backoffice/cuenta_t.php' target='_blank' title='Resumen de todas las Cuentas T'><strong>Resumen de todas las Cuentas T</strong></a><hr/>";
                    //$ctasTSaldoHTML .= "<a href='../backoffice/cuentat_mov.php' target='_blank' title='Movimientos de todas las Cuentas T'><strong>Mov. de todas las Cuentas T</strong></a><hr/>";

                    $ctasTSaldoHTML .= "<table id='tablectasTSaldoMas' style='width: 280px;'>";
                    foreach($ctasTSaldo as $k=>$ctaT)
                        if($k>0)
                            $ctasTSaldoHTML .= "<tr><td colspan='2' class='tbctasTSaldo'><a href='../backoffice/cuentat_mov.php?cuentat=".$ctaT['usuario']."' target='_blank'><strong>".$ctaT['usuario']."</strong></a></td></tr>
<tr><td class='tbPESOS' id='brn_tmxp_$ctaT[cuentaT_id]'>".echonf($ctaT['on_hand_mx'],true)."</td>
<td class='tbUSD' id='brn_tusd_$ctaT[cuentaT_id]'>".echonf($ctaT['on_hand_usd'],true)."</td></tr>";
                    $ctasTSaldoHTML .= "</div></table>"; //";
                } else {
                    // solo tiene 1 cuenta t
                    $ctasTSaldoHTML .= "<a href='../backoffice/cuentat_mov.php' target='_blank' title='Movimientos la Cuentas T'><strong>Mov. de la Cuenta T</strong></a>";
                }
            } else {
                $ctasTSaldoHTML = "<table id='tablectasTSaldo' style='width: 280px;margin-top:0px;padding-top:0px;'>";
                $ctasTSaldoHTML .= "<tr><td colspan='2' class='tbctasTSaldo' style='text-align:left;'>".$this->brainTToolbarTitle();
                $ctasTSaldoHTML .= "</table>";
            }
            return $ctasTSaldoHTML;
        }

	function brainTToolbarTitle($mioTitle='')
    {
        $semaforo = new Semaforo();
        $ret = "";
        $reportes_bodega = [];
        $sinArchive = !(
            str_contains($_SERVER['REQUEST_URI'] ?? '', 'archive') ||
            ( array_key_exists('_app_prefix', $_REQUEST) &&  $_REQUEST['_app_prefix'] === 'archive_')
        );

        $appArchive = $sinArchive ? '' : 'archive_';
        $appArchvieJs = jsit($appArchive);

        if(usuarioTipoRony()) {
            $reportes_bodega['reporte_bodega_ventas'] = [
                "img" => "<a class=\"tooltip_toolbar ui_tooltip_grid_notas_inconsistenticias_info\" style='padding:0.1em;margin: auto 0.5em'
                    href='../bodega/bodega_reporte_ventas.php' 
                    title='<div class=\"ui_tooltip_grid_notas_inconsistenticias_info\">Reporte Ventas De Bodega</div>'><i class='fa-duotone fa-arrow-up-from-arc'></i></a>"
            ];
            $reportes_bodega['panel de productos'] = [
                "img" => "<a class=\"tooltip_toolbar ui_tooltip_grid_notas_inconsistenticias_info\" style='padding:0.1em;margin: auto 0.5em'
                    href='../bodega/productos_panel_control.php' 
                    title='<div class=\"ui_tooltip_grid_notas_inconsistenticias_info\">Productos</div>'><i class='fa-solid fa-reel'></i></a>"
            ];
        }
        if(puedePermisoUsuario(nombrePermiso: "puede_consultar_existencia")) {
            $reportes_bodega['existencias'] = [
                "img" => "<script>function dlgConsExShow(){dialogConsultarExistencia.show(true, $appArchvieJs);}</script><img src='../img/icons/Find.png' width='24' height='24' alt='C' 
            title='<div class=\"tooltip_toolbar ui_tooltip_grid_notas_inconsistenticias_info\">CONSULTAR EXISTENCIAS</div>' style='vertical-align:middle;width:25px;height:auto;margin-right:6px;cursor:pointer;' 
                onclick='dlgConsExShow();' class='tooltip_toolbar'>"
            ];
        }
        $reportes_bodega['existencias']['html'] = include_once(__DIR__ . "/../backoffice/view/component/commons/dialog_consulta_existenciaColapsable.php");

        /*$reportes_bodega['reset_productos'] = [
            "img" => "<img src='../img/64-docs-azules.png' width='24' height='24' alt='Reset de Productos' title='Reset de Productos' style='vertical-align:middle;width:17px;height:auto;margin-right:6px;cursor:pointer;' onclick='dialogoResetProductos.showDialogo()'>",
            "html" => include(__DIR__ . "/../backoffice/view/component/commons/dialog_reset_productos.php")
        ];*/
        if($sinArchive) {
            $reportes_bodega['last_note'] = [
                "img" => "<img src='../img/icons/Notes.png' width='24' height='24' alt='Ver/Nueva Nota' title='<div class=\"ui_tooltip_grid_notas_verificacion_completa\">VER/NUEVA NOTA</div>' style='vertical-align:middle;width:auto;height:auto;margin-right:6px;cursor:pointer;' onclick='dialogConsultarExistencia.dialog_consulta_nota()' class='tooltip_toolbar'/>",

                "html" => '',
            ];
        $reportes_bodega['reportes_bodegas'] = [
            "img" => "<img src='../img/icons/Report.png' width='24' height='24' alt='Reportes de Bodegas' title='<div class=\"ui_tooltip_grid_nota_bodega_entrada\"  style=\"width:fit-content\">REPORTES DE BODEGA</div>' style='vertical-align:middle;margin-right:6px;cursor:pointer;width:25px !important;'  onclick='nuevoReporte();' class='tooltip_toolbar'>",
            "html" => include_once(__DIR__ . "/../backoffice/view/component/commons/dialog_reportes_bodega.php")
        ];
        $reportes_bodega['reportes_salidas'] = [
            "img" => "<img src='../img/icons/Diagram.png' width='24' height='24' alt='Reportes de Ventas' title='<div class=\"ui_tooltip_grid_notas_entrada_autorizada\"  style=\"width:fit-content\">SALIDAS A TIENDAS</div>' style='vertical-align:middle;width:25px;height:auto;margin-right:6px;cursor:pointer;' onclick='dialogoReporteVentas.showDialogoSalidas();'  class='tooltip_toolbar'>",
            "html" => include_once(__DIR__ . "/../backoffice/view/component/commons/dialogo_reportes_salidas.php")
        ];
            $reportes_bodega['reportes_red'] = [
                "html" => "<span onclick='networTimeInfo();' class='ui-icon ui-icon-signal' style=\"cursor:pointer;\"></span>     <span id='icono_jquery_rules'><i class='fa-duotone fa-pen-ruler' style='--fa-primary-color: #c78233; --fa-secondary-color: #ebc400; cursor: pointer; font-size: 0.8rem' onclick='InicializandoModalRules()'></i></span> <i class='fa-solid fa-clipboard-list' id='li_precios_tiendas' style='color: #531409; cursor: pointer;' title='Ver lista de precios'></i>",

            ];
            if(Permisador::puede_consultar_permisos()) {
                $reportes_bodega['permisos'] = [
                    "html" => "<span id='permisosPorHoja' title='Activa Ver/Editar Permisos de esta Hoja' class='ui-icon ui-icon-key' style=\"cursor:pointer;display:none\"></span>"
                ];
                global $gHojaSoloRony;
                if(!empty($gHojaSoloRony)) {
                    global $gIconoSoloTipoRony;
                    $reportes_bodega['soloTipoRony'] = [
                        "html" => $gIconoSoloTipoRony
                    ];
                }
                $reportes_bodega['permisos_parte'] = [
                    "html" => "<span id='permisosPorParte' onclick='permisador.ponPermisoParte();' title='Activa Ver/Editar Permisos Especificos' class='ui-icon ui-icon-key' style=\"cursor:pointer;display:none\"></span>",
                ];
            }

    }
        $images = array_column($reportes_bodega, 'img');
        $images = implode("", $images);

        $includes = array_column($reportes_bodega, 'html');
        $includes = implode("", $includes);

        return "<span style='font-weight:normal;font-size:smaller;padding-left:2px;'>$images</span>".$includes;

        /*if (puedePermisoUsuario(nombrePermiso: "puede_consultar_existencia") )
            $ret="<span style='font-weight:normal;font-size:smaller;padding-left:2px;'>
    <img src='../img/48-revise.png' width='25' height='25' alt='Consultar Existencia de Productos' title='Consultar Existencia de Productos' style='vertical-align:middle;width:25px;height:auto;margin-right:6px;cursor:pointer;' onclick='dialogConsultarExistencia.show();'>";

        $ret.="
<!--
<img id='brainRefreshMe' style='vertical-align:middle;width:14px;height:auto;margin-right:6px;cursor:pointer;' title='Refrescar las cuentas T ahorita' src='../img/32-reload.png'>
-->
<!-- @TODO poner if solo si pueden bodegas -->
<img src='../img/reporte.png' width='25' height='25' alt='Reportes de Bodegas' title='Reportes de Bodegas' style='vertical-align:middle;width:17px;height:auto;margin-right:6px;cursor:pointer;'  onclick='nuevoReporte();'/>
<img src='../img/64-docs-azules.png' width='25' height='25' alt='Ver Nota' title='Ver notas de la bodega' style='vertical-align:middle;width:17px;height:auto;margin-right:6px;cursor:pointer;'  onclick='dialogConsultarExistencia.dialog_consulta_nota()'>
<img src='../img/sales.webp' width='25' height='25' alt='Reportes de Ventas' title='Reportes de salidas a tiendas' style='vertical-align:middle;width:25px;height:auto;margin-right:6px;cursor:pointer;' onclick='dialogoReporteVentas.showDialogoSalidas();'>
</span>";*/

        /**
         * JJDPL: 19-10-2021 -> Para el dialogo de consulta de existencia
         */
        // die($reporteInclude);
        //$dialogConsulta= include(__DIR__ . "/../backoffice/view/component/commons/dialog_consulta_existencia.php");
        //if (puedePermisoUsuario(nombrePermiso: "puede_consultar_existencia") )
        /*$dialogConsulta = include(__DIR__ . "/../backoffice/view/component/commons/dialog_consulta_existenciaColapsable.php");
        $reporteInclude = include(__DIR__ . "/../backoffice/view/component/commons/dialog_reportes_bodega.php");
        $reportesVentas = include(__DIR__ . "/../backoffice/view/component/commons/dialogo_reportes_salidas.php");*/
        // return $ret . $dialogConsulta . $reporteInclude . $reportesVentas;
	}

    function display_toolbar($h = null, $cambia = [], $doDiv = true, $toolBarClass = 'iactoolbar')
    {
        if(param('iframed')!='')
            return;
        parent::display_toolbar($h,$cambia,$doDiv, $toolBarClass);
        inicializa_catalogos_globales();
        $this->brainTToolbarData();
        ob_flush();
        flush();
    }

	function brainTToolbarData() {
	}

    function listme($gridId='',$title='',$where='',$jsAfter='',$postData=array()) {
        if(empty($gridId))
            $gridId=$this->jqGridId;
            //$gridId=$this->jqGridId_Prefix.$this->table;

        parent::listme($gridId,$title,$where,$this->export_gridvalues($gridId),$postData);
        ob_flush();
        flush();
    }

    function export_gridvalues($gridId,$title='',$fileName='',$gridVar='',$pagerId='') {
        if(empty($pagerId))
            $pagerId="pgr$gridId";
        if(empty($fileName))
            $fileName=$this->table;
        if(empty($title))
            $title=$this->label_list(false);

        $exportarPDF = "";
        if(isset($this->exportarPDF) && $this->exportarPDF == 'opcionesDePDF')
            $exportarPDF = "\$tempgrid.jqGrid('navButtonAdd','#$pagerId',{caption:'PDF',title:'Exportar a PDF', buttonicon:'ui-icon-file-pdf',
            onClickButton: function(){ postToUrl('../backoffice/doc2pdf.php', {doc: '$this->table', id: JSON.stringify($('#$gridId').jqGrid('getDataIDs')), multiple: 'SI'}); }});";
        else
            $exportarPDF = "\$tempgrid.jqGrid('navButtonAdd','#$pagerId',{caption:'PDF',title:'Exportar a PDF', buttonicon:'ui-icon-file-pdf',
            onClickButton: function(){ exportReport('$gridId', arrIgnore, 'PDF', '$fileName.pdf', '$title', arrInclude);}});";

        $reporteDiarioPDF = "";
        if(isset($this->reporteDiarioPDF) && $this->reporteDiarioPDF == 'SI')
            $reporteDiarioPDF = "\$tempgrid.jqGrid('navButtonAdd','#$pagerId',{caption:'REPORTE',title:'Reporte a PDF', buttonicon:'ui-icon-note',
            onClickButton: function(){ reporteDiarioPDF(); }});
            \$tempgrid.jqGrid('navSeparatorAdd','#$pagerId');";

        return <<< EXPORTGRIDER
var \$tempgrid = jQuery('#$gridId');

if(typeof arrInclude == 'undefined')
    arrInclude = new Array();

if(typeof arrIgnore == 'undefined')
    arrIgnore = new Array();

arrIgnore.push('pwd','Actions','Act');

\$tempgrid.jqGrid('navSeparatorAdd','#$pagerId');
\$tempgrid.jqGrid('navButtonAdd','#$pagerId',{caption:'Excel',title:'Exportar a Excel', buttonicon:'ui-icon-table',
    onClickButton: function(){ exportReport('$gridId', arrIgnore, 'XLS', '$fileName.xls', '$title', arrInclude);}});

$exportarPDF
\$tempgrid.jqGrid('navSeparatorAdd','#$pagerId');
$reporteDiarioPDF
EXPORTGRIDER;

    }

    function permisos_por_tienda_set($cual='cobranza') {
        $h=$this->h;
        if( ($h=='e' || $h=='s' || $h=='b' || $h=='d' || $h=='r') && array_key_exists('tienda_id',$this->enDB)  ) {
           $puede=tienda_puede($this->enDB['tienda_id'], '', $cual);
           if($puede=='Consultar') {
                $this->permiso_app=true;
                $this->permiso_delete=false;
                $this->permiso_export=false;
                $this->permiso_insert=false;
                $this->permiso_list=true;
                $this->permiso_read=true;
                $this->permiso_update=false;
           }
           elseif($puede=='Editar') {
                $this->permiso_app=true;
                //$this->permiso_delete=true;
                $this->permiso_export=true;
                $this->permiso_insert=true;
                $this->permiso_list=true;
                $this->permiso_read=true;
                $this->permiso_update=true;
           }
           elseif($puede=='Nada') {
                $this->permiso_app=false;
                $this->permiso_delete=false;
                $this->permiso_export=false;
                $this->permiso_insert=false;
                //$this->permiso_list=false;
                $this->permiso_read=false;
                $this->permiso_update=false;
           }
        }

        if(usuarioTipoRony())
        {
            $this->permiso_app=true;
            $this->permiso_delete=true;
            $this->permiso_export=true;
            $this->permiso_insert=true;
            $this->permiso_list=true;
            $this->permiso_read=true;
            $this->permiso_update=true;
        }
    }

    function listme_postRender($grid) {
        $busqueda_desde_iacase = 'false';
        $activeBA = 'false';
        $contentBA = '<fieldset name="busqueda_access_fs" id="busqueda_access_fs"  class="lazy-content" style="visibility: hidden" ><legend><strong>Búsqueda Rápida (F8)</strong></legend><div id="content" data-group="" data-order="0"></div></fieldset>';
        if(isset($this->activeBA) && $this->activeBA) {
            $busqueda_desde_iacase = 'true';
            $activeBA = 'true';
            echo $contentBA;
        }
if(!$this->asChild) {

    $nombreDoc = $this->label_list(false);
//    $footerUSD = "doGridFooterRowUSD();";
    $footerUSD = "";

    if(false && $this->table == "nota_bodega")
        $footerUSD = "";

echo <<< REPORTEADORSTRING
<div id="reporteador_cr_$this->table" class="lazy-content">
<hr class="lazy-content"/>
</div>

<script>
var gridID='$grid->element_id';
var activeBA = $activeBA;
var contentBA = '$contentBA';
var busqueda_desde_iacase = $busqueda_desde_iacase;
var br = null;

\$vitex_globales['init_ia_jqueries_corre_inicio'] = '$this->h' == 'e' || '$this->h' == 'r' ? true : false;

$(document).ready(function(){
    setTimeout(function(){
    // try
    // {
        if (activeBA){
            br= new BusquedaRapida(gridhandler.jqGrid('getGridParam').colModel);
            //br.init();
            brGridHandler = $this->jgGridVar;
        }
     }, 10);
    
    setTimeout(function(){
    try
    {
        if(cr_inicializaConfiguradordeReportes)
            var inicio_CR = cr_inicializaConfiguradordeReportes([['$grid->element_id','$this->table','$this->label']], 0, 'reporteador_cr_$this->table');
    }catch(er) { console.log('Al iniciar el configurador de reportes',er);}
    }, 10000);
    
    // setTimeout(function(){
    //     initAutoCompleteToolBarjqGrid($this->jgGridVar);
    // }, 100);
    
    setTimeout(function(){
        $('option[value="10000000"]').text('Todos');
        $footerUSD
        
    },100);
    
    
});

gboxGrid = 'gbox_$this->jqGridId'
\$nombreDoc = '$nombreDoc';

gridhandler = $("#$this->jqGridId");

</script>
REPORTEADORSTRING;
     }
        ob_flush();
        flush();
    }

/// deliverd cheques y pagares
    /**
     * forma_acepta_delivered
     * Pone el combo de aceptar/rechazar delivered, si cambia delivered_to a una cuentaT diferente a la original y a la del usuario se oculta
     *
     */
    function forma_acepta_delivered($h,$nexth) {
    global $gAppRelate;
        $cta=empty($this->values['cuentaT_transferto_id']) ? $this->values['cuentaT_deliveredto_id'] : $this->values['cuentaT_transferto_id'];
        //$tmp=ia_sqlArray( str_replace('ORDER BY t.usuario','', $gAppRelate->cuentat_options_sql('',false,'cheque','poner_delivered_cheques')),"cuentat_id");
        $tmp=cuentasTPuede('','aceptar_delivered_cheques','array');
        //echo "cta:$cta<br />";
        //echo "<pre>".print_r($tmp, true)."</pre>";
        //echo "<pre>".print_r($this->values, true)."</pre>";
        $micta=$gAppRelate->cuentat_prefereida('','aceptar_delivered_cheques');
        if( array_key_exists($cta,$tmp) ) {
            echo <<< ACEPTARRECHAZAR
<div class='dved' id=delivered_accept_div style='float:left;'><label for='delivered_accept' title="Aceptar / Rechazar el delivered" class="lbl">Accept Delivery</label><br/>
<select name=delivered_accept id=delivered_accept><option value=''></option><option value='Accepted'>Accept</option><option value='Rejected'>Reject</option></select>
</div>
<script>
jQuery(function($) {
    $("#cuentaT_deliveredto_id").on("change", function() {
        var accept_cta=$cta;
        var mi_cta=$micta;
        var show_accept=$(this).attr('value')==accept_cta || $(this).attr('value')==mi_cta;
        if( show_accept ) {
            $("#delivered_accept_div").show();
        } else {
            $("#delivered_accept_div").hide();
            $("#delivered_accept").val('');
        }
    });
});
</script>
ACEPTARRECHAZAR;
        } else echo "<strong>Esperando a que sea aceptado el Delivered...</strong>";//echo "<h1>VA</h1>";
    }



    /**
     * iacase_base::cargaADelivered()
     * En el primer delivered carga el cheque a la cuentaT origen_cuentat_id, Al cambiar delivered cambia el status y hace el log
     *
     * @return
     */
    function cargaADelivered(&$sql,&$log) {
    global $gAppRelate;
        //Ponemos el campo en R/W para poder actualizarlo.
        $this->campos['delivered']['modo']='R/W';
        $h=$this->h;

        if($h=='a' || $h=='i')
        {
            $dlvd_to_enDB=0;
            $dlvd_to_ND=array_key_exists('cuentaT_deliveredto_id',$this->values) ? $this->values['cuentaT_deliveredto_id'] : 0;
            $dlvd_to_ori=$dlvd_to_enDB;

            $dd_enDB=0;
            $dd_ND=array_key_exists('delivered_directo',$this->values) ? $this->values['delivered_directo'] : 0;
            $dd_ori=$dd_enDB;

            $ctatori_enDB=0;
            $ctatori_ND=array_key_exists('origen_cuentat_id',$this->values) ? $this->values['origen_cuentat_id'] : 0;
            $ctatori_ori=$ctatori_enDB;

            $accepted_enDB=array_key_exists('accepted',$this->enDB) ? $this->enDB['accepted']:'Not delivered';

            $autorizado=false;
            $primer_delivered='Si';
        }
        else
        {
            $dlvd_to_enDB=array_key_exists('cuentaT_deliveredto_id',$this->enDB) ? $this->enDB['cuentaT_deliveredto_id'] : 0;
            $dlvd_to_ND=array_key_exists('cuentaT_deliveredto_id',$this->values) ? $this->values['cuentaT_deliveredto_id'] : 0;
            $dlvd_to_ori=array_key_exists('cuentaT_deliveredto_id',$this->enDB) ? $this->enDB['cuentaT_deliveredto_id'] : $dlvd_to_enDB;

            $dd_enDB=array_key_exists('delivered_directo',$this->enDB) ? $this->enDB['delivered_directo'] : 0;
            $dd_ND=array_key_exists('delivered_directo',$this->values) ? $this->values['delivered_directo'] : 0;
            $dd_ori=array_key_exists('delivered_directo',$this->enDB) ? $this->enDB['delivered_directo'] : $dd_enDB;

            $ctatori_enDB=array_key_exists('origen_cuentat_id',$this->enDB) ? $this->enDB['origen_cuentat_id'] : 0;
            $ctatori_ND=array_key_exists('origen_cuentat_id',$this->values) ? $this->values['origen_cuentat_id'] : 0;
            $ctatori_ori=array_key_exists('origen_cuentat_id',$this->enDB) ? $this->enDB['origen_cuentat_id'] : $ctatori_enDB;

            $accepted_enDB=array_key_exists('accepted',$this->enDB) ? $this->enDB['accepted']:'Not delivered';

            $autorizado=$this->enDB['autorizado']=='Si'?true:false;

            $primer_delivered=$this->enDB['primer_delivered'];
        }

        $dd_ND = $dd_enDB = (property_exists($this, 'soy_cheque_dd') && $this->soy_cheque_dd() == 'SI') || $this instanceof app_cheque_dd;

//        echo "<pre>".print_r($this, true)."</pre>";
//        die();

        $dlvd_to_ND=empty($dlvd_to_ND)?0:$dlvd_to_ND;
        $dd_ND=empty($dd_ND)?0:$dd_ND;
        $ctatori_ND=empty($ctatori_ND)?0:$ctatori_ND;

        $dlvd_cambio=$dlvd_to_ND==$dlvd_to_ori?0:1;
        $dd_cambio=$dd_ND==$dd_ori?0:1;
        $ctatori_cambio=$ctatori_ND==$ctatori_ori?0:1;

        $msg='';
        $deleted=false;
        $razon="SE DEVUELVE DINERO A CUENTA T PORQUE QUITO <strong>CUENTA T ORIGEN</strong>";
        $cargoACuentaT=false;
        $totalPayments = array_key_exists('total_payments',$this->enDB) ? $this->enDB['total_payments'] : 0;
        $numerodeACuentas = property_exists($this, 'numerodeACuentas') ? $this->numerodeACuentas : 0;
        $documentUpdateFields="";

        //28-05-2020
        //Rony puede dejar cheques muestos. Entonces sí es Rony, el cheque puede quedar sin $dlvd_to_ND, $dd_ND, $ctatori_ND.
        $utr = usuarioTipoRony();

        //Bug: Un usuario tipo Rony ya no podía aceptar delivered.

        $da_ND = array_key_exists('delivered_accept',$_REQUEST) && !empty($_REQUEST['delivered_accept']);

//        if(($h=='e' || $h=='s') && $utr && !$dlvd_to_ND && !$dd_ND && !$ctatori_ND && !$da_ND && !$dd_enDB) //VCA Delivered directo
        if(($h=='e' || $h=='s') && $dd_enDB) //VCA Delivered directo
            return true;

        if($h=='b' || $h=='d')
        {
            if($dd_enDB || empty($ctatori_enDB) || $numerodeACuentas > 0)
                return true;

            $deleted=true;
            $dd_cambio=$dd_ND=$ctatori_cambio=1;
            $dd_enDB=$ctatori_ND=0;
            $razon="SE DEVUELVE DINERO A CUENTA T PORQUE SE <strong>BORRÓ</strong>";
        }


        /**
        echo "<hr/><hr/>dlvd_to_enDB: $dlvd_to_enDB<br />";
        echo "dlvd_to_ND: $dlvd_to_ND<br />";
        echo "dlvd_to_ori: $dlvd_to_ori<br />";

        echo "dd_enDB: $dd_enDB<br />";
        echo "dd_ND: $dd_ND<br />";
        echo "dd_ori: $dd_ori<br />";

        echo "ctatori_enDB: $ctatori_enDB<br />";
        echo "ctatori_ND: $ctatori_ND<br />";
        echo "ctatori_ori: $ctatori_ori<br />";

        echo "accepted_enDB: $accepted_enDB<br />";
        echo "dlvd_cambio: $dlvd_cambio<br />";
        echo "dd_cambio: $dd_cambio<br />";
        echo "ctatori_cambio: $ctatori_cambio<br />";

        echo "totalPayments: $totalPayments<br />";
        echo "numerodeACuentas: $numerodeACuentas<br /><hr/><hr/>";
        **/



        //Cambió la CuentaT Origen. Decidimos el escenario.
        if(!$dd_enDB && $ctatori_cambio)
        {
            /** Primera vez. NO importa h==a o h==e.
            NO es delivered_directo, sí tiene CuentaT Origen y sí está Delivered a alguien. **/
            $ultimo_mov='CUENTAT ORIGEN';

            //Fail safe por si no viene cuentaT_deliveredto_id
            if(!$dlvd_to_ND)
            {
                $ctat_pref = $gAppRelate->cuentat_prefereida();
                $dlvd_to_ND = empty($ctat_pref) ? $_SESSION['usuario_id'] : $ctat_pref;
            }

            if(!$dd_ND && $ctatori_ND && $dlvd_to_ND && $totalPayments == 0 && $numerodeACuentas == 0)
            {
                $this->values['delivered'] = date('Y-m-d H:i:s'); //Es la fecha y hora del delivered.
                $cargoACuentaT=true;
                $aDoc = "<a title='Abrir el $this->table' href='../backoffice/$this->table.php?iah=e&id=$this->id' target='_blank'><strong>".$this->label_record_summary()."</strong></a>";

                $cuentaT_nombre=ia_singleread("SELECT usuario FROM cuentat WHERE vale='Active' AND cuentaT_id=".strit($dlvd_to_ND));
                $cuentat_mov = cuentat_mov_default_record(null,$this->values['quantity'],'Egreso', empty($this->values['moneda_id']) ? $this->enDB['moneda_id'] : $this->values['moneda_id'], 1, $this->values['delivered']);
                $cuentat_mov["cuentaT_tipo_mov_id"]='12';
                $cuentat_mov["remarks"]="$aDoc delivered to ".ia_htmlentities($cuentaT_nombre);
                $cuentat_mov["cuentaT_id"]=$ctatori_ND;

                $cuentat_mov["origen_mov_id"]=$this->id;
                $cuentat_mov["app_origen"]=ucfirst($this->table).' Delivered';

                $cuentat_mov["tienda_id"]=$this->values['tienda_id']||$this->enDB['tienda_id'];

                $log.="<li>".$cuentat_mov["remarks"].", se carga a cuenta T";
                $sql[]=ia_insert('cuentat_mov',$cuentat_mov,array(),'','',"/* cargaADelivered h=$this->h */");
                $sql[]="UPDATE /* cargaADelivered */ $this->table SET cuentat_mov_id='$cuentat_mov[cuentaT_mov_id]', puede_origen_cuentat='Si', set_origen_cuentat=NOW(), primer_delivered='No' WHERE $this->pk_field=".strit($this->id)." LIMIT 1";
            }
            /** Tenía CuentaT Origen y ahora es Delivered Directo. **/
            if($dd_cambio && $dd_ND && !$dd_enDB && !$ctatori_ND && $ctatori_enDB)
            {
                //Regresamos el dinero a la CuentaT Origen porque ya es Delivered Directo.
                if(usuarioTipoRony($_SESSION['usuario_id']))//debe hacer con un param('devuelveaCuentaT');//Como puso undelivered preguntamos si regresamos el dinero a la cuenta T origen. Esta variable la manda el form con javascript. Ahorita la simulamos.
                    $devuelveaCuentaT = param('devuelveaCuentaT');
                else
                    $devuelveaCuentaT = 'SI';
                //$devuelveaCuentaT = 'SI'; //Revisar porque no manda mensaje.
                //echo "devuelveaCuentaT: $devuelveaCuentaT<br />";

                if($devuelveaCuentaT == 'SI')
                {
                    $cuentaT_mov_id=ia_guid();
                    $sel = "SELECT * FROM cuentat_mov WHERE origen_mov_id = '$this->id' AND activo='Si' ORDER BY alta_db ASC";
                    //echo "sel: $sel<br />";
                    $cuentaT_mov_original = ia_singleton($sel);
                    //De volada actualizo el movimiento de cuenta t original y lo marco como que si tiene contraparte.

//                    echo "$sel<pre>".print_r($cuentaT_mov_original, true)."</pre>";
//                    die();
                    //ia_query("UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_id', activo='No' WHERE cuentaT_mov_id='$cuentaT_mov_original[cuentaT_mov_id]'");
                    $sql[]="UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_id', activo='No' WHERE cuentaT_mov_id='$cuentaT_mov_original[cuentaT_mov_id]'";

                    $cuentat_mov = cuentat_mov_default_record($cuentaT_mov_id,$this->enDB['quantity'],'Ingreso', $this->enDB['moneda_id']);
                    $aDoc = "<a title='Abrir el $this->table' href='../backoffice/$this->table.php?iah=e&id=$this->id' target='_blank'><strong>".$this->label_record_summary()."</strong></a>";
                    $cuentat_mov["remarks"]="$razon $aDoc";
                    $cuentat_mov["cuentaT_id"]=$cuentaT_mov_original["cuentaT_id"];
                    $cuentat_mov["cuentaT_tipo_mov_id"]='12';
                    $cuentat_mov["origen_mov_id"]=$cuentaT_mov_original['cuentaT_mov_id'];
                    $cuentat_mov["contra_mov_id"]=$cuentaT_mov_original['cuentaT_mov_id'];
                    $cuentat_mov["app_origen"]=ucfirst($this->table).' Delivered';
                    $cuentat_mov["activo"]='No';
                    $cuentat_mov["tienda_id"]=$this->values['tienda_id'];
                    $log.="<li> $razon";
                    //echo "<pre>".print_r($cuentat_mov, true)."</pre>";
                    $sql[]=ia_insert('cuentat_mov',$cuentat_mov,array(),'','',"/* cargaADelivered */");
                }
                //$documentUpdateFields=",origen_cuentat_id=NULL, puede_origen_cuentat='Si', set_origen_cuentat=NOW(), primer_delivered='Si', puede_borrar='Si' ";
                $documentUpdateFields=",origen_cuentat_id=NULL";
                $ultimo_mov='DELIVERED DIRECTO';
            }
            /** Cambio CuentaT Origen **/
            elseif(!empty($ctatori_ori))
            {
                //Regresamos el dinero a la CuentaT Origen porque ya es Delivered Directo.
                //if(usuarioTipoRony($_SESSION['usuario_id']))//debe hacer con un param('devuelveaCuentaT');//Como puso undelivered preguntamos si regresamos el dinero a la cuenta T origen. Esta variable la manda el form con javascript. Ahorita la simulamos.
                    //$devuelveaCuentaT = param('devuelveaCuentaT');
                //else
                $devuelveaCuentaT = 'SI';
                //$devuelveaCuentaT = 'SI'; //Revisar porque no manda mensaje.
                //echo "devuelveaCuentaT: $devuelveaCuentaT<br />";

                if($devuelveaCuentaT == 'SI')
                {
                    $razon="SE DEVUELVE DINERO A CUENTA T PORQUE CAMBIO <strong>CUENTA T ORIGEN</strong>";
                    $cuentaT_mov_id=ia_guid();
                    $sel = "SELECT * FROM cuentat_mov WHERE origen_mov_id = '$this->id' AND activo='Si' ORDER BY alta_db ASC";
                    //echo "sel: $sel<br />";
                    $cuentaT_mov_original = ia_singleton($sel);
                    //De volada actualizo el movimiento de cuenta t original y lo marco como que si tiene contraparte.

                    //echo "<pre>".print_r($cuentaT_mov_original, true)."</pre>";
                    ia_query("UPDATE cuentat_mov SET contra_mov_id='$cuentaT_mov_id', activo='No' WHERE cuentaT_mov_id='$cuentaT_mov_original[cuentaT_mov_id]'");

                    $cuentat_mov = cuentat_mov_default_record($cuentaT_mov_id,$this->enDB['quantity'],'Ingreso', $this->enDB['moneda_id']);
                    $aDoc = "<a title='Abrir el $this->table' href='../backoffice/$this->table.php?iah=e&id=$this->id' target='_blank'><strong>".$this->label_record_summary()."</strong></a>";
                    $cuentat_mov["remarks"]="$razon DE: $aDoc";
                    $cuentat_mov["cuentaT_id"]=$cuentaT_mov_original["cuentaT_id"];
                    $cuentat_mov["cuentaT_tipo_mov_id"]='12';
                    $cuentat_mov["origen_mov_id"]=$cuentaT_mov_original['cuentaT_mov_id'];
                    $cuentat_mov["contra_mov_id"]=$cuentaT_mov_original['cuentaT_mov_id'];
                    $cuentat_mov["app_origen"]=ucfirst($this->table).' Delivered';
                    $cuentat_mov["activo"]='No';
                    $cuentat_mov["tienda_id"]=$this->values['tienda_id'];
                    $log.="<li> $razon";
                    //echo "<pre>".print_r($cuentat_mov, true)."</pre>";
                    $sql[]=ia_insert('cuentat_mov',$cuentat_mov,array(),'','',"/* cargaADelivered */");
                }
                //$documentUpdateFields=",origen_cuentat_id=NULL, puede_origen_cuentat='Si', set_origen_cuentat=NOW(), primer_delivered='Si', puede_borrar='Si' ";
                $documentUpdateFields=",primer_delivered='No',origen_cuentat_id=".strit($ctatori_ND);
            }

            if($h=='a' || $h=='i' || $primer_delivered=='Si')
                $ultimo_mov='ALTA';


            if($autorizado)
                $sql[]="UPDATE /* cargaADelivered */ $this->table SET ultimo_movimiento='$ultimo_mov', autorizado='No', desautorizado_el=CURRENT_TIMESTAMP WHERE $this->pk_field=".strit($this->id)." LIMIT 1";
        }

        //Si cambio el delivered. Ya sólo es informativo.
        if($this->campos['cuentaT_deliveredto_id']['modo']=='R/W' && $dlvd_cambio)
        {
            $this->values['delivered'] = date('Y-m-d H:i:s');
            // estaba en waiting y se cambio el deliverd to, cancela el anterior en el log
            if($accepted_enDB=='Waiting'){
                $sql[]="UPDATE /* cargaADelivered */ delivered SET delivered_status='Canceled',accepted=NOW() "
                    ." WHERE document_type='$this->table' AND document=".strit($this->id)
                    ." AND delivered_status='Waiting' AND cuentaT_to_id=".strit($dlvd_to_ori);
            }

            if(!empty($dlvd_to_ND)){
                // puso un delivered
                $documentUpdateFields.=",delivered=".strit($this->values['delivered']);
                $msg.="<li>".mysqlDate2display($this->values['delivered'])." ".$_SESSION['usuario'].' pone deliverd to '.ia_singleread("SELECT usuario FROM cuentat WHERE cuentaT_id=".strit($dlvd_to_ND),'').", esperando acepte";
                // hace delivered a si mismo, aceptalo automaticamente
                //$micta=$gAppRelate->cuentat_prefereida(); //Ahora preguntamos por las cuentas T donde pueda aceptar_delivered_cheques.
                $ctasTpdc=cuentasTPuede('','aceptar_delivered_cheques','array');
                //$documentUpdateFields.=",cuentaT_transferto_id=".strit($delivered_estaba);
                //if($micta==$deliverd_to_values) {
                if(array_key_exists($dlvd_to_ND,$ctasTpdc))
                {
                    $delivered_status=$accepted='Accepted';
                    $msg.=", y lo acepta él mismo";
                    $documentUpdateFields.=" ,primer_delivered='No', accepted='Accepted' ,cuentaT_transferto_id=".strit($dlvd_to_ND);

                }
                else
                {
                    $micta=$gAppRelate->cuentat_prefereida('','poner_delivered_cheques');
                    if($dlvd_to_ND!=$micta)
                        $documentUpdateFields.= " ,cuentaT_deliveredto_id=".strit($micta);
                    $delivered_status=$accepted='Waiting';
                    $documentUpdateFields.=" ,primer_delivered='No' ,cuentaT_transferto_id=".strit($dlvd_to_ND);
                }
            }
            $log.=$msg;
            $msg=strit($msg);
            $msg="deliverd_log=IF(deliverd_log IS NULL,$msg, CONCAT($msg,deliverd_log ))";
            $sql[]="UPDATE /* cargaADelivered */ $this->table SET $msg,accepted='$accepted' $documentUpdateFields WHERE $this->pk_field=".strit($this->id)." LIMIT 1";
            $delivered=array();
            $delivered['delivered_id']=ia_guid();
            $delivered['document_type']=$this->table;
            $delivered['document']=$this->id;
            $delivered['usuario_deliveres_id']=$_SESSION['usuario_id'];
            $delivered['cuentaT_deliversFrom_id']= $dlvd_to_ori;
            $delivered['delivered_status']=$delivered_status;
            $delivered['cuentaT_to_id']=$dlvd_to_ND;
            $delivered['delivered']='NOW()';
            $sql[]=ia_insert("delivered",$delivered,array(),'','','/* cargaADelivered */');
        }

        // checa accepted/rejected en inc/helpers.php
        if( array_key_exists('delivered_accept',$_REQUEST) && !empty($_REQUEST['delivered_accept']) )
            deliverd_to_accept($this->table,$_REQUEST['delivered_accept'],$this->id,$sql,$log);

            /**
        echo "<pre>".print_r($this,true)."</pre>";
        echo "deliverd_to_ori: $deliverd_to_ori<br />";
        echo "deliverd_to_db: $deliverd_to_db<br />";
        echo "deliverd_to_values: $deliverd_to_values<br />";
        echo "cuentaT_origen: $cuentaT_origen<br />";
        echo "totalPayments: $totalPayments<br />";
        echo "numerodeACuentas: $numerodeACuentas<br />";

        die();
             * **/


    }

    function input_datetime($fieldName,$value=null,$atributes=array(),&$modo=null,$doSet=true) {
        return parent::input_datetime($fieldName,$value,$atributes,$modo,$doSet);
    }

    function renderTable($data = [], $order = [], $table_title = null, $colsWidths = [], $widthTable = '100', $activePaddingTd = true, $colsShow= [], $classTrBody = '', $sumCols = [], $countCols = [])
    {
        if (count($data) == 0) return '';

        $caption = ($table_title != null) ? "<caption class='txt_bold_dark_blue'><strong>- = $table_title = -</strong></caption>" : '';
        $headers = "";
        $body = "";
        $keys = array_keys($data[0]);
        $arrayDiff = array_diff($keys, $order);
        $fields = (empty($colsShow)) ? array_merge($order, $arrayDiff): $colsShow;
        $lengthCols = count($fields);
        $width = 100/(count($fields));

        foreach ($fields as $key => $field) {
            $headers .= "<th class='lbl'>". $this::dashesToCamelCase($field) ."</th>";
        }
        $valPrevi = null;
        $moneda = null;
        $paddingTd = $activePaddingTd ? 'padding: 10px;' : '';
        foreach ($data as $index => $item) {
            $body.= "<tr>";
            $moneda = isset($item['moneda_id']) ? $item['moneda_id'] : null;
            foreach ($fields as $key => $field) {
                if (isset($item[$field])) {
                    $class = $this::setClass($field, $item[$field], $valPrevi, $moneda);
                    $width = (isset($colsWidths[$key])) ? $colsWidths[$key]: $width;
                    $body.= "<td class='bold_table_childs $class' style='width:$width%; $paddingTd'>". $this::setValue($field, $item[$field]) ."</td>";
                    $valPrevi = $item[$field];
                }
            }
            $body.= "</tr>";
        }
        $marginLeft = ((100-intval($widthTable))/2);
        $marginLeft = 0;

        $tfoot= [];
        foreach ($sumCols as $sumCol) {
            if (in_array($sumCol, $keys)) {
                $tfoot[$sumCol] = number_format(array_sum(array_column($data,$sumCol)),2, '.', ',');
            }
        }
        foreach ($countCols as $countCol) {
            if (in_array($countCol, $keys)) {
                $tfoot[$countCol] = "<span style='float: right'>TOTAL: ".number_format(count($data),0, '.', ',') . "</span>";
            }
        }


        $tfootTable= "";
        if (!empty($tfoot)) {
            $tfootTable = "<tfoot><tr><td colspan='$lengthCols'><hr style='margin:0'/></td></tr><tr>";
            foreach ($fields as $key => $field) {
                // dd_($field, $tfoot, $tfoot[$field], isset($tfoot[$field]));
                if (isset($tfoot[$field])) {
                    $width = (isset($colsWidths[$key])) ? $colsWidths[$key]: $width;
                    $tfootTable.= "<td class='bold txt_right_aligned lbl' style='width:$width%; $paddingTd'>".$tfoot[$field]."</td>";
                } else {
                    $tfootTable.="<td></td>";
                }
            }
            $tfootTable .= "</tr></tfoot>";
        }

        $table =   "<table style='width: $widthTable%; margin-left: $marginLeft%; border-style: solid; border-width: 1px; padding: 4px 4px; border-color:gray; margin: auto;' class='table_child_pdf'>
                        $caption
                        <thead>
                            <tr>
                                $headers
                            </tr>
                        </thead>
                        <tbody class='$classTrBody'>
                            <tr><td colspan='$lengthCols'><hr/></td></tr>
                            $body
                        </tbody>
                        $tfootTable
                    </table>";
        return $table;
    }

    static function setClass($field, $value = null, $prevValue = null, $moneda = null)
    {
        $class = '';
        $arrayDef_bold = ['nombre', 'fecha', 'ultimo_pago', 'ultima_compra', 'doc_mas_antiguo'];

        $arrayParseMoney = ['moneda', 'moneda_id', 'doc_moneda_id'];

        $arrayParseMoneyPrevius = ['saldo_final'];

        $arrayParseNumber = ['rollos', 'quantity', 'total_rolls', 'total_quantity'];
        
        if (in_array($field, $arrayDef_bold)) $class .= 'bold ';

        if (in_array($field, $arrayParseMoney)) {
            $class .= ($moneda == 1 || $moneda == '1') ? 'bold txt_color_PESOS txt_right_aligned' : 'bold txt_color_USD txt_right_aligned';
        }

        if (in_array($field, $arrayParseMoneyPrevius)) {
            $class .= ($moneda == 1 || $moneda == '1') ? 'bold txt_color_PESOS ' : 'bold txt_color_USD ';
        }

        if (in_array($field, $arrayParseNumber)) {
            $class .= 'txt_right_aligned ';
        }

        $arrayField = explode("_", $field);
        if(in_array('pesos', $arrayField)) $class .= 'txt_right_aligned bold txt_color_PESOS ';

        if(in_array('usd', $arrayField)) $class .= 'txt_right_aligned bold txt_color_USD ';

        if(in_array('saldo', $arrayField) ||in_array('tienda', $arrayField)) $class .= 'txt_right_aligned ';


        return $class;
    }

    static function setValue($key, $value)
    {
        $arrayParseMoney = ['moneda', 'moneda_id', 'doc_moneda_id'];

        $arrayParseDate = ['fecha', 'ultimo_pago', 'ultima_compra', 'doc_mas_antiguo'];

        $arrayParseNumber = ['rollos', 'quantity', 'total_rolls', 'total_quantity'];

        if (in_array($key, $arrayParseMoney)) {
            $value = ($value == 1 || $value == '1') ? 'PESOS' : 'USD';
        }

        if (in_array($key, $arrayParseDate)) {
            $value = getDateLabel($value);
        }

        $arrayField = explode("_", $key);
        if(in_array('pesos', $arrayField) || in_array('usd', $arrayField) || in_array('saldo', $arrayField)) {
            $value = number_format($value, 2);
        }

        if (in_array($key, $arrayParseNumber)) {
            $decimals = ($key === 'quantity' || $key === 'total_quantity') ? 6: 2;
            $value = number_format($value, 2);
        }

        return $value;
    }


    static function dashesToCamelCase($string, $capitalizeFirstCharacter = true) 
    {
        $str = str_replace('id', '', ucwords($string));
        $str = str_replace('_', ' ', ucwords($str, '_'));

        if (!$capitalizeFirstCharacter) {
            $str = lcfirst($str);
        }

        return $str;
    }

    //Función para
    function child_2_table($parent_table,$child_table,$child_title='',$parent_id="",$cols=array(),$orderby='ORDER BY 1',$totalsby_arr=array(),$sql=null,$separator='<hr/>',$ia_case = null,$caption=true,$colsPer=array(),$tdbtbdr=false,$rules4TR=false,&$cuantasCols=0,$parent_pk='', $colsHidden = [], $include_log_auth = false, $colsRename = [])
    {
        $tmp = "app_".$child_table;
        $child_class = new $tmp();

        $tmp = "app_".$parent_table;
        $parent_class = new $tmp();

        $parent_class->id = $parent_id;
        $parent_class->h = 'r';
        if($include_log_auth !== true)
            $parent_class->enDB=$parent_class->values=$parent_class->read_sql($parent_id, $parent_class->h);
        $parent_class->doChilds=false;

        $child_class->h = 'r';

        $htmlSpace = "<br/>";


        $modo = 'R/O';

        if($tdbtbdr)
            $tdbtbdr = " border-bottom:1px; border-bottom-style: solid; padding-top: 5px; border-color:gray";
        else
            $tdbtbdr = "";

        if(empty($ia_case))
            $x = new iacase('r');
        //echo "<pre>$child_title</pre>";
        if(empty($child_title))
            $child_title = $child_class->label_table_plural();

        $totals = array();
        $cols_arr = explode(',',$cols);
        $cuantasCols=sizeof($cols_arr);

        //echo "<pre>$child_title</pre>";
        //caption ahora es una fila con el título
        if($caption)
            $caption = "<tr><td colspan='$cuantasCols' class='cen txt_bold_dark_blue bold txt_1_2em'>$child_title</td></tr>";
        else
            $caption = '';

        $ret='';
        $ret="<table id='$child_table' class='print_table' style='width: 100%; padding: 4px 4px;'><thead>";
        $ret.= "$caption<tr>";


        foreach($cols_arr as $k=>$c) {
            if (!in_array($c, $colsHidden)) {
                $class_lbl = array_key_exists('extraClass4ChildLabel', isset($child_class->campos[$c]) ? $child_class->campos[$c] : []) ? $child_class->campos[$c]['extraClass4ChildLabel'] : "";

                $c = trim($c);
                if(empty($c))
                {
                    unset($cols_arr[$k]);
                    continue;
                }
                $label_field = $colsRename[$c] ?? $child_class->label_field($c);
                if(array_key_exists($c,$colsPer))
                    $ret.="<th class='cen lbl $class_lbl' style'width:$colsPer[$c]%;' >".$label_field."</th>";
                else
                    $ret.="<th class='cen lbl $class_lbl'>".$label_field."</th>";
                $totals[$c]=0;
                $cols_arr[$k] = $c;
            }
        }
        //echo "<pre>".print_r($cols_arr, true)."</pre>";
        //echo "<pre>".print_r($colsPer, true)."</pre>";

        $ret.="</thead><tbody>\r\n<tr><td colspan='".$cuantasCols."'><hr/></td></tr>";

        $doColsPer=false;
        if(empty($colsPer) || !is_array($colsPer) || sizeof($colsPer) != sizeof($totals))
            $doColsPer = false;
        else
            $doColsPer = true;
        /**
        echo "<pre>".print_r($totals,true)."</pre>";
        echo "<pre>".print_r($cols_arr,true)."</pre>";
        echo "<pre>".print_r($totalsby_arr,true)."</pre>";
        **/

        //echo "<pre>".print_r($child_class,true)."</pre>";
/*
Para el combo plantilla_id en iac_usr
$parent_id=iac_usr_id:
$child_table = plantilla

 SELECT $cols FROM plantilla JOIN iac_usr u ON u.plantilla_id=plantilla.plantilla_id WHERE u.iac_usr_id=$user_id
*/
        //VCA 24-11-2020
        $parent_pk = empty($parent_pk) ? $parent_class->pk_field : $parent_pk;
        $cols = implode(",", $cols_arr);
        if(empty($sql))
            $sql = "SELECT $cols FROM $child_table WHERE $parent_pk=".strit($parent_id)." $orderby";
        // echo "<pre>$sql</pre>";
        if ($include_log_auth === true)
            $data = array();
        else
            $data = ia_sqlArrayIndx($sql);

        // dd_($data);

        // JJDPL: Se agregan logs de tipo verificar
        // if ($child_title === 'A U T O R I Z A C I O N E S' || $include_log_auth === true) {
        if ($include_log_auth === true) {
            $document_logs = $this->getLogAuthDocument();
             //dd_($data);
            foreach ($data as $index => &$val) {

                if ($val['ultimo_movimiento'] === 'ALTA' /*|| $val['ultimo_movimiento'] === 'QUANTITY'*/) {
                    unset($data[$index]);
                    continue;
//
//                    $val['autorizado_por'] = null;
//                    $val['autorizado_el'] = null;
//                    $val['desautorizado_el'] = null;

                }

                if (empty($val['autorizado_por']) && empty($val['autorizado_el']) && empty($val['desautorizado_el'])){
                    unset($data[$index]);
                }
                if (empty($val['ultimo_movimiento']) || $val['ultimo_movimiento'] === 'A CUENTA BORRADO') {
                    unset($data[$index]);
                }

            }

            // dd_($data);
            if (!empty($document_logs)) {
                $data = array_merge($data, $document_logs);
            }
            // ordenamos por alta_db DESC
            usort($data, function ($a, $b){
                return (strtotime($a["alta_db"]) < strtotime($b["alta_db"])) ? 1 : -1;
            });
        }

        if(empty($data))
            return '';
        // echo "<pre>".print_r($data, true)."</pre>";

//        echo "<pre>".print_r($data, true). "</pre>";
        if (count($data) < 2) $totalsby_arr = [];

        $doRules4TR = false;
        /** **/
        /**
        [0] = columnas
        [1] = condición
        [2] = clase que se debe aplicar.
        **/
        if($rules4TR !== false)
            $doRules4TR = true;
        /** **/

        foreach($data as $d)
        {
            //if (empty($parent_class->enDB[$parent_pk])) {

            //echo "<pre>".print_r($d, true)."</pre>";
                if(array_key_exists($parent_pk, $d)) {

                    $parent_class->id = $d[$parent_pk];

                    $parent_class->h = 'r';
                    $parent_class->enDB=$parent_class->values=$parent_class->read_sql($parent_class->id, $parent_class->h);
                    $parent_class->doChilds=false;
                }
            //}
            $child_class->enDB = $child_class->values = $d; //echo "<pre>".print_r($child_class, true)."</pre>";
            $ret.="<tr>";
            $k=0;

            $extraStyle='';

            if($doRules4TR)
            {
                foreach($rules4TR[0] as $k=>$fieldName)
                {
                    $doEE = "'".$child_class->values[$fieldName]."'".$rules4TR[1][$k];
                    $er = false;
                    $ee = "\$er = ($doEE)? true:false;";
                    eval($ee);
                    if($er)
                        $extraStyle.=" ".$rules4TR[2][$k];
                }
            }


            foreach($cols_arr as $fieldName)
            {
                $style = "";
//                echo "<pre>$fieldName: ".print_r($child_class->campos[$fieldName], true)."</pre>";
                //echo "<pre>$fieldName: ".$child_class->show($fieldName)."</pre>";
                if (!in_array($fieldName, $colsHidden)) {
                    $array = isset($child_class->campos[$fieldName]) ? $child_class->campos[$fieldName]: [];

                    if(stripos($fieldName,'numero')!==FALSE)
                        $style='txt_centered';
                    elseif(array_key_exists('numeric', $array) && $child_class->campos[$fieldName]['numeric'] && stripos($fieldName,'cuentaT')===FALSE && stripos($fieldName,'moneda')===FALSE && stripos($fieldName,'metodo_pago')===FALSE && stripos($fieldName,'_id')===FALSE)
                        $style='txt_right_aligned';
                    else
                        $style='txt_centered';

                    //tipo de cambio
                    if(stripos($fieldName,'tipo_cambio')!==FALSE)
                    {
                        if(floatval($child_class->values[$fieldName]) == 1.00)
                            $child_class->values[$fieldName] = '';
                    }

                    //remarks
                    if(stripos($fieldName,'comentario')!==FALSE || stripos($fieldName,'remarks')!==FALSE)
                    {
                        $child_class->values[$fieldName] = strip_tags(nl2br($child_class->values[$fieldName]),'<br><br/>');
                    }

                    //note, para bitácora.
                    if(stripos($fieldName,'note')!==FALSE)
                    {
                        $child_class->values[$fieldName] = nl2br($child_class->values[$fieldName]);
                    }

                    if(array_key_exists($fieldName, $child_class->campos) && array_key_exists('extraClass4Child', $child_class->campos[$fieldName]))
                        if(stripos($child_class->campos[$fieldName]['extraClass4Child'],'align')!==FALSE)
                            $style = $child_class->campos[$fieldName]['extraClass4Child'];
                        else
                            $style = $style . " " . $child_class->campos[$fieldName]['extraClass4Child'];

                    //Estilos condicionales por columna
                    if(array_key_exists('extraClass4ChildCond', $array))
                    {
                        if($child_class->campos[$fieldName]['extraClass4ChildCond'][0] == 'doc_moneda_id')
                        {
//                        echo "<li>$fieldName";
//                        echo "<li>Parent Class: " .$parent_class->enDB['moneda_id'];
//                        echo "<li>Child Class: " . $child_class->values['moneda_id'];
                            //echo "<pre>SON".print_r($child_class->values, true)."</pre>";

                            /*die();
                            if (isset($child_class->values['doc_moneda_id'])) {
                                if($child_class->values['doc_moneda_id'] == 1)
                                    $style.=" txt_color_PESOS";
                                else
                                    $style.=" txt_color_USD";
                            }
                            else*/
                                if($parent_class->enDB['moneda_id'] == 1)
                                    $style.=" txt_color_PESOS";
                                else
                                    $style.=" txt_color_USD";

                            /*} else {
                                if($child_class->values['moneda_id'] == 1)
                                    $style.=" txt_color_PESOS";
                                else
                                    $style.=" txt_color_USD";
                            }*/

//                        echo "<li>$style";
                        }
                        else
                        {
                            $doEE = "'".$child_class->values[$child_class->campos[$fieldName]['extraClass4ChildCond'][0]]."'".$child_class->campos[$fieldName]['extraClass4ChildCond'][1];

                            $er = false;
                            $ee = "\$er = ($doEE)? true:false;";
                            eval($ee);
                            if($er)
                                $style.=" ".$child_class->campos[$fieldName]['extraClass4ChildCond'][2];
                            else
                                $style.=" ".$child_class->campos[$fieldName]['extraClass4ChildCond'][3];
                        }
                    }

                    //VCA 14-09-2021 Hack de José para 'CHEQUE DD' ? 'NOTA'.
                    $val4Table = $child_class->show($fieldName) == 'CHEQUE DD' ? 'NOTA' : $child_class->show($fieldName);
                    if($fieldName == 'metodo_pago_id' && $val4Table == 'Link')
                        $val4Table = 'Depósito';
                    //$val4Table = $child_class->display($fieldName,array(),$v,$modo,false,'log');
                    if(array_key_exists('donotShowifZero', $array) && $child_class->values[$fieldName] == 0)
                        $val4Table = '';


                    $tdwidth='';
                    if($doColsPer == true)
                        $tdwidth = isset($colsPer[$k]) ? " width:$colsPer[$k]%; " : " ";

                    $style.=$extraStyle;

                    $ret.="<td class='$style padding_4px' style='$tdwidth vertical-align:middle; $tdbtbdr".($child_class->values[$fieldName]=='No'?"color:red;":"")."'>$val4Table";
                    if(in_array($fieldName,$totalsby_arr))
                    {
                        $action = 'sum';

                        if(array_key_exists('specialActionTotal4Child', $child_class->campos[$fieldName]))
                            $action = $child_class->campos[$fieldName]['specialActionTotal4Child'];

                        switch($action)
                        {
                            case 'sum':
                                $totals[$fieldName]+=$child_class->values[$fieldName];
                                break;

                            case 'count':
                                $totals[$fieldName]+=1;
                                break;

                            default:
                                $totals[$fieldName]+=$child_class->values[$fieldName];
                                break;
                        }

                    }
                }

                $k++;
             }
             //$ret.="</tr>";
        }
        $ret.="\r\n</tbody>";



        if(!empty($totalsby_arr))
        {
            $ret.="\r\n<tfoot><tr>";

            $ret.="\r\n<td colspan='".sizeof($cols_arr)."'><hr/></td></tr><tr>";
            foreach($cols_arr as $fieldName)
            {
                if(in_array($fieldName,$totalsby_arr))
                {
                    $style = 'lbl bold txt_right_aligned';

                    if(array_key_exists('extraClass4Child', $child_class->campos[$fieldName]))
                        $style = $style . " " . $child_class->campos[$fieldName]['extraClass4Child'];

                    //Estilos condicionales por columna
                    if(array_key_exists('extraClass4ChildCond', $child_class->campos[$fieldName]))
                    {
                        if($child_class->campos[$fieldName]['extraClass4ChildCond'][0] == 'doc_moneda_id')
                        {
                            if($parent_class->enDB['moneda_id'] == 1)
                                $style.=" txt_color_PESOS";
                            else
                                $style.=" txt_color_USD";
                        }
                        else
                        {
                            $doEE = "'".$child_class->values[$child_class->campos[$fieldName]['extraClass4ChildCond'][0]]."'".$child_class->campos[$fieldName]['extraClass4ChildCond'][1];
                            $er = false;
                            $ee = "\$er = ($doEE)? true:false;";
                            eval($ee);
                            if($er)
                                $style.=" ".$child_class->campos[$fieldName]['extraClass4ChildCond'][2];
                            else
                                $style.=" ".$child_class->campos[$fieldName]['extraClass4ChildCond'][3];
                        }
                    }

                    if(array_key_exists('
                    .
                    ', $child_class->campos[$fieldName]))
                        $ret.="<td class='$style'>$totals[$fieldName]</td>";
                    else
                        $ret.="<td class='$style'>".number_format($totals[$fieldName],2,'.',',')."</td>";


                } else
                    $ret.="<td>&nbsp;</td>";
            }

            $ret.="\r\n</tr></tfoot>";
        }

        $ret.="\r\n</table>$htmlSpace$separator";
        return $ret;
    }

    function getLogAuthDocument(string $record_id = '') {
        $record_id = (empty($record_id)) ? $this->id: $record_id;
//IF (ultimo_movimiento LIKE '%QUITA%', alta_db, null) desautorizado_el,
        //null desautorizado_el,
        $sql_logs = "
    SELECT
        autorizado_por,
        IF (ultimo_movimiento NOT LIKE '%QUITA%' AND ultimo_movimiento LIKE '%VERIFI%', alta_db, null) autorizado_el,
        ultimo_movimiento, alta_db
    FROM (
        SELECT
        usuario as autorizado_por,
        null autorizado_el,
    CASE 
        WHEN note LIKE '%verificó%' THEN 'VERIFICADO'
        WHEN note LIKE '%quitó la verificación%' THEN 'QUITA VERIFICACIÓN'
        WHEN note LIKE '%rechazó el%' THEN 'RECHAZADO'
        WHEN note LIKE '%quitó el rechazo%' THEN 'QUITA RECHAZO'
        WHEN note LIKE '% cuenta%' THEN 'BORRA A CUENTA'
        ELSE UPPER(kv_accion_log.accion)
    END as ultimo_movimiento, alta_db
    FROM kv_record_log LEFT JOIN kv_accion_log ON kv_record_log.kv_accion_log_id = kv_accion_log.kv_accion_log_id  
        WHERE record_id = ".strit($record_id)." 
        AND (kv_record_log.kv_accion_log_id = 4
        OR kv_record_log.kv_accion_log_id = 1 
        OR (kv_record_log.kv_accion_log_id > 50 AND kv_record_log.kv_accion_log_id < 70) 
        OR note LIKE '%SE ELIMINA EL%') 
        ORDER BY alta_db DESC
    ) logs_documento ORDER BY alta_db DESC";
        return ia_sqlArrayIndx($sql_logs);
    }

    //Función para generar la bitácora en HTML, PDF y ajax.
    function despliegaBitacora($cache=false)
    {
        $movsHTML = "<div id='despliegaBitacora' class'dvrd' style='width: 100%;'>";
        $movsHTML .= $this->child_2_table('fiduciario', 'kv_record_log','Bitácora de Modificaciones', $this->id,
        'alta_db,usuario,kv_accion_log_id,note','ORDER BY alta_db DESC',array(),
        "SELECT alta_db,usuario,kv_accion_log_id,note,revisado FROM kv_record_log WHERE record_id = '$this->id' ORDER BY alta_db DESC",
        '', $this, false,array(),true,array(array('revisado'),array("=='No'"),array('txt_bold_brightred')));
        $movsHTML .= "</div>";

        return $movsHTML;
    }

    function despliega_autorizaciones($cache = false, $include_log_auth = true) // VCA OJO aquí empiezas el 27-04-2021
    {
        if($cache && !empty($this->values['html_verified']))
            return $this->values['html_verified'];

//        $colsConts = 'autorizado_por,autorizado_el,desautorizado_el,ultimo_movimiento,alta_db';
        $colsConts = 'autorizado_por,autorizado_el,ultimo_movimiento,alta_db';
        $colsContsTot = array();
        $colsWidths = array();
//        $order_by = 'ORDER BY desautorizado_el DESC, autorizado_el DESC';
        $order_by = 'ORDER BY alta_db DESC';

        $movsHTML = "<div id='autorizaciones_div' class='dvrd div_autorizaciones_doctos' style='width: 420px; float:left; padding: 5px; border:#1111b1 solid 1px'>";
        //$movsHTML .= "<span class='bold lbl'>A U T O R I Z A C I O N E S</span>";
        $movsHTML .= $this->child_2_table('doctos', 'doctos', 'A U T O R I Z A C I O N E S', $this->id,
            $colsConts, $order_by,
            $colsContsTot, null, '', $this, false,
            $colsWidths, false, false, $numero_desconocido, "doc_origen_id", [], $include_log_auth);
        $movsHTML .= "</div>";

        return $movsHTML;
    }

/////////////////////////
/// Auto cierre y cierre
/////////////////////////
	/*
		Agregar:
		1.- En forma_pre(&$h,&$nexth) {
				if($h=='e' || $h=='s')
					$this->autocierre_forma_pre();
		2.- En forma_PostDiv
				if($h=='e' || $h=='s')
					$this->autocierre_postDiv($h);
			    parent::forma_postDiv($h,$nexth);
		3.- EN
				$this->autocierre_listme_postRender();
				parent::listme_postRender($grid);
		4. en construct
				$this->autocierre_construct();


	*/
	function autocierre_construct() {
        //VCA 28-06-2017 Lo cambiaremos por puede_borrar
        return;
        if(usuarioTipoRony($_SESSION['usuario_id']))
        {
            $this->iajqgrid_actions_extra[0]=array('icon'=>'ui-icon-locked','title'=>'Cerrar '.ucfirst($this->table), 'isjs'=>true, 'url'=>'cerrarDocumentodesdeGrid','target'=>'_self','params'=>'','id'=>$this->table.'_id');
            $this->actions_width = 85;
        }
	}
	function autocierre_postDiv($h) {
	global $gIAParametros;

    //arreglado, causó un error paid cuando no era.
    if(!array_key_exists($this->id,$_SESSION))
        return;

	    //Autocierre
	    if($h=='e' || $h=='s')
	    {
	        $pa = $_SESSION["$this->id"] ?? $_SESSION["A_$this->id"] ?? '';
	        $pa = str_replace('iah=e','iah=r',$pa);

	        echo <<<AUTOCIERRE
<div style="width: 50px; height: 35px;" id="pageTimer"></div>
<script>

arrHotKeysDocPadre = [ ['alt+s','acT_PayAll','click'],['alt+a','acT_aCta','click']];
incializaHotKeysLocales(arrHotKeysDocPadre);
var rDoc = '$pa';
$(function() { abrirDocumento(); });
function debeCerrarDocumento(){
    $.ajax({
        url: "ajax/docs_acciones.php",
        cache: false,
        type: "get",
        data: {accion:'debeCerrarDocumento',doc_id:'$this->id',doc:'$this->table',aa:'$this->h'},
    })
    .done(function(response,textStatus,jqXHR){
        try {
            var jsonDoc = eval('(' + response + ')');
            if(jsonDoc.Status == 'OK'){
                if(jsonDoc.accionFinal == 'cerrado'){
                    iaFormDirty=false; window.location = rDoc;
                }
                else if(jsonDoc.accionFinal == 'recargar'){
                    iaFormDirty=false; location.reload();
                }
            }
        }catch(err){alert(err.message);console.log(response) }
    }).fail(function(jqXHR,textStatus,errorThrown){console.log($(this).url+" ajax failed "+textStatus);});
}
function cerrarDocumento(fuerza = true){
    $.ajax({
        url: "ajax/docs_acciones.php",
        cache: false,
        type: "post",
        data: {accion:'cerrarDocumento',doc_id:'$this->id',doc:'$this->table',ae:'c',fuerza:fuerza},
    }).fail(function(jqXHR,textStatus,errorThrown) {console.log($(this).url+" ajax failed "+textStatus);});
}
function abrirDocumento(){
    $.ajax({
        url: "ajax/docs_acciones.php",
        cache: false,
        type: "post",
        data: {accion:'abrirDocumento',doc_id:'$this->id',doc:'$this->table',ae:'a'},
    })
    .always(function(){
        var startTime = new Date(),endTime = new Date(); 
        endTime.setMinutes(startTime.getMinutes() + $gIAParametros[tiempo_para_cerrar_documento]);
        $('#pageTimer').countdown({until: endTime, 
        // compact: true, 
        format: 'MS', 
        // layout: '{m1000} {sn}',
        onExpiry: function(){
            // debeCerrarDocumento();
            setInterval(debeCerrarDocumento, 10000);
            /*iaFormDirty=false; window.location = "$pa";*/
        }, 
        onTick: debeCerrarDocumento, tickInterval: 10})
            .countdown($.countdown.regional['es']).makeAbsolute().draggable()
            .css({ left: $('#divDataTable').width() - $('#pageTimer').width(), top: $('#divDataTable').position().top });        
    })
    .fail(function(jqXHR,textStatus,errorThrown) {console.log("ajax failed",$(this).url); console.log("ajax error is",textStatus);});
}

function muestra_oculta_autorizaciones(fuerza = ''){
    let \$autorizaciones_div = \$('#autorizaciones_div'), \$div_verified_group = \$('#div_verified_group');
    
    \$("#autorizaciones_boton").remove();
        if(\$autorizaciones_div.is(":visible") || fuerza === 'hide'){
            \$div_verified_group.append('<div id="autorizaciones_boton" style="float:left;"><img src="../img/35-rojo-abajo-flecha.png" alt="Mostrar Bitácora de Autorizaciones" title="Mostrar Bitácora de Autorizaciones" class="noborders" onclick="muestra_oculta_autorizaciones();" style="cursor:pointer;"></div>');
            \$autorizaciones_div.hide();
            
        }
        else if(!\$autorizaciones_div.is(":visible") || fuerza === 'show'){
            \$div_verified_group.append('<div id="autorizaciones_boton" style="float:left;"><img src="../img/35-verde-arriba-flecha.png" alt="Ocultar Bitácora de Autorizaciones" title="Ocultar Bitácora de Autorizaciones" class="noborders" onclick="muestra_oculta_autorizaciones();" style="cursor:pointer;"></div>');
            \$autorizaciones_div.show();
        }
   }
   
    $(function() {muestra_oculta_autorizaciones('hide');});
</script>
AUTOCIERRE;
	    }

	}

	protected function autocierre_listme_postRender() {
        if(usuarioTipoRony($_SESSION['usuario_id']))
        {
        	$iajggrid_var = "iajqgrid".$this->table."_var";
            echo <<<FUNCCERRARDOC
<script>
function cerrarDocumentodesdeGrid(doc_id){
    if(doc_id.length == 0)
        return false;
    selected_row_id = doc_id;
    var doc = '$this->table', ae = 'c', fuerza = true;
    $.ajax({
        url: "ajax/docs_acciones.php",
        cache: false,
        type: "post",
        data: {'accion':'cerrarDocumento','doc_id':doc_id,'doc':doc,'ae':ae,'fuerza':fuerza},
    }).done(function(response,textStatus,jqXHR ) {
        try {
            var jsonDoc = eval('(' + response + ')');
            if(jsonDoc.Status == 'OK'){
                if(jsonDoc.accionFinal == 'cerrado'){
                    $iajggrid_var.trigger('reloadGrid');
            }
            }
        }catch(err){alert(err.message);console.log(response) }
   	}).fail(function(jqXHR,textStatus,errorThrown){console.log($(this).url+" ajax failed "+textStatus);});
}
</script>
FUNCCERRARDOC;
        }
	}

	protected function autocierre_forma_pre() {
            //ESTATUS DEL DOCUMENTO.
            $ed = estatusDocumento($this->table, $this->id);
//            echo "<pre>".print_r($ed, true)."</pre>";
//            die();
            if($ed['status']=='CERRADO' || ($ed['status']=='ABIERTO' && $ed['abierto_por'] == $_SESSION['usuario']))
            {
                //die("voy a abrir el doc.");
                if(!marcaAbiertoDocumento($this->table, $this->id))
                    $this->msg_aviso = "Error al marcar el <strong>$this->table</strong> como abierto";
                //die($this->msg_aviso);
            }
            else
            {

                //$doc_r = (!empty($_SERVER['HTTPS'])) ? "https://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'] : "http://".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
                $doc_r = (!empty($_SERVER['HTTPS'])) ? "https://$_SERVER[SERVER_NAME]:$_SERVER[SERVER_PORT]$_SERVER[REQUEST_URI]" : "http://$_SERVER[SERVER_NAME]:$_SERVER[SERVER_PORT]$_SERVER[REQUEST_URI]";
                $doc_r = str_replace('iah=e','iah=r',$doc_r);

                //$pa = $this->id;

                if(true || $_SESSION['usuario_id'] == 1)
                {
                    $msg = "El <strong>".strtoupper($this->table)."</strong> está abierto por: <strong>".($ed['abierto_por']??'')."</strong>. ¿Deseas cerrarlo?";
                    echo <<<CERRARDOCONO
<div id="IA_ERROR" style="display:none; z-index: 100000;"></div>
<div id="IA_INFO" style="display:none; z-index: 100000;"></div>
<div id="IA_DLGGEN" style="display:none; z-index: 100000;"></div>

<style>
    .tox.tox-tinymce {
        width: max-content !important;
    }
</style>
<script>
if(!divIDError) var divIDError = 'IA_ERROR';
if(!divIDInfo)  var divIDInfo = 'IA_INFO';
if(!divIDTemp)  var divIDTemp = 'IA_TEMP';
if(!divIDSolReem)  var divIDSolReem = 'IA_SOLREEM';
if(!divIDConf)  var divIDConf = 'IA_CONF';

a_cuentas_selected_row_id = '';
a_cuentas_log_selected_row_id = '';

$(function() {preguntaPorCerrarDocumento();});

function preguntaPorCerrarDocumento(){
    $("#" + divIDInfo).html('<br/>$msg').dialog({
	    resizable: false,
		modal: true,
        width: 600,
        title: 'Cerrar $this->table',
        open: function(event, ui) {
            //hide close button.
            $(this).parent().children().children('.ui-dialog-titlebar-close').hide();
            iaFormSetDirty(false);
            },
		buttons: {
		    'Cerrar $this->table para poder Modificarlo': function() {
                cerrarDocumentoxRony();

    		},
            'Abrirlo como sólo Lectura': function() {
    			window.location = "$doc_r";
            }
		}
	});
}

function cerrarDocumentoxRony()
{
    doc_id = '$this->id';
    doc = '$this->table';
    ae = 'c';
    fuerza = true;
    $.ajax({
        url: "ajax/docs_acciones.php",
        cache: false,
        data: {'accion':'cerrarDocumento','doc_id':doc_id,'doc':doc, 'ae':ae,'fuerza':fuerza},
    }).done(function(response,textStatus,jqXHR) {
        try {
            var jsonDoc = eval('(' + response + ')');
            if(jsonDoc.Status == 'OK'){
                if(jsonDoc.accionFinal == 'cerrado'){
                    location.reload();
                }
            }
        }catch(err){alert(err.message);console.log(response) }
   	}).fail(function(xhr,textStatus,thrownError) {
        try {
            var jsonDoc = eval('(' + xhr + ')');
            if(jsonDoc.Status == 'OK'){
                if(jsonDoc.accionFinal == 'cerrado'){
                    location.reload();
                }
            }
        }catch(err){alert(err.message);console.log(xhr) }
        console.log($(this).url + " ajax failed "+textStatus);
	});
}
</script>
CERRARDOCONO;
                }
                else
                {
                    echo <<<REDIRECTA
<script>
    $(function() {
        window.location = "$doc_r";
    });
</script>
REDIRECTA;
                }

                die(); //qutar para controlas con $function()
            }
	}

    function agrega_data_validation($fieldName,&$atributes=array(),$value=null,&$modo=null,$oriValue=null,$forzaEdit=false){
        $campo_tipo = $this->campos[$fieldName]['Type'] ?? '';
        $defs=array('funcCall'=>'funcCall','maxlength'=>'maxSize','minlength'=>'minSize','min'=>'min','max'=>'max','required'=>'required');
        $dv=array();
        $frules=$this->campos[$fieldName]??[];
        $dvstr='';


        foreach($defs as $rule=>$dvrule)
            if(array_key_exists($rule, $frules)) {
                if($campo_tipo == 'date'){
                    if($rule == 'min')
                        $dv['past'] = $frules[$rule];
                    if($rule == 'max')
                        $dv['future'] = $frules[$rule];
                }
                else
                    $dv[$dvrule] = $frules[$rule];
            }

        if(sizeof($dv))
            foreach($dv as $k=>$v)
                if($k=='required') {
                    if($v !== false) $dvstr .= "$k,";
                }else
                    $dvstr.="$k"."[".$v."],";

        if(strlen($dvstr)){
            $dvstr="validate[".substr($dvstr, 0, -1)."]";
            $atributes['data-validation-engine']=$dvstr;
        }
    }

    function insert_post_save(){
        @async_ws_generaCatalogos(array($this->table,'doctos'));
        parent::insert_post_save();
    }

    function update_pre_save(){

//        $this->my_ia_case_Lock = new ProcessLock();
//        $s = md5($this->id);
//        $gotLock = $this->my_ia_case_Lock->aquire($s);
//
//        if(!$gotLock) {
//            $this->msg_err.="<li><strong class='txt_shadow_rojo_quemado txt_1_3em'>Concurrencia de updates. Intenta nuevamente.</strong>";
//            // $this->my_ia_case_Lock->release();
//            return false;
//        }

//        sleep(30);

        parent::update_pre_save();
        return true;
    }

    function update_post_save(){

//        if($this->my_ia_case_Lock)
//            $this->my_ia_case_Lock->release();

//        @async_ws_generaCatalogos(array($this->table,'doctos'));
        parent::update_post_save();
    }

    function delete_post_delete($h){
        @async_ws_generaCatalogos(array($this->table,'doctos'));
        parent::delete_post_delete($h);
    }

    function insert_pre_validate()
    {
        return parent::insert_pre_validate() && $this->revisaReferreriacase();
    }

    function update_pre_validate()
    {
        return parent::update_pre_validate() && $this->revisaReferreriacase();
    }

    function delete_pre_validate($h)
    {
        return parent::delete_pre_validate($h) && $this->revisaReferreriacase();
    }

    function revisaReferreriacase()
    {
        $h = $this->h;
        $ok = true;

        $ref = array_key_exists('HTTP_REFERER', $_SERVER) ? $_SERVER['HTTP_REFERER'] : "";
        if(strpos($ref,'backoffice/estado.php') !== false ||
            strpos($ref,'backoffice/categoria.php') !== false ||
            strpos($ref,'bodega/estado_bodega.php') !== false ||
            strpos($ref,'backoffice/bodega_grupo_verificador.php') !== false ||
            strpos($ref,'bodega/permisos_bodega.php') !== false ||
            strpos($ref,'bodega/trial_by_fire.php') !== false ||
            strpos($ref,'backoffice/ayudantes.php') !== false ||
            strpos($ref,'bodega/edita_movimiento.php') !== false ||
            strpos($ref,'bodega/edita_movimientos_v2.php') !== false ||
            strpos($ref,'bodega/edita_verificacion.php') !== false ||
            strpos($ref,'bodega/edita_verificacion_v2.php') !== false ||
            strpos($ref,'backoffice/ajuste.php') !== false
        ) // es jquery ui-dialog sin iah
            return true;
        switch($h)
        {
            case "d":
                if(strpos($ref,'iah=b') === false)
                {
                    //$ref = str_replace('iah=d','iah=b',$ref);
                    $this->msg_err = "<li class='bold'>No se puede borrar el documento sin pasar por la verificación.";
                    $ok = false;
                }
                break;

            case "s":
                if($this->modo != 'jqgrid_iacform' && strpos($ref,'iah=e') === false)
                {
                    //$ref = str_replace('iah=s','iah=e',$ref);
                    $this->msg_err = "<li class='bold'>No se puede guardar el documento sin pasar por el formulario de edición.";
                    $ok = false;
                }
                break;

            case "i":
                if(strpos($ref,'iah=a') === false)
                {
                    //$ref = str_replace('iah=i','iah=a',$ref);
                    $this->msg_err = "<li class='bold'>No se puede insertar el documento sin pasar por el formulario de alta.";
                    $ok = false;
                }
                break;

            case "a":case "e":case "b":
                $ok = true;
                break;

            default:
                $ok = false;
                break;
        }


        return $ok;
    }

    public function forma_postDiv($h,$nexth){

        if($h == 'a' || $h == 'i' || ($this->table != 'cheque' && $this->table != 'pagare' && $this->table != 'vale' && $this->table != 'cliente_saldo')) {
            if($h == 'a' || $h == 'i')
                parent::forma_postDiv($h,$nexth);
            return;
        }
        echo estado_cuenta_cliente($this->enDB['cliente_id'], $this->table);
        $fileName = $this->label_record_summary();
        $fileName = sanitizeFileName($fileName);

        init_estado_cuenta_cliente(fileName: $fileName, cliente_id: $this->enDB['cliente_id']);

        parent::forma_postDiv($h,$nexth);
    }


    /**
     * iacase::show_alta_por_con_link()
     *
     * @param string $fieldName nombre del campo
     * @param array $atributes
     * @param mixed $value
     * @param null $modo Nada, R/O, R/W
     * @param bool $putLink
     * @param string $enumlogType
     * @return string|void
     */
    function show_alta_por_con_link($fieldName,$atributes=array(),$value=null,&$modo=null,$putLink=true,$enumlogType='') {
        //echo $fieldName;
        if ($value === null)
            $value = $this->values[$fieldName];

        if(($this->table === 'cheque' || $this->table === 'pagare' || $this->table === 'vale' || $this->table === 'compra') &&
            array_key_exists($fieldName,$this->campos)) {


            $href = "";
            $ponHttp = 'cuentat_mov.php?cuentat=';

            $href = $ponHttp . $value;

            switch($this->table) {
                case 'cheque':
                    if($this->values['delivered_directo'] == 0 &&
                    $this->values['origen_cuentat_id'] > 0 &&
                    !empty($this->values['origen_cuentat_id'])) {
                        $ponHttp = "cuentat_mov.php?cuentat={$this->values['origen_cuentat_id']}&selected_row_id={$this->values['cuentat_mov_id']}";
                        $href = $ponHttp;
                    }
                    break;
                case 'vale':
                    if(!empty($this->values['cuenta_t_mov_id'])) {
                        $ponHttp = "cuentat_mov.php?cuentat={$this->values['cuentaT_id']}&selected_row_id={$this->values['cuenta_t_mov_id']}";
                        $href = $ponHttp;
                    }
                    break;



            }
            $pie_campo = array_key_exists('pie', $this->campos[$fieldName]) ? $this->campos[$fieldName]['pie'] : '';



            return "<a target='_blank' rel='opener refferer' href='" . $href . "' class='tooltip_toolbar_wohtml bold txt_shadow_azul_marino pointer' title='Ir a movimientos de Cuenta T'>" . ia_htmlentities($value) . "</a>$pie_campo";
        }
        else
            return "<strong>$value</strong>";

    }
}