<?php
require_once('../../inc/config.php');
session_write_close();

/**
 * Clase que extiende de AjaxHelper para gestionar la obtención de datos relacionados
 * con alumnos becados. Permite verificar permisos y recuperar información de alumnos
 * becados desde la base de datos.
 */
class getAlumnosBecados extends AjaxHelper {

    function __construct()
    {
        parent::__construct();
        $this->setDebug();
    }

    /**
     * Regresa true si el usuario tiene permiso de hacer $this->accion, false del contrario
     * @return bool True puede hacer la accion, false no tiene permiso
     */
    protected function puedeHacerAccion(): bool
    {
        return match ($this->accion) {
            'get_alumno_becado' => true,
            default => false,
        };
    }

    /**
     * Obtiene los datos de un alumno becado basado en su identificador o parámetros específicos.
     * Si no se proporciona un identificador, utiliza un límite para obtener alumnos becados.
     * Ajusta la respuesta con los resultados obtenidos o un mensaje en caso de error.
     *
     * @param string $alumno_becado_id Identificador del alumno becado (opcional). Si no se proporciona, se intenta obtenerlo desde los parámetros globales.
     * @return void No retorna valor, pero modifica el arreglo de respuesta con el estado y los datos de los alumnos becados o un mensaje de error.
     */
    protected function get_alumno_becado(string $alumno_becado_id = ''):void
    {
        $str_where = "";
        if($alumno_becado_id == '')
            $alumno_becado_id = param('alumno_becado_id');
        if($alumno_becado_id == '') {
            $limit = param("limit", " LIMIT 1");

            $str_where = " WHERE 1 ORDER BY estudiante_id " . $limit;
        }
        else {
            $str_where = "WHERE alumno_becado_id = " . strit($alumno_becado_id);
            $this->response['alumno_becado_id'] = $alumno_becado_id;
        }
        $queryAlumnosBecados = "SELECT /* get_alumnos_becados.php get_alumno_becado */ * FROM alumnos_becados " . $str_where;
        $alumnos_becados = ia_sqlArrayIndx($queryAlumnosBecados);

        if($alumnos_becados === false) //Sí hubo error
        {
            $this->response['status'] = false;
            $this->response['message'] = "No se trajeron los alumnos_becados";
            return;
        }
        $this->response['status'] = true;
        $this->response['message'] = 'get alumnos_becados archivo get_alumnos_becados.php';
        $this->response['alumnos_becados'] = $alumnos_becados;

    }

}

$getAlumnosBecados = new getAlumnosBecados();