<?php
require_once('../../inc/config.php');
session_write_close();

/**
 * accion=getUsersActive: trae los usuarios activos
 *
 * @author Clara
 * @version 1.1
 */

class UserUtil extends AjaxHelper {

    function __construct()
    {
        parent::__construct();
        $this->setDebug();
    }

    /**
     * Regresa true si el usuario tiene permiso de hacer $this->accion, false del contrario
     * @return bool True puede hacer la accion, false no tiene permiso
     */
    protected function puedeHacerAccion(): bool
    {
        return match ($this->accion) {
            'getUsersActive' => usuarioTipoRony(),
            default => false,
        };
    }

    protected function getUsersActive():void
    {
        $method = __METHOD__;
        $sql="SELECT /*$method*/ nick, iac_usr_id, CASE WHEN vale = 'Active' THEN 'No' END as active FROM iac_usr where vale='Active' AND iac_usr_id <>1 ORDER BY nick";
        $array_users= ia_sqlArrayIndx($sql);
        if($array_users === false) //Sí hubo error
        {
            $this->response['status'] = false;
            $this->response['message'] = "No se trajeron los usuarios";
            return;
        }
        $this->response['status'] = true;
        $this->response['message'] = 'getUsersActive';
        $this->response['usuarios'] = $array_users;

    }
}
$getUseracciones = new UserUtil();