<?php
/*
CREATE TABLE iaFiller (
    iaFiller_id MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(64) NOT NULL COMMENT 'nombre de los valores a llenar',
    descr  VARCHAR(128) NOT NULL DEFAULT '' COMMENT 'Descripcion para recordar que quiere decir el nombre',
    tag VARCHAR(64) NOT NULL DEFAULT '' COMMENT 'tipo de datos a llenar',
    color VARCHAR(32) NOT NULL DEFAULT 'iaFillerNormal' COMMENT 'clase default de la plantilla',
    vals LONGTEXT COMMENT 'json con los valores a llenar',
    alta_db DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'fecha de alta',
    ultimo_cambio  DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'fecha en que se actualizo',
    UNIQUE KEY nombre_unico(tag,nombre)
) ENGINE=Innodb COMMENT 'Plantillas de iaFiller';
*/
/* altas,bajas,cambios,lista los templates para llenar iaFiller Plantillas, ie: el dialog de depositar_en_set.php
*/
require_once('../../inc/config.php');
session_write_close();
//error_reporting(-1);
//ini_set('display_errors',0);

// check login
if(empty($_SESSION['usuario_id'])) {
    ajax_send(['errorMessage'=>'Login expirado, vuelva ha hacer login']);
}

$action = paramGet('action');
if(empty($action)) {
    ajax_send(['errorMessage'=>'Transmision invalida']);
}

$tag = paramGet('tag');

if($action === 'list') {
    $sql = "SELECT iaFiller_id, nombre, descr, color, vals FROM iaFiller WHERE tag=".strit($tag)." ORDER BY nombre";
    $list = ia_sqlArrayIndx($sql);
    if($list === false) {
        ajax_send(['errorMessage'=>"Problemas al leer las plantillas"]);
    }
    ajax_send($list);
}

if(!usuarioTipoRony()) {
    ajax_send(array('errorMessage'=>"Sin permiso de modificar plantillas"));
}

if($action === 'del') {
   $iaFiller_id = paramGet('iaFiller_id');
   $ok = ia_query("DELETE FROM iaFiller WHERE iaFiller_id=".strit($iaFiller_id)." AND tag=".strit($tag));
   ajax_send(['id'=>$iaFiller_id, 'ok'=>$ok]);
}

$values = [
    'nombre' => paramGet('nombre'),
    'tag' => paramGet('tag'),
    'descr' => paramGet('descr'),
    'color' => paramGet('color'),
    'vals' => paramGet('vals'),
];
if($action === 'update') {
    $ok = ia_query(ia_insert('iaFiller',$values,array(),'',true));
    $sql = "SELECT iaFiller_id, nombre, descr, color, vals FROM iaFiller WHERE tag=".strit($values['tag'])." AND nombre=".strit($values['nombre']);
    $list = ia_singleton($sql);
    if($list === false) {
        ajax_send(['errorMessage'=>"Problemas al leer las plantillas"]);
    }
    ajax_send($list);
}

ajax_send(['errorMessage'=>"Invalid action param"]);

function paramGet($key) {
    $p = isset($_REQUEST[$key]) ? $_REQUEST[$key] : '';
    return strim($p);
}

function ajax_send($arr) {
    echo json_encode($arr);
    ia_errores_a_dime();
    exit();
}


?>