<?php
/** @noinspection PhpUnused */

use Iac\inc\sql\IacSqlBuilder;

require_once('../../inc/config.php');

error_reporting( E_ALL );
ini_set('ignore_repeated_errors', "1");
ini_set('display_errors',"1");
global $gDebugging; $gDebugging = true;

class iacParam_acciones extends AjaxHelper {

    public function __construct() {
        parent::__construct();
    }


    /**
     * @inheritDoc
     */
    protected function puedeHacerAccion(): bool {
        return match ($_REQUEST['accion'] ?? '') {
            'get', 'save', 'getParams', 'saveParametros', 'saveParametrosv2'  => usuarioTipoRony(),
            default => false,
        };
    }

    protected function get():void {
        $method = __METHOD__;
        $this->response['gIAParametros'] = ia_singleton(
            "SELECT /*$method*/ * FROM iac_parametros WHERE iac_parametros_id=1"
        );
        $fileName = $_REQUEST['html'] ?? '';
        $this->response['html'] = empty($fileName) || strrchr($fileName, ".") !== '.html' ?
            '' : file_get_contents("../view/iacParam/$fileName");
        if(empty($this->response['html'])) {
            $this->response['message'] = "Parámetro html inválido:<ol><li>Debe existir en backoffice/view/iacParam/<li>Terminar en .html<li>Llego: '$fileName'</ol>";
        }
    }
    protected function save():void {
        $fields = $_REQUEST ?? [];
        unset($fields['accion'], $fields['iac_parametros_id']);
        $builder = new IacSqlBuilder();
        $ok = !ia_query($builder->update("iac_parametros", $fields, ['iac_parametros_id'=>1]));
        $this->response['status'] = $ok;
        $this->response['message'] = $ok ? '' : 'Error inesperado al guardar los parámetros, intente más tarde';
    }

    protected function getParams()
    {
        $tema = param('tema');
        $subtema = param('subtema');
        $method = __METHOD__;
        if( !usuarioTipoRony() ){
            $this->response =  [
                'code' => 400,
                'status' => false,
                'message' => '<strong>No tiene permiso para esta acción.</strong>'
            ];
            return;
        }

        if (strpos($subtema, ',') !== false) {
            $subtema = explode(",", $subtema);
            $params_nota_bodega = "SELECT /*$method*/* FROM parametro WHERE grupo NOT LIKE 'Traslado_match_lock%' AND  tema = ".strit($tema)." AND subtema IN ('" . implode("', '", $subtema) . "')";
        }else{
            $params_nota_bodega = "SELECT /*$method*/* FROM parametro WHERE grupo NOT LIKE 'Traslado_match_lock%' AND tema = ".strit($tema)." and subtema = ".strit($subtema)." and is_active = '1'";
        }

        $params = ia_sqlArrayIndx($params_nota_bodega);

        if($params === false){
            $this->response =  [
                'code' => 200,
                'status' => false,
                'message' => 'Error en DB al leer los parametros'
            ];
            return;
        }
        if(empty($params)){
            if (is_array($subtema))
                $subtema = implode(", ", $subtema);
            $this->response =  [
                'code' => 200,
                'status' => false,
                'message' => htmlentities("Parametros de $tema, $subtema NOT FOUND"),
            ];
            return;
        }

        $this->response =  [
            'code' => 200,
            'status' => true,
            'message' => '',
            'parametros' => $params
        ];
    }

    protected function saveParametros()
    {
        $parametros = param('paramsValues');
        $method = __METHOD__;

        if(empty($parametros)){
            $this->response =  [
                'code' => 200,
                'status' => false,
                'message' => '',
                'error' => ''
            ];
            return false;
        }

        if( !usuarioTipoRony() ){
            $this->response =  [
                'code' => 200,
                'status' => false,
                'message' => 'No tiene permiso para esta acción.',
                'error' => ''
            ];
            return false;
        }
        global $gDime;
        foreach($parametros as $llave => &$valor) {
            $v = $valor["value"] ?? $valor["valor"] ?? '';
            $def = json_decode(ia_singleread(
                "SELECT /*$method*/ parametros FROM parametro WHERE parametro_id = " . strit($llave)
            ), true);
            $gDime[] = "_______________________________________________";
            $gDime[] = "____ Checando $llave: =$v= def es:";
            $gDime[] = $def;
            if(!is_array($def)) continue;
            switch($def["tipo"] ?? '') {
                case 'number':
                case 'number_decimal':
                    $float = (float)$v;
                    if(!is_numeric($v) || (float)$def["min"] >= $float || $float >= (float)$def["max"]) {
                        $this->response = [
                            'code' => 200,
                            'status' => false,
                            'error' => $llave,
                            'message' => $llave . " Debe ser númerico y entre: $def[min] y $def[max]",
                        ];
                        return false;
                    }
                    $valor["value"] = round($float,  (int)($def['decimales'] ?? 2));
                    break;
                case 'minutos':
                case 'int':
                case 'integer':
                    $int = is_numeric($v) ? floor($v) : $v;
                    if(!is_numeric($v) || floor($def["min"]) >= $int || $int >= floor($def["max"]) ) {
                        $this->response = [
                            'code' => 200,
                            'status' => false,
                            'error' => $llave,
                            'message' => $llave . " Debe ser númerico y entre: $def[min] y $def[max]"
                        ];
                        return false;
                    }
                    $valor["value"] = $int;
                    break;
                default:
                    if(array_key_exists('options', $def)) {
                        if(!in_array($v, $def['options'])) {
                            $this->response = [
                                'code' => 200,
                                'status' => false,
                                'error' => $llave,
                                'message' => $llave . " puede ser: " . implode(", ", $def['options'])
                            ];
                            return false;
                        }
                        continue 2;
                    }
            }
        }
        unset($valor, $v);

        $sql = [];
        foreach ( $parametros as $key => $v ){
            $value = $v["value"];
            $campo = explode("-", $key);
            if (str_contains($key, 'active')) {
                $valor = ($value === 'Si') ? 1 : 0;
                $subtema = str_replace('_', ' ', $campo[0]);
                $sql[] = "UPDATE /*$method*/ parametro SET is_active = " . strit($valor) . " WHERE subtema = " . strit($subtema) . " AND parametro_id != " . strit($key);
            } elseif (str_contains($key, 'unidades')) {
                $sql[] = "UPDATE /*$method*/ parametro SET parametros = JSON_SET(parametros, '$.unit', " . strit($value) . ") WHERE parametro_id = " . strit($campo[0] . "-time");
            }
            $sql[] = "UPDATE /*$method*/ parametro SET parametros = JSON_SET(parametros, '$.valor', " . strit($value) . ") WHERE parametro_id = " . strit($key);
        }


        if (ia_transaction($sql)) {
            $this->response =  [
                'code' => 400,
                'status' => false,
                'message' => 'Error al guardar en la base de datos',
                'error' => ''
            ];
            return false;
        }

        $this->response =  [
            'code' => 200,
            'status' => true,
            'message' => 'Success update params',
            'error' => ''
        ];
        return true;
    }

    protected function saveParametrosv2()
    {
        $parametros = param('paramsValues');
        $method = __METHOD__;

        if(empty($parametros)){
            $this->response =  [
                'code' => 200,
                'status' => false,
                'message' => '',
                'error' => ''
            ];
            return false;
        }

        if( !usuarioTipoRony() ){
            $this->response =  [
                'code' => 200,
                'status' => false,
                'message' => 'No tiene permiso para esta acción.',
                'error' => ''
            ];
            return false;
        }
        global $gDime;
        foreach($parametros as $llave => &$item) {
            foreach($item as &$valor){
                $v = $valor["value"] ?? $valor["valor"] ?? '';
                $def = json_decode(ia_singleread(
                    "SELECT /*$method*/ parametros FROM parametro WHERE parametro_id = " . strit($llave)
                ), true);
                $gDime[] = "_______________________________________________";
                $gDime[] = "____ Checando $llave: =$v= def es:";
                $gDime[] = $def;
                if(!is_array($def)) continue;
                switch($def["tipo"] ?? '') {
                    case 'number':
                    case 'number_decimal':
                        $float = (float)$v;
                        if(!is_numeric($v) || (float)$def["min"] >= $float || $float >= (float)$def["max"]) {
                            $this->response = [
                                'code' => 200,
                                'status' => false,
                                'error' => $llave,
                                'message' => $llave . " Debe ser númerico y entre: $def[min] y $def[max]",
                            ];
                            return false;
                        }
                        $valor["value"] = round($float,  (int)($def['decimales'] ?? 2));
                        break;
                    case 'minutos':
                    case 'int':
                    case 'integer':
                        $int = is_numeric($v) ? floor($v) : $v;
                        if(!is_numeric($v) || floor($def["min"]) >= $int || $int >= floor($def["max"]) ) {
                            $this->response = [
                                'code' => 200,
                                'status' => false,
                                'error' => $llave,
                                'message' => $llave . " Debe ser númerico y entre: $def[min] y $def[max]"
                            ];
                            return false;
                        }
                        $valor["value"] = $int;
                        break;
                    default:
                        if(array_key_exists('options', $def)) {
                            if(!in_array($v, $def['options'])) {
                                $this->response = [
                                    'code' => 200,
                                    'status' => false,
                                    'error' => $llave,
                                    'message' => $llave . " puede ser: " . implode(", ", $def['options'])
                                ];
                                return false;
                            }
                            continue 2;
                        }
                }
            }
        }
        unset($valor, $v);
        $sql = [];
        foreach ( $parametros as $key => $val ){
            foreach($val as $index => $v){
                $value = $v["value"];
                $campo = explode("-", $key);
                if (str_contains($key, 'active')) {
                    $valor = ($value === 'Si') ? 1 : 0;
                    $subtema = str_replace('_', ' ', $campo[0]);
                    $sql[] = "UPDATE /*$method*/ parametro SET is_active = " . strit($valor) . " WHERE subtema = " . strit($subtema) . " AND parametro_id != " . strit($key);
                } elseif (str_contains($key, 'unidades')) {
                    $sql[] = "UPDATE /*$method*/ parametro SET parametros = JSON_SET(parametros, '$.unit', " . strit($value) . ") WHERE parametro_id = " . strit($campo[0] . "-time");
                }
                // $sql[] = "UPDATE /*$method*/ parametro SET parametros = JSON_SET(parametros, '$.valor', " . strit($value) . ") WHERE parametro_id = " . strit($key);

                $sql[] = "UPDATE parametro SET parametros = JSON_SET(parametros,'$[".$index."].valor',CASE WHEN JSON_UNQUOTE(JSON_EXTRACT(parametros, '$[".$index."].id')) = ".strit($v["id"])." THEN ".strit($value)." ELSE JSON_UNQUOTE(JSON_EXTRACT(parametros, '$[".$index."].valor')) END ) WHERE parametro_id = ". strit($key);
            }
        }

        if (ia_transaction($sql)) {
            $this->response =  [
                'code' => 400,
                'status' => false,
                'message' => 'Error al guardar en la base de datos',
                'error' => ''
            ];
            return false;
        }

        $this->response =  [
            'code' => 200,
            'status' => true,
            'message' => 'Success update params',
            'error' => ''
        ];
        return true;
    }


}

$temp  = new iacParam_acciones();
