<?php

	require_once('../../inc/config.php');
session_write_close();
    ignore_user_abort(true);
    $arrIacParamacciones = iac_parametros_acciones();
    ia_errores_a_dime();
    echo json_encode($arrIacParamacciones);


    function iac_parametros_acciones() {
    	$accion = param("accion");
    	$doc_id = param('doc_id',param('iaid', "1"));
    	if(empty($accion) || empty($doc_id))
    		return array();


        $iacCamposPermitidos = [

            "tiempo_para_actualizar_bancos",
            "dias_actualizar_bancos",
            "hora_inicio_actualizar_bancos",
            "hora_fin_actualizar_bancos",
            "solicitar_actualizar_bancos",
            "flashear_tab_actualizar_bancos",
            "tiempo_para_actualizar_por_banco",
            "do_flash_tab",
            "dias_para_solicitar_reembolso_fiduciario",
            "dias_para_flashear_tab_fiduciario",
            "flashear_tab_fiduciario",
            "dias_despues_solicitar_reembolso",
            "do_flash_tab_fid",
            "tiempo_para_bloquear_contenedor_fiduciario",
            
            // depositar en
                "numero_filas_depositar_en",
                "maximo_filas_depositar_en",
                "redondos_mostrar_fila_1_depositar_en",
                "redondos_reset_fin_dia_depositar_en",
                "tiempo_monto_minutos_default_depositar_en",
                "tiempo_monto_veces_mostrar_depositar_en",
                "tiempo_monto_tiempo_inicia",
                "tiempo_monto_tiempo_termina",
                "tiempo_monto__fila_1_depositar_en",            
                "redondo_independiente",
                "tiempo_monto_independiente",                
                "deposita_en_default_cola_tiempo_monto",
                "deposita_en_default_cola_redondo",
                "deposita_en_default_cola_una_vez",
                "deposita_en_default_cola_diario",
                "deposita_en_default_cola_siempre",
                "deposita_en_default_cola_no_depositar",
                
                "deposita_en_max_fila_1_carril_A",
                "deposita_en_max_fila_1_carril_B",
                "deposita_en_max_fila_1_carril_C",
                "deposita_en_max_fila_1_carril_D",
                "deposita_en_max_fila_1_carril_E",
                "deposita_en_max_fila_2_carril_A",
                "deposita_en_max_fila_2_carril_B",
                "deposita_en_max_fila_2_carril_C",
                "deposita_en_max_fila_2_carril_D",
                "deposita_en_max_fila_2_carril_E",
                "deposita_en_max_fila_3_carril_A",
                "deposita_en_max_fila_3_carril_B",
                "deposita_en_max_fila_3_carril_C",
                "deposita_en_max_fila_3_carril_D",
                "deposita_en_max_fila_3_carril_E",                                
                
                "deposita_en_max_fila_1",
                "deposita_en_max_fila_2",
                "deposita_en_max_fila_3",

                "deposita_en_reinicia_diario",

                "agrega_bodegas_no_existencia",
                "origen_destino_especial",
            "dias_antes_alta_nota_bodega",
"max_salto_notas_bodega",
"tiempo_para_editar_nota_bodega",
"bloquear_notas_automaticamente",
"chofer_responsable_obligatorio",
"ayudantes_obligatorio",
"salida_max_metros",
"salida_max_rollos",
"salida_max_kilos",
"salida_max_metros_rony",
"salida_max_rollos_rony",
"salida_max_kilos_rony",
"bodegas_no_existencia",
"reset_max_quantity",
"reset_max_rollos",
"existencia_default_status",
"num_compra_dup_a_partir",
"inconsistencia_pina_por_producto",
"inconsistencia_pina_por_color",
"banco_cuenta_permite_inversion_manual",
        ];

        global $gIAParametros;

    	$arrIacParamacciones = array (	"Status" =>	"",
                                        "accion" =>	"",
                                        "Error"	=>	"",
                                        "accionFinal" => "");

        $arrIacParamacciones["accion"] = $accion;

        $usuario = $_SESSION['usuario'];
        $usuario_id = $_SESSION['usuario_id'];

        $now = date('Y-m-d H:i:s');
        switch($accion)
        {
            case 'updateIacParametros':
                //VCA 30-11-2020 probar permiso depositar_en
                if(!puedePermisoUsuario('','puede_depositar_en') && !usuarioTipoRony()) //Falta agregar permiso.
                {
                    $arrIacParamacciones['Error'] = '<strong>No tiene permiso para esta acción.</strong>';
                    $arrIacParamacciones['Status'] = 'Error';
                    return $arrIacParamacciones;
                }

                $params = $_REQUEST ?? [];
                $docND = array();

                foreach($params as $key=>$value)
                    if(in_array($key,$iacCamposPermitidos))
                        $docND[$key] = param($key);

                $doc_id='1';
                $doc = 'iac_parametros';
                $pk_campo = 'iac_parametros_id';
                
                 
                $sql=ia_update($doc, $docND, "$pk_campo='$doc_id'", array(), '', " /** iac_parametros_acciones: UPDATE doc **/ ");
                //$sql="UPDATE /** Docacciones: Poner y quitar paid **/ $doc SET paid=$paid WHERE $pk_campo='$doc_id'";

                if(ia_query($sql))
                {
                    $arrIacParamacciones['Error'] = '<strong>Error al actualizar el '.strtoupper($doc).'</strong>';
                    $arrIacParamacciones['Status'] = 'Error';
                    $arrIacParamacciones['sql'] = $sql;
                    return $arrIacParamacciones;
                }
                if(array_key_exists('tiempo_monto_minutos_default_depositar_en', $docND)) {
                    ia_query(ia_update('deposita_en', ['minutos_a_mostrar'=>$docND['tiempo_monto_minutos_default_depositar_en']], 
                        ' minutos_a_mostrar='.strit($gIAParametros['tiempo_monto_minutos_default_depositar_en']), 
                        array(), '', " /** iac_parametros_acciones: UPDATE depositar_en.minutos_a_mostrar a defaults **/ "));
                }
                if(array_key_exists('tiempo_monto_veces_mostrar_depositar_en', $docND)) {
                    ia_query(ia_update('deposita_en', ['veces_a_mostrar'=>$docND['tiempo_monto_veces_mostrar_depositar_en']], 
                        ' veces_a_mostrar='.strit($gIAParametros['tiempo_monto_veces_mostrar_depositar_en']), 
                        array(), '', " /** iac_parametros_acciones: UPDATE deposita_en.veces_a_mostrar a defaults **/ "));
                }
                                
                $arrIacParamacciones["Error"] = "";
                $arrIacParamacciones['Status'] = 'OK';
                $arrIacParamacciones['sql'] = $sql;
                leeParametrosVitex(true);
                @async_ws_actualizaFiduciariosAtrasados();
            break;

            case 'getIacParametros':
                //VCA 30-11-2020 probar permiso depositar_en
                if(!puedePermisoUsuario('','puede_depositar_en') && !usuarioTipoRony())
                {
                    $arrIacParamacciones['Error'] = '<strong>No tiene permiso para esta acción.</strong>';
                    $arrIacParamacciones['Status'] = 'Error';
                    return $arrIacParamacciones;
                }

                leeParametrosVitex(true);
                $docenDB = array();

                 foreach($gIAParametros as $key=>$value)
                    if(in_array($key,$iacCamposPermitidos))
                        $docenDB[$key] = $gIAParametros[$key];

                $arrIacParamacciones["Error"] = "";
                $arrIacParamacciones['Status'] = 'OK';
                $arrIacParamacciones['gIAParametros'] = $docenDB;
            break;

            //VCA 30-11-2020 banco_cuenta_poner_deposito_ND
            //VCA 12-12-2020 banco_cuenta_no_aparece_depositar_en
            case 'agrega_cuenta':

                //Pedimos los datos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $permiso = param("permiso");

                if($permiso != "_poner_deposito_ND" && $permiso != "_no_aparece_depositar_en") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $banco_cuenta_id=addslashes($json_cpnd->banco_cuenta_id);

                $campo = "banco_cuenta$permiso";

                $sql="UPDATE iac_parametros SET $campo = IF($campo <> '', CONCAT($campo,',',".strit($banco_cuenta_id)."),".strit($banco_cuenta_id).")";

                if($permiso == "_no_aparece_depositar_en")
                    ia_query("UPDATE banco_cuenta SET dep_inactiva = '1' WHERE banco_cuenta_id = " .strit($banco_cuenta_id));

                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al insertar $permiso en la BD.";
                    return $arrIacParamacciones;
                }

                $ret_arr_cuentas= $permiso=="_poner_deposito_ND" ? leer_banco_cuenta_poner_deposito_ND() : leer_banco_cuenta_no_aparece_depositar_en();

                if($permiso=="_poner_deposito_ND"){
                    ia_query("UPDATE banco_cuenta_mov SET link_vale = 'ND' WHERE link_vale = 'Q' AND banco_cuenta_id = " .strit($banco_cuenta_id));
                }

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Poner Cuenta con depósitos en ND insertado con éxito en la BD.";
                $arrIacParamacciones["sql"] = ("UPDATE banco_cuenta_mov SET link_vale = 'ND' WHERE link_vale = 'Q' AND banco_cuenta_id = " .strit($banco_cuenta_id));
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
                $arrIacParamacciones["banco_cuenta"] = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id=".strit($banco_cuenta_id));

                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);

                break;

            case 'quita_cuenta':

                //Recibimos banco_cuenta_id
                //La cuentas están guardadas como una cadena csv
                //Leemos el CSV lo convertimos en array, y borramos la cuenta, juntamos y guardamos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $banco_cuenta_id=addslashes($json_cpnd->banco_cuenta_id);

                $permiso = param("permiso");

                if($permiso != "_poner_deposito_ND" && $permiso != "_no_aparece_depositar_en") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $campo = "banco_cuenta$permiso";

                $cpnd_csv = ia_singleread("SELECT $campo FROM iac_parametros WHERE 1");

                $cpnd_arr = explode(",", $cpnd_csv);

                $cpnd_arr = array_flip($cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";

                unset($cpnd_arr[$banco_cuenta_id]);

                $cpnd_arr = array_keys($cpnd_arr);

                $cpnd_csv = "";

                $cpnd_csv = join(",", $cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";


                $sql="UPDATE iac_parametros SET $campo = " . strit($cpnd_csv) . " WHERE iac_parametros_id = '1'";

                if($permiso == "_no_aparece_depositar_en")
                    ia_query("UPDATE banco_cuenta SET dep_inactiva = '0' WHERE banco_cuenta_id = " .strit($banco_cuenta_id));

                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al quita_cuenta_poner_deposito_ND de la BD.";
                    die(json_encode($arrIacParamacciones));
                }


                $ret_arr_cuentas= $permiso=="_poner_deposito_ND" ? leer_banco_cuenta_poner_deposito_ND() : leer_banco_cuenta_no_aparece_depositar_en();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Quitar Cuenta con depósitos en ND eliminado con éxito de la BD.";
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
                $arrIacParamacciones["banco_cuenta"] = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id=".strit($banco_cuenta_id));
                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);
                break;

                break;
            //VCA 30-11-2020 banco_cuenta_poner_deposito_ND
            //VCA 12-12-2020 banco_cuenta_no_aparece_depositar_en
            case 'agrega_origen_destino_especial':

                //Pedimos los datos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $permiso = param("permiso");

                if($permiso != "_origen_destino_especial" && $permiso != "_origen_destino_especial") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $banco_cuenta_id=addslashes($json_cpnd->bodega_id);

                $campo = "origen_destino_especial";

                $sql="UPDATE iac_parametros SET $campo = IF($campo <> '', CONCAT($campo,',',".strit($banco_cuenta_id)."),".strit($banco_cuenta_id).")";

//                if($permiso == "_no_aparece_depositar_en")
//                    ia_query("UPDATE banco_cuenta SET dep_inactiva = '1' WHERE banco_cuenta_id = " .strit($banco_cuenta_id));

                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al insertar $permiso en la BD.";
                    return $arrIacParamacciones;
                }

                $ret_arr_cuentas= leer_origen_destino_especial();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Poner Cuenta con depósitos en ND insertado con éxito en la BD.";
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
                $arrIacParamacciones["nombre"] = ia_singleread("SELECT clave FROM origen_bodega WHERE origen_bodega_id=".strit($banco_cuenta_id));

                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);

                break;

            case 'quita_origen_destino_especial':

                //Recibimos banco_cuenta_id
                //La cuentas están guardadas como una cadena csv
                //Leemos el CSV lo convertimos en array, y borramos la cuenta, juntamos y guardamos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $banco_cuenta_id=addslashes($json_cpnd->bodega_id);

                $permiso = param("permiso");

                if($permiso != "_origen_destino_especial" && $permiso != "_origen_destino_especial") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $campo = "origen_destino_especial";

                $cpnd_csv = ia_singleread("SELECT $campo FROM iac_parametros WHERE 1");

                $cpnd_arr = explode(",", $cpnd_csv);

                $cpnd_arr = array_flip($cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";

                unset($cpnd_arr[$banco_cuenta_id]);

                $cpnd_arr = array_keys($cpnd_arr);

                $cpnd_csv = "";

                $cpnd_csv = join(",", $cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";


                $sql="UPDATE iac_parametros SET $campo = " . strit($cpnd_csv) . " WHERE iac_parametros_id = '1'";


                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al do_quita_origen_destino_especial de la BD.";
                    die(json_encode($arrIacParamacciones));
                }


                $ret_arr_cuentas= $permiso=="_origen_destino_especial" ? leer_origen_destino_especial() : leer_origen_destino_especial();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Quitar destino con autorización eliminado con éxito de la BD.";
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
//                $arrIacParamacciones["banco_cuenta"] = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id=".strit($banco_cuenta_id));
                $arrIacParamacciones["nombre"] = ia_singleread("SELECT clave FROM origen_bodega WHERE origen_bodega_id=".strit($banco_cuenta_id));

                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);
                break;

                break;

            //VCA 12-12-2020 banco_cuenta_no_aparece_depositar_en
            case 'agrega_bodegas_no_existencia':

                //Pedimos los datos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $permiso = param("permiso");

                if($permiso != "_bodegas_no_existencia" && $permiso != "_bodegas_no_existencia") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $banco_cuenta_id=addslashes($json_cpnd->bodega_id);

                $campo = "bodegas_no_existencia";

                $sql="UPDATE iac_parametros SET $campo = IF($campo <> '', CONCAT($campo,',',".strit($banco_cuenta_id)."),".strit($banco_cuenta_id).")";

//                if($permiso == "_no_aparece_depositar_en")
//                    ia_query("UPDATE banco_cuenta SET dep_inactiva = '1' WHERE banco_cuenta_id = " .strit($banco_cuenta_id));

                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al insertar $permiso en la BD.";
                    return $arrIacParamacciones;
                }

                $ret_arr_cuentas= leer_bodegas_no_existencia();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Poner Bodegas que no aparecen en existencia insertado con éxito en la BD.";
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
                $arrIacParamacciones["nombre"] = ia_singleread("SELECT CONCAT(bodega, IF(label <> '', CONCAT(' (', label, ')'), '')) as nombre FROM bodega WHERE bodega_id=".strit($banco_cuenta_id));

                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);

                break;

            case 'quita_bodegas_no_existencia':

                //Recibimos banco_cuenta_id
                //La cuentas están guardadas como una cadena csv
                //Leemos el CSV lo convertimos en array, y borramos la cuenta, juntamos y guardamos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $banco_cuenta_id=addslashes($json_cpnd->bodega_id);

                $permiso = param("permiso");

                if($permiso != "_bodegas_no_existencia" && $permiso != "_bodegas_no_existencia") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $campo = "bodegas_no_existencia";

                $cpnd_csv = ia_singleread("SELECT $campo FROM iac_parametros WHERE 1");

                $cpnd_arr = explode(",", $cpnd_csv);

                $cpnd_arr = array_flip($cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";

                unset($cpnd_arr[$banco_cuenta_id]);

                $cpnd_arr = array_keys($cpnd_arr);

                $cpnd_csv = "";

                $cpnd_csv = join(",", $cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";


                $sql="UPDATE iac_parametros SET $campo = " . strit($cpnd_csv) . " WHERE iac_parametros_id = '1'";


                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al quita_bodegas_no_existencia de la BD.";
                    die(json_encode($arrIacParamacciones));
                }


                $ret_arr_cuentas= $permiso=="_bodegas_no_existencia" ? leer_bodegas_no_existencia() : leer_bodegas_no_existencia();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Quitar Bodegas que no aparecen en existencia con éxito de la BD.";
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
//                $arrIacParamacciones["banco_cuenta"] = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id=".strit($banco_cuenta_id));
                $arrIacParamacciones["nombre"] = ia_singleread("SELECT CONCAT(bodega, IF(label <> '', CONCAT(' (', label, ')'), '')) as nombre FROM bodega WHERE bodega_id=".strit($banco_cuenta_id));

                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);
                break;

                break;


            case 'leertodos':

                //Pedimos los datos.
                $jsonVPxU = param("jsonVPxU");
                $jsonVPxU = json_decode($jsonVPxU);

                $VPxU = new stdClass();

                //$VPxU->vale_permiso_id=addslashes($jsonVPxU->vale_permiso_id);;
                $VPxU->vale_id=addslashes($jsonVPxU->vale_id);
                //$VPxU->iac_usr_id=addslashes($jsonVPxU->iac_usr_id);
                //$VPxU->tienda_id=addslashes($jsonVPxU->tienda_id);

                $pxusql = "SELECT * FROM vale_permiso WHERE vale_id = '$VPxU->vale_id' ORDER BY vale_permiso_id ASC";
                $pxuarray = ia_sqlArrayIndx($pxusql);

                $arrValePxUacciones["Status"] = 'OK';
                $arrValePxUacciones["Error"] .= "Permisos para Vale leídos con éxito de la BD.";
                $arrValePxUacciones["VPxU"] = $pxuarray;
                //echo '<pre>'.print_r($gVxsql,true).'</pre>';
                break;

            case 'leerPermisos':
                //Pedimos los datos.
                //$jsonVPxU = param("jsonVPxU");
                //$jsonVPxU = json_decode($jsonVPxU);

                //$vale_id=addslashes($jsonVPxU->vale_id);
                $vale_id=param('vale_id');

                $arrPermisos=leerPermisosVale($vale_id);

                $arrValePxUacciones["Status"] = 'OK';
                $arrValePxUacciones["Error"] .= "Permisos para Vale leídos con éxito de la BD.";
                $arrValePxUacciones["txtPermisosXUsuario"] = $arrPermisos["txtPermisosXUsuario"];
                $arrValePxUacciones["divUsuariossinPermiso"] = $arrPermisos["divUsuariossinPermiso"];
                $arrValePxUacciones["divUsuariosconPermiso"] = $arrPermisos["divUsuariosconPermiso"];

                break;

            case 'agregar_solicitud_tipo_cambio_temporal':
                if (!puede_solicitar_tipo_cambio_tempral())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso Para solicitar Tipo de Cambio Temporal'
                    ]));

                // $por_quien = param('tc_temporal_usuario');
                $por_quien = $_SESSION['usuario_id'];
                $tc_temporal = param('tc_temporal');
                $tc_tiempo = param('tc_temporal_tiempo'); // Se debe convertir a seconds
                $tc_tiempo = min(60, $tc_tiempo);

                if (empty($por_quien))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Ingresa quien solicito el tipo de cambio'
                    ]));

                if (empty($tc_temporal))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Ingresa el tipo de cambio temporal'
                    ]));

                if (empty($tc_tiempo))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Ingresa cuanto tiempo sera el tipo de cambio (en minutos)'
                    ]));

                $nick = $_SESSION['usuario'];
                $tiempo_min = $tc_tiempo;
                $tc_tiempo = $tiempo_min*60;
                $tc_temporal_id = ia_guid();
                $nuevo_tc_temporal = [
                    'tipo_cambio_temporal_id' => $tc_temporal_id,
                    'iac_usr_id' => $por_quien,
                    'tc_anterior' => ia_singleread("SELECT tc FROM iac_parametros"),
                    'tc_temporal' => $tc_temporal,
                    'tiempo' => $tc_tiempo, // en segundos
                    'activo' => 'Si',
                    'alta_por' => $nick
                ];

                $builder = new Iac\inc\sql\IacSqlBuilder();
                $sql = [];
                $sql[] = $builder->insert('tipo_cambio_temporal', $nuevo_tc_temporal);
                $sql[] = "UPDATE /* ACTUALIZA tipo_cambio_temporal */ `tipo_cambio_temporal`  SET `activo`='No' WHERE `activo`='Si' AND `tipo_cambio_temporal_id` NOT IN (SELECT tipo_cambio_temporal_id FROM (SELECT tipo_cambio_temporal_id FROM tipo_cambio_temporal WHERE activo = 'Si' ORDER BY alta_db DESC LIMIT 3) AS activos)";

                $usuario_solicito = ia_singleread("SELECT /* agregar_solicitud_tipo_cambio_temporal */nick FROM iac_usr WHERE iac_usr_id = ".strit($por_quien));
                $sql[] = registraMovimientoDivisa($usuario_solicito . " agregó un Tipo de cambio Temporal por $tiempo_min minutos.", $tc_temporal, 'NO', 0.00, $por_quien, $usuario_solicito, $tc_temporal_id, 'iac_parametros');

                if (ia_transaction($sql)) {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => 'No se pudo crear la solicitud de tipo de cambio temporal',
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                actualizaTCenDB(true, $tc_temporal, date("Y-m-d H:i:s"), true, "TEMPORAL", true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => 'Se creo la solicitud de tipo de cambio temporal',
                    'resumen' => app_iac_parametros::table_resumen_tc_temporal($nuevo_tc_temporal),
                    'tipo_cambio_temporal_id' => $nuevo_tc_temporal['tipo_cambio_temporal_id']
                ]));

                break;

            case 'inactivar_solicitud_tipo_cambio_temporal':

                $method = __METHOD__;
                if (!puede_solicitar_tipo_cambio_tempral())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso Para solicitar Tipo de Cambio Temporal'
                    ]));

                $id = param('id');

                if (empty($id))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falto el id del tipo de cambio temporal'
                    ]));

                $select = "SELECT /* $method */ * FROM tipo_cambio_temporal WHERE tipo_cambio_temporal_id = ".strit($id);
                $tc_tmp = ia_singleton($select);
                if (empty($tc_tmp))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'No existe el tipo de cambio temporal que quiere quitar'
                    ]));

                $update = "UPDATE tipo_cambio_temporal SET activo = 'No' WHERE tipo_cambio_temporal_id = ".strit($id);
                if (ia_query($update)) {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => 'No se pudo quitar el tipo de cambio temporal',
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }

                $usuario_solicito = ia_singleread("SELECT /* $method */nick FROM iac_usr WHERE iac_usr_id = ".strit($tc_tmp['iac_usr_id']));
                global $gIAParametros;
                @registraMovimientoDivisa("Se desactivó el Tipo de Cambio Tempral solicitado por $usuario_solicito.", $gIAParametros['tc'], 'SI', 0.00, $_SESSION['usuario_id'], $_SESSION['usuario'], $id, 'iac_parametros', tc_temporal:$tc_tmp['tc_temporal'], forza_ia_guid:true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => 'Se quitó el tipo de cambio temporal',
                    'resumen' => app_iac_parametros::table_resumen_tc_temporal(),
                ]));

                break;

            /*
            case 'set_banco_cuenta_q_a_mano':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);

                $bancos_q_a_mano = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_q_a_mano);
                $sql="UPDATE iac_parametros SET banco_cuenta_poner_deposito_Q_a_mano = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";

                if (ia_query($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }

                leeParametrosVitex(true);
                app_iac_parametros::setEstadoDepositosBancoCuenta();

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para poner Q al ingresar a mano",
                    'componentes_q' => app_iac_parametros::preparaHtmlCuentasQAMano($set_actuales),
                    'componentes_nd' => app_iac_parametros::preparaHtmlCuentasNDAMano($gIAParametros['banco_cuenta_poner_deposito_ND_a_mano']),
                    'total' => count($bancos_q_a_mano)
                ]));
                break;

            case 'set_banco_cuenta_nd_a_mano':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);

                $bancos_nd_a_mano = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_nd_a_mano);
                $sql="UPDATE iac_parametros SET banco_cuenta_poner_deposito_ND_a_mano = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";

                if (ia_query($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }

                leeParametrosVitex(true);
                app_iac_parametros::setEstadoDepositosBancoCuenta();

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para poner ND al ingresar a mano",
                    'componentes_nd' => app_iac_parametros::preparaHtmlCuentasNDAMano($set_actuales),
                    'componentes_q' => app_iac_parametros::preparaHtmlCuentasQAMano($gIAParametros['banco_cuenta_poner_deposito_Q_a_mano']),
                    'total' => count($bancos_nd_a_mano)
                ]));
                break;*/
            case 'set_banco_cuenta_set_estado_a_mano':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $valores = param('valores', []);

                $queries = [];

                // limpiamos valores de los campos
                $queries[] = "UPDATE iac_parametros SET
                    banco_cuenta_poner_deposito_Q_a_mano = '',
                    banco_cuenta_poner_deposito_ND_a_mano = ''
                WHERE iac_parametros_id = '1'";

                $bancos_q = array_unique($valores['Q']??[]);
                $bancos_q = implode(",", $bancos_q);
                $bancos_q_it = strit($bancos_q);

                $bancos_nd = array_unique($valores['ND']??[]);
                $bancos_nd = implode(",", $bancos_nd);
                $bancos_nd_it = strit($bancos_nd);


                $queries[] = "UPDATE iac_parametros SET
                    banco_cuenta_poner_deposito_Q_a_mano = $bancos_q_it,
                    banco_cuenta_poner_deposito_ND_a_mano = $bancos_nd_it
                WHERE iac_parametros_id = '1'";


                if (ia_transaction($queries))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }

                leeParametrosVitex(true);
                app_iac_parametros::setEstadoDepositosBancoCuenta();

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios pára el estado de los depósitos al ingresar a mano",
                    'componentes' => app_iac_parametros::preparaHtmlCuentasEstadoAMano(),
                ]));
                break;
            case 'set_capturar_withdrawals':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);

                $bancos_set = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_set);
                $sql="UPDATE iac_parametros SET banco_cuenta_capturar_withdrawals = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";

                if (ia_query($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }

                leeParametrosVitex(true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para capturar withdrawals en el banco",
                    'componentes' => app_iac_parametros::preparaHtmlCuentasCapturanWithdrawals($set_actuales),
                    'total' => count($bancos_set)
                ]));
                break;
            case 'set_cuentas_depositos_nd':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);

                $bancos_set = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_set);
                $sql="UPDATE iac_parametros SET banco_cuenta_poner_deposito_ND = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";

                if (ia_query($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para cuentas con depósitos en ND",
                    'componentes' => leer_banco_cuenta_poner_deposito_ND(),
                    'total' => count($bancos_set)
                ]));
                break;
            case 'set_cuentas_permite_inversion_manual':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);

                $bancos_set = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_set);
                $sql="UPDATE iac_parametros SET banco_cuenta_permite_inversion_manual = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";

                if (ia_query($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para cuentas con depósitos en ND",
                    'componentes' => leer_banco_cuenta_permite_inversion_manual(),
                    'total' => count($bancos_set)
                ]));
                break;
            case 'set_cuentas_no_aparence_en_depositar_en':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);

                $bancos_set = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_set);
                $sql = array();
                $sql[]="UPDATE iac_parametros SET banco_cuenta_no_aparece_depositar_en = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";
                $sql[]="update banco_cuenta set dep_inactiva = 0 where banco_cuenta_id NOT IN( " . strit($set_actuales) . ")";
                $sql[]="update banco_cuenta set dep_inactiva = 1 where banco_cuenta_id IN( " . strit($set_actuales) . ")";

                if (ia_transaction($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para cuentas que no aparecen en DEPOSITAR EN",
                    'componentes' => leer_banco_cuenta_no_aparece_depositar_en(),
                    'total' => count($bancos_set)
                ]));
            break;
            case 'set_banco_cuenta_en_parametro':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $method = __METHOD__;
                $banco_cuenta_id = param('banco_cuenta_id', []);
                $parametro = param('parametro');
                if (empty($parametro))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falta indicar el parametro',
                    ]));

                $bancos_set = array_unique($banco_cuenta_id);
                $set_actuales = implode(",", $bancos_set);
                $sql="UPDATE iac_parametros SET $parametro = " . strit($set_actuales) . " WHERE iac_parametros_id = '1'";

                if (ia_query($sql))
                {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo modificar los parametros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);

                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'message' => "Se realizaron los cambios para cuentas en el parametro $parametro",
                    'componentes' => app_iac_parametros::preparaHtmlCuentasCapturanWithdrawals($set_actuales),
                    'total' => count($bancos_set)
                ]));
                break;

            case 'set_active_tc':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));
                $valor = param('valor');
                $campo = param('campo');

                $estoy_en_server = estoyEnServidor();
                $estoy_en_server = false;
                if ($estoy_en_server) {
                    $campos_no_server = ['tc_activo', 'tc_limite_abajo_activo', 'tc_limite_arriba_activo', 'tc_abajo_activo', 'tc_arriba_activo'];
                    if (in_array($campo, $campos_no_server))
                        die(json_encode([
                            'status' => false,
                            'code' => 400,
                            'message' => 'No puedes cambiar este valor en el servidor',
                        ]));
                }

                if (empty($valor))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falta valor para cambiar',
                    ]));

                if (empty($campo))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falta campo para cambiar',
                    ]));

                $action_pre = $valor == 'Si' ? 'activar':'desactivar';
                $action_post = $valor == 'Si' ? 'activo':'desactivo';
                $label_campo = match($campo) {
                    'tc_activo' => 'Tipo de Cambio Actual',
                    'tc_abajo_activo' => 'Tipo de Cambio Inferior',
                    'tc_arriba_activo' => 'Tipo de Cambio Superior',
                    'tc_limite_abajo_activo' => 'Limite Inferior',
                    'tc_warning_abajo_activo' => 'Warning Inferior',
                    'tc_warning_arriba_activo' => 'Warning Superior',
                    'tc_limite_arriba_activo' => 'Limite Superior',
                    default => $campo
                };

                $values = [
                    $campo => $valor
                ];
                global $gIAParametros;
                $sql = [];
                if ($campo === 'tc_activo') {
                    $values_set = param('values', []);
                    $tc_config = VARS_DEFAULT['tipo_cambio']['estado_tasa'];
                    $r_c = "Se tomará el Tipo de Cambio del sistema como referencia <b class='txt_USD'>($gIAParametros[tc_sistema])</b> y los ";
                    if ($valor === 'Si') {
                        $values['tc_abajo_activo'] = 
                        $values['tc_limite_abajo_activo'] = 
                        $values['tc_warning_abajo_activo'] = 
                        $values['tc_arriba_activo'] = 
                        $values['tc_limite_arriba_activo'] = 
                        $values['tc_warning_arriba_activo'] = 'Si';

                        $r_c = "Se tomarán los";
                    }
                    $values = array_merge($values, $values_set);
                    $table = "<table class='table bg-white'>
                        <tr><th>{$tc_config['OK']['label']}</th><td class='text-right bold'>$values[tc_limite_abajo]</td></tr>
                        <tr><th>{$tc_config['LD']['label']}</th><td class='text-right bold'>$values[tc_limite_abajo]</td></tr>
                        <tr><th>{$tc_config['WD']['label']}</th><td class='text-right bold'>$values[tc_warning_abajo]</td></tr>
                        <tr><th>{$tc_config['WU']['label']}</th><td class='text-right bold'>$values[tc_warning_arriba]</td></tr>
                        <tr><th>{$tc_config['LU']['label']}</th><td class='text-right bold'>$values[tc_limite_arriba]</td></tr>
                    </table>";
                    $remarks = ucfirst($_SESSION['usuario']). " $action_post el Tipo de Cambio.  $r_c siguientes valores: $table";
                    $sql[]=registraMovimientoDivisa($remarks, $gIAParametros['tc_sistema'], 'NO', 0.00, $_SESSION['usuario_id'], $_SESSION['usuario'], 1, 'iac_parametros', forza_ia_guid: true);
                }
                else {
                    $remarks = ucfirst($_SESSION['usuario']). " $action_post $label_campo.";
                    $sql[]=registraMovimientoDivisa($remarks, $gIAParametros['tc_sistema'], 'NO', 0.00, $_SESSION['usuario_id'], $_SESSION['usuario'], 1, 'iac_parametros', forza_ia_guid: true);
                }

                if ($campo === 'tc_arriba_activo') {
                    $values['tc_warning_arriba_activo'] = $values['tc_limite_arriba_activo'] = $valor;
                }
                if ($campo === 'tc_abajo_activo') {
                    $values['tc_warning_abajo_activo'] = $values['tc_limite_abajo_activo'] = $valor;
                }

                $sql[] = ia_update("iac_parametros", $values, ['iac_parametros_id' => 1]);

                if (ia_transaction($sql)) {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo $action_pre $label_campo",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);
                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'update' => $sql,
                    'message' => "Se $action_post $label_campo",
                ]));
            break;
            case 'set_mostrar_boton_save':
                if (!usuarioTipoRony())
                    die(json_encode([
                        'status' => false,
                        'code' => 403,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));
                $valor = param('valor');
                $estoy_en_server = estoyEnServidor();
                $estoy_en_server = false;
                if ($estoy_en_server) {
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'No puedes cambiar este valor en el servidor',
                    ]));
                }

                if (empty($valor))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falta valor para cambiar',
                    ]));

               
                $action_pre = $valor == 'Si' ? 'activar':'desactivar';
                $action_post = $valor == 'Si' ? 'activo':'desactivo';
                $label_campo = 'Mostrar boton de Save';

                $values = [
                    'mostrar_boton_save' => $valor
                ];
                global $gIAParametros;
                $sql = [];
                $remarks = ucfirst($_SESSION['usuario']). " $action_post $label_campo.";
                $sql[]=registraMovimientoDivisa($remarks, $gIAParametros['tc_sistema'], 'NO', 0.00, $_SESSION['usuario_id'], $_SESSION['usuario'], 1, 'iac_parametros', forza_ia_guid: true);
                $sql[] = ia_update("iac_parametros", $values, ['iac_parametros_id' => 1]);

                if (ia_transaction($sql)) {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo $action_pre $label_campo",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);
                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'update' => $sql,
                    'message' => "Se $action_post $label_campo",
                ]));
            break;

            case 'set_param_impuesto_contenedor':
                if (!puede_entrar_a_costos_contenedor())
                    die(json_encode([
                        'status' => false,
                        'code' => 200,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $valor = param('valor');
                $parametro = param('param');
                if (empty($valor))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falta valor para cambiar',
                    ]));

                $values = [$parametro => $valor];
                global $gIAParametros;

                $sql = [];
                $sql[] = ia_update("iac_parametros", $values, ['iac_parametros_id' => 1]);

                if (ia_transaction($sql)) {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo guradar el parametro ($parametro)",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);
                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'update' => $sql,
                    'message' => "Se guardo el parametro ($parametro)",
                ]));
                break;

            case 'set_params_impuesto_contenedor':
                if (!puede_entrar_a_costos_contenedor())
                    die(json_encode([
                        'status' => false,
                        'code' => 200,
                        'message' => 'No tienes permiso para realizar esta acción',
                    ]));

                $es_default = strcasecmp(param('default', 'No'), 'Si')===0;
                $parametros = param('params');
                $para = param('para');
                $name = param('name');
                if (empty($parametros))
                    die(json_encode([
                        'status' => false,
                        'code' => 400,
                        'message' => 'Falta parametros para cambiar',
                    ]));

                // $values = [$parametro => $valor];
                global $gIAParametros;

                $sql = [];

                if (!$es_default) { // configuración para las otras sesiones
                    $sql[] = ia_update("iac_parametros", $parametros, ['iac_parametros_id' => 1]);
                }

                if ($es_default) { // mandamos esos parametros a la tabla user_json_data
                    $values = [
                        'tema' => 'costos_contenedor.php#'.$para,
                        'name' => $name,
                        'iac_usr_id' => 1,
                        'data' => json_encode($parametros, JSON_OPTIONS_FOR_MYSQL),
                        'es_default' => 'Si',
                        'es_para_todos' => 'Si',
                        'alta_por' => $_SESSION['usuario'],
                    ];
                    $sql_builder = new \Iac\inc\sql\IacSqlBuilder();
                    $sql[] = $sql_builder->insert('user_json_data', $values, false, "data=VALUES(data), ultimo_cambio=NOW(), ultimo_cambio_por='$_SESSION[usuario]'");
                }


                $complete = $es_default ? 'default':'';

                if (ia_transaction($sql)) {
                    ia_errores_a_dime();
                    global $gIAsql;
                    die(json_encode([
                        'status' => false,
                        'code' => 409,
                        'message' => "No se pudo guradar la configuración $complete de parámetros",
                        'error' => $gIAsql['error'] ?? $gIAsql['err'] ?? 'Algo sucedio',
                    ]));
                }
                leeParametrosVitex(true);
                die(json_encode([
                    'status' => true,
                    'code' => 200,
                    'update' => $sql,
                    'message' => "Se guardó la configuración $complete de parámetros",
                ]));
                break;
            case 'agrega_cuenta_permite_inversion_manual':

                //Pedimos los datos.
                $json_pim = param("json_cpnd");
                $json_pim = json_decode($json_pim);

                $permiso = param("permiso");

                if($permiso != "_permite_inversion_manual") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $banco_cuenta_id=addslashes($json_pim->banco_cuenta_id);

                $campo = "banco_cuenta$permiso";

                $sql="UPDATE iac_parametros SET $campo = IF($campo <> '', CONCAT($campo,',',".strit($banco_cuenta_id)."),".strit($banco_cuenta_id).")";

                $ret_arr_cuentas = leer_banco_cuenta_permite_inversion_manual();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Poner Cuenta con depósitos en ND insertado con éxito en la BD.";
                $arrIacParamacciones["sql"] = $sql;
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_pim);
                $arrIacParamacciones["banco_cuenta"] = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id=".strit($banco_cuenta_id));

                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);

                break;

            case 'quita_cuenta_permite_inversion_manual':

                //Recibimos banco_cuenta_id
                //La cuentas están guardadas como una cadena csv
                //Leemos el CSV lo convertimos en array, y borramos la cuenta, juntamos y guardamos.
                $json_cpnd = param("json_cpnd");
                $json_cpnd = json_decode($json_cpnd);

                $banco_cuenta_id=addslashes($json_cpnd->banco_cuenta_id);

                $permiso = param("permiso");

                if($permiso != "_poner_deposito_ND" && $permiso != "_no_aparece_depositar_en") {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "No tiene permiso para esta acción.";
                    return $arrIacParamacciones;
                }

                $campo = "banco_cuenta$permiso";

                $cpnd_csv = ia_singleread("SELECT $campo FROM iac_parametros WHERE 1");

                $cpnd_arr = explode(",", $cpnd_csv);

                $cpnd_arr = array_flip($cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";

                unset($cpnd_arr[$banco_cuenta_id]);

                $cpnd_arr = array_keys($cpnd_arr);

                $cpnd_csv = "";

                $cpnd_csv = join(",", $cpnd_arr);

                //echo "<pre>$cpnd_csv" . print_r($cpnd_arr, true) . "</pre>";


                $sql="UPDATE iac_parametros SET $campo = " . strit($cpnd_csv) . " WHERE iac_parametros_id = '1'";

                if($permiso == "_no_aparece_depositar_en")
                    ia_query("UPDATE banco_cuenta SET dep_inactiva = '0' WHERE banco_cuenta_id = " .strit($banco_cuenta_id));

                if(ia_query($sql,true,false))
                {
                    $arrIacParamacciones["Status"] = 'Error';
                    $arrIacParamacciones["Error"] = "Error al quita_cuenta_poner_deposito_ND de la BD.";
                    die(json_encode($arrIacParamacciones));
                }


                $ret_arr_cuentas= $permiso=="_poner_deposito_ND" ? leer_banco_cuenta_poner_deposito_ND() : leer_banco_cuenta_no_aparece_depositar_en();

                $arrIacParamacciones["Status"] = 'OK';
                $arrIacParamacciones["Error"] .= "Quitar Cuenta con depósitos en ND eliminado con éxito de la BD.";
                $arrIacParamacciones["json_cpnd"] = get_object_vars($json_cpnd);
                $arrIacParamacciones["banco_cuenta"] = ia_singleread("SELECT nombre FROM banco_cuenta WHERE banco_cuenta_id=".strit($banco_cuenta_id));
                $arrIacParamacciones = array_merge($arrIacParamacciones, $ret_arr_cuentas);
                break;

                break;
        }
        //print_r($gVxsql);
        return $arrIacParamacciones;
        echo json_encode($arrIacParamacciones);
    }
?>