<?php /** @noinspection PhpRedundantOptionalArgumentInspection */

/** @noinspection PhpUnused */

use Iac\inc\sql\IacSqlBuilder;
global $gSoyWorker; $gSoyWorker = true;
require_once('../../inc/config.php');
session_write_close();

class index_acciones extends AjaxHelper {
    protected PermisosBodega $permisoBodega;
    protected IacSqlBuilder $builder;

    public function __construct() {
        $this->permisoBodega = new PermisosBodega();
        $this->builder = new IacSqlBuilder();
        $this->debug = true;
        parent::__construct();
    }


    /**
     * @inheritDoc
     */
    protected function puedeHacerAccion(): bool {
        return match ($this->accion) {
            'seccion_traslado', 'seccion_bodega', 'verificacion_grupos', 'capturaDeNotas', 'nuevaNota', 'existenciaNegativa',
            'notasARevisar', 'traslado_match', 'destino_match', 'bodega_modifcaciones_importantes',
            'tab_bodega', 'seccion_verificacion', 'reporte_notas_por_verificar', 'logins_count' , 'limpia_clientes_cobranza', 'ajaxCompareDBs' => true,
            default => false,
        };
    }

    protected function logins_count() {
        if(usuarioTipoRony()) {
            $Login_log = new Login_log();
            $cuantos = $Login_log->count();
        } else
            $cuantos = '';
        $this->response = [
            'code' => 200,
            'status' => true,
            'count' => $cuantos,
        ];
    }
    protected function reporte_notas_por_verificar() {

            $html = BodegaReportes::notasPorVerificarTable(null, true);
            $html .= BodegaReportes::notasPorVerificarTable($_REQUEST['bodega_grupo_verificador_id'] ?? null);

            $this->response = [
                'code' => 200,
                'status' => true,
                'reporte' => $html,
            ];
    }

    protected function bodega_modificaciones_importantes() {
        $puede_consultar = $this->permisoBodega->bodegasPuedeConsultarMovimientos();
        if(usuarioSupervisaBodega() || empty($puede_consultar))
            $and_bodega_id_in = '';
        else
            $and_bodega_id_in = ' AND ' . $this->builder->where(['bodega_id' => array_keys($puede_consultar) ]);
        $method = __METHOD__;
        $this_year = '2023, part_2022';
        /** @noinspection HtmlUnknownTarget */
        $this->response['selector_html']['#tabBodegaModifImportantesNum'] =
            bcformat(ia_singleread(
                "SELECT /*$method*/ COUNT(*) FROM nota_bodega /*PARTITION (part_$this_year)*/ WHERE modificacion_importante = 'Si' $and_bodega_id_in"
            ), 0) . '<img id="fidModImg" src="../img/m_red.ico" alt="NM" style="vertical-align: top; width: 12px !important;height: 12px !important">';
        if($this->response['selector_html']['#tabBodegaModifImportantesNum'] == "0" . '<img id="fidModImg" src="../img/m_red.ico" alt="NM" style="vertical-align: top; width: 12px !important;height: 12px !important">')
            $this->response['selector_removeClass']['#tabBodegaModifImportantesNum'] = "flashMal";
        else
            $this->response['selector_addClass']['#tabBodegaModifImportantesNum'] = "flashMal";
    }


    protected function seccion_traslado(): void {
        if(!$this->permisoBodega->puedeEntrarABodegas())
            return;
        if(!usuarioTipoRony() && !puedePermisoUsuario('', "puede_ver_traslados_match"))
            return;
        $this->traslado_match();
    }

    protected function seccion_bodega():void {
        $method = __METHOD__;
        if(!$this->permisoBodega->puedeEntrarABodegas()) {
            $this->destino_match();
            return;
        }

      //  $where_oculta =  producto_oculta_where("pg");
        // colores Pendientes de revisar
        $colores_rev = ia_singleread("
            SELECT /*$method*/ 1 WHERE EXISTS (
                SELECT 1
                FROM producto_color pc
                    JOIN producto_general pg ON pc.producto_general_id = pg.producto_general_id
                WHERE pc.activo = 'Si' AND pc.prohibido = 'No' AND pc.notificado='No'
            )"
        );
        if($colores_rev)
            $this->response['selector_show']['#colores_rev'] = 1;
        else
            $this->response['selector_hide']['#colores_rev'] = 1;

        // $this->response['selector_append']['#panel_control_productos'] = jqgridcolssorter_SelectLinkTo('../bodega/productos_panel_control.php', 'productos_colores_');;

        $this->bodega_modificaciones_importantes();
        $this->destino_match();
        $this->notasARevisar();
        $this->existenciaNegativa();
        if(!empty($this->permisoBodega->bodegasPuedeHacerMovimientos()))
            $this->nuevaNota();
        if(!empty($this->permisoBodega->bodegasPuedeHacerMovimientos()) || !empty($this->permisoBodega->bodegasPuedeConsultarMovimientos()) )
            $this->capturaDeNotas();
    }

    protected function seccion_verificacion():void {
        if(!usuarioTipoRony() && !$this->permisoBodega->puedeEntrarABodegas()) {
            return;
        }
        if(usuarioTipoRony() || !empty($this->permisoBodega->bodegasPuedeHacerVerificarMovimientos()) || !empty($this->permisoBodega->bodegasPuedeConsultarVerificarMovimientos()) )
            $this->verificacion_grupos();
    }

    protected function tab_bodega():void {
        $this->seccion_bodega();
        $this->seccion_verificacion();

    }

    public function destino_match():void {
        $method = __METHOD__;

        $wherePermitidoDe = NotaBodegaDestinoMatch::permisosDestinoMatch();
        if(!empty($wherePermitidoDe))
            $wherePermitidoDe = " AND ($wherePermitidoDe)";

        $this->response['selector_html']['#destinoMatchMalNumCompra'] =  bcformat( ia_singleread(
          "SELECT /*$method*/ COUNT(DISTINCT nb.nota_bodega_id) as notas
                FROM inconsistencia_nota_bodega inb
                    JOIN nota_bodega nb on inb.nota_bodega_id = nb.nota_bodega_id
                WHERE
                    inb.tipo_inconsistencia = 'numero_compra'
                        AND inb.estado='activo'
                        AND nb.tipo NOT IN('Cancelada', 'Borrado')
                        AND nb.destino_fuerza_ok = 'No'
                        AND nb.origen_id <> '11ec6cb303b9307cad6b23073af2fe60' $wherePermitidoDe", "0"), 0);

        $this->response['selector_html']['#destinoMatchMalNum'] = bcformat( ia_singleread(
          "SELECT /*$method*/
            COUNT(DISTINCT nb.nota_bodega_id) as notas
            FROM inconsistencia_nota_bodega inb
                JOIN nota_bodega nb on inb.nota_bodega_id = nb.nota_bodega_id
            WHERE
                inb.tipo_inconsistencia IN ('clientes', 'ayudantes', 'pedido_por')
                    AND inb.estado='activo'
                    AND nb.tipo NOT IN('Cancelada', 'Borrado')
                    AND nb.destino_fuerza_ok = 'No'
                    AND nb.origen_id <> '11ec6cb303b9307cad6b23073af2fe60' $wherePermitidoDe", "0"), 0);

/*
        $campos_inconsistencia_destino_match = ['clientes', 'ayudantes', 'pedido_por', 'numero_compra'];
        $in = parseClauseIn($campos_inconsistencia_destino_match);

        $select = "SELECT
            inb.nota_bodega_id, inb.tipo_inconsistencia
        FROM inconsistencia_nota_bodega inb 
            JOIN nota_bodega nb on inb.nota_bodega_id = nb.nota_bodega_id
        WHERE 
            inb.tipo_inconsistencia IN ($in)
            AND inb.estado='activo'
            AND nb.tipo NOT IN('Cancelada', 'Borrado')
            AND nb.destino_fuerza_ok = 'No'
            AND nb.origen_id <> " . strit(WAREHOSE_ID);
        $inconsistencias = ia_sqlSelectMultiKey($select, 2);

        $this->response['selector_html']['#destinoMatchMalNum'] = 0;
        $this->response['selector_html']['#destinoMatchMalNumCompra'] = 0;
        foreach ($inconsistencias as $values) {
            if(array_key_exists('clientes', $values) || array_key_exists('ayudantes', $values) || array_key_exists('pedido_por', $values))
                $this->response['selector_html']['#destinoMatchMalNum']++;
            elseif(array_key_exists('numero_compra', $values))
                $this->response['selector_html']['#destinoMatchMalNumCompra']++;
        }
*/
    }

    protected function traslado_match():void {
        $notas =  NotaBodegaMatcher::matcher_notas(['diff_date_min' =>  NotaBodegaMatcher::trasladoMatchDefaultFromDate() ]);
        $cmp = new NotaBodegaMatcher();
        $cmp->trasladosMatch($notas);
        $total =  $cmp->getRenglonesMal();
        $this->response['selector_html']['#trasladoMatchMalNum'] = $total === 0 ? " " : "<span class='tabBodegaNumMal'> $total</span>";
    }

    protected function whereBodegasConsulta($bodega_id = 'b.bodega_id'):string {
        if(usuarioTipoRony())
            return '';
        $bodegasPuede = $this->permisoBodega->bodegasPuedeConsultarMovimientos();
        if(empty($bodegasPuede))
            return " AND 1=0 ";
        return " AND " . $this->builder->where([$bodega_id => array_keys($bodegasPuede)]);
    }
    protected function notasARevisar():void {
        $method = __METHOD__;
        $desdeNotasRevisar = Date('Y-m-d', strtotime("35 days ago"));
        $whereBodegas = $this->whereBodegasConsulta();
        $where_oculta =  producto_oculta_where("pg");
        $son =
            ia_sqlArrayIndx(
                "SELECT /*$method*/
                    CONCAT(
                        'producto_general_id[]=', pg.producto_general_id,
                        '&color_id[]=', c.color_id,
                        '&bodega_id[]=', b.bodega_id,
                        '&por=trackit', 
                        '&fecha_min=', DATE_SUB(bed.fecha, INTERVAL 45 DAY)
                    ) as href,
                    CONCAT_WS('\t',b.grupo, b.bodega, pg.producto, c. color, ' tuvo ∃ negativa el ', DATE_FORMAT(bed.fecha, '%e/%b/%y')  ) as txt,
                    r.revisado_el
                FROM bodega_existencia_diaria bed
                    JOIN producto_general pg on bed.producto_general_id = pg.producto_general_id
                    JOIN color c on bed.color_id = c.color_id
                    JOIN bodega b on bed.bodega_id = b.bodega_id
                    LEFT OUTER JOIN revisador r ON r.tema = 'tab_bodega_producto_color_raro' AND
                        r.id = CONCAT_WS('_', b.bodega_id, pg.producto_general_id, c.color_id) AND r.iac_usr_id='$_SESSION[usuario_id]'
                WHERE bed.fecha >= '$desdeNotasRevisar' $whereBodegas AND
                    pg.activo = 'Si' AND existencia_quantity<>0 AND  existencia_quantity  = -1 * salida_quantity AND existencia_rollos = -1 * salida_rollos
                    $where_oculta
                ORDER BY b.grupo, b.bodega, bed.fecha DESC, pg.producto, c. color");
        $list = [''];
        $total = 0;
        $i = 0;
        $prevIndx = 1;
        $prev = '';
        if(!empty($son)) {
            foreach ($son as $data) {
                $href = $data['href'];
                $text = $data['txt'];
                $t = explode("\t", $text);
                if ($prev !== $t[0] . ' ' . $t[1]) {
                    if (!empty($prev)) {
                        $list[$prevIndx - 1] = "</div></details>";
                        $list[$prevIndx] = "<details class='default'>
                <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                            number_format($i, 0, '', ',') . "</span> $prev</summary><div>";
                        $prevIndx = count($list);
                    }
                    $prev = $t[0] . ' ' . $t[1];
                    $list[] = '';
                    $list[] = '';
                    $i = 0;
                    $list[] = '';
                    $list[] = '';
                }
                $list[] = '';
                $total++;
                $i++;
                $parts = [];
                parse_str($href, $parts);
                $id = $parts['bodega_id'][0] . '_' . $parts['producto_general_id'][0] . '_' . $parts['color_id'][0];
                if (empty(empty($data['revisado_el']))) {
                    $checked = 'checked="checked"';
                    $title = " title='Lo revisaste el " . mysqlDateTime2display($data['revisado_el']) . "'";
                } else {
                    $title = $checked = '';
                }
                $list[] = "<input $title type='checkbox' value='$id' $checked onclick=\"revisadorMarca('tab_bodega_producto_color_raro', this)\"> <a href='../bodega/bodega_articulo_rastrea.php?$href' target='_blank'
            style='font-weight:100;font-size:0.9em;text-shadow: none'>$text</a>";
                $list[] = '';
            }
        }
        unset($list[0]);
        if($total > 0) {
            $list[$prevIndx] = "<details class='default'>
                    <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                number_format($i, 0, '', ',') . "</span> $prev</summary><div>";
            if($prevIndx > 0)
                $list[$prevIndx - 1] = "</div></details>";
        }
        $this->response['selector_html']['#notasARevisarList'] = "<dl><dt>" . implode("<dt>", $list) . "</dt></dl>";
        $this->response['selector_html']['#notasARevisarNum'] = number_format(count($son), 0, '', ',');
    }

    protected function existenciaNegativa():void {
        $method = __METHOD__;
        $where_oculta =  producto_oculta_where("pg");
        $whereBodegas = $this->whereBodegasConsulta();
        $son = ia_sqlArrayIndx(
            "SELECT /*$method*/ 
        CONCAT('bodega_id[]=', b.bodega_id, '&producto_general_id[]=', pg.producto_general_id, '&color_id[]=', c.color_id) as href,
        CONCAT_WS('\t', b.grupo, b.bodega, pg.producto, c.color,  
            IF(pb.existencia_rollos < 0 , '<span style=\"color:red\">', '<span>') , pb.existencia_rollos, ' rollos</span>', 
            IF(pb.existencia_quantity < 0 , '<span style=\"color:red\">', '<span>') , pb.existencia_quantity,
            u.unidad,'</span>'
            ) as txt,
        r.revisado_el
        FROM producto_bodega pb
            JOIN producto_general pg on pb.producto_general_id = pg.producto_general_id
            JOIN unidades u on pg.unidades_id = u.unidades_id
            JOIN color c on pb.color_id = c.color_id
            JOIN bodega b on pb.bodega_id = b.bodega_id
            LEFT OUTER JOIN revisador r ON r.tema = 'tab_bodega_producto_color_raro' AND
                r.id = CONCAT_WS('_', b.bodega_id, pg.producto_general_id, c.color_id) AND r.iac_usr_id='$_SESSION[usuario_id]'
        WHERE b.activo='Si' $whereBodegas AND pg.activo='Si' AND c.activo='Si' AND (existencia_rollos < 0 OR existencia_quantity < 0) $where_oculta
        ORDER BY 2");
        $list = [''];
        $cuentaTotal = 0;
        $cuentaPorBodega = 0;
        $prevIndx = 1;
        $prev = '';
        foreach($son as $data) {
            $href = $data['href'];
            $text = $data['txt'];
            $t = explode("\t", $text);
            if($prev !== $t[0] . ' ' . $t[1]) {
                if(!empty($prev)) {
                    $list[$prevIndx -1] = "</div></details>";
                    $list[$prevIndx] = "<details class='default'>
                <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                        number_format($cuentaPorBodega, 0, '', ',') . "</span> $prev</summary><div>";
                    $prevIndx = count($list);
                }
                $prev = $t[0] . ' ' . $t[1];
                $list[] = '';
                $list[] = '';
                $cuentaPorBodega = 0;
                $list[] = '';
                $list[] = '';
            }
            $cuentaTotal++;
            $cuentaPorBodega++;
            $parts = [];
            parse_str($href, $parts);
            $id = $parts['bodega_id'][0] . '_' . $parts['producto_general_id'][0] . '_' . $parts['color_id'][0];
            if(empty(empty($data['revisado_el']))) {
                $checked = 'checked="checked"';
                $title = " title='Lo revisaste el " . mysqlDateTime2display($data['revisado_el']) . "'";
            } else {
                $title = $checked = '';
            }
            $list[] = "<input $title type='checkbox' value='$id' $checked onclick=\"revisadorMarca('tab_bodega_producto_color_raro', this)\"> <a href='../bodega/bodega_articulo_rastrea.php?$href&por=trackit' target='_blank'
             style='font-weight:100!important;font-size:0.9em;text-shadow: none'>$text</a>";
            $list[] = '';
        }
        unset($list[0]);
        if($cuentaTotal > 0) {
            $list[$prevIndx] = "<details class='default'>
                    <summary class='default' style='font-weight:bold;font-size:1.1em'><span style='color:red'>" .
                number_format($cuentaPorBodega, 0, '', ',') . "</span> $prev</summary><div>";
            if($prevIndx > 0)
                $list[$prevIndx - 1] = "</div></details>";
        }
        $this->response['selector_html']['#artNegativosList'] = "<dl><dt>" . implode("<dt>", $list) . "</dt></dl>";
        $this->response['selector_html']['#artNegativosNum'] = number_format($cuentaTotal, 0, '', ',');
    }

    protected function nuevaNota():void {

        $list_salidas = '';
        $list_entradas = '';
        foreach ($this->permisoBodega->bodegasPuedeHacerMovimientos() as $key => $bodega) {
            $list_salidas .= "<li style='margin-top: 1.3em;color:$bodega[color]'>" .
                getLabelBodega($bodega, [
                    'isAnchor' => true,
                    'urlAnchor' => "../bodega/alta_movimiento.php?bodega_id=".urlencode($key)."&movimientode=salida",
                    'titleAnchor' => "Nueva Salida en " . ia_htmlentities($bodega['bodega'])
                ]) . "</li>";
            $list_entradas .= "<li style='margin-top: 1.3em;color:$bodega[color]'>" .
                getLabelBodega($bodega, [
                    'isAnchor' => true,
                    'urlAnchor' => "../bodega/alta_movimiento.php?bodega_id=".urlencode($key)."&movimientode=entrada",
                    'titleAnchor' => "Nueva Entrada en " . ia_htmlentities($bodega['bodega'])
                ]) . "</li>";
        }
        $this->response['selector_html']['#tabBodegaNuevaNota'] = strim(
        "<div class=\"flexItem flexItemBodega\">
            <ul class=\"tab tabBodega bodega_boxSalida\">
                <li><h3 style=\"margin: 0\">Salida</h3>
                    $list_salidas
            </ul>
        </div>
        <div class=\"flexItem flexItemBodega\">
            <ul class=\"tab tabBodega bodega_boxEntrada\">
                <li><h3 style=\"margin: 0;\">Entrada</h3>
                    $list_entradas
            </ul>
        </div>");
    }

    protected function capturaDeNotas():void {

        if(empty($this->permisoBodega->bodegasPuedeHacerMovimientos()) && empty($this->permisoBodega->bodegasPuedeConsultarMovimientos()))
            return;
        $totalFaltan = 0;
        $this->response['selector_html']['#captura_notas_list'] = bodegasResumenNumeroNotas(
            $this->permisoBodega->bodegasPuedeConsultarMovimientos(),
            $this->permisoBodega->bodegasPuedeHacerMovimientos() ,
            $totalFaltan
        );
        if($totalFaltan) {
            $resumenExtra = "<span style='color:red;font-weight: 800'>Faltan de Capturar: " .
                number_format($totalFaltan, 0, ',', '') . "</span>";
            $this->response['selector_html']['#captura_notas_summary'] = "<span style='color:red;font-size:2em;'>&cross;</span> Captura de Notas: $resumenExtra";
            $this->response['selector_html']['#captura_notas_marca_grande'] = '';
        } else {
            $this->response['selector_html']['#captura_notas_summary'] = "<span style='color:green;font-size:2em;'>✔</span> ¡Ok!";
            $this->response['selector_html']['#captura_notas_marca_grande'] = "<span style='color:green;font-size:2em;'>✔</span>";
        }
    }

    protected function notasFaltanPorVerificar() {
        $porBodegaCount =[];
        $method = __METHOD__;
        $sql =
          "SELECT  gb.bodega_grupo_verificador_id , nb.bodega_id,  nb.entrada_salida /*$method*/
            FROM bodega_grupo_verificador bgv
                JOIN bodega_grupo_verificador_verfica_bodega gb ON gb.bodega_grupo_verificador_id = bgv.bodega_grupo_verificador_id
                JOIN bodega b ON gb.bodega_id = b.bodega_id
                JOIN nota_bodega nb ON gb.bodega_id = nb.bodega_id 
                       AND (nb.fecha >= bgv.a_partir_de OR (bgv.a_partir_de IS NULL AND nb.fecha >= '2025-01-01') ) 
                       AND (bgv.hasta IS NULL OR nb.fecha <= '2025-05-13')
                       AND (nb.tipo = 'Movimiento' OR nb.tipo='Traslado' OR nb.tipo='Container' OR  nb.tipo = 'Devolucion' OR nb.tipo='Mwarehose')
                LEFT OUTER JOIN nota_bodega_verificacion nbv ON nb.nota_bodega_id = nbv.nota_bodega_id  AND nbv.bodega_verificador_id = bgv.bodega_grupo_verificador_id
            WHERE nbv.nota_bodega_id IS NULL";

        $faltaPorVerificar = ia_sqlArrayIndx($sql);
        if(empty($faltaPorVerificar)) return [];
        foreach($faltaPorVerificar as $falta) {
            $grupoVerificador_id = $falta['bodega_grupo_verificador_id'];
            $key = $falta['bodega_id'] . '_' . strtolower($falta['entrada_salida']);
            if(array_key_exists($key, $porBodegaCount[$grupoVerificador_id] ?? []))
                $porBodegaCount[$grupoVerificador_id][$key] += 1;
            else
                $porBodegaCount[$grupoVerificador_id][$key] = 1;
        }
        return $porBodegaCount;
    }

    protected function verificacion_grupos2() {
        $this->response['selector_html']['#verificacion_grupos'] = "!!!" . $this->panelVerificaciones();
    }
    /** Tablita entrada/salida por bodega */
    protected function verificacion_grupos() {
        // global $gDime;
        $start = microtime(true);

        global $gDime; $gDime[] =
        $grupos_verificacion = GruposVerificacion::obtenGruposYBodegasPuedeUsuario();
        //  $gDime["grupos_verificacion"] = $grupos_verificacion;
        if($grupos_verificacion === false) {
            $this->response['selector_html']['#verificacion_grupos'] = '';
            return;
        }
        if(empty($grupos_verificacion)) {
            $this->response['selector_html']['#'] = '';
            return;
        }
        // $end = microtime(true);
        // $gDime['obten G y B'] = $end - $start;

        //  $start = microtime(true);
        $noCuadran = GruposVerificacion::obtenCuantasNotasNoCuadran();
        // $end = microtime(true);
        // $gDime['nocuadrane'] = $end - $start;

        $html = [""];
        $puede_Ver_notas_origen = usuarioTipoRony() ? true : !empty($this->permisoBodega->bodegasPuedeConsultarMovimientos());
        // $start = microtime(true);
        $faltanCuentaPorBodegaEntradaSalida = $this->notasFaltanPorVerificar();
        // $end = microtime(true);
        // $gDime['notasFaltanPorVerificar'] = $end - $start;
        foreach ($grupos_verificacion as $grupo_verificacion_id => $elAgrupado) {
            $noCuadranPorBodega = GruposVerificacion::obtenCuantsNotasNoCuadranPorBodega($grupo_verificacion_id);
            //$faltanPorBodega = GruposVerificacion::obtenCuantasNotasFaltanPorBodegaEntradaSalida($grupo_verificacion_id);
            $faltanPorBodega = $faltanCuentaPorBodegaEntradaSalida[$grupo_verificacion_id] ?? false;
            if ($faltanPorBodega === false) {
                $faltanPorBodega = [];
            }

            // $start = microtime(true);
            $faltanPorVerificar =  number_format( array_sum($faltanPorBodega), 0, '', ',');
            if($faltanPorVerificar != '0')
                $faltanPorVerificarGrupo = "<span style='color:red;font-weight: bold;font-size:larger'>$faltanPorVerificar</span>";
            else
                $faltanPorVerificarGrupo = '0';
            // $end = microtime(true);
            // $gDime['sumalas '.$grupo_verificacion_id] = $end - $start;

            if(($noCuadran[$grupo_verificacion_id] ?? 0) > 0)
                $noCuadranNum = "<span style='color:red;font-weight: bold;font-size:larger'>" . number_format( $noCuadran[$grupo_verificacion_id] ?? 0, 0, '', ',') . "</span>";
            else
                $noCuadranNum = '0';
            $list_salidas = '';
            $list_entradas = '';
            // $nombreGrupoVerificador = GruposVerificacion::getField('grupo_verficiador', $grupo_verificacion_id);
            $start = microtime(true);
            foreach($elAgrupado as $bodega_id => $bodega) {
                $nombreGrupoVerificador = $bodega['grupo_verficiador'];
                $classDetailBodegaVerificar = "detailBodegaVerificar";
                $faltanPorVerificar =  number_format( $faltanPorBodega[$bodega_id . '_salida'] ?? 0, 0, '', ',');
                if($faltanPorVerificar !== '0')
                    $faltanPorVerificar = "<span style='color:red;font-size:larger;text-shadow: 1px 1px 2px #eaffe9, 0 0 0.1em #ffcba5, 0 0 0.1em #f8f8f8 !important;'>$faltanPorVerificar</span>";
                else
                    $faltanPorVerificar = '';
                $noCuadranEnLaBodega =  number_format( $noCuadranPorBodega[$bodega_id.'_salida'] ?? 0, 0, '', ',');
                if($noCuadranEnLaBodega !== '0')
                    $noCuadranEnLaBodega = "<span style='color:red;font-size:larger'>$noCuadranEnLaBodega</span>";

                $href_por_capturar_salida = "nota_bodega.php?sin_verificar=si&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Salida";
                $href_nueva = "../bodega/alta_verificacion.php?bodega_id=".urlencode($bodega_id)."&movimientode=salida&grupo_verificador=".$bodega['bodega_grupo_verificador_id'];
                if (!$puede_Ver_notas_origen)
                    $href_por_capturar_salida = $href_nueva;
                $list_salidas .= "<li style='margin-top: 0.8em;color:$bodega[color]'>" . getLabelBodega($bodega, [
                        'isAnchor' => true,
                        'urlAnchor' => $href_nueva,
                        'titleAnchor' => "Nueva Salida en " . ia_htmlentities($bodega['bodega'])
                    ]) . "<p style='font-size:smaller'><a class='hover-underline-animation' href='$href_por_capturar_salida' style='padding-left: 20px;'> Por capturar: $faltanPorVerificar</a> <a class='hover-underline-animation' href='nota_bodega_verificacion.php?match=no&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Salida' style='padding-left: 20px;'>No Cuadran: $noCuadranEnLaBodega</a></p></li>";

                $faltanPorVerificar =  number_format( $faltanPorBodega[$bodega_id . '_entrada'] ?? 0, 0, '', ',');
                if($faltanPorVerificar !== '0')
                    $faltanPorVerificar = "<span style='color:red;font-size:larger;text-shadow: 1px 1px 2px #eaffe9, 0 0 0.1em #ffcba5, 0 0 0.1em #f8f8f8 !important;'>$faltanPorVerificar</span>";

                $noCuadranEnLaBodega =  number_format( $noCuadranPorBodega[$bodega_id.'_entrada'] ?? 0, 0, '', ',');
                if($noCuadranEnLaBodega !== '0')
                    $noCuadranEnLaBodega = "<span style='color:red;font-size:larger'>$noCuadranEnLaBodega</span>";

                $href_por_capturar_entrada = "nota_bodega.php?sin_verificar=si&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Entrada";
                $href_nueva = "../bodega/alta_verificacion.php?bodega_id=".urlencode($bodega_id)."&movimientode=entrada&grupo_verificador=".$bodega['bodega_grupo_verificador_id'];
                if (!$puede_Ver_notas_origen)
                    $href_por_capturar_entrada = $href_nueva;
                $list_entradas .= "<li style='margin-top: 0.8em;color:$bodega[color]'>" . getLabelBodega($bodega, [
                        'isAnchor' => true,
                        'urlAnchor' => $href_nueva,
                        'titleAnchor' => "Nueva Entrada en " . ia_htmlentities($bodega['bodega'])
                    ]) . "<p style='font-size:smaller'><a class='hover-underline-animation' href='$href_por_capturar_entrada' style='padding-left: 20px;'> Por capturar: $faltanPorVerificar</a> <a class='hover-underline-animation' href='nota_bodega_verificacion.php?match=no&grupo_verificacion=$grupo_verificacion_id&bodega_id=$bodega_id&entrada_salida=Entrada' style='padding-left: 20px;'>No Cuadran: $noCuadranEnLaBodega</a></p></li>";
            }
            // $end = microtime(true);
            // $gDime['looop internon '.$grupo_verificacion_id] = $end - $start;

            $notas_por_verificar = '';
            if ($puede_Ver_notas_origen) {
                $notas_por_verificar ='<dt><a class="aTriangulo" href="nota_bodega.php?sin_verificar=si&grupo_verificacion='.$grupo_verificacion_id.'">Notas que falta verificar por '.$nombreGrupoVerificador.'</a></dt>';
            }


            $href_por_capturar = $puede_Ver_notas_origen ? "nota_bodega.php?sin_verificar=si&grupo_verificacion=$grupo_verificacion_id":"javascript:void(0);";

            if($nombreGrupoVerificador === 'OFI'){
                $html[0] = strim(
                    <<<HTML
            <fieldset class="indexVerificacion" id="grp_Verificacion" style="margin:0;padding:0.1em 0.1em;min-width:480px; margin-bottom: 2em">
                <legend class="indexVerificacion legend_grupo_verificacion">$nombreGrupoVerificador<span class="txtTituloLugar">
                    <span style='font-weight:100;font-size:smaller;padding-right:1em'>
                        <a class='hover-underline-animation' href='$href_por_capturar'> Por Capturar!: $faltanPorVerificarGrupo</a>
                        <a class='hover-underline-animation' href='nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id&match=no'>No Cuadran: $noCuadranNum</a>
                    </span>
                </legend>
                <dl class="tabBodega indexVerificacion">            
                    $notas_por_verificar
                    <dt><a class="aTriangulo" href="nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id">Notas Verificadas</a></dt>
                </dl>
                <details id="bnv_$grupo_verificacion_id" class="bodega $classDetailBodegaVerificar tabBodegaVerifyDetails">
                    <summary class="Bodegas_titIndex indexVerificacion legend_grupo_verificacion" >NUEVA VERIFICACIÓN</summary>
                    <div class="flexRow" style="gap:0.01em;">
                        <div class="flexItem flexItemBodega">
                            <ul class="tab tabBodega bodega_boxSalida_Verify">
                                <h3 style="margin: 0">Salida</h3>
                                $list_salidas
                            </ul>
                        </div>
                        <div class="flexItem flexItemBodega">
                            <ul class="tab tabBodega bodega_boxEntrada_Verify">
                                <h3 style="margin: 0;">Entrada</h3>
                                $list_entradas
                            </ul>
                        </div>
                    </div>
                </details>
            </fieldset>
            HTML);

            }
            else
            $html[] = strim(
                <<<HTML
            <fieldset class="indexVerificacion" id="grp_Verificacion" style="margin:0;padding:0.1em 0.1em;min-width:480px; margin-bottom: 2em">
                <legend class="indexVerificacion legend_grupo_verificacion">$nombreGrupoVerificador<span class="txtTituloLugar">
                    <span style='font-weight:100;font-size:smaller;padding-right:1em'>
                        <a class='hover-underline-animation' href='$href_por_capturar'> Por Capturar!: $faltanPorVerificarGrupo</a>
                        <a class='hover-underline-animation' href='nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id&match=no'>No Cuadran: $noCuadranNum</a>
                    </span>
                </legend>
                <dl class="tabBodega indexVerificacion">            
                    $notas_por_verificar
                    <dt><a class="aTriangulo" href="nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id">Notas Verificadas</a></dt>
                </dl>
                <details id="bnv_$grupo_verificacion_id" class="bodega $classDetailBodegaVerificar tabBodegaVerifyDetails">
                    <summary class="Bodegas_titIndex indexVerificacion legend_grupo_verificacion" >NUEVA VERIFICACIÓN</summary>
                    <div class="flexRow" style="gap:0.01em;">
                        <div class="flexItem flexItemBodega">
                            <ul class="tab tabBodega bodega_boxSalida_Verify">
                                <h3 style="margin: 0">Salida</h3>
                                $list_salidas
                            </ul>
                        </div>
                        <div class="flexItem flexItemBodega">
                            <ul class="tab tabBodega bodega_boxEntrada_Verify">
                                <h3 style="margin: 0;">Entrada</h3>
                                $list_entradas
                            </ul>
                        </div>
                    </div>
                </details>
            </fieldset>
            HTML);
        }
        $this->response['selector_html']['#verificacion_grupos'] = implode("\n", $html);
    }


    protected function limpia_clientes_cobranza(): void
    {

        $method = __METHOD__;
        /** @noinspection HtmlUnknownTarget */

        $consulta_limpia = param("limpia", 'NO');

        if($consulta_limpia === 'SI'){

            $this->response['clientes']['cuantos_limpia_clientes_cobranza'] =
                bcformat(ia_singleread(
                    "SELECT /*$method*/ COUNT(*) FROM cliente where receive_cheques = 1 and (cheques_totales = 0 and pagares_totales = 0 and vales_totales = 0)"
                ), 0);

            limpia_clientes_cobranza();
        }

        $this->response['selector_html']['#limpia_clientes_cobranza'] =
            bcformat(ia_singleread(
                "SELECT /*$method*/ COUNT(*) FROM cliente where receive_cheques = 1 and (cheques_totales = 0 and pagares_totales = 0 and vales_totales = 0)"
            ), 0);
    }
    protected function ajaxCompareDBs(): void
    {
        $this->response['html_card'] = doRunCompareDBs();
    }

    protected function panelVerificaciones():string {
        $grupos_verificacion = GruposVerificacion::obtenGruposYBodegasPuedeUsuario();
        if(empty($grupos_verificacion)) {
            return "" ;
        }

        $html = [];
        foreach($grupos_verificacion as $grupo_verificacion_id => $elAgrupado) {
            $nombreGrupoVerificador = reset($elAgrupado)['grupo_verficiador'];
            $href_por_capturar ="";
            $pon = strim(
              <<<HTML
            <fieldset class="indexVerificacion" id="grp_Verificacion" style="margin:0;padding:0.1em 0.1em;min-width:480px; margin-bottom: 2em">
                <legend class="indexVerificacion legend_grupo_verificacion">$nombreGrupoVerificador<span class="txtTituloLugar">
                    <span style='font-weight:100;font-size:smaller;padding-right:1em'>
                        <a class='hover-underline-animation' href='$href_por_capturar'> Por Capturar!: <span id="{$grupo_verificacion_id}_faltanPorVerificarGrupo"</span></a>
                        <a class='hover-underline-animation' href='nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id&match=no'>No Cuadran: <span id="{$grupo_verificacion_id}_faltanVerificar"></span></a>
                    </span>
                </legend>
                <dl class="tabBodega indexVerificacion">            
                    <div id="notas_por_verificar"</div>
                    <dt><a class="aTriangulo" href="nota_bodega_verificacion.php?grupo_verificacion=$grupo_verificacion_id">Notas Verificadas</a></dt>
                </dl>
                <details id="bnv_$grupo_verificacion_id" class="bodega detailBodegaVerificar tabBodegaVerifyDetails">
                    <summary class="Bodegas_titIndex indexVerificacion legend_grupo_verificacion" >NUEVA VERIFICACIÓN</summary>
                    <div class="flexRow" style="gap:0.01em;">
                        <div class="flexItem flexItemBodega">
                            <h3 class="bodega_boxSalida_Verify" style="margin: 0">Salida</h3>
                            <ul id="{$grupo_verificacion_id}_list_salidas" class="tab tabBodega bodega_boxSalida_Verify"></ul>
                        </div>
                        <div class="flexItem flexItemBodega">
                            <h3 class="bodega_boxEntrada_Verify" style="margin: 0;">Entrada</h3>
                            <ul id="{$grupo_verificacion_id}_list_entradas" class="tab tabBodega bodega_boxEntrada_Verify"></ul>
                        </div>
                    </div>
                </details>
            </fieldset>
            HTML);
            if($nombreGrupoVerificador === 'OFI')
                $html[0] = $pon;
            else
                $html[] = $pon;
        }
        return implode("\n", $html);
    }
}
new index_acciones();
