<?php
/** @noinspection PhpUnused */

use Iac\inc\sql\IacSqlBuilder;

require_once('../../inc/config.php');

class jqgridcolssorter_acciones extends AjaxHelper {

    function __construct() {
        parent::__construct();
    }

    protected function puedeHacerAccion():bool {
        return true;
    }

    protected function getColDefs():void {
        $method = __METHOD__;
        $col_def_key = strit(param('col_def_key'));
        $iac_usr_id = strit($_SESSION['usuario_id']);
        $colDef = ia_sqlArrayIndx(
            "SELECT /*$method*/ jqgridcolssorter_id as value, label, def, para_todos, para_todos as paratodos, ocultar_ribbon
                FROM jqgridcolssorter
                WHERE col_def_key = $col_def_key AND (para_todos = 'Si' OR iac_usr_id = $iac_usr_id)
                ORDER BY myDefault, para_todos DESC, jqgridcolssorter.label"
        );
        foreach($colDef as &$c)
            $c['def'] = json_decode($c['def']);
        $this->response = [
          'code' => 200,
          'status' => $colDef !== false,
          'message' => $colDef === false ? 'Problemas al leer la plantilla de columnas, intente más tarde' : '',
          'colDef' => $colDef,  
        ];
    }

    protected function setColDefs():void {
        $builder = new IacSqlBuilder();
        $values =  [
         'col_def_key' => param('col_def_key'),
         'label' => strim(param('label')),
         'def' =>  json_encode( $_REQUEST['def'] ?? [], JSON_OPTIONS_FOR_MYSQL),
         'para_todos' => usuarioTipoRony() ? param('para_todos', 'No') : 'No',
         'ocultar_ribbon' => strim(param('ocultar_ribbon', 'No')),
         'myDefault' => strim(param('myDefault', 'No')),
         'iac_usr_id'  => $_SESSION['usuario_id'],
         'ultimo_cambio' => 'NOW()',
        ];
        if(usuarioTipoRony() && $values['myDefault'] === 'Si')
            $values['para_todos'] = 'Si';
        if($values['para_todos'] !== 'Si' && $values['para_todos'] !== 'No')
            $values['para_todos'] = 'No';
        if($values['ocultar_ribbon'] !== 'Si' && $values['ocultar_ribbon'] !== 'No')
            $values['ocultar_ribbon'] = 'No';
        if($values['myDefault'] !== 'Si' && $values['myDefault'] !== 'No')
            $values['myDefault'] = 'No';
        if($values['myDefault'] === 'Si') {
            $method = __METHOD__;
            ia_query(
                "UPDATE /*$method*/ jqgridcolssorter SET myDefault = 'No' 
                    WHERE iac_usr_id=" . strit($_SESSION['usuario_id']) .
                " AND col_def_key=" . strit($values['col_def_key'])
            );
        }
        $id = ia_insertIded(
            $builder->insert(
                "jqgridcolssorter",
                $values,
                true,
                "jqgridcolssorter_id = LAST_INSERT_ID(jqgridcolssorter_id)"
            )
        );

        $this->response = [
            'code' => 200,
            'status' => $id !== false,
            'message' => $id !== false ? "$values[label] guardado" : 'Problemas al guardar la plantilla de columnas", intente más tarde',
            'value' => $id,
        ];
    }

    protected function deleteColDefs():void {
        $method = __METHOD__;
        $col_def_key = strit(param('col_def_key'));
        $label = strit(param('label'));
        $id = strit(param('id'));
        $iac_usr_id = strit($_SESSION['usuario_id']);

        $wheres = [
            "jqgridcolssorter_id = $id",
            "col_def_key = $col_def_key"
        ];
        if (!usuarioTipoRony())
        {
            $wheres[] = "iac_usr_id = $iac_usr_id";
        }
        $where = implode(" AND ", $wheres);
        $query = "DELETE /*$method*/ FROM jqgridcolssorter WHERE $where";
        $status = !ia_query($query);
        $this->response = [
            'code' => 200,
            'status' => $status,
            'message' => $status ? "$label borrado" : 'Problemas al borrar la plantilla de columnas, intente más tarde',
        ];
    }
}
$temp = new jqgridcolssorter_acciones();
