<?php
use Iac\inc\sql\IacSqlBuilder;

require_once('../../inc/config.php');
session_write_close();
/**
 * Clase para acciones AJAX de bodega
 * @author José Juan del Prado
 * @version 1.1
 */

class ValidandoPermiso extends AjaxHelper {

    function __construct()
    {
        parent::__construct();
        $this->setDebug();
    }

    /**
     * Regresa true si el usuario tiene permiso de hacer $this->accion, false del contrario
     * @return bool True puede hacer la accion, false no tiene permiso
     */
    protected function puedeHacerAccion(): bool
    {
        switch($this->accion) {
            case 'setPermiso':
                return true;
            default:
                return false;
        }
    }

    protected function setPermiso()
    {
        $ultimaCarpeta = param("ultimaCarpeta");
        $ultimaCarpeta= str_replace('.php','',$ultimaCarpeta);

        $permiso = true; //usuarioTipoRony() || Permisador::puede("puede_busqueda_rapida_$ultimaCarpeta",'No') !=='No';

        $this->response['status'] = true;
        $this->response['message'] = 'guardarRegla';
        $this->response['permiso'] = $permiso;


        return;
    }
}

$productogeneralAcciones = new ValidandoPermiso();