<?php
require_once("../inc/config.php");

// Database migration: Check and add missing columns to alumnos_becados table
$db_columns = ia_sqlArrayIndx("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = 'quantix' AND TABLE_NAME = 'alumnos_becados'");
$existing_columns = array();
if (is_array($db_columns)) {
    foreach ($db_columns as $row) {
        $existing_columns[$row['COLUMN_NAME']] = true;
    }
}

// Define required columns with their definitions
$required_columns = array(
    'ciclo_tesup' => "VARCHAR(50) NULL",
    'status' => "ENUM('pending','processing','success','skipped','error') NOT NULL DEFAULT 'pending'",
    'run_id' => "VARCHAR(64) NULL",
    'attempt_count' => "INT UNSIGNED NOT NULL DEFAULT 0",
    'last_attempt_at' => "DATETIME NULL",
    'locked_at' => "DATETIME NULL",
    'locked_by' => "VARCHAR(64) NULL",
    'last_error_code' => "VARCHAR(64) NULL",
    'last_error_message' => "VARCHAR(1024) NULL",
    'evidence_path' => "VARCHAR(512) NULL",
    'evidence_files' => "JSON NOT NULL DEFAULT (JSON_ARRAY())",
    'skip_reason' => "VARCHAR(255) NULL",
    'portal_url' => "VARCHAR(1024) NULL",
    'portal_student_found' => "TINYINT(1) NOT NULL DEFAULT 0",
    'portal_confirmed_id' => "VARCHAR(32) NULL",
    'portal_confirmed_programa' => "VARCHAR(255) NULL",
    'portal_confirmed_periodo' => "VARCHAR(64) NULL",
    'portal_saved_at' => "DATETIME NULL",
    'portal_receipt_id' => "VARCHAR(128) NULL",
);

// Get current table structure to determine column positions
$table_info = ia_sqlArrayIndx("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = 'quantix' AND TABLE_NAME = 'alumnos_becados' ORDER BY ORDINAL_POSITION");
$current_columns = array();
if (is_array($table_info)) {
    foreach ($table_info as $row) {
        $current_columns[] = $row['COLUMN_NAME'];
    }
}

// Migration: Add missing columns with proper positioning
$alter_statements = array();
$previous_column = 'porcentaje_beca_inscripcion'; // Starting point for new columns

foreach ($required_columns as $column_name => $column_def) {
    if (!isset($existing_columns[$column_name])) {
        $alter_statements[] = "ADD COLUMN `{$column_name}` {$column_def} AFTER `{$previous_column}`";
        $previous_column = $column_name;
    } else {
        // Update previous_column to this one for proper positioning
        $previous_column = $column_name;
    }
}

// Execute ALTER TABLE if there are missing columns
if (!empty($alter_statements)) {
    $alter_sql = "ALTER TABLE `alumnos_becados` " . implode(", ", $alter_statements);
    ia_query($alter_sql);
}

global $gAppRelate;
$f=new app_alumnos_becados();
$f->process_action();
$f->toolbar_set();
//$gIaHeader->html_head_add( array( 'jqgrid', 'datepicker','auotNumeric','jquery.MultiFile','fckeditor','table_addanother','ia' ));
?>
<!DOCTYPE html>
<html lang="es">
<head>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=utf-8">
<title> <?php echo $f->label; ?></title>
<?php $gIaHeader->html_head_echo(); ?>
</head>
<body>
<?php 
include('header.php');
$h=param('h',param('iah'));
if( true || $f->modo!='jqgrid_iacform' || ($f->modo=='jqgrid_iacform' && $h!='e' && $h!='r' && $h!='b' && $h!='d' && $h!='i' )  ) { 
    echo $f->form_tag();
    $f->display_toolbar();
    echo '<div style="margin-top:5px;">';
}
$f->process();
?>
</form>
<?php include('footer.php'); ?>
</body>
</html>