<?php
require_once('../../inc/config.php');
prepareForAsyncRequest();

// Create a process lock instance
$myLock = new ProcessLock();
$lockId = md5("actualiza_a_cuentas_live");

// If cannot aquire the lock, kill the script
if(!$myLock->aquire($lockId)) exit;

// Get the 'force' parameter's value, default to 'NO' if not set
$force = param('force', 'NO');

$myactualizaACuentasLiveATS = new ATS(func: 'async_actualizaACuentasLive', cada_minutos: 10);
$myactualizaACuentasLiveATS->ats_registra();
// Execute function
actualizaACuentasLive($force);

$myactualizaACuentasLiveATS->ats_done();
// Finally, release the lock and end execution
$myLock->release();
file_debug_reporte();
ia_errores_a_dime();