<?php

class AsignacionEstatus
{
    public $app = 'cuentat_gasto';
    public $origen = '';
    public $rules = [
        'A' => 'Asignado',
        'B' => 'Revisado',
        'C' => 'Autorizado',
        'D' => 'Rechazado',
        'E' => 'Rechazado revisado',
        'Z' => 'No asignado',
    ];
    public $userSession = null;
    public $usuario_id = null;
    public $pkField = null;
    function __construct($_app = null)
    {
        $this->app = ($_app != null) ? $_app : $this->app;
        $this->pkField = $this->app . "_id";
        $this->origen = ($this->app == 'cuentat_gasto') ? 'cuentat_gasto_asignacion' : 'banco_cuenta_mov_asignacion';
        $this->userSession = $_SESSION['usuario'];
        $this->usuario_id = $_SESSION['usuario_id'];
    }

    public function revisaGastoAsignado($cuentat_gasto_id, $user_id, $option, $returnSql = false, $posicion = null, $forzaRevision = false, $optionForza = 'a') {
        $sql = [];
        $andPosicion = ($posicion !== null) ? "AND posicion = '$posicion'": "";
        $query = "SELECT * FROM asignacion WHERE usuario_id = $user_id AND cuentat_gasto_id = '$cuentat_gasto_id' $andPosicion";
        // echo $query;
        // exit;
        $asignacion = ia_singleton($query);
    
        if (empty($asignacion)) {
            $arrCuentaTacciones["Status"] = 'Error';
            $arrCuentaTacciones["Error"] = "No se te asigno el gasto para su revisión. $cuentat_gasto_id";
            die(json_encode($arrCuentaTacciones));
        }
        $asignacion_id = $asignacion['asignacion_id'];
    
        $andPosicion = ($posicion !== null) ? "AND posicion = '$posicion'": "";
        $query = "SELECT usuario_id, descripcion nombre,valor FROM estado WHERE usuario_id = $user_id AND origen = '$this->origen' $andPosicion";
        $user_Estado = ia_singleton($query);
        $estado = $user_Estado['valor'];
        
        $query = "SELECT * FROM $this->app WHERE $this->pkField = '$cuentat_gasto_id'";
        $i_enDB = $cuentat_gasto = ia_singleton($query);
    
        $pos = strpos($estado, 'Z');
    

        // $dataEstado = $this->calculaEstatus($i_enDB, $pos, $option, false); // new
        $dataEstado = $this->calculaEstatus2($i_enDB, $pos, $option, false, $forzaRevision, $optionForza); // new
        // dd_($dataEstado);
        $nuevoEstado = $dataEstado['estado'];
        $replace = $dataEstado['replace'];
    
        $cuentat_gasto['asignacion'] = $nuevoEstado;
        // dd_($nuevoEstado);

//        dd_($nuevoEstado, $i_enDB['autorizado'], $cuentat_gasto_asignacion[$pos], $replace);
        $i_ND = array();
        $i_ND['asignacion']= $nuevoEstado;

        $esRony = usuarioTipoRony($this->usuario_id);

        $fecha_revision = null;

        if (!$esRony) {
            $fecha_revision = date('Y-m-d H:i:s');// ia_singleread("SELECT CURRENT_TIMESTAMP fecha_revision");
        }

        // Si el estatus es B: revisado o E: rechazado_revisado o C:autorizado
        // $revisado_el = ($replace == 'B' || $replace == 'E' || $replace == 'C') ? : '';
        $revisado_el = '';
        if (($replace == 'B' || $replace == 'E' || $replace == 'C') && !$esRony) {
            $revisado_el = ", revisado_el = '$fecha_revision'";
        } elseif($replace == 'A') {
            $fecha_revision = $asignacion['alta_db'];
            $revisado_el = ", revisado_el = null";
        }

        $semaforo = calculaSemaforo(null, $i_ND['asignacion'], $this->app);
        $i_ND['asig_semaforo_rony'] = $semaforo['rony'];
        $i_ND['asig_semaforo_usuarios'] = isset($semaforo['otros']) ? json_encode($semaforo['otros']) : '';
        $i_ND['html_asignaciones'] = asignacion_2_html($this->origen, $i_ND['asignacion'], $cuentat_gasto_id, true, $fecha_revision, $pos);

        $difBCM = haz_update_con_log($i_ND, $i_enDB, $this->app, $this->pkField, $cuentat_gasto_id);
    
        $sql = $difBCM;

        $sql[] = "UPDATE asignacion set
                    estatus_revision = '$replace',
                    ultimo_cambio_por = '$this->userSession'
                    $revisado_el
                WHERE asignacion_id = '$asignacion_id'";

        // dd_($sql);

        if ($returnSql == true) {
            return $sql;
        }
    
        if(ia_transaction($sql)) {
            ia_errores_a_dime('','','',true);
            $arrCuentaTacciones["Status"] = 'Error';
            $arrCuentaTacciones["Error"] = "Error al modificar el Gasto de Cuenta T.";
            die(json_encode($arrCuentaTacciones));
        }

        $_app = ($this->app == 'cuentat_gasto') ? $this->app : 'withdrawals_de_banco';

        $query = "SELECT valor, tabla_exists, tabla_origen FROM campos_exists WHERE tabla_origen='$_app'";
        $cgDatos = ia_sqlArray($query, 'tabla_exists');

        $query = "SELECT * FROM $this->app WHERE $this->pkField = '$cuentat_gasto_id'";
        // dd_($query);
        $cuentat_gasto = ia_singleton($query);

    
        $arrCuentaTacciones["Status"] = 'OK';
        $arrCuentaTacciones["Error"] = '';
        if ($this->app == 'cuentat_gasto') {
            $arrCuentaTacciones["cgenDB"] = $cuentat_gasto;
        } else {
            $arrCuentaTacciones["bcmenDB"] = $cuentat_gasto;
        }
        $arrCuentaTacciones['Importantes'] = $cgDatos['importante']['valor'];
        $arrCuentaTacciones['Pendientes'] = $cgDatos['pendiente']['valor'];
        $arrCuentaTacciones["newStatus"] = $replace; // replace Estatus
        echo json_encode($arrCuentaTacciones);
        
        @async_ws_actualizaGastosPorRevisar();
        exit;
    }

    public function calculaEstadoAsignacionPlantilla($plantillaID, &$asignados, &$cgND)
    {
        $sql_ = "SELECT asignado_para_revision FROM plantilla_cuentat_gasto WHERE plantilla_cuentat_gasto_id = '$plantillaID'";
        $asignados = ia_singleread($sql_);

        $asinacionEstado = 'ZZZZZZZZZZZZ';
        if (!empty($asignados)) {
            $sql_USers = "SELECT usuario_id, descripcion nombre,valor, origen FROM estado WHERE usuario_id IN ($asignados) AND origen = 'cuentat_gasto_asignacion'";
            $user_Estados = ia_sqlArrayIndx($sql_USers);

            $current = '';
            $estatusAsignacion = [];
            foreach ($user_Estados as $key => $estado) {
                $current = $estado['valor'];
                $pos = strpos($current, 'Z');
                $asinacionEstado = substr_replace($asinacionEstado, 'A', $pos, 1);
            }
            $cgND['asignacion'] = $asinacionEstado;
        } else {
            $cgND['asignacion'] = $asinacionEstado;
        }
    }

    public function asignaGastoSupervision($gastoID, &$sql, &$cgND, $org = null)
    {
        $org = ($org == null) ? $this->origen: $org;
        $sql_USers_sup = "SELECT usuario_id, descripcion nombre,valor, origen, posicion, clave FROM estado WHERE usuario_id != 0 AND origen = '$org' AND activo = 'Si'";
        $supervisores = ia_sqlArrayIndx($sql_USers_sup);
        if (!empty($supervisores)) {

            $asinacionEstado = 'ZZZZZZZZZZZZ';
            if (isset($cgND['asignacion'])) {

                $asinacionEstado = $cgND['asignacion'];
            }

            $supervisionEstado = 'ZZZZZZZZZZZZ';
            if (isset($cgND['supervision'])) {
                $supervisionEstado = $cgND['supervision'];
            }
            $current = '';
            $query = "INSERT /** INSERTA ASIGNACION **/ INTO asignacion (asignacion_id, usuario_id, cuentat_gasto_id, alta_por, posicion, clave
            , origen) VALUES ";
            foreach ($supervisores as $index => $supervisor) {
                $current = $supervisor['valor'];
                $pos = strpos($current, 'Z');
                $asinacionEstado = substr_replace($asinacionEstado, 'A', $pos, 1);
                $supervisionEstado = substr_replace($supervisionEstado, 'A', $pos, 1);

                $guid = ia_guid();
                $query .= "('$guid', '$supervisor[usuario_id]', '$gastoID', 'Sistema', $pos, '$supervisor[clave]', '$this->app'), ";
            }
            $cgND['asignacion'] = $asinacionEstado;
            $cgND['supervision'] = $supervisionEstado;

            $sql[] = substr($query, 0, -2);
        } else {
            $asinacionEstado = 'ZZZZZZZZZZZZ';
            $supervisionEstado = 'ZZZZZZZZZZZZ';
            $cgND['asignacion'] = $asinacionEstado;
            $cgND['supervision'] = $supervisionEstado;
        }
    }

    public function calculaNuevoEstadoAsignacion($cgenDB, $aor, &$sql, $onlyStatus = true, $posicion = null)
    {
        // dd_($cgenDB);
        // echo "<pre>".print_r($cgenDB, true);
        // $cgID = $cgenDB['cuentat_gasto_id'];
        $cgID = $cgenDB[$this->pkField];
        $current_asignacion_estado = $cgenDB['asignacion'];
        $nuevoEstadoAsignacion = $current_asignacion_estado;

        $query = "SELECT * FROM asignacion WHERE cuentat_gasto_id = '$cgID'";
        $asignados = ia_sqlArray($query, 'asignacion_id');
        $estadoUsuario = '';
        $current = '';
        $dataenDB = [];
        $replace = 'Z';
        foreach ($asignados as $key => $asignado) {
            $posicion = $asignado['posicion'];
            $posCurrentUSer = ($this->app == 'cuentat_gasto') ? obtenNumeroRevisorGastosCuentaT($asignado['usuario_id'], 'asignacion', $posicion): obtenNumeroRevisorMovimientosBanco($asignado['usuario_id'], 'asignacion', $posicion);

            $field_autorizado = ($this->app == 'cuentat_gasto') ? 'autorizado' : 'withdrawal_autorizado';
            $dataenDB['asignacion'] = $nuevoEstadoAsignacion;
            $dataenDB[$field_autorizado] = $cgenDB[$field_autorizado];
            if ($this->app != 'cuentat_gasto') {
                $dataenDB['link_vale'] = $cgenDB['link_vale'];
            } else {
                $dataenDB['rechazado'] = $cgenDB['rechazado'];
            }

            $dataEsatus = $this->calculaEstatus2($dataenDB, $posCurrentUSer, $aor, false);
            // dd_($dataEsatus);
            $nuevoEstadoAsignacion = $dataEsatus['estado'];
            $replace = $dataEsatus['replace'];

            $sql[] = "UPDATE asignacion SET
                        estatus_revision = '$replace',
                        ultimo_cambio_por = '$this->userSession'
                    WHERE asignacion_id = '$key'";
        }
        // dd_($nuevoEstadoAsignacion);
        if (!$onlyStatus) {
            return ['estado' => $nuevoEstadoAsignacion, 'replace' => $replace];
        }
        return $nuevoEstadoAsignacion;
    }

    public function calculaEstatus($dataenDB, $pos, $option, $onlyStatus = true)
    {
        $estado = $dataenDB['asignacion'];
        $current = $estado[$pos];
        if ($current == 'A' || $current == 'B') {
            $replace = 'B';
        }
    
        if ($current == 'D' || $current == 'E') {
            $replace = 'E';
        }
    
        $field_autorizado = ($this->app == 'cuentat_gasto') ? 'autorizado' : 'withdrawal_autorizado';
        if ($dataenDB[$field_autorizado] == 'No' && $current == 'C') {
            $replace = 'B';
        }

        if ($dataenDB[$field_autorizado] == 'Si') { // ya fue autorizado por rony
            $replace = 'C';
        }

        $nuevoEstado = substr_replace($estado, $replace, $pos, 1);
        // dd_($nuevoEstado, $current, $replace, $dataenDB[$field_autorizado]);
        if (!$onlyStatus) {
            return ['estado' => $nuevoEstado, 'replace' => $replace];
        }
        return $nuevoEstado;
    }

    public function calculaEstatus2($dataenDB, $pos, $option, $onlyStatus = true, $forzaRevision = false, $optionForza = 'a')
    {
        // dd_($dataenDB);
        $field_autorizado = ($this->app == 'cuentat_gasto') ? 'autorizado' : 'withdrawal_autorizado';
        $aurotizado = $dataenDB[$field_autorizado];

        $esRony = usuarioTipoRony($this->usuario_id);// : !empty($_SESSION['usuario_id']) && $_SESSION['usuario_id']=="1" ;

        $esRevisor = ($this->app == 'cuentat_gasto') ? esRevisor($this->usuario_id) : esRevisorBanco($this->usuario_id);
/*
        public $rules = [
        'A' => 'Asignado',
        'B' => 'Revisado',
        'C' => 'Autorizado',
        'D' => 'Rechazado',
        'E' => 'Rechazado revisado',
        'Z' => 'No asignado',
    ];*/
        $estado = $dataenDB['asignacion'];
        $nuevoEstado = $estado;
        $current = $estado[$pos];

        $replace = 'A';

        if ($option == 'a') {
            if ($forzaRevision) {
                $replace = 'B';
            }
            else if ($current == 'A') {
                $replace = !$esRony ? 'B' : 'A';
            }
            else if ($current == 'B' || $current == 'C') {
                $replace = $esRony ? 'B':'A';

            }
            else if ($current == 'D' || $current == 'E') {
                $replace = $esRony ? 'D' : 'B';
            }
        }
        else {
            $replace = $current == 'A' ? 'A' : 'D';
        }

        $nuevoEstado[$pos] = $replace;
        $vars = [
            'opcion' => $option == 'r' ? 'Rechazar' : 'Autorizar',
            'current' => "$current -> {$this->rules[$current]}",
            'esRony' => $esRony,
            'replace' => "$replace -> {$this->rules[$replace]}",
            'posicion real' => $pos,
            'posicion virtual' => $pos + 1,
            'autorizado' => $aurotizado,
            'nuevoEstado' => $nuevoEstado
        ];
        if (!$onlyStatus) {
            return ['estado' => $nuevoEstado, 'replace' => $replace];
        }
        return $nuevoEstado;
    }
}
