<?php
/** 2021-12-18 todo verde */

/**
 * Clase para crear reporte
 * @author José Juan del Prado
 * @version 1.0
 *
 *
 */
require_once 'autoload.php';
ini_set('memory_limit', '-1');
ini_set("pcre.backtrack_limit","10000000");
set_time_limit(0);
final class ReporteHelper
{
    protected $mpdf = null;
    protected $htmlexcel = '';
    public function __construct(protected $type='pdf')
    {
        if ($this->type == 'pdf') {
            $constructor = [
                'mode' => 'UTF-8',
                'format' => 'LETTER',
                'default_font_size' => 0,
                'margin_left' => 15,
                'margin_right' => 15,
                'margin_top' => 10,
                'margin_bottom' => 10,
                'margin_header' => 9,
                'margin_footer' => 9,
                'orientation' => 'P',
                'default_font' => 'dejavusans',
            ];
            $this->mpdf = new \Mpdf\Mpdf($constructor);
            $this->mpdf->SetTitle('IA');
            $this->mpdf->SetAuthor("IA");
            $this->mpdf->SetDisplayMode('fullpage');
            $this->mpdf->keep_table_proportions = TRUE;
            $this->mpdf->AddPageByArray(array(
                'orientation' => 'P'
            ));
        }
    }

    public function setStyleSheet($css_sheet = '')
    {
        $stylesheet = file_get_contents($css_sheet);
        $stylesheet = iconv("UTF-8", "UTF-8//IGNORE", $stylesheet);
        $this->mpdf->WriteHTML($stylesheet, 1);
    }
    public function setHeaderPdf($header = '')
    {
        $this->mpdf->SetHTMLHeader($header);
    }
    public function setFooterPdf($footer = '')
    {
        $this->mpdf->SetHTMLFooter($footer);
    }
    public function renderPdf($htmlBody = '<h1>HOLA MUNDO</h1>', $debug = false, $returnHtml = false)
    {
        $css_sheet = param('css_sheet', '../../css2/iastyles.css');
        if ($debug)
            $css_sheet = getUrlTo('css2/iastyles.css');

        $htmlFinal = '<!DOCTYPE html>
        <html lang="es">
        <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title></title>'.
            ($debug ? '<link href="'.$css_sheet.'" rel="stylesheet" type="text/css"/>':'')
            .'</head>
        <body style="">'.$htmlBody.'</body></html>';
        if ($returnHtml)
            return $htmlFinal;
        if ($debug) {
            echo $htmlFinal;
            exit;
            return;
        }
        $this->setStyleSheet($css_sheet);

        $htmlFinal = iconv("UTF-8", "UTF-8//IGNORE", $htmlFinal);
        $this->mpdf->WriteHTML($htmlFinal, 2);
    }
    public function pdfDownload($file_name = 'reporte.pdf', $title = '')
    {
        if (!empty($title)) {
            $this->mpdf->SetTitle($title);
        }
        $this->mpdf->Output($file_name, 'D');
    }

    public function renderExcel($excel_body = '<h1>HOLA MUNDO</h1>')
    {
        $this->htmlexcel = '<!DOCTYPE html><html lang="es" xmlns:x="urn:schemas-microsoft-com:office:excel">
        <head>
            <!--[if gte mso 9]>
            <xml>
                <x:ExcelWorkbook>
                    <x:ExcelWorksheets>
                        <x:ExcelWorksheet>
                            <x:Name>Sheet 1</x:Name>
                            <x:WorksheetOptions>
                                <x:Print>
                                    <x:ValidPrinterInfo/>
                                </x:Print>
                            </x:WorksheetOptions>
                        </x:ExcelWorksheet>
                    </x:ExcelWorksheets>
                </x:ExcelWorkbook>
            </xml>
            <![endif]-->
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        </head>
        <body>'.$excel_body .'</body></html>';
    }
    public function excelDownload($file_name = 'reporte.xls')
    {
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename='.$file_name);
        header("Pragma: no-cache");
        header("Cache-Control: 0");
        echo $this->htmlexcel;
    }
}
