<?php
/** 2021-12-18 todo verde */

/**
 * Clase para crear html de una tabla con base a un array de datos
 * @author José Juan del Prado
 * @version 1.0
 *
 *
 */
final class TableHelper
{
    static function render(array $data = [], array $order = [], ?string $table_title = null, array $colsWidths = [], $widthTable = '100%', $activePaddingTd = true, $colsShow= [], $classTrBody = '', $sumCols = [], $countCols = [], $identifier = 'tabla_generada', $solo_body = false, $cols_hidden = [], $margin_table = "auto", $date_time_label_keys = [], $classTable = 'table', $doHeaders = true, $pk = ''
    ): array|string
    {
        if (count($data) == 0) return '';

        if (empty($widthTable)) $widthTable = '100%';

        $headers = "";
        $body = "";
        $keys = array_keys(reset($data));
        $arrayDiff = array_diff($keys, $order);
        $fields = (empty($colsShow)) ? array_merge($order, $arrayDiff): $colsShow;
        $lengthCols = count($fields);
        // $width = 100/(count($fields));

        $caption = ($table_title != null && $doHeaders) ? "<tr class='txt_bold_dark_blue'><th colspan='$lengthCols'>- = $table_title = -</th></tr>" : '';

        if($doHeaders) foreach ($fields as $key => $field) {
            if (in_array($field, $cols_hidden))
                continue;
            $headers .= "<th class='lbl'>". self::dashesToCamelCase($field) ."</th>";
        }
        $valPrevi = null;
        $moneda = null;
        $paddingTd = $activePaddingTd ? 'padding: 5px;' : '';
        foreach ($data as $index => $item) {
            $id = '';
            if ($pk != '' && isset($item[$pk]))
                $id = "id='$item[$pk]'";
            $body.= "<tr $id>";
            $moneda = isset($item['moneda_id']) ? $item['moneda_id'] : null;
            foreach ($fields as $key => $field) {
                if (in_array($field, $cols_hidden))
                    continue;

                if (array_key_exists($field, $item)) {
                    $class = self::setClass($field, $item[$field], $valPrevi, $moneda);
                    $width = (isset($colsWidths[$field])) ? "width: $colsWidths[$field]": "";
                    $value = in_array($field, $date_time_label_keys) ? getDateLabel($item[$field], addTime: true, format: "d/m/Y H:i:s") :self::setValue($field, $item[$field]);
                    $body .= "<td class='$class' style='$paddingTd $width'>  $value " . ($field === 'inconsistencia' ? ($item['input'] ?? '') : '') . ($field === 'inconsistencia' ? $item["check_input"] : '' ) ."</td>";
                    $valPrevi = $item[$field];
                }
            }
            $body.= "</tr>";
        }
        if ($solo_body and empty($sumCols)) return $body;
        // $marginLeft = ((100-intval($widthTable))/2);
        $marginLeft = 0;

        $tfoot= [];
        foreach ($sumCols as $sumCol) {
            if (in_array($sumCol, $keys)) {
                $decimal = 2;
                if (str_contains($sumCol, 'rolls')||str_contains($sumCol, 'rollos') )
                    $decimal = 0;
                if($sumCol==='N/A')
                    $sumCol= 0;

                $tfoot[$sumCol] = number_format(array_sum(array_column($data,$sumCol)), $decimal, '.', ',');
            }
        }
        foreach ($countCols as $countCol) {
            if (in_array($countCol, $keys)) {
                $tfoot[$countCol] = "<span style='float: right'>TOTAL: ".number_format(count($data),0, '.', ',') . "</span>";
            }
        }


        $tfootTable= "";
        if (!empty($tfoot)) {
            $tfootTable = "<tfoot class='total'><tr>";
            foreach ($fields as $key => $field) {
                // dd_($field, $tfoot, $tfoot[$field], isset($tfoot[$field]));
                if (isset($tfoot[$field])) {
                    // $width = (isset($colsWidths[$key])) ? $colsWidths[$key]: ($width."%");
                    $tfootTable.= "<td class='bold txt_right_aligned lbl' style='$paddingTd'>".$tfoot[$field]."</td>";
                } else {
                    $tfootTable.="<td></td>";
                }
            }
            $tfootTable .= "</tr></tfoot>";
        }
        if ($solo_body) return ['tbody' => $body, 'sumsFooter' => $tfootTable];

        // $margin_table = "auto";
        $thead = $doHeaders ? "<thead> $caption <tr> $headers </tr> </thead>" : "";
        return "<table style='width: $widthTable; margin: $margin_table; font-size: 0.8em;' class='$classTable' id='$identifier'>
                        $thead
                        <tbody class='$classTrBody'>
                            $body
                        </tbody>
                        $tfootTable
                    </table>";
    }

    static function setClass($field, $value = null, $prevValue = null, $moneda = null)
    {
        $class = '';
        $arrayDef_bold = ['nombre', 'fecha', 'ultimo_pago', 'ultima_compra', 'doc_mas_antiguo'];

        $arrayParseMoney = ['moneda', 'moneda_id', 'doc_moneda_id'];

        $arrayParseMoneyPrevius = ['saldo_final'];

        $arrayParseNumber = ['rollos', 'quantity', 'total_rolls', 'total_rollos', 'total_quantity', 'salida_rollos', 'salida_quantity', 'entrada_rollos', 'entrada_quantity'];

        if (in_array($field, $arrayDef_bold)) $class .= 'bold ';

        if (in_array($field, $arrayParseMoney)) {
            $class .= ($moneda == 1 || $moneda == '1') ? 'bold txt_color_PESOS txt_right_aligned' : 'bold txt_color_USD txt_right_aligned';
        }

        if (in_array($field, $arrayParseMoneyPrevius)) {
            $class .= ($moneda == 1 || $moneda == '1') ? 'bold txt_color_PESOS ' : 'bold txt_color_USD ';
        }

        if (in_array($field, $arrayParseNumber)) {
            $class .= 'txt_right_aligned ';
        }

        $arrayField = explode("_", $field);
        if(in_array('pesos', $arrayField)) $class .= 'txt_right_aligned bold txt_color_PESOS ';

        if(in_array('usd', $arrayField)) $class .= 'txt_right_aligned bold txt_color_USD ';

        if(in_array('saldo', $arrayField) ||in_array('tienda', $arrayField)) $class .= 'txt_right_aligned ';


        return $class;
    }

    static function setValue($key, $value)
    {
        $arrayParseMoney = ['moneda', 'moneda_id', 'doc_moneda_id'];

        $arrayParseDate = ['fecha', 'ultimo_pago', 'ultima_compra', 'doc_mas_antiguo'];

        $arrayParseNumber = ['rollos', 'quantity', 'total_quantity', 'salida_quantity', 'entrada_quantity'];

        if (in_array($key, $arrayParseMoney)) {
            $value = ($value == 1 || $value == '1') ? 'PESOS' : 'USD';
        }

        if (in_array($key, $arrayParseDate)) {
            $value = getDateLabel($value);
        }

        $arrayField = explode("_", $key);
        if(in_array('pesos', $arrayField) || in_array('usd', $arrayField) || in_array('saldo', $arrayField)) {
            $value = number_format($value, 2);
        }

        if (in_array($key, $arrayParseNumber)) {
            $decimals = ($key === 'quantity' || $key === 'total_quantity') ? 6: 2;
            $value = number_format($value, 2);
        }
        $arrayProtectedHTML = ['inconsistencia'];
        if (in_array($key, $arrayProtectedHTML)) {
            $value = "<div class='dved'>$value</div>";
        }

        return $value;
    }

    static function dashesToCamelCase($string, $capitalizeFirstCharacter = true)
    {
        $str = str_replace('_id', '', ucwords($string));
        $str = str_replace('_', ' ', ucwords($str, '_'));

        if (!$capitalizeFirstCharacter) {
            $str = lcfirst($str);
        }

        return $str;
    }
}
