<?php
class ToolBar
{
    private $response = ['status' => false, 'code' => 200, 'message' => 'Petición invalida'];
    private $msg_err = '';
    public $module = '';

    public $section = null;
    public $data = [];

    function __construct($reviewRequest = true)
    {
        // dd_($_POST);
        $gIAsql['trace']=true;
        $this->module = param('module');
        $this->section = param('section');

        if ($reviewRequest == true) {
            $this->validateRequest();
        }
    }

    function setModule($module = '')
    {
        $this->module = $module;
    }

    function validateRequest()
    {
        if (empty($this->module)) {
            die(json_encode($this->response, JSON_UNESCAPED_UNICODE));
        }
    }
    public function preparaData()
    {
        $method = __METHOD__;
        global $gIAsql;
        switch ($this->module) {
            case 'facturas':
                    // if (empty($this->section)) {
                    //     $this->data['canceladas_sin_revision'] = 23;
                    // } else {
                    //     if ($this->section == 'canceladas_sin_revision') {
                            // actualizaFacturasCanceladas();
                            $sql = "SELECT /*$method*/ valor, tabla_exists FROM campos_exists WHERE tabla_origen = 'facturas'";
                            $datos = ia_sqlArray($sql, 'tabla_exists');
                            // dd_($datos);
                            $factSinRevision = isset($datos['canceladas_sin_revision']) ? $datos['canceladas_sin_revision']['valor'] : 0;
                            $factConRevision = isset($datos['canceladas_con_revision']) ? $datos['canceladas_con_revision']['valor'] : 0;
                            $factPendientes = isset($datos['canceladas_pendientes']) ? $datos['canceladas_pendientes']['valor'] : 0;
                            /* if (empty($existe)) {
                                $sql = "SELECT COUNT(*) total FROM links_al_banco_live
                                        WHERE (
                                            factura <> 'DEVOLUCION'
                                            AND (factura IN ('FACTURA', 'FACTURA PENDIENTE') OR ivacobradox100 > 0)
                                            AND cancelacion_revisada != 'Si'
                                        );";
                                $factSinRevision =  ia_singleread($sql);
                            } else {
                                $factSinRevision = $existe['valor'];
                            } */
                            /* $sql = "SELECT COUNT(*) total FROM links_al_banco_live
                                        WHERE (
                                            factura <> 'DEVOLUCION'
                                            AND (factura IN ('FACTURA', 'FACTURA PENDIENTE') OR ivacobradox100 > 0)
                                            AND cancelacion_revisada = 'No'
                                        );";
                            $factSinRevision =  ia_singleread($sql);
                            if (empty($existe)) {
                                $sql = "INSERT INTO campos_exists (campo_id, valor, tabla_exists, tabla_origen) VALUES(1, $factSinRevision, 'canceladas_sin_revision', 'facturas');";
                            } else {
                                $sql = "UPDATE campos_exists SET valor = $factSinRevision WHERE campos_exists_id = $existe[campos_exists_id]";
                            }
                            if(ia_query($sql))
                            {
                                ia_errores_a_dime();
                                if($gIAsql['trace'])
                                    ia_errores_a_dime("sql_trace=".print_r($gIAsql['sql_trace'],true));
                            } */
                            $sql = "SELECT /*$method*/ valor, tabla_exists FROM campos_exists WHERE tabla_origen = 'facturas'";
                            $this->data['canceladas_sin_revision'] = $factSinRevision;
                            $this->data['canceladas_con_revision'] = $factConRevision;
                            $this->data['canceladas_pendientes'] = $factPendientes;

                            $this->title('Solicitudes de Facturas.');
                    //     }
                    //     if ($this->section == 'canceladas_con_revision') {
                    //         $this->data['canceladas_con_revision'] = 30;
                    //     }
                    // }
            break;
            case 'inversiones':
                $tipo_inversion_empresa_privada = param('tipo_inversion_empresa_privada', 'empresa');
                if (empty($this->section)) {
                    $invDatos = ia_sqlArray("SELECT /*$method*/ valor, tabla_exists, tabla_origen FROM campos_exists WHERE tabla_origen='inversion$tipo_inversion_empresa_privada'",'tabla_exists');
                    //$this->data['modificados'] = $invDatos['bloqueado']['valor'];
                    $this->data['errores'] = $invDatos['error']['valor'];
                    $this->data['capturados'] = $invDatos['capturado']['valor'];
                    $this->data['expirados'] = $invDatos['expirados_sin_solicitud']['valor'];
                    $this->data['expiradosUrg'] = $invDatos['expirados_urgentes']['valor'];
                    $this->data['modificados_con_reembolso'] = $invDatos['modificados_con_reembolso']['valor'];
                }
                $this->title(param('titulo'));
            break;
            case 'fiduciarios':
                $_app = param("_app");
                $fidDatos = array();
                if (empty($this->section)) {
                    switch($_app) {
                        case 'fiduciario':
                            $this->title('Movimientos de Fiduciario.');
                            $fidDatos = ia_sqlArray("SELECT /*$method*/ valor, tabla_exists, tabla_origen FROM campos_exists WHERE tabla_origen='fiduciario'",'tabla_exists');
                        break;

                        case 'fiduciario_contenedor':
                            $fidDatos = ia_sqlArray("SELECT /*$method*/ valor, tabla_exists, tabla_origen FROM campos_exists WHERE tabla_origen='fiduciario_contenedor'",'tabla_exists');
                            $fidDatos['capturado'] = array('valor'=>0);
                            $this->title('Contenedores de Fiduciario.');
                        break;
                    }
                    $this->data['modificados'] = $fidDatos['bloqueado']['valor'];
                    $this->data['errores'] = $fidDatos['error']['valor'];
                    $this->data['capturados'] = $fidDatos['capturado']['valor'];
                    $this->data['expirados'] = $fidDatos['expirados_sin_solicitud']['valor'];
                    $this->data['expiradosSolicitados'] = $fidDatos['expirados_con_solicitud']['valor'];
                    $this->data['expiradosUrg'] = $fidDatos['expirados_urgentes']['valor'];
                    $this->data['expiradosSolicitadosUrg'] = $fidDatos['expirados_con_solicitud_urge']['valor'];
                }
            break;
            case 'cuentat_gastos':
                $cgDatos = array();
                $_app = param('_app');
                $grid_normal = param('grid_normal', 'SI');
                $grid_para_asignar = param('grid_para_asignar', 'NO');
                $usuario_revisor_id = param('usuario_revisor_id', 0);
                $titulo_replace = "";
                $origen = "";

                if($_app == 'withdrawalbanco') {
                    $_app = 'withdrawals_de_banco';
                    $origen = "banco_cuenta_mov_asignacion";

                    $titulo_replace = 'WITHDRAWALS';
                } else {
                    $_app = 'cuentat_gasto';
                    $titulo_replace = 'GASTOS DE CUENTA T';

                    $origen = "cuentat_gasto_asignacion";
                }

                $url_components = parse_url($_SERVER['HTTP_REFERER']);
                parse_str($url_components['query'] ?? '', $params);

                $textIdentificador = (($params['supervisor'] ?? 'NO') == 'SI') ? '(Sup)': '(Rev)';


                $revisar_txt = "";
                $usuario_id = $_SESSION['usuario_id'];

                if($grid_normal == 'NO' && $usuario_revisor_id) {
                    $usuario_revisor_id = empty($usuario_revisor_id) ? $usuario_id : $usuario_revisor_id;
                    $query = "SELECT clave FROM estado WHERE usuario_id = $usuario_revisor_id AND origen = '$origen'";
                    $usuario_revisor = ia_singleread($query);
                    $revisar_txt = $grid_normal == 'NO' ? "<span class='txt14px txt_color_red bold'>REVISAR $titulo_replace DE </span><span class='txt17px txt_color_PESOS bold'>$usuario_revisor$textIdentificador</span>" : "";
                }
                if($grid_para_asignar == 'SI') {
                    $revisar_txt = "<span class='txt14px bold'>ASIGNAR $titulo_replace";
                }

                // $this->title(empty($revisar_txt) ? $titulo_replace : $titulo_replace);
                $this->title(empty($revisar_txt) ? $titulo_replace : $revisar_txt);


                // if (empty($this->section)) {
                    $sql = "SELECT valor, tabla_exists, tabla_origen FROM campos_exists WHERE tabla_origen='$_app'";
                    $cgDatos = ia_sqlArray($sql,'tabla_exists');
                    
                    $this->data['importantes'] = $cgDatos['importante']['valor'];
                    $this->data['pendientes'] = $cgDatos['pendiente']['valor'];
                    $this->data['repetidos'] = array_key_exists('repetido', $cgDatos) ? $cgDatos['repetido']['valor'] : 0;
                    $this->data['editCont'] = param('ecc','No');
                    $this->data['grid_normal'] = $grid_normal;
                    $this->data["sql"] = $sql;
                // }
            break;
            case 'estado_de_cuenta':
                $banco_cuenta_id = param("banco_cuenta_id");
                $banco_cuenta_mov_id = param("BCMID");
                $ECO = param("ECO");

                if ($ECO != 'NO') {
                    $ECO = 'SI';
                    $Original = true;
                } else {
                    $Original = false;
                }

                $sql = '';
                $sqlextra = '';

                if ($banco_cuenta_mov_id != '' || strlen($banco_cuenta_mov_id) == 32) {
                    $bcs_arr["banco_cuenta_id"] = $banco_cuenta_id;
                    $bcs_arr["saldo_actual"] = CalculaBancoCuentaSaldodesdeunMovimiento($banco_cuenta_id, $banco_cuenta_mov_id, $Original);
                } else {
                    if ($ECO == "SI") {
                        $sql = "SELECT /*$method*/ banco_cuenta_id, SUM(cash)+SUM(deposit)-SUM(withdrawal) AS saldo_actual FROM banco_cuenta_mov WHERE banco_cuenta_id = " . strit($banco_cuenta_id) . $sqlextra;
                    } else {
                        $sql = "SELECT /*$method*/ banco_cuenta_id, SUM(cash)+SUM(deposit)-SUM(withdrawal) AS saldo_actual FROM mov_verificado WHERE banco_cuenta_id = " . strit($banco_cuenta_id) . $sqlextra;
                    }
                    $bcs_arr = ia_singleton($sql);
                }

                $this->data['banco_cuenta_id'] =  $bcs_arr["banco_cuenta_id"];
                $this->data['saldo_actual'] =  $bcs_arr["saldo_actual"];

                
            break;
            case 'doctos':
                $this->title('Cheques, Pagarés, Vales y Compras.');
            break;
            case 'nota_bodega':
                /*$this->data['numero_compra_vacios'] = ia_singleread("SELECT count(*) FROM nota_bodega
                WHERE 
                    (numero_compra IS NULL OR numero_compra = '' OR numero_compra = '[]' OR (numero_compra LIKE '%\"fue_error\":\"Si\"%' AND numero_compra NOT LIKE '%\"fue_error\":\"No\"%'))");*/
                /*$this->data['numero_compra_vacios'] = ia_singleread("SELECT COUNT(*) FROM nota_bodega nb
                    WHERE (nb.numero_compra IS NULL OR nb.numero_compra = '' OR nb.numero_compra = '[]' OR JSON_LENGTH(numero_compra) < 1)
                        OR
                        0 = (SELECT count(*) as hay
                                FROM nota_bodega nbj
                                JOIN JSON_TABLE(nbj.numero_compra, '$[*]' COLUMNS (
                                    ord FOR ORDINALITY,
                                    fue_error TEXT PATH '$.fue_error'
                                    )
                                ) AS j
                                WHERE nb.nota_bodega_id=nbj.nota_bodega_id AND j.fue_error='No')");*/

                $and_bodega_id_in = '';
                if (!usuarioTipoRony()) {
                    global $gPermisosbodega;
                    $bodegas_id_IN = parseClauseIn(array_keys($gPermisosbodega->bodegasPuedeConsultarMovimientos()));
                    if(!empty($bodegas_id_IN))
                        $and_bodega_id_in = " AND bodega_id IN ($bodegas_id_IN)";
                }
                $tempComment = __METHOD__ . ":" . __LINE__;
                $this->data['numero_compra_vacios'] = ia_singleread("SELECT /*$tempComment*/ count(*) FROM nota_bodega WHERE (numero_compra_actual is null or numero_compra_actual = '') AND tipo IN('Movimiento', 'Devolucion') $and_bodega_id_in");
                $this->data['notas_modificadas_sin_autorizar'] = ia_singleread("SELECT /*$tempComment*/ COUNT(*) FROM nota_bodega WHERE modificacion_importante = 'Si' $and_bodega_id_in");
                $this->data['notas_modificadas'] = ia_singleread("SELECT /*$tempComment*/ COUNT(*) FROM nota_bodega WHERE modificacion_importante_cuantas>0 $and_bodega_id_in");
                $this->data['notas_borradas'] = ia_singleread("SELECT /*$tempComment*/ COUNT(*) FROM nota_bodega WHERE tipo = 'Borrado' $and_bodega_id_in");
                $this->data['notas_modificadas_mayor_12'] = ia_singleread("SELECT /*$tempComment*/ COUNT(*) FROM nota_bodega WHERE horas_flag = 1 $and_bodega_id_in");
                $this->data['es_entrada_contenedor'] = param("es_entrada_contenedor", param("container"));

            break;
            case 'pedido':
                $this->data['sin_pi'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_pi = ''");
                $this->data['con_contenedor'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_contenedor <> ''");
                $this->data['sin_contenedor'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_contenedor = ''");
                $this->data['contenedor_sin_pi'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_contenedor <> '' AND numero_pi = ''");
                $this->data['contenedor_con_pi'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_contenedor <> '' AND numero_pi <> ''");
                $this->data['pi_sin_contenedor'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_contenedor = '' AND numero_pi <> ''");
                $this->data['container_sin_eta'] = ia_singleread("SELECT COUNT(*) FROM pedido WHERE activo='Si' AND numero_contenedor <> '' AND eta IS NULL");
            break;
            case 'ajuste':
                $this->data['cancelados'] = ia_singleread("SELECT COUNT(*) FROM ajuste WHERE cancelado='Si'");
            break;
            case 'tc_log':
                $this->data['por_sistema'] = ia_singleread("SELECT COUNT(*) FROM tc_log WHERE alta_por = 'actualizaTCenDB'");
                $this->data['todos'] = ia_singleread("SELECT COUNT(*) FROM tc_log");
                $this->data['manual'] = ia_singleread("SELECT COUNT(*) FROM tc_log WHERE ALTA_POR <> 'actualizaTCenDB'");
                break;
            default:
                # code...
                break;
        }
    }
    
    public function title ($title = null) {
        $this->data['title'] = $title;
    }
    public function render($view = null, $ini = false)
    {
        $pathView = (empty($view)) ? $this->module . "/". (empty($this->section) ? $this->module: $this->section) : $view;
        $pathView = "component/toolbar/" . $pathView;
        // echo $pathView;
        $this->data['ini'] = $ini;
        $view = renderView($pathView, $this->data);
        if (isset($this->data['title'])) {
            $view = $this->data['title'] . $view;
        }
        return $view;
    }

}