<?php
/**
 * Ajax responder para el tema tema explicar que hace en general
 *
 * regresa un json
 *  {ok: true, // todo ok
 *   msgErrors:[mensajes de error], // en false los mensajes de error
 *   avisos:['',..],
 *   ...
 * }
 * o un header diferente de error >=400 y <=599 con el mensaje de error
 *

 fechas de ultimos cambios:
    2021-008-24 mejore permisos

  estas son el minimo comentario mejorar todo lo posible segun el caso
 */
namespace ajaxResponder\tema; // cambiar tema y Tema por el tema, por ejemplo bodega

////////////////////////////////////////
/// setup, checa exista login
    require_once('../../inc/config.php');

////////////////////////////////////////
/// revisa permiso y ejecuta petición
    if(!puedeTema())
        terminaConHeaderError('401', 'Sin permiso');
    action($_REQUEST['action'] ?? '');

    function action($action) {
        switch( $action) {
            case 'l': // l= que es a, por ejemplo: lista
                $params = paramsClean(params(['param1'=>'default','param2'=>'defaultValue']));
                $msgErrors = parametrosValidos($params);
                if(count($msgErrors > 0))
                    terminaConObject(['ok'=>false, 'msgErrors'=>$msgErrors]);
                if(!puedeTemaAccionA($params))
                    terminaConHeaderError('401', 'Sin permiso');
                $return = procesaAccionA($params);
                $return['ok'] = true;
                terminaConObject($return);
                break;
            case 'b': // comentario que explica que es b
                $params = paramsClean(params(['param1','param2']));
                $msgErrors = parametrosValidos($params);
                if(count($msgErrors > 0))
                    terminaConObject(['ok'=>false, 'msgErrors'=>$msgErrors]);
                if(!puedeTemaAccionA($params))
                    terminaConHeaderError('401', 'Sin permiso');
                $return['ok'] = accionBOk($params);
                terminaConObject($return);
                break;
            default:
                terminaConHeaderError('402', 'Invalida action');
        }
        terminaConObject($return); // fallback
    }

////////////////////////////////////////
///  acciones pueden ir aqui o en otro lado
    function accionA($params):array {return [];}

    function accionBOk($params):bool {return true;}

////////////////////////////////////////
// Helpers de este
    function params($paramKeys) {
        return array_key_intersect($_REQUEST, array_flip($paramKeys));
    }
    function paramsClean($params) {
        foreach($params as $name => &$p) {
            if(is_array($p))
                foreach($p as &$d)
                    $d = strim($d);
            else
                $p = strim($p);
         //@TODO quitar comas a números
        }
        return $params;
    }
    function parametrosValidos($params):array {
        $msgErrors = [];
        // ejemplo un parametro mal_ $msgErrors[] = 'Nombre es un dato requerido'
        return $msgErrors;
    }
    function puedeTema():bool {

    }

////////////////////////////////////////
// helpers generales
    function terminaConHeaderError($http_response_code, $message) {

        header($message, true, $http_response_code);
        ia_errores_a_dime();
        die();
    }
    function terminaConObject($array) {
        echo json_encode($array);
        ia_errores_a_dime();
        die();
    }
