<?php
/**
 * Simple test to verify data loads correctly
 */
require_once("../../inc/config.php");

header('Content-Type: text/plain');
echo "CFDI Matcher Data Test\n";
echo "======================\n\n";

// Test 1: Check latest iteration
echo "Test 1: Latest Iteration\n";
$latest_sql = "SELECT iteration_id, iteration_number, matched_count, match_rate_percent
               FROM cfdi_matcher_iterations
               ORDER BY iteration_id DESC LIMIT 1";
$latest = ia_sqlArrayIndx($latest_sql)[0] ?? null;

if ($latest) {
    echo "✓ Found iteration #{$latest['iteration_number']} (ID: {$latest['iteration_id']})\n";
    echo "  Matched: {$latest['matched_count']} ({$latest['match_rate_percent']}%)\n";
} else {
    echo "✗ No iterations found!\n";
}

// Test 2: Check match results count
echo "\nTest 2: Match Results\n";
if ($latest) {
    $count_sql = "SELECT COUNT(*) as total FROM cfdi_matcher_results WHERE iteration_id = {$latest['iteration_id']}";
    $count_row = ia_sqlArrayIndx($count_sql)[0] ?? null;
    $count = $count_row['total'] ?? 0;
    echo "✓ Found {$count} match results\n";
}

// Test 3: Test JOIN query
echo "\nTest 3: JOIN Query\n";
if ($latest) {
    $join_sql = "SELECT r.result_id, r.match_tier, r.match_confidence,
                 i.Nombre_Receptor as client_name,
                 d.banco_cuenta_id
                 FROM cfdi_matcher_results r
                 LEFT JOIN eleyeme_cfdi_emitidos i ON r.invoice_id COLLATE utf8mb4_unicode_ci = i.eleyeme_cfdi_emitido_id COLLATE utf8mb4_unicode_ci
                 LEFT JOIN banco_cuenta_mov d ON r.deposit_id COLLATE utf8mb4_unicode_ci = d.banco_cuenta_mov_id COLLATE utf8mb4_unicode_ci
                 WHERE r.iteration_id = {$latest['iteration_id']}
                 LIMIT 3";
    $matches = ia_sqlArrayIndx($join_sql);

    if (count($matches) > 0) {
        echo "✓ JOIN works! First 3 matches:\n";
        foreach ($matches as $m) {
            echo "  - Tier {$m['match_tier']}, Conf {$m['match_confidence']}%, Client: {$m['client_name']}, Bank: {$m['banco_cuenta_id']}\n";
        }
    } else {
        echo "✗ JOIN returned no results\n";
    }
}

// Test 4: API endpoint
echo "\nTest 4: API Response\n";
echo "Visit: https://dev-app.filemonprime.net/quantix/backoffice/helper/cfdi_matcher_api.php?action=get_matches\n";

echo "\n✅ All tests complete!\n";
