<?php
$pdo = new PDO("mysql:host=localhost;unix_socket=/lamp/mysql/mysql.sock;dbname=quantix", "root", "M@chiavell1");

function normalize_text(string $text): string {
    if (empty($text)) return '';
    $text = strtolower(trim($text));
    $accents = ['á', 'à', 'ä', 'â', 'ã', 'él', 'è', 'ë', 'ê', 'í', 'ì', 'ï', 'î', 'ó', 'ò', 'ö', 'ô', 'õ', 'ú', 'ù', 'ü', 'û', 'ñ', 'ý', 'ÿ', 'ç', 'š', 'ž', 'ć', 'č'];
    $replacements = ['a', 'a', 'a', 'a', 'a', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'n', 'y', 'y', 'c', 's', 'z', 'c', 'c'];
    $text = str_replace($accents, $replacements, $text);
    $text = preg_replace('/\s+/', ' ', $text);
    return $text;
}

function extract_street_name(string $text): string {
    if (empty($text)) return '';
    $text = normalize_text($text);
    preg_match('/(\d)/', $text, $matches, PREG_OFFSET_CAPTURE);
    if (!empty($matches[0][1])) {
        return trim(substr($text, 0, $matches[0][1]));
    }
    return $text;
}

function extract_unit_number(string $text): string {
    if (empty($text)) return '';
    $text = normalize_text($text);
    if (preg_match('/-\s*(\d{1,4}[a-z]?)\b/i', $text, $matches)) {
        return trim($matches[1]);
    }
    $patterns = [
        '/\b(ph\s*\d{0,2}[a-z]?)\b/i',
        '/\b(unidad\s*\d+)\b/i',
        '/\b(depto\.?\s*\d+)\b/i',
        '/\b(apt\.?\s*\d+)\b/i',
        '/\b(\d{1,3})\b/',
        '/\b([a-z])\b(?!\s*\d)/',
    ];
    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $text, $matches)) {
            return trim($matches[1]);
        }
    }
    return '';
}

function similar_text_pct(string $str1, string $str2): float {
    similar_text($str1, $str2, $percent);
    return round($percent, 2);
}

$anuncio = "Laredo 20 - Balderas | CoS1BK";

$props = $pdo->query("SELECT * FROM propiedad WHERE nombre_propiedad LIKE '%Laredo%'")->fetchAll();

echo "Anuncio: $anuncio\n";
$normAnuncio = normalize_text($anuncio);
$anuncioStreet = extract_street_name($anuncio);
$anuncioUnit = extract_unit_number($anuncio);

echo "Norm: '$normAnuncio'\n";
echo "Street: '$anuncioStreet'\n";
echo "Unit: '$anuncioUnit'\n\n";

foreach ($props as $prop) {
    $normProp = normalize_text($prop['nombre_propiedad']);
    $normAddr = normalize_text($prop['direccion']);
    $propStreet = extract_street_name($prop['nombre_propiedad']);
    $propUnit = extract_unit_number($prop['nombre_propiedad']);

    // Tier 3: Similarity
    $simName = similar_text_pct($normAnuncio, $normProp);
    $simAddr = empty($normAddr) ? 0 : similar_text_pct($normAnuncio, $normAddr);

    // Tier 4: Street + Unit
    $streetScore = similar_text_pct($anuncioStreet, $propStreet);
    if (!empty($normAddr)) {
        $addrStreet = extract_street_name($prop['direccion']);
        $addrScore = similar_text_pct($anuncioStreet, $addrStreet);
        $streetScore = max($streetScore, $addrScore);
    }

    $unitScore = 0;
    if (!empty($anuncioUnit) && !empty($propUnit)) {
        $unitScore = $anuncioUnit === $propUnit ? 100 : 0;
    }

    $unitWeight = (!empty($anuncioUnit) && !empty($propUnit)) ? 0.3 : 0;
    $streetWeight = 1 - $unitWeight;
    $tier4Conf = round(($streetScore * $streetWeight) + ($unitScore * $unitWeight));

    echo "Property: " . $prop['nombre_propiedad'] . "\n";
    echo "  Address: " . $prop['direccion'] . "\n";
    echo "  Prop street: '$propStreet', Unit: '$propUnit'\n";
    echo "  Tier3 (85%+): name=$simName%, addr=$simAddr%\n";
    echo "  Tier4 (40%+): street=$streetScore%, unit=$unitScore%, conf=$tier4Conf%\n";
    echo "\n";
}
