<?php
/**
 * Iteration 2 - Test Improved Matcher
 */

require_once("../../inc/config.php");

echo "<!DOCTYPE html><html><head><title>Iteration 2</title></head><body>";
echo "<h1>Iteration 2 - After Pattern Improvements</h1>";
echo "<p><strong>Patterns Added:</strong> SLP37-301 format, Ver # format</p>";
echo "<hr>";

// Create iteration record
$sql = "INSERT INTO matcher_iterations (
    iteration_number, source_pms, total_reservations, matched_count, unmatched_count,
    match_rate_percent, high_confidence_count, medium_confidence_count, low_confidence_count,
    avg_confidence, patterns_added
) VALUES (
    2, 'both', 0, 0, 0, 0.00, 0, 0, 0, 0.00, 2
)";
ia_query($sql);
$iteration_id = (int) ia_singleton("SELECT LAST_INSERT_ID()");
echo "<p>✓ Iteration ID: $iteration_id</p>";

// Analyze current state
$sql_cb = "SELECT COUNT(*) as total,
           SUM(CASE WHEN propiedad_id IS NOT NULL THEN 1 ELSE 0 END) as matched,
           SUM(CASE WHEN match_confidence >= 80 THEN 1 ELSE 0 END) as high_conf
           FROM cloudbeds_reserva
           WHERE check_in_date >= '2025-01-01'";
$cb_stats = ia_sqlArrayIndx($sql_cb)[0];

$sql_hf = "SELECT COUNT(*) as total,
           SUM(CASE WHEN propiedad_id IS NOT NULL THEN 1 ELSE 0 END) as matched,
           SUM(CASE WHEN match_confidence >= 80 THEN 1 ELSE 0 END) as high_conf
           FROM hostify_reserva
           WHERE check_in >= '2025-01-01'";
$hf_stats = ia_sqlArrayIndx($sql_hf)[0];

$total = $cb_stats['total'] + $hf_stats['total'];
$matched = $cb_stats['matched'] + $hf_stats['matched'];
$unmatched = $total - $matched;
$high_conf = $cb_stats['high_conf'] + $hf_stats['high_conf'];
$match_rate = $total > 0 ? ($matched / $total) * 100 : 0;

// Calculate improvement
$sql_prev = "SELECT match_rate_percent, high_confidence_count FROM matcher_iterations WHERE iteration_number = 1";
$prev = ia_sqlArrayIndx($sql_prev)[0];
$improvement = $match_rate - $prev['match_rate_percent'];
$high_conf_gain = $high_conf - $prev['high_confidence_count'];

echo "<h2>Results</h2>";
echo "<ul>";
echo "<li>Total: $total</li>";
echo "<li>Matched: $matched</li>";
echo "<li>Unmatched: $unmatched</li>";
echo "<li>Match Rate: " . number_format($match_rate, 2) . "%</li>";
echo "<li>High Confidence: $high_conf</li>";
echo "</ul>";

echo "<h2>📈 Improvements vs Iteration 1</h2>";
echo "<ul>";
echo "<li><strong>Match Rate:</strong> " . number_format($improvement, 2) . "pp (from " . number_format($prev['match_rate_percent'], 2) . "% to " . number_format($match_rate, 2) . "%)</li>";
echo "<li><strong>High Confidence Gain:</strong> +$high_conf_gain matches</li>";
echo "<li><strong>Patterns Applied:</strong> 2 new patterns</li>";
echo "</ul>";

// Update iteration
$sql_update = "UPDATE matcher_iterations SET
    total_reservations = $total,
    matched_count = $matched,
    unmatched_count = $unmatched,
    match_rate_percent = " . number_format($match_rate, 2) . ",
    high_confidence_count = $high_conf,
    improvement_vs_previous = " . number_format($improvement, 2) . ",
    cumulative_improvement = " . number_format($improvement, 2) . "
    WHERE iteration_id = $iteration_id";
ia_query($sql_update);

echo "<h2>✅ Iteration 2 Complete!</h2>";
echo "<p>Successfully logged improvements to database.</p>";

echo "</body></html>";
?>
