<?php
/**
 * Iteration 3 - More Pattern Improvements
 */

require_once("../../inc/config.php");

echo "<!DOCTYPE html><html><head><title>Iteration 3</title></head><body>";
echo "<h1>Iteration 3 - Advanced Pattern Recognition</h1>";
echo "<p><strong>Patterns Added:</strong></p>";
echo "<ul>";
echo "<li>✓ Fixed SLP37-301 regex (flexible dash handling)</li>";
echo "<li>✓ VS146 - 102 format (space-dash-space)</li>";
echo "<li>✓ P.E.21 - #701 format (# + unit)</li>";
echo "<li>✓ VS146 - GH1 format (Garden/Guest House)</li>";
echo "<li>✓ Ibsen - 3 format (simple street-unit)</li>";
echo "</ul>";
echo "<hr>";

// Create iteration record
$sql = "INSERT INTO matcher_iterations (
    iteration_number, source_pms, total_reservations, matched_count, unmatched_count,
    match_rate_percent, high_confidence_count, medium_confidence_count, low_confidence_count,
    avg_confidence, patterns_added
) VALUES (
    3, 'both', 0, 0, 0, 0.00, 0, 0, 0, 0.00, 3
)";
ia_query($sql);
$iteration_id = (int) ia_singleton("SELECT LAST_INSERT_ID()");

// Analyze current state
$sql_cb = "SELECT COUNT(*) as total,
           SUM(CASE WHEN propiedad_id IS NOT NULL THEN 1 ELSE 0 END) as matched,
           SUM(CASE WHEN match_confidence >= 80 THEN 1 ELSE 0 END) as high_conf
           FROM cloudbeds_reserva
           WHERE check_in_date >= '2025-01-01'";
$cb_stats = ia_sqlArrayIndx($sql_cb)[0];

$sql_hf = "SELECT COUNT(*) as total,
           SUM(CASE WHEN propiedad_id IS NOT NULL THEN 1 ELSE 0 END) as matched,
           SUM(CASE WHEN match_confidence >= 80 THEN 1 ELSE 0 END) as high_conf
           FROM hostify_reserva
           WHERE check_in >= '2025-01-01'";
$hf_stats = ia_sqlArrayIndx($sql_hf)[0];

$total = $cb_stats['total'] + $hf_stats['total'];
$matched = $cb_stats['matched'] + $hf_stats['matched'];
$unmatched = $total - $matched;
$high_conf = $cb_stats['high_conf'] + $hf_stats['high_conf'];
$match_rate = $total > 0 ? ($matched / $total) * 100 : 0;

// Calculate improvement vs Iteration 2
$sql_prev = "SELECT match_rate_percent, high_confidence_count FROM matcher_iterations WHERE iteration_number = 2 ORDER BY iteration_id DESC LIMIT 1";
$prev = ia_sqlArrayIndx($sql_prev)[0] ?? null;

if ($prev) {
    $improvement = $match_rate - $prev['match_rate_percent'];
    $high_conf_gain = $high_conf - $prev['high_confidence_count'];
} else {
    // Fallback to Iteration 1
    $sql_prev = "SELECT match_rate_percent, high_confidence_count FROM matcher_iterations WHERE iteration_number = 1 LIMIT 1";
    $prev = ia_sqlArrayIndx($sql_prev)[0];
    $improvement = $match_rate - $prev['match_rate_percent'];
    $high_conf_gain = $high_conf - $prev['high_confidence_count'];
}

echo "<h2>📊 Results</h2>";
echo "<table border='1' cellpadding='10'>";
echo "<tr><th>Metric</th><th>Value</th></tr>";
echo "<tr><td>Total Reservations</td><td>$total</td></tr>";
echo "<tr><td>Matched</td><td>$matched</td></tr>";
echo "<tr><td>Unmatched</td><td>$unmatched</td></tr>";
echo "<tr><td><strong>Match Rate</strong></td><td><strong>" . number_format($match_rate, 2) . "%</strong></td></tr>";
echo "<tr><td><strong>High Confidence (≥80%)</strong></td><td><strong>$high_conf</strong></td></tr>";
echo "<tr><td style='color:green;'><strong>Gain vs Iteration 2</strong></td><td style='color:green;'><strong>+$high_conf_gain</strong></td></tr>";
echo "</table>";

echo "<h2>🎯 Breakdown by System</h2>";
echo "<table border='1' cellpadding='10'>";
echo "<tr><th>System</th><th>Total</th><th>Matched</th><th>High Conf</th><th>Unmatched</th></tr>";
echo "<tr><td>Cloudbeds</td><td>{$cb_stats['total']}</td><td>{$cb_stats['matched']}</td><td>{$cb_stats['high_conf']}</td><td>" . ($cb_stats['total'] - $cb_stats['matched']) . "</td></tr>";
echo "<tr><td>Hostify</td><td>{$hf_stats['total']}</td><td>{$hf_stats['matched']}</td><td>{$hf_stats['high_conf']}</td><td>" . ($hf_stats['total'] - $hf_stats['matched']) . "</td></tr>";
echo "</table>";

// Update iteration
$sql_update = "UPDATE matcher_iterations SET
    total_reservations = $total,
    matched_count = $matched,
    unmatched_count = $unmatched,
    match_rate_percent = " . number_format($match_rate, 2) . ",
    high_confidence_count = $high_conf,
    improvement_vs_previous = " . number_format($high_conf_gain, 2) . "
    WHERE iteration_id = $iteration_id";
ia_query($sql_update);

echo "<h2>✅ Iteration 3 Complete!</h2>";
echo "<p><strong>High Confidence Improvement:</strong> +$high_conf_gain matches</p>";
echo "<p><strong>Cumulative High Confidence Gain:</strong> From 420 (baseline) to $high_conf (+". ($high_conf - 420) .")</p>";

echo "</body></html>";
?>
