<?php
/**
 * Iteration 6 - Deep Analysis of Remaining 91 Unmatched
 */

require_once("../../inc/config.php");

echo "<!DOCTYPE html><html><head><title>Iteration 6 Analysis</title></head><body>";
echo "<h1>Iteration 6 - Analyzing Final 91 Unmatched</h1>";
echo "<hr>";

// Get all unmatched
$sql = "SELECT anuncio, COUNT(*) as count
        FROM hostify_reserva
        WHERE check_in >= '2025-01-01'
          AND propiedad_id IS NULL
        GROUP BY anuncio
        ORDER BY count DESC";
$unmatched = ia_sqlArrayIndx($sql);

$total_count = 0;
foreach ($unmatched as $row) {
    $total_count += $row['count'];
}

echo "<p><strong>Total Unmatched:</strong> $total_count reservations across " . count($unmatched) . " unique anuncios</p>";

// Categorize by pattern
$categories = [
    'P.E.21' => [],
    'Ver' => [],
    'Invalid/Dummy' => [],
    'Property Name Only' => [],
    'Other' => []
];

foreach ($unmatched as $row) {
    $anuncio = $row['anuncio'];
    $count = $row['count'];

    if (strpos($anuncio, 'P.E.21') !== false || strpos($anuncio, 'PE21') !== false) {
        $categories['P.E.21'][] = ['anuncio' => $anuncio, 'count' => $count];
    } elseif (preg_match('/^Ver\s+/', $anuncio)) {
        $categories['Ver'][] = ['anuncio' => $anuncio, 'count' => $count];
    } elseif (preg_match('/^\d{3,4}\s+Reservas/', $anuncio)) {
        $categories['Invalid/Dummy'][] = ['anuncio' => $anuncio, 'count' => $count];
    } elseif (!preg_match('/[\|\-]/', $anuncio) && !preg_match('/\d/', $anuncio)) {
        // No pipes, dashes, or numbers - just a name
        $categories['Property Name Only'][] = ['anuncio' => $anuncio, 'count' => $count];
    } else {
        $categories['Other'][] = ['anuncio' => $anuncio, 'count' => $count];
    }
}

echo "<h2>Categorization:</h2>";

foreach ($categories as $category => $items) {
    if (empty($items)) continue;

    $cat_total = array_sum(array_column($items, 'count'));
    echo "<h3>$category ($cat_total reservations)</h3>";
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>Anuncio</th><th>Count</th><th>Analysis</th></tr>";

    foreach ($items as $item) {
        echo "<tr>";
        echo "<td>{$item['anuncio']}</td>";
        echo "<td>{$item['count']}</td>";
        echo "<td>";

        // Analyze each category
        if ($category === 'P.E.21') {
            echo "<span style='color: red;'>❌ No properties found with 'Paseo de la Reforma 21' or similar</span>";
        } elseif ($category === 'Ver') {
            if (strpos($item['anuncio'], 'Ver 4') !== false) {
                echo "<span style='color: orange;'>⚠️  Tigre 4 | Veracruz 26 | 4 does NOT exist in database</span>";
            } elseif (strpos($item['anuncio'], 'Ver PH 7') !== false) {
                echo "<span style='color: orange;'>⚠️  No PH 7 at Veracruz 26</span>";
            }
        } elseif ($category === 'Invalid/Dummy') {
            echo "<span style='color: gray;'>ℹ️  Appears to be dummy/test data</span>";
        } elseif ($category === 'Property Name Only') {
            // Check if similar property exists
            $anuncio_clean = strtolower($item['anuncio']);

            if (strpos($anuncio_clean, 'pani') !== false) {
                echo "<span style='color: blue;'>✓ Possible match: 'Yautepec 24 Pani'</span>";
            } elseif (strpos($anuncio_clean, 'campeche') !== false) {
                echo "<span style='color: red;'>❌ No Campeche properties in database</span>";
            } elseif (strpos($anuncio_clean, 'ibsen') !== false) {
                echo "<span style='color: orange;'>⚠️  Ibsen A, B exist but not '- 3'</span>";
            } elseif (strpos($anuncio_clean, 'mexico') !== false) {
                echo "<span style='color: blue;'>✓ Av. Mexico 175, 195 exist</span>";
            }
        }

        echo "</td>";
        echo "</tr>";
    }

    echo "</table>";
}

echo "<hr>";
echo "<h2>🎯 Actionable Findings:</h2>";
echo "<ol>";
echo "<li><strong>P.E.21 properties (37 reservations):</strong> These properties DO NOT exist in the database. Need to verify if these are valid or if P.E. maps to something else.</li>";
echo "<li><strong>Ver 4 (5 reservations):</strong> Tigre 4 | Veracruz 26 | 4 does not exist. Property may need to be added.</li>";
echo "<li><strong>Ver PH 7 (11 reservations):</strong> No Penthouse 7 at Veracruz 26. May be invalid.</li>";
echo "<li><strong>'1111 Reservas' (10 reservations):</strong> Dummy/test data - should be excluded from matching.</li>";
echo "<li><strong>'Casa Pani' (6 reservations):</strong> Can match to 'Yautepec 24 Pani' with name pattern.</li>";
echo "<li><strong>'Av Mexico Ana' (3 reservations):</strong> Can match to 'Av. Mexico 175' or '195' with name pattern.</li>";
echo "<li><strong>'Campeche Frida/Ana' (10 reservations):</strong> NO Campeche properties exist - invalid or need to be added.</li>";
echo "<li><strong>'Ibsen - 3' (5 reservations):</strong> Only Ibsen A and B exist - no unit 3.</li>";
echo "</ol>";

echo "<h2>💡 Iteration 6 Strategy:</h2>";
echo "<ul>";
echo "<li><strong>Add simple name matching:</strong> Match 'Casa Pani' → 'Yautepec 24 Pani', 'Av Mexico Ana' → 'Av. Mexico 175'</li>";
echo "<li><strong>Mark invalid data:</strong> Exclude '1111 Reservas' and other test data</li>";
echo "<li><strong>Realistic target:</strong> Can potentially match ~10-15 more (Casa Pani, Av Mexico)</li>";
echo "<li><strong>Final unmatched:</strong> ~76-81 (mostly invalid/missing properties)</li>";
echo "<li><strong>Expected final match rate:</strong> ~96.2-96.5%</li>";
echo "</ul>";

echo "</body></html>";
?>
