<?php
/**
 * Matcher Baseline Test - Simple Version
 *
 * Purpose: Establish baseline by reading existing match data
 * This avoids complex matching logic and just logs current state
 */

require_once("../../inc/config.php");

echo "<!DOCTYPE html><html><head><title>Matcher Baseline</title></head><body>";
echo "<h1>Matcher Learning System - Baseline Test</h1>";
echo "<hr>";

// Create iteration record
echo "<h2>Creating Iteration Record...</h2>";
$sql = "INSERT INTO matcher_iterations (
    iteration_number, source_pms, total_reservations, matched_count, unmatched_count,
    match_rate_percent, high_confidence_count, medium_confidence_count, low_confidence_count,
    avg_confidence
) VALUES (
    1, 'both', 0, 0, 0, 0.00, 0, 0, 0, 0.00
)";
ia_query($sql);
$iteration_id = (int) ia_singleton("SELECT LAST_INSERT_ID()");
echo "<p>✓ Created iteration ID: $iteration_id</p>";

// Load existing match data from Cloudbeds
echo "<h2>Analyzing Cloudbeds Matches...</h2>";
$sql_cb = "SELECT COUNT(*) as total,
           SUM(CASE WHEN propiedad_id IS NOT NULL THEN 1 ELSE 0 END) as matched,
           SUM(CASE WHEN match_confidence >= 80 THEN 1 ELSE 0 END) as high_conf
           FROM cloudbeds_reserva
           WHERE check_in_date >= '2025-01-01'";
$cb_stats = ia_sqlArrayIndx($sql_cb)[0];
echo "<p>Cloudbeds: {$cb_stats['total']} total, {$cb_stats['matched']} matched, {$cb_stats['high_conf']} high-confidence</p>";

// Load existing match data from Hostify
echo "<h2>Analyzing Hostify Matches...</h2>";
$sql_hf = "SELECT COUNT(*) as total,
           SUM(CASE WHEN propiedad_id IS NOT NULL THEN 1 ELSE 0 END) as matched,
           SUM(CASE WHEN match_confidence >= 80 THEN 1 ELSE 0 END) as high_conf
           FROM hostify_reserva
           WHERE check_in >= '2025-01-01'";
$hf_stats = ia_sqlArrayIndx($sql_hf)[0];
echo "<p>Hostify: {$hf_stats['total']} total, {$hf_stats['matched']} matched, {$hf_stats['high_conf']} high-confidence</p>";

// Calculate totals
$total = $cb_stats['total'] + $hf_stats['total'];
$matched = $cb_stats['matched'] + $hf_stats['matched'];
$unmatched = $total - $matched;
$high_conf = $cb_stats['high_conf'] + $hf_stats['high_conf'];
$match_rate = $total > 0 ? ($matched / $total) * 100 : 0;

echo "<h2>Summary Statistics</h2>";
echo "<ul>";
echo "<li>Total Reservations: $total</li>";
echo "<li>Matched: $matched</li>";
echo "<li>Unmatched: $unmatched</li>";
echo "<li>Match Rate: " . number_format($match_rate, 2) . "%</li>";
echo "<li>High Confidence (≥80%): $high_conf</li>";
echo "</ul>";

// Update iteration record
$sql_update = "UPDATE matcher_iterations SET
    total_reservations = $total,
    matched_count = $matched,
    unmatched_count = $unmatched,
    match_rate_percent = " . number_format($match_rate, 2) . ",
    high_confidence_count = $high_conf
    WHERE iteration_id = $iteration_id";
ia_query($sql_update);

echo "<h2>✅ Baseline Iteration Complete!</h2>";
echo "<p>Iteration ID $iteration_id logged successfully.</p>";
echo "<p><strong>Match Rate:</strong> " . number_format($match_rate, 2) . "% ($matched / $total)</p>";
echo "<p><strong>High Confidence:</strong> $high_conf</p>";
echo "<p><strong>Unmatched:</strong> $unmatched</p>";

echo "</body></html>";
?>
