#!/lamp/php/bin/php
<?php
/**
 * Create final missing properties: VS146 (Veracruz 146) and P.E.21
 */

declare(strict_types=1);

$pdo = new PDO("mysql:host=localhost;unix_socket=/lamp/mysql/mysql.sock;dbname=quantix", "root", "M@chiavell1", [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
]);

function generateId(): string {
    return bin2hex(random_bytes(16));
}

echo "Loading data...\n";
$existingProps = [];
$res = $pdo->query("SELECT nombre_propiedad, departamento, direccion, propietario_id FROM propiedad")->fetchAll();
foreach ($res as $p) {
    $existingProps[strtolower(trim($p['nombre_propiedad']))] = $p;
}

// Get VS146 units from unmatched reservations
$vs146Units = [];
$res = $pdo->query("
    SELECT DISTINCT 
           SUBSTRING_INDEX(SUBSTRING_INDEX(anuncio, \" - \", 2), \" - \", -1) as unit
    FROM hostify_reserva 
    WHERE anuncio LIKE \"VS146%\" AND propiedad_id IS NULL
")->fetchAll();
foreach ($res as $r) {
    $unit = trim($r["unit"]);
    // Clean up unit - remove channel info after |
    $unit = strtok($unit, " |");
    if (!empty($unit) && !in_array($unit, $vs146Units)) {
        $vs146Units[] = $unit;
    }
}

// Get P.E.21 units
$pe21Units = [];
$res = $pdo->query("
    SELECT DISTINCT 
           SUBSTRING_INDEX(SUBSTRING_INDEX(anuncio, \" - \", 2), \" - \", -1) as unit
    FROM hostify_reserva 
    WHERE anuncio LIKE \"P.E.21%\" AND propiedad_id IS NULL
")->fetchAll();
foreach ($res as $r) {
    $unit = trim($r["unit"]);
    $unit = str_replace("#", "", $unit); // Remove #
    $unit = strtok($unit, " |");
    if (!empty($unit) && !in_array($unit, $pe21Units)) {
        $pe21Units[] = $unit;
    }
}

echo "VS146 units to create: " . count($vs146Units) . "\n";
echo "P.E.21 units to create: " . count($pe21Units) . "\n\n";

// Find a similar property to get owner info
$templateProp = $pdo->query("
    SELECT propietario_id, direccion, codigo_postal, colonia
    FROM propiedad 
    WHERE nombre_propiedad LIKE \"%Veracruz 20%\" OR nombre_propiedad LIKE \"%Veracruz 82%\"
    LIMIT 1
")->fetch();

if (!$templateProp) {
    // Try any property
    $templateProp = $pdo->query("
        SELECT propietario_id, direccion, codigo_postal, colonia
        FROM propiedad LIMIT 1
    ")->fetch();
}

$ownerId = $templateProp["propietario_id"] ?? 'f613cbca63d0a4fb4d705aca0e69fd9b';
$addrTemplate = $templateProp["direccion"] ?? 'Veracruz 146, Roma Norte';
$cp = $templateProp["codigo_postal"] ?? '06700';
$colonia = $templateProp["colonia"] ?? 'ROMA NORTE';

$newProps = [];

// Create VS146 properties
echo "Creating VS146 (Veracruz 146) properties:\n";
foreach ($vs146Units as $unit) {
    $propName = "Veracruz 146 - $unit";
    $normKey = strtolower($propName);
    
    if (isset($existingProps[$normKey])) {
        echo "  Already exists: $propName\n";
        continue;
    }
    
    $newProps[] = [
        'nombre_propiedad' => $propName,
        'departamento' => 'Veracruz 146',
        'direccion' => 'Veracruz 146, Roma Norte',
        'numero_unidad' => $unit,
        'codigo_postal' => '06700',
        'colonia' => 'ROMA NORTE',
        'propietario_id' => $ownerId,
    ];
    echo "  Will create: $propName\n";
}

// Create P.E.21 properties
echo "\nCreating P.E.21 properties:\n";
foreach ($pe21Units as $unit) {
    $propName = "P.E.21 - $unit";
    $normKey = strtolower($propName);
    
    if (isset($existingProps[$normKey])) {
        echo "  Already exists: $propName\n";
        continue;
    }
    
    $newProps[] = [
        'nombre_propiedad' => $propName,
        'departamento' => 'P.E.21',
        'direccion' => 'Parque España 21, Roma Norte',
        'numero_unidad' => $unit,
        'codigo_postal' => '06700',
        'colonia' => 'ROMA NORTE',
        'propietario_id' => $ownerId,
    ];
    echo "  Will create: $propName\n";
}

// Insert new properties
echo "\n" . str_repeat("=", 60) . "\n";
echo "INSERTING " . count($newProps) . " PROPERTIES\n";
echo str_repeat("=", 60) . "\n\n";

$created = 0;
$errors = [];

foreach ($newProps as $p) {
    try {
        $sql = "
            INSERT INTO propiedad (
                propiedad_id, nombre_propiedad, direccion, vale,
                departamento, numero_unidad, codigo_postal, colonia,
                estado, estado_descripcion, municipio, municipio_descripcion,
                propietario_id, alta_db, alta_por
            ) VALUES (
                ?, ?, ?, 'Active', ?, ?, ?, ?, 'DIF', 'CIUDAD DE MEXICO', 
                '015', 'CUAUHTEMOC', ?, NOW(), 'pms_matcher'
            )
        ";
        
        $propId = generateId();
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $propId,
            $p['nombre_propiedad'],
            $p['direccion'],
            $p['departamento'],
            $p['numero_unidad'],
            $p['codigo_postal'],
            $p['colonia'],
            $p['propietario_id'],
        ]);
        
        echo "Created: " . $p['nombre_propiedad'] . "\n";
        $created++;
    } catch (Exception $e) {
        $errors[] = $p['nombre_propiedad'] . ': ' . $e->getMessage();
        echo "Error: " . $p['nombre_propiedad'] . ' - ' . $e->getMessage() . "\n";
    }
}

echo "\n" . str_repeat("-", 60) . "\n";
echo "SUMMARY:\n";
echo "  Created: $created properties\n";
echo "  Errors: " . count($errors) . "\n";
