#!/lamp/php/bin/php
<?php
/**
 * Fix remaining unmatched VS146 GH reservations
 */

$pdo = new PDO("mysql:host=localhost;unix_socket=/lamp/mysql/mysql.sock;dbname=quantix", "root", "M@chiavell1", [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
]);

echo "Updating VS146 GH reservations...\n";

// Get VS146 GH properties
$props = [];
$res = $pdo->query("SELECT propiedad_id, nombre_propiedad, numero_unidad FROM propiedad WHERE nombre_propiedad LIKE 'Veracruz 146 - GH%'")->fetchAll();
foreach ($res as $p) {
    $unit = strtolower(trim($p['numero_unidad']));
    $props[$unit] = $p['propiedad_id'];
}

// Update reservations
$updated = 0;
foreach ($props as $unit => $propId) {
    // Find reservations like "VS146 - GH1 - Name" or "VS146 - GH1"
    $res = $pdo->query("
        SELECT hostify_reserva_id, anuncio
        FROM hostify_reserva 
        WHERE (anuncio LIKE 'VS146 - GH{$unit}%' OR anuncio LIKE 'VS146 GH{$unit}%')
        AND propiedad_id IS NULL
    ")->fetchAll();
    
    foreach ($res as $r) {
        echo "  Updating: " . substr($r['anuncio'], 0, 50) . "\n";
        $pdo->exec("UPDATE hostify_reserva SET propiedad_id = '{$propId}' WHERE hostify_reserva_id = '{$r['hostify_reserva_id']}'");
        $updated++;
    }
}

echo "\nUpdated: $updated reservations\n";

// Verify
$matched = $pdo->query("SELECT COUNT(*) as cnt FROM hostify_reserva WHERE propiedad_id IS NOT NULL AND check_in >= '2025-01-01'")->fetch();
$total = $pdo->query("SELECT COUNT(*) as cnt FROM hostify_reserva WHERE check_in >= '2025-01-01'")->fetch();
echo "Hostify: {$matched['cnt']}/{$total['cnt']} (" . round($matched['cnt']/$total['cnt']*100) . "%)\n";
