<?php
if (!defined('MYSQLI_ASSOC')) define('MYSQLI_ASSOC', 1);
require_once("../../inc/config.php");

echo "═══════════════════════════════════════════════════════════════\n";
echo "  PMS MATCHER CLI - BASELINE\n";
echo "═══════════════════════════════════════════════════════════════\n\n";

$stats = ['cloudbeds' => ['total' => 0, 'matched' => 0, 'by_tier' => []], 'hostify' => ['total' => 0, 'matched' => 0, 'by_tier' => []]];

echo "[1/5] Loading properties...\n";
$propiedades = ia_sqlArrayIndx("SELECT * FROM propiedad ORDER BY nombre_propiedad");
echo "  ✓ " . count($propiedades) . " properties\n\n";

function normalize_text($text) {
    if (empty($text)) return '';
    $a = ['Á'=>'A','É'=>'E','Í'=>'I','Ó'=>'O','Ú'=>'U','á'=>'a','é'=>'e','í'=>'i','ó'=>'o','ú'=>'u','Ñ'=>'N','ñ'=>'n','Ü'=>'U','ü'=>'u'];
    $text = strtr($text, $a);
    $text = mb_strtolower($text, 'UTF-8');
    return trim(preg_replace('/\s+/', ' ', $text));
}

function extract_street_name($text) {
    $n = normalize_text($text);
    $map = ['slp37'=>'san luis potosi 37','vs146'=>'vicente suarez 146','ver 2'=>'veracruz 26','ver2'=>'veracruz 26'];
    foreach ($map as $a => $f) {
        if (strpos($n, $a . '-') !== false) { $n = str_replace($a . '-', $f . ' | ', $n); break; }
        if (strpos($n, $a) !== false) { $n = str_replace($a, $f, $n); break; }
    }
    if (preg_match('/\d/', $n, $m, PREG_OFFSET_CAPTURE)) return trim(substr($n, 0, $m[0][1]));
    return $n;
}

function extract_unit_number($text) {
    $n = normalize_text($text);
    if (preg_match('/\b(\d{2,4})\b/', $n, $m)) return $m[1];
    if (preg_match('/ph\s*(\w+)/i', $n, $m)) return 'ph' . normalize_text($m[1]);
    if (preg_match('/\b([A-Z])\b/', $text, $m)) return strtolower($m[1]);
    return '';
}

function match_cloudbeds($prop, $cb_property, $cb_room) {
    $ps = extract_street_name($prop['nombre_propiedad']);
    if (strlen($ps) < 3) $ps = extract_street_name($prop['direccion'] ?? '');
    $cs = extract_street_name($cb_property);
    $np = normalize_text($prop['nombre_propiedad']);
    $nd = normalize_text($prop['direccion'] ?? '');
    $nc = normalize_text($cb_property);
    $bs = 0;
    if (strlen($nc) >= 5) {
        if (strpos($np, $nc) !== false || strpos($nd, $nc) !== false) $bs = 100;
        elseif (strlen($ps) >= 5 && strlen($cs) >= 5) { similar_text($ps, $cs, $p); $bs = $p; }
    }
    $us = 0;
    $pu = extract_unit_number($prop['nombre_propiedad']);
    $cu = extract_unit_number($cb_room);
    if (!empty($pu) && !empty($cu)) { if ($pu === $cu) $us = 100; else { similar_text($pu, $cu, $p); $us = $p; } }
    elseif (empty($cu) || $cb_room === 'N/A') $us = $bs;
    $conf = round($bs * 0.6 + $us * 0.4);
    $tier = ($conf >= 95) ? 1 : (($conf >= 80) ? 2 : (($conf >= 65) ? 3 : (($conf >= 40) ? 4 : 0)));
    return ($tier > 0) ? ['m' => true, 'c' => $conf, 't' => $tier] : ['m' => false];
}

function match_hostify($prop, $anuncio) {
    $np = normalize_text($prop['nombre_propiedad']);
    $nd = normalize_text($prop['direccion'] ?? '');
    $na = normalize_text($anuncio);
    if ($np === $na) return ['m' => true, 'c' => 100, 't' => 1];
    foreach (preg_split('/[\|,]/', $na) as $seg) {
        $seg = trim($seg);
        if (strlen($seg) >= 5 && strlen($np) >= 5) {
            if (strpos($seg, $np) !== false || strpos($np, $seg) !== false) return ['m' => true, 'c' => 90, 't' => 2];
            if (strlen($nd) >= 5 && (strpos($seg, $nd) !== false || strpos($nd, $seg) !== false)) return ['m' => true, 'c' => 90, 't' => 2];
        }
    }
    similar_text($np, $na, $p); if ($p >= 85) return ['m' => true, 'c' => 70, 't' => 3];
    similar_text($nd, $na, $p); if ($p >= 85) return ['m' => true, 'c' => 70, 't' => 3];
    $ps = extract_street_name($prop['nombre_propiedad']);
    if (strlen($ps) < 3) $ps = extract_street_name($prop['direccion'] ?? '');
    $as = extract_street_name($anuncio);
    if (strlen($ps) >= 5 && strlen($as) >= 5) {
        if (strpos($as, $ps) !== false || strpos($ps, $as) !== false) {
            $pu = extract_unit_number($prop['nombre_propiedad']);
            $au = extract_unit_number($anuncio);
            $c = (!empty($pu) && !empty($au) && $pu === $au) ? 65 : 50;
            return ['m' => true, 'c' => $c, 't' => 4];
        }
    }
    return ['m' => false];
}

echo "[2/5] Processing Cloudbeds...\n";
$cb_res = ia_sqlArrayIndx("SELECT * FROM cloudbeds_reserva WHERE check_in_date >= '2025-01-01' AND propiedad_id IS NULL");
$stats['cloudbeds']['total'] = count($cb_res);
echo "  Found " . count($cb_res) . " unmatched\n";
$cb_matches = [];
foreach ($cb_res as $cb) {
    $best = null; $bc = 0;
    foreach ($propiedades as $prop) {
        $r = match_cloudbeds($prop, $cb['property'], $cb['room_number'] ?? '');
        if ($r['m'] && $r['c'] > $bc) { $bc = $r['c']; $best = ['p' => $prop, 'r' => $cb, 'm' => $r]; }
    }
    if ($best && $bc >= 80) { $cb_matches[] = $best; $stats['cloudbeds']['by_tier'][$best['m']['t']]++; }
}
$stats['cloudbeds']['matched'] = count($cb_matches);
echo "  ✓ Matched: " . count($cb_matches) . "\n\n";

echo "[3/5] Processing Hostify...\n";
$hf_res = ia_sqlArrayIndx("SELECT * FROM hostify_reserva WHERE check_in >= '2025-01-01' AND propiedad_id IS NULL");
$stats['hostify']['total'] = count($hf_res);
echo "  Found " . count($hf_res) . " unmatched\n";
$hf_matches = [];
foreach ($hf_res as $hf) {
    $best = null; $bc = 0;
    foreach ($propiedades as $prop) {
        $r = match_hostify($prop, $hf['anuncio']);
        if ($r['m'] && $r['c'] > $bc) { $bc = $r['c']; $best = ['p' => $prop, 'r' => $hf, 'm' => $r]; }
    }
    if ($best && $bc >= 80) { $hf_matches[] = $best; $stats['hostify']['by_tier'][$best['m']['t']]++; }
}
$stats['hostify']['matched'] = count($hf_matches);
echo "  ✓ Matched: " . count($hf_matches) . "\n\n";

echo "[4/5] Statistics\n───────────────────────────────────────────────────────────────\n";
$cb_rate = $stats['cloudbeds']['total'] ? round(100 * $stats['cloudbeds']['matched'] / $stats['cloudbeds']['total'], 2) : 0;
$hf_rate = $stats['hostify']['total'] ? round(100 * $stats['hostify']['matched'] / $stats['hostify']['total'], 2) : 0;
$total = $stats['cloudbeds']['total'] + $stats['hostify']['total'];
$matched = $stats['cloudbeds']['matched'] + $stats['hostify']['matched'];
$total_rate = $total ? round(100 * $matched / $total, 2) : 0;

echo "CLOUDBEDS: {$stats['cloudbeds']['matched']}/{$stats['cloudbeds']['total']} ({$cb_rate}%)\n";
foreach ($stats['cloudbeds']['by_tier'] as $t => $c) echo "  Tier $t: $c\n";

echo "\nHOSTIFY: {$stats['hostify']['matched']}/{$stats['hostify']['total']} ({$hf_rate}%)\n";
foreach ($stats['hostify']['by_tier'] as $t => $c) echo "  Tier $t: $c\n";

echo "\nCOMBINED: $matched/$total ({$total_rate}%)\n";
echo "═══════════════════════════════════════════════════════════════\n";
