<?php
/**
 * Test ACTUAL Matching with New Patterns
 * Actually calls the matching functions to see if patterns work
 */

require_once("../../inc/config.php");

// Include the matcher library with new patterns
require_once("matcher_lib.php");

echo "<h1>Testing Actual Matching Logic</h1>\n";
echo "<p>Testing if new patterns correctly match reservations</p>\n";
echo "<hr>\n";

// Test cases from unmatched reservations
$test_cases = [
    'SLP37-401 - RoG1BQ -B',
    'Ver 3',
    'P.E.21 - #701 | CoG2BrKK-B',
    'VS146 - GH2 | CoB1BQS -P - Bcom',
    'Ibsen - 3'
];

// Load all propiedades
$sql = "SELECT * FROM propiedad ORDER BY nombre_propiedad";
$propiedades = ia_sqlArrayIndx($sql);

echo "<h2>Test Results:</h2>\n";

foreach ($test_cases as $test_text) {
    echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px 0;'>\n";
    echo "<h3>Testing: \"$test_text\"</h3>\n";

    // Test combo expansion
    $combo = expand_combo_anuncio($test_text);

    if (!empty($combo) && !empty($combo['units'])) {
        echo "<p style='color: green;'>✓ <strong>Combo pattern detected!</strong></p>\n";
        echo "<ul>\n";
        echo "<li>Type: {$combo['type']}</li>\n";
        echo "<li>Street: {$combo['street']}</li>\n";
        echo "<li>Units: " . implode(', ', $combo['units']) . "</li>\n";
        echo "<li>Pattern Raw: {$combo['pattern_raw']}</li>\n";
        echo "</ul>\n";

        // Now try to match against propiedades
        $matched = false;
        foreach ($propiedades as $prop) {
            $result = match_hostify_combo(
                $prop['nombre_propiedad'],
                $prop['direccion'],
                $test_text
            );

            if ($result['match']) {
                echo "<p style='color: blue;'><strong>🎯 MATCHED TO PROPERTY!</strong></p>\n";
                echo "<ul>\n";
                echo "<li>Property: {$prop['nombre_propiedad']}</li>\n";
                echo "<li>ID: {$prop['propiedad_id']}</li>\n";
                echo "<li>Confidence: {$result['confidence']}%</li>\n";
                echo "<li>Tier: {$result['tier']}</li>\n";
                echo "<li>Pattern: {$result['pattern']}</li>\n";
                echo "</ul>\n";
                $matched = true;
                break; // Take first match
            }
        }

        if (!$matched) {
            echo "<p style='color: orange;'>⚠️ Combo detected but no property match found</p>\n";

            // Show why it didn't match
            echo "<p><strong>Searching for properties with street:</strong> \"{$combo['street']}\"</p>\n";
            $sql_search = "SELECT nombre_propiedad FROM propiedad
                          WHERE nombre_propiedad LIKE " . strit("%{$combo['street']}%") . "
                          LIMIT 5";
            $similar_props = ia_sqlArrayIndx($sql_search);
            if (count($similar_props) > 0) {
                echo "<p>Properties with similar street:</p><ul>\n";
                foreach ($similar_props as $sp) {
                    echo "<li>{$sp['nombre_propiedad']}</li>\n";
                }
                echo "</ul>\n";
            } else {
                echo "<p style='color: red;'>❌ No properties found with street \"{$combo['street']}\"</p>\n";
            }
        }

    } else {
        echo "<p style='color: red;'>❌ No combo pattern detected</p>\n";

        // Try regular tiers
        $best_match = null;
        $best_confidence = 0;

        foreach ($propiedades as $prop) {
            $result = match_hostify_tier1($prop['nombre_propiedad'], $test_text);
            if (!$result['match']) $result = match_hostify_tier2($prop['nombre_propiedad'], $prop['direccion'], $test_text);
            if (!$result['match']) $result = match_hostify_tier3($prop['nombre_propiedad'], $prop['direccion'], $test_text);
            if (!$result['match']) $result = match_hostify_tier4($prop['nombre_propiedad'], $prop['direccion'], $test_text);

            if ($result['match'] && $result['confidence'] > $best_confidence) {
                $best_match = $result;
                $best_match['propiedad'] = $prop;
                $best_confidence = $result['confidence'];
            }
        }

        if ($best_match) {
            echo "<p style='color: blue;'>🎯 <strong>Matched via Tier {$best_match['tier']}</strong></p>\n";
            echo "<ul>\n";
            echo "<li>Property: {$best_match['propiedad']['nombre_propiedad']}</li>\n";
            echo "<li>Confidence: {$best_match['confidence']}%</li>\n";
            echo "<li>Pattern: {$best_match['pattern']}</li>\n";
            echo "</ul>\n";
        } else {
            echo "<p style='color: red;'>❌ No match found in any tier</p>\n";
        }
    }

    echo "</div>\n";
}

echo "<hr>\n";
echo "<h2>Summary</h2>\n";
echo "<p>✓ Testing complete. If patterns are working, you should see green checkmarks and matches above.</p>\n";
?>
