<?php
/**
 * Standalone test - no framework dependencies
 * Run via CLI: /lamp/php/bin/php test_slash_simple.php
 */

// Database connection
$mysqli = new mysqli('localhost', 'root', 'M@chiavell1', 'quantix', 3306, '/lamp/mysql/mysql.sock');

if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Functions
function extract_after_slash($text) {
    if (empty($text)) return '';
    if (strpos($text, '/') !== false) {
        $parts = explode('/', $text, 2);
        return trim($parts[1]);
    }
    return $text;
}

function normalize_text($text) {
    if (empty($text)) return '';
    $accents = [
        'Á'=>'A', 'É'=>'E', 'Í'=>'I', 'Ó'=>'O', 'Ú'=>'U',
        'á'=>'a', 'é'=>'e', 'í'=>'i', 'ó'=>'o', 'ú'=>'u',
        'Ñ'=>'N', 'ñ'=>'n', 'Ü'=>'U', 'ü'=>'u'
    ];
    $text = strtr($text, $accents);
    $text = mb_strtolower($text, 'UTF-8');
    $text = trim(preg_replace('/\s+/', ' ', $text));
    return $text;
}

echo "=============================================================\n";
echo "🎯 SLASH EXTRACTION TEST - VERIFY 100% MATCH\n";
echo "=============================================================\n\n";

// Load propiedades
$result = $mysqli->query("SELECT propiedad_id, nombre_propiedad FROM propiedad ORDER BY nombre_propiedad");
$propiedades = [];
while ($row = $result->fetch_assoc()) {
    $propiedades[] = $row;
}

// Load propietarios
$result2 = $mysqli->query("SELECT propietario_id, propietario, departamento FROM propietario ORDER BY propietario");
$propietarios = [];
while ($row = $result2->fetch_assoc()) {
    $propietarios[] = $row;
}

echo "✓ Loaded " . count($propiedades) . " propiedades\n";
echo "✓ Loaded " . count($propietarios) . " propietarios (active)\n\n";

// Test slash extraction on first 5 propiedades
echo "--- SLASH EXTRACTION EXAMPLES ---\n\n";
foreach (array_slice($propiedades, 0, 5) as $idx => $propiedad) {
    $raw = $propiedad['nombre_propiedad'];
    $extracted = extract_after_slash($raw);

    echo "Propiedad #{$idx}:\n";
    echo "  Raw:       {$raw}\n";
    echo "  Extracted: {$extracted}\n\n";
}

// Count perfect matches
echo "--- MATCHING ANALYSIS ---\n\n";
$tier1_perfect = 0; // 100% exact match
$total_propiedades = count($propiedades);
$matched_propiedades = [];

foreach ($propiedades as $propiedad) {
    $prop_extracted = extract_after_slash($propiedad['nombre_propiedad']);
    $prop_norm = normalize_text($prop_extracted);

    foreach ($propietarios as $propietario) {
        $dept_norm = normalize_text($propietario['departamento']);

        if ($prop_norm === $dept_norm) {
            $tier1_perfect++;
            $matched_propiedades[] = [
                'propiedad' => $propiedad['nombre_propiedad'],
                'extracted' => $prop_extracted,
                'departamento' => $propietario['departamento'],
                'propietario' => $propietario['propietario']
            ];
            break; // Found match, move to next propiedad
        }
    }
}

// Show first 10 matches
echo "✅ PERFECT MATCHES (first 10):\n\n";
foreach (array_slice($matched_propiedades, 0, 10) as $idx => $match) {
    echo ($idx + 1) . ". Propiedad: '{$match['propiedad']}'\n";
    echo "   → Extracted: '{$match['extracted']}'\n";
    echo "   → Matches: '{$match['departamento']}' ({$match['propietario']})\n\n";
}

// Calculate stats
$match_percentage = ($tier1_perfect / $total_propiedades) * 100;

echo "=============================================================\n";
echo "📊 RESULTS\n";
echo "=============================================================\n";
echo "Total Propiedades: {$total_propiedades}\n";
echo "Tier 1 Perfect Matches: {$tier1_perfect}\n";
echo "Match Rate: " . round($match_percentage, 1) . "%\n";
echo "\n";

if ($match_percentage >= 99) {
    echo "🎉 SUCCESS! Slash extraction achieves ~100% match!\n";
} elseif ($match_percentage >= 90) {
    echo "✅ EXCELLENT! Slash extraction achieves >90% match!\n";
} else {
    echo "⚠️  Check: Match rate is " . round($match_percentage, 1) . "%\n";
}

echo "=============================================================\n";

$mysqli->close();
